/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.List;
import java.util.TreeMap;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.jsondefs.JSONBullet;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperEntity;
import minecrafttransportsimulator.packets.instances.PacketEntityBulletHit;
import minecrafttransportsimulator.packets.instances.PacketEntityBulletHitBlock;
import minecrafttransportsimulator.packets.instances.PacketEntityBulletHitEntity;
import minecrafttransportsimulator.packets.instances.PacketEntityBulletHitWrapper;
import minecrafttransportsimulator.rendering.instances.RenderBullet;
import minecrafttransportsimulator.systems.ConfigSystem;

public class EntityBullet
extends AEntityD_Definable<JSONBullet> {
    public final PartGun gun;
    public final int bulletNumber;
    private final boolean isBomb;
    private final double initialVelocity;
    private final double anglePerTickSpeed;
    private final Point3d velocityToAddEachTick;
    private Point3d targetPosition;
    public double targetDistance;
    private PartEngine engineTargeted;
    private WrapperEntity externalEntityTargeted;
    private HitType lastHit;
    private static RenderBullet renderer;

    public EntityBullet(Point3d position, Point3d motion, PartGun gun) {
        super(gun.world, position, motion, ZERO_FOR_CONSTRUCTOR, gun.loadedBullet);
        this.gun = gun;
        this.bulletNumber = gun.bulletsFired;
        this.isBomb = ((JSONPart)gun.definition).gun.muzzleVelocity == 0;
        this.boundingBox = new BoundingBox(this.position, (double)((JSONBullet)this.definition).bullet.diameter / 1000.0 / 2.0, (double)((JSONBullet)this.definition).bullet.diameter / 1000.0 / 2.0, (double)((JSONBullet)this.definition).bullet.diameter / 1000.0 / 2.0);
        this.initialVelocity = motion.length();
        this.anglePerTickSpeed = ((JSONBullet)this.definition).bullet.turnFactor * 1000.0f / ((JSONBullet)this.definition).bullet.diameter;
        if (((JSONBullet)this.definition).bullet.accelerationTime > 0) {
            double velocityDelta = (double)((JSONBullet)this.definition).bullet.maxVelocity / 20.0 / 10.0 - motion.length();
            this.velocityToAddEachTick = new Point3d(0.0, 0.0, 1.0).rotateFine(gun.angles).multiply(velocityDelta / (double)((JSONBullet)this.definition).bullet.accelerationTime);
        } else {
            this.velocityToAddEachTick = new Point3d();
        }
        if (this.isBomb) {
            this.angles.setTo(gun.angles);
        } else {
            this.angles.setTo(motion).getAngles(true);
        }
        this.prevAngles.setTo(this.angles);
    }

    public EntityBullet(Point3d position, Point3d motion, PartGun gun, Point3d blockTargetPos) {
        this(position, motion, gun);
        this.targetPosition = blockTargetPos;
    }

    public EntityBullet(Point3d position, Point3d motion, PartGun gun, PartEngine engineTargeted) {
        this(position, motion, gun, engineTargeted.position);
        if (engineTargeted.entityOn instanceof EntityVehicleF_Physics) {
            ((EntityVehicleF_Physics)engineTargeted.entityOn).acquireMissile(this);
        }
        if (this.externalEntityTargeted != null) {
            this.engineTargeted = engineTargeted;
        }
    }

    public EntityBullet(Point3d position, Point3d motion, PartGun gun, WrapperEntity externalEntityTargeted) {
        this(position, motion, gun, new Point3d(externalEntityTargeted.getPosition()));
        this.externalEntityTargeted = externalEntityTargeted;
    }

    @Override
    public boolean update() {
        if (super.update()) {
            Damage damage;
            List<WrapperEntity> attackedEntities;
            if (this.ticksExisted > (long)((JSONBullet)this.definition).bullet.burnTime) {
                if (((JSONBullet)this.definition).bullet.slowdownSpeed > 0.0f) {
                    this.motion.add(this.motion.copy().normalize().multiply(-((JSONBullet)this.definition).bullet.slowdownSpeed));
                }
                this.motion.y -= (double)((JSONPart)this.gun.definition).gun.gravitationalVelocity;
                if (this.ticksExisted > (long)(((JSONBullet)this.definition).bullet.burnTime + 200)) {
                    if (((Boolean)ConfigSystem.configObject.clientControls.devMode.value).booleanValue()) {
                        InterfaceClient.getClientPlayer().displayChatMessage("TIMEOUT");
                    }
                    this.remove();
                    return false;
                }
            } else {
                if (this.ticksExisted < (long)((JSONBullet)this.definition).bullet.accelerationTime) {
                    this.motion.add(this.velocityToAddEachTick);
                }
                if (this.targetPosition != null) {
                    if (this.externalEntityTargeted != null) {
                        if (this.externalEntityTargeted.isValid()) {
                            this.targetPosition.setTo(this.externalEntityTargeted.getPosition());
                        } else {
                            this.externalEntityTargeted = null;
                            this.targetPosition = null;
                        }
                    } else if (this.engineTargeted != null && (!this.engineTargeted.isValid || this.engineTargeted.temp <= 30.0)) {
                        List<APart> vehicleParts = this.engineTargeted.entityOn.parts;
                        this.engineTargeted = null;
                        double closestEngineDistance = Double.MAX_VALUE;
                        for (APart part : vehicleParts) {
                            double engineDistance;
                            if (!(part instanceof PartEngine)) continue;
                            PartEngine engine = (PartEngine)part;
                            if (!engine.isValid || !(engine.temp > 30.0) || !((engineDistance = this.position.distanceTo(engine.position)) < closestEngineDistance)) continue;
                            this.engineTargeted = engine;
                            this.targetPosition = this.engineTargeted.position;
                            closestEngineDistance = engineDistance;
                        }
                    }
                    if (this.targetPosition != null) {
                        this.targetDistance = this.position.distanceTo(this.targetPosition);
                        double yawTarget = Math.toDegrees(Math.atan2(this.targetPosition.x - this.position.x, this.targetPosition.z - this.position.z));
                        double pitchTarget = -Math.toDegrees(Math.atan2(this.targetPosition.y - this.position.y, Math.hypot(this.targetPosition.x - this.position.x, this.targetPosition.z - this.position.z)));
                        if (pitchTarget > 0.0 && pitchTarget < (double)((JSONBullet)this.definition).bullet.angleOfAttack) {
                            pitchTarget = this.position.y < this.targetPosition.y + 0.5 * (double)((JSONBullet)this.definition).bullet.angleOfAttack ? (double)(-((JSONBullet)this.definition).bullet.angleOfAttack) : 0.0;
                        }
                        Point3d deltas = this.motion.copy().getAngles(true).add(-pitchTarget, -yawTarget, 0.0).multiply(-1.0);
                        while (deltas.y > 180.0) {
                            deltas.y -= 360.0;
                        }
                        while (deltas.y < -180.0) {
                            deltas.y += 360.0;
                        }
                        if (deltas.y < 0.0) {
                            if (deltas.y < -this.anglePerTickSpeed) {
                                deltas.y = -this.anglePerTickSpeed;
                            }
                            this.motion.rotateY(deltas.y);
                        } else if (deltas.y > 0.0) {
                            if (deltas.y > this.anglePerTickSpeed) {
                                deltas.y = this.anglePerTickSpeed;
                            }
                            this.motion.rotateY(deltas.y);
                        }
                        if (deltas.x < 0.0) {
                            if (deltas.x < -this.anglePerTickSpeed) {
                                deltas.x = -this.anglePerTickSpeed;
                            }
                            this.motion.rotateFine(new Point3d(this.motion.z, 0.0, -1.0 * this.motion.x).multiply(deltas.x));
                        } else if (deltas.x > 0.0) {
                            if (deltas.x > this.anglePerTickSpeed) {
                                deltas.x = this.anglePerTickSpeed;
                            }
                            this.motion.rotateFine(new Point3d(this.motion.z, 0.0, -1.0 * this.motion.x).multiply(deltas.x));
                        }
                    }
                }
            }
            if (!(attackedEntities = this.world.attackEntities(damage = new Damage("bullet", this.velocity * (double)((JSONBullet)this.definition).bullet.diameter / 5.0 * (Double)ConfigSystem.configObject.damage.bulletDamageFactor.value, this.boundingBox, this.gun, null), this.motion)).isEmpty()) {
                WrapperEntity entity = attackedEntities.get(0);
                InterfacePacket.sendToServer(new PacketEntityBulletHitWrapper(this, entity));
                this.lastHit = HitType.ENTITY;
                if (((Boolean)ConfigSystem.configObject.clientControls.devMode.value).booleanValue()) {
                    InterfaceClient.getClientPlayer().displayChatMessage("HIT ENTITY");
                }
                this.remove();
                return false;
            }
            Point3d endPoint = this.position.copy().add(this.motion);
            BoundingBox bulletMovmenetBounds = new BoundingBox(endPoint.copy().subtract(this.position).multiply(0.5).add(this.position), Math.abs(this.motion.x / 2.0), Math.abs(this.motion.y / 2.0), Math.abs(this.motion.z / 2.0));
            for (EntityVehicleF_Physics entity : this.world.getEntitiesOfType(EntityVehicleF_Physics.class)) {
                double armorPenetrated = 0.0;
                if (entity.parts.contains(this.gun) || !entity.encompassingBox.intersects(bulletMovmenetBounds)) continue;
                TreeMap<Double, BoundingBox> hitBoxes = new TreeMap<Double, BoundingBox>();
                for (BoundingBox box : entity.allInteractionBoxes) {
                    Point3d delta = box.getIntersectionPoint(this.position, endPoint);
                    if (delta == null) continue;
                    hitBoxes.put(delta.distanceTo(this.position), box);
                }
                if (hitBoxes.isEmpty()) continue;
                for (BoundingBox hitBox : hitBoxes.values()) {
                    if (hitBox.definition != null && hitBox.definition.armorThickness > 0.0f) {
                        if (!((armorPenetrated += (double)hitBox.definition.armorThickness) > (double)((JSONBullet)this.definition).bullet.armorPenetration * this.velocity / this.initialVelocity)) continue;
                        InterfacePacket.sendToServer(new PacketEntityBulletHit(this, hitBox.globalCenter));
                        this.lastHit = HitType.ARMOR;
                        if (((Boolean)ConfigSystem.configObject.clientControls.devMode.value).booleanValue()) {
                            InterfaceClient.getClientPlayer().displayChatMessage("HIT TOO MUCH ARMOR.  MAX PEN: " + (int)((double)((JSONBullet)this.definition).bullet.armorPenetration * this.velocity / this.initialVelocity));
                        }
                        this.remove();
                        return false;
                    }
                    APart hitPart = entity.getPartWithBox(hitBox);
                    if (hitPart != null) {
                        InterfacePacket.sendToServer(new PacketEntityBulletHitEntity(this, hitBox, hitPart));
                        this.lastHit = HitType.PART;
                        if (((Boolean)ConfigSystem.configObject.clientControls.devMode.value).booleanValue()) {
                            InterfaceClient.getClientPlayer().displayChatMessage("HIT PART");
                        }
                        this.remove();
                        return false;
                    }
                    InterfacePacket.sendToServer(new PacketEntityBulletHitEntity(this, hitBox, entity));
                    this.lastHit = HitType.ENTITY;
                    if (((Boolean)ConfigSystem.configObject.clientControls.devMode.value).booleanValue()) {
                        InterfaceClient.getClientPlayer().displayChatMessage("HIT VEHICLE");
                    }
                    this.remove();
                    return false;
                }
                if (armorPenetrated == 0.0 || !((Boolean)ConfigSystem.configObject.clientControls.devMode.value).booleanValue()) continue;
                InterfaceClient.getClientPlayer().displayChatMessage("PEN ARMOR: " + (int)armorPenetrated + " TOTAL UNITS OUT OF " + (int)((double)((JSONBullet)this.definition).bullet.armorPenetration * this.velocity / this.initialVelocity) + " POSSIBLE");
            }
            Point3d hitPos = this.world.getBlockHit(this.position, this.motion);
            if (hitPos != null) {
                InterfacePacket.sendToServer(new PacketEntityBulletHitBlock(this, hitPos));
                this.lastHit = HitType.BLOCK;
                if (((Boolean)ConfigSystem.configObject.clientControls.devMode.value).booleanValue()) {
                    InterfaceClient.getClientPlayer().displayChatMessage("HIT BLOCK");
                }
                this.remove();
                return false;
            }
            if (((JSONBullet)this.definition).bullet.proximityFuze != 0.0f) {
                double distanceUntilImpact;
                if (this.targetPosition != null && (distanceUntilImpact = this.position.distanceTo(this.targetPosition)) <= (double)((JSONBullet)this.definition).bullet.proximityFuze) {
                    InterfacePacket.sendToServer(new PacketEntityBulletHit(this, this.position));
                    HitType hitType = this.externalEntityTargeted != null ? HitType.ENTITY : (this.lastHit = this.engineTargeted != null ? HitType.PART : HitType.BLOCK);
                    if (((Boolean)ConfigSystem.configObject.clientControls.devMode.value).booleanValue()) {
                        InterfaceClient.getClientPlayer().displayChatMessage("PROX FUSE");
                    }
                    this.remove();
                    return false;
                }
                if (this.world.getBlockHit(this.position, this.motion.copy().normalize().multiply(((JSONBullet)this.definition).bullet.proximityFuze)) != null) {
                    InterfacePacket.sendToServer(new PacketEntityBulletHitBlock(this, this.position));
                    this.lastHit = HitType.BLOCK;
                    if (((Boolean)ConfigSystem.configObject.clientControls.devMode.value).booleanValue()) {
                        InterfaceClient.getClientPlayer().displayChatMessage("HIT BLOCK");
                    }
                    this.remove();
                    return false;
                }
            }
            if (((JSONBullet)this.definition).bullet.airBurstDelay != 0 && this.ticksExisted > (long)((JSONBullet)this.definition).bullet.airBurstDelay) {
                InterfacePacket.sendToServer(new PacketEntityBulletHit(this, this.position));
                this.lastHit = HitType.BURST;
                if (((Boolean)ConfigSystem.configObject.clientControls.devMode.value).booleanValue()) {
                    InterfaceClient.getClientPlayer().displayChatMessage("BURST");
                }
                this.remove();
                return false;
            }
            if (!this.isBomb) {
                this.angles.setTo(this.motion).getAngles(true);
            }
            this.position.add(this.motion);
            return true;
        }
        return false;
    }

    @Override
    public void remove() {
        if (this.world.isClient()) {
            this.spawnParticles(0.0f);
        }
        super.remove();
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        switch (variable) {
            case "bullet_hit": {
                return this.lastHit != null ? 1.0 : 0.0;
            }
            case "bullet_burntime": {
                return this.ticksExisted > (long)((JSONBullet)this.definition).bullet.burnTime ? 0.0 : (double)((long)((JSONBullet)this.definition).bullet.burnTime - this.ticksExisted);
            }
            case "bullet_hit_block": {
                return HitType.BLOCK.equals((Object)this.lastHit) ? 1.0 : 0.0;
            }
            case "bullet_hit_entity": {
                return HitType.ENTITY.equals((Object)this.lastHit) ? 1.0 : 0.0;
            }
            case "bullet_hit_part": {
                return HitType.PART.equals((Object)this.lastHit) ? 1.0 : 0.0;
            }
            case "bullet_hit_armor": {
                return HitType.ARMOR.equals((Object)this.lastHit) ? 1.0 : 0.0;
            }
            case "bullet_hit_burst": {
                return HitType.BURST.equals((Object)this.lastHit) ? 1.0 : 0.0;
            }
        }
        return super.getRawVariableValue(variable, partialTicks);
    }

    @Override
    public boolean shouldSync() {
        return false;
    }

    @Override
    public boolean shouldSavePosition() {
        return false;
    }

    public RenderBullet getRenderer() {
        if (renderer == null) {
            renderer = new RenderBullet();
        }
        return renderer;
    }

    private static enum HitType {
        BLOCK,
        ENTITY,
        PART,
        ARMOR,
        BURST;

    }
}

