/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.Map;
import minecrafttransportsimulator.entities.components.AEntityA_Base;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.instances.PacketFluidTankChange;
import minecrafttransportsimulator.systems.ConfigSystem;

public class EntityFluidTank
extends AEntityA_Base {
    private final int maxLevel;
    private String currentFluid;
    private double fluidLevel;
    private double fluidDispensed;

    public EntityFluidTank(WrapperWorld world, WrapperNBT data, int maxLevel) {
        super(world, data);
        this.maxLevel = maxLevel;
        this.currentFluid = data.getString("currentFluid");
        this.fluidLevel = data.getDouble("fluidLevel");
        this.fluidDispensed = data.getDouble("fluidDispensed");
    }

    @Override
    public double getMass() {
        return this.fluidLevel / 50.0;
    }

    public double getFluidLevel() {
        return this.fluidLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public double getAmountDispensed() {
        return this.fluidDispensed;
    }

    public void resetAmountDispensed() {
        this.fluidDispensed = 0.0;
    }

    public String getFluid() {
        return this.currentFluid;
    }

    public void manuallySet(String fluidName, double setLevel) {
        this.currentFluid = fluidName;
        this.fluidLevel = setLevel;
    }

    public double fill(String fluid, double maxAmount, boolean doFill) {
        if (this.currentFluid.isEmpty() || this.currentFluid.equals(fluid)) {
            if (maxAmount >= (double)this.getMaxLevel() - this.fluidLevel) {
                maxAmount = (double)this.getMaxLevel() - this.fluidLevel;
            }
            if (doFill) {
                this.fluidLevel += maxAmount;
                if (this.currentFluid.isEmpty()) {
                    this.currentFluid = fluid;
                }
                if (!this.world.isClient()) {
                    InterfacePacket.sendToAllClients(new PacketFluidTankChange(this, maxAmount));
                }
            }
            return maxAmount;
        }
        return 0.0;
    }

    public double drain(String fluid, double maxAmount, boolean doDrain) {
        if (!this.currentFluid.isEmpty() && (this.currentFluid.equals(fluid) || fluid.isEmpty())) {
            if (maxAmount >= this.fluidLevel) {
                maxAmount = this.fluidLevel;
            }
            if (doDrain) {
                if (!this.world.isClient()) {
                    InterfacePacket.sendToAllClients(new PacketFluidTankChange(this, -maxAmount));
                }
                this.fluidLevel -= maxAmount;
                this.fluidDispensed += maxAmount;
                if (this.fluidLevel == 0.0) {
                    this.currentFluid = "";
                }
            }
            return maxAmount;
        }
        return 0.0;
    }

    public double getExplosiveness() {
        for (Map<String, Double> fuelEntry : ConfigSystem.configObject.fuel.fuels.values()) {
            if (!fuelEntry.containsKey(this.currentFluid)) continue;
            return this.fluidLevel * fuelEntry.get(this.currentFluid) / 10000.0;
        }
        return 0.0;
    }

    @Override
    public WrapperNBT save(WrapperNBT data) {
        super.save(data);
        data.setString("currentFluid", this.currentFluid);
        data.setDouble("fluidLevel", this.fluidLevel);
        data.setDouble("fluidDispensed", this.fluidDispensed);
        return data;
    }
}

