/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.List;
import minecrafttransportsimulator.baseclasses.IInventoryProvider;
import minecrafttransportsimulator.entities.components.AEntityA_Base;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.instances.PacketInventoryContainerChange;

public class EntityInventoryContainer
extends AEntityA_Base
implements IInventoryProvider {
    private final List<WrapperItemStack> inventory;

    public EntityInventoryContainer(WrapperWorld world, WrapperNBT data, int maxSlots) {
        super(world, data);
        this.inventory = data.getStacks(maxSlots);
    }

    @Override
    public double getMass() {
        return this.getInventoryMass();
    }

    @Override
    public int getSize() {
        return this.inventory.size();
    }

    @Override
    public WrapperItemStack getStack(int index) {
        return this.inventory.get(index);
    }

    @Override
    public void setStack(WrapperItemStack stackToSet, int index) {
        this.inventory.set(index, stackToSet);
        if (!this.world.isClient()) {
            InterfacePacket.sendToAllClients(new PacketInventoryContainerChange(this, index, stackToSet));
        }
    }

    @Override
    public WrapperNBT save(WrapperNBT data) {
        super.save(data);
        data.setStacks(this.inventory);
        return data;
    }
}

