/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.nio.FloatBuffer;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityC_Renderable;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.jsondefs.JSONParticle;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.InterfaceEventsModelLoader;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.rendering.components.RenderableObject;
import minecrafttransportsimulator.rendering.instances.RenderParticle;

public class EntityParticle
extends AEntityC_Renderable {
    private static final FloatBuffer STANDARD_RENDER_BUFFER = EntityParticle.generateStandardBuffer();
    private static final int PARTICLES_PER_ROWCOL = 16;
    private final JSONParticle definition;
    private final int maxAge;
    private final ColorRGB startColor;
    private final ColorRGB endColor;
    private final ColorRGB staticColor;
    private final RenderableObject renderable;
    public boolean touchingBlocks;
    public int age;
    private static RenderParticle renderer;

    public EntityParticle(AEntityD_Definable<?> entitySpawning, JSONParticle definition) {
        super(entitySpawning.world, entitySpawning.position, ZERO_FOR_CONSTRUCTOR, ZERO_FOR_CONSTRUCTOR);
        if (definition.pos != null) {
            this.position.add(definition.pos.copy().rotateFine(entitySpawning.angles));
        }
        if (definition.initialVelocity != null) {
            Point3d adjustedVelocity = definition.initialVelocity.copy().rotateFine(entitySpawning.angles);
            this.motion.x += adjustedVelocity.x / 10.0 + 0.02 - Math.random() * 0.04;
            this.motion.y += adjustedVelocity.y / 10.0 + 0.02 - Math.random() * 0.04;
            this.motion.z += adjustedVelocity.z / 10.0 + 0.02 - Math.random() * 0.04;
            this.prevMotion.setTo(this.motion);
        }
        this.definition = definition;
        this.boundingBox = new BoundingBox(this.position, (double)this.getSize() / 2.0, (double)this.getSize() / 2.0, (double)this.getSize() / 2.0);
        this.maxAge = this.generateMaxAge();
        if (definition.color != null) {
            if (definition.toColor != null) {
                this.startColor = definition.color;
                this.endColor = definition.toColor;
                this.staticColor = null;
            } else {
                this.startColor = null;
                this.endColor = null;
                this.staticColor = definition.color;
            }
        } else {
            this.startColor = null;
            this.endColor = null;
            this.staticColor = ColorRGB.WHITE;
        }
        FloatBuffer buffer = FloatBuffer.allocate(STANDARD_RENDER_BUFFER.capacity());
        buffer.put(STANDARD_RENDER_BUFFER);
        STANDARD_RENDER_BUFFER.rewind();
        buffer.flip();
        this.renderable = new RenderableObject("particle", definition.texture != null ? definition.texture : (definition.type.equals((Object)JSONParticle.ParticleType.BREAK) ? "GLOBAL" : "PARTICLE"), this.staticColor != null ? this.staticColor : new ColorRGB(), buffer, false);
        this.renderable.disableLighting = definition.type.equals((Object)JSONParticle.ParticleType.FLAME);
        this.renderable.ignoreWorldShading = true;
        if (definition.type.equals((Object)JSONParticle.ParticleType.BREAK)) {
            this.setParticleTextureBounds(0, 0);
        }
    }

    @Override
    public boolean update() {
        if (super.update()) {
            if (this.definition.movementVelocity != null) {
                this.motion.add(this.definition.movementVelocity);
                if (this.motion.x > this.definition.terminalVelocity.x) {
                    this.motion.x = this.definition.terminalVelocity.x;
                }
                if (this.motion.x < -this.definition.terminalVelocity.x) {
                    this.motion.x = -this.definition.terminalVelocity.x;
                }
                if (this.motion.y > this.definition.terminalVelocity.y) {
                    this.motion.y = this.definition.terminalVelocity.y;
                }
                if (this.motion.y < -this.definition.terminalVelocity.y) {
                    this.motion.y = -this.definition.terminalVelocity.y;
                }
                if (this.motion.z > this.definition.terminalVelocity.z) {
                    this.motion.z = this.definition.terminalVelocity.z;
                }
                if (this.motion.z < -this.definition.terminalVelocity.z) {
                    this.motion.z = -this.definition.terminalVelocity.z;
                }
            } else {
                switch (this.definition.type) {
                    case SMOKE: {
                        this.motion.x *= 0.9;
                        this.motion.y += 0.004;
                        this.motion.z *= 0.9;
                        break;
                    }
                    case FLAME: {
                        this.motion.multiply(0.96);
                        break;
                    }
                    case DRIP: {
                        if (!this.touchingBlocks) {
                            this.motion.multiply(0.96).add(0.0, -0.06, 0.0);
                            break;
                        }
                        this.motion.multiply(0.0);
                        break;
                    }
                    case BUBBLE: {
                        if (!this.world.isBlockLiquid(this.position)) {
                            this.remove();
                            break;
                        }
                        this.motion.multiply(0.85).add(0.0, 0.002, 0.0);
                        break;
                    }
                    case BREAK: {
                        if (!this.touchingBlocks) {
                            this.motion.multiply(0.98).add(0.0, -0.04, 0.0);
                            break;
                        }
                        this.motion.multiply(0.0);
                        break;
                    }
                }
            }
            this.touchingBlocks = this.boundingBox.updateMovingCollisions(this.world, this.motion);
            if (this.touchingBlocks) {
                this.motion.add(-this.boundingBox.currentCollisionDepth.x * Math.signum(this.motion.x), -this.boundingBox.currentCollisionDepth.y * Math.signum(this.motion.y), -this.boundingBox.currentCollisionDepth.z * Math.signum(this.motion.z));
            }
            this.position.add(this.motion);
            if (++this.age == this.maxAge) {
                this.remove();
            }
            WrapperPlayer clientPlayer = InterfaceClient.getClientPlayer();
            this.angles.setTo(this.position).subtract(clientPlayer.getPosition()).add(0.0, -clientPlayer.getEyeHeight(), 0.0).subtract(InterfaceClient.getCameraPosition()).getAngles(true);
            this.angles.y += 180.0;
            this.angles.x = -this.angles.x;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldSync() {
        return false;
    }

    @Override
    public boolean shouldSavePosition() {
        return false;
    }

    public RenderParticle getRenderer() {
        if (renderer == null) {
            renderer = new RenderParticle();
        }
        return renderer;
    }

    private int generateMaxAge() {
        if (this.definition.duration != 0) {
            return this.definition.duration;
        }
        switch (this.definition.type) {
            case SMOKE: {
                return (int)(8.0 / (Math.random() * 0.8 + 0.2));
            }
            case FLAME: {
                return (int)(8.0 / (Math.random() * 0.8 + 0.2)) + 4;
            }
            case DRIP: {
                return (int)(64.0 / (Math.random() * 0.8 + 0.2));
            }
            case BUBBLE: {
                return (int)(8.0 / (Math.random() * 0.8 + 0.2));
            }
            case BREAK: {
                return (int)(4.0 / (Math.random() * 0.9 + 0.1));
            }
            case GENERIC: {
                return (int)(8.0 / (Math.random() * 0.8 + 0.2));
            }
        }
        return 0;
    }

    private float getSize() {
        return this.definition.type.equals((Object)JSONParticle.ParticleType.DRIP) || this.definition.type.equals((Object)JSONParticle.ParticleType.BREAK) ? 0.1f : 0.2f;
    }

    public void render(float partialTicks) {
        if (this.staticColor == null) {
            this.renderable.color.red = this.startColor.red + (this.endColor.red - this.startColor.red) * ((float)this.age + partialTicks) / (float)this.maxAge;
            this.renderable.color.green = this.startColor.green + (this.endColor.green - this.startColor.green) * ((float)this.age + partialTicks) / (float)this.maxAge;
            this.renderable.color.blue = this.startColor.blue + (this.endColor.blue - this.startColor.blue) * ((float)this.age + partialTicks) / (float)this.maxAge;
        }
        this.renderable.alpha = this.getAlpha(partialTicks);
        this.renderable.scale = this.getSize() * this.getScale(partialTicks);
        switch (this.definition.type) {
            case SMOKE: {
                this.setParticleTextureBounds(7 - this.age * 8 / this.maxAge, 0);
                break;
            }
            case FLAME: {
                this.setParticleTextureBounds(0, 3);
                break;
            }
            case DRIP: {
                this.setParticleTextureBounds(this.touchingBlocks ? 1 : 0, 7);
                break;
            }
            case BUBBLE: {
                this.setParticleTextureBounds(0, 2);
                break;
            }
            case BREAK: {
                break;
            }
        }
        this.renderable.render();
    }

    private float getAlpha(float partialTicks) {
        if (this.definition.transparency != 0.0f) {
            if (this.definition.toTransparency != 0.0f) {
                return this.definition.transparency + (this.definition.toTransparency - this.definition.transparency) * ((float)this.age + partialTicks) / (float)this.maxAge;
            }
            return this.definition.transparency;
        }
        return 1.0f;
    }

    private float getScale(float partialTicks) {
        if (this.definition.scale != 0.0f) {
            if (this.definition.toScale != 0.0f) {
                return this.definition.scale + (this.definition.toScale - this.definition.scale) * ((float)this.age + partialTicks) / (float)this.maxAge;
            }
            return this.definition.scale;
        }
        switch (this.definition.type) {
            case FLAME: {
                return (float)(1.0 - Math.pow(((float)this.age + partialTicks) / (float)this.maxAge, 2.0) / 2.0);
            }
            case DRIP: {
                return this.touchingBlocks ? 3.0f : 1.0f;
            }
        }
        return 1.0f;
    }

    private void setParticleTextureBounds(int uRow, int vCol) {
        float V;
        float v;
        float U;
        float u;
        if (this.definition.type.equals((Object)JSONParticle.ParticleType.BREAK)) {
            this.position.y -= 1.0;
            float[] uvPoints = InterfaceEventsModelLoader.getBlockBreakTexture(this.world, this.position);
            this.position.y += 1.0;
            u = uvPoints[0];
            U = uvPoints[1];
            v = uvPoints[2];
            V = uvPoints[3];
        } else {
            u = (float)uRow++ / 16.0f;
            U = (float)uRow / 16.0f;
            v = (float)vCol++ / 16.0f;
            V = (float)vCol / 16.0f;
        }
        block8: for (int i = 0; i < 6; ++i) {
            switch (i) {
                case 0: {
                    this.renderable.vertices.put(i * 8 + 3, U);
                    this.renderable.vertices.put(i * 8 + 4, V);
                    continue block8;
                }
                case 1: {
                    this.renderable.vertices.put(i * 8 + 3, U);
                    this.renderable.vertices.put(i * 8 + 4, v);
                    continue block8;
                }
                case 2: {
                    this.renderable.vertices.put(i * 8 + 3, u);
                    this.renderable.vertices.put(i * 8 + 4, v);
                    continue block8;
                }
                case 3: {
                    this.renderable.vertices.put(i * 8 + 3, U);
                    this.renderable.vertices.put(i * 8 + 4, V);
                    continue block8;
                }
                case 4: {
                    this.renderable.vertices.put(i * 8 + 3, u);
                    this.renderable.vertices.put(i * 8 + 4, v);
                    continue block8;
                }
                case 5: {
                    this.renderable.vertices.put(i * 8 + 3, u);
                    this.renderable.vertices.put(i * 8 + 4, V);
                }
            }
        }
    }

    private static FloatBuffer generateStandardBuffer() {
        FloatBuffer buffer = FloatBuffer.allocate(48);
        for (int i = 0; i < 6; ++i) {
            buffer.put(0.0f);
            buffer.put(0.0f);
            buffer.put(1.0f);
            switch (i) {
                case 0: {
                    buffer.put(1.0f);
                    buffer.put(1.0f);
                    buffer.put(0.5f);
                    buffer.put(-0.5f);
                    break;
                }
                case 1: {
                    buffer.put(1.0f);
                    buffer.put(0.0f);
                    buffer.put(0.5f);
                    buffer.put(0.5f);
                    break;
                }
                case 2: {
                    buffer.put(0.0f);
                    buffer.put(0.0f);
                    buffer.put(-0.5f);
                    buffer.put(0.5f);
                    break;
                }
                case 3: {
                    buffer.put(1.0f);
                    buffer.put(1.0f);
                    buffer.put(0.5f);
                    buffer.put(-0.5f);
                    break;
                }
                case 4: {
                    buffer.put(0.0f);
                    buffer.put(0.0f);
                    buffer.put(-0.5f);
                    buffer.put(0.5f);
                    break;
                }
                case 5: {
                    buffer.put(0.0f);
                    buffer.put(1.0f);
                    buffer.put(-0.5f);
                    buffer.put(-0.5f);
                }
            }
            buffer.put(0.0f);
        }
        buffer.flip();
        return buffer;
    }
}

