/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.instances.ItemPartGun;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONPlayerGun;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.WrapperEntity;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.rendering.instances.RenderPlayerGun;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.ControlSystem;
import minecrafttransportsimulator.systems.PackParserSystem;

public class EntityPlayerGun
extends AEntityF_Multipart<JSONPlayerGun> {
    public static final Map<UUID, EntityPlayerGun> playerClientGuns = new HashMap<UUID, EntityPlayerGun>();
    public static final Map<UUID, EntityPlayerGun> playerServerGuns = new HashMap<UUID, EntityPlayerGun>();
    public final WrapperPlayer player;
    private int hotbarSelected = -1;
    private WrapperItemStack gunStack;
    private boolean didGunFireLastTick;
    public PartGun activeGun;
    private static RenderPlayerGun renderer;

    public EntityPlayerGun(WrapperWorld world, WrapperPlayer placingPlayer, WrapperNBT data) {
        super(world, placingPlayer, data);
        if (placingPlayer != null) {
            this.player = placingPlayer;
            this.position.setTo(this.player.getPosition());
            this.prevPosition.setTo(this.position);
            this.angles.set(this.player.getPitch(), this.player.getYaw(), 0.0);
            this.prevAngles.setTo(this.angles);
        } else {
            UUID playerUUID = data.getUUID("playerUUID");
            WrapperPlayer foundPlayer = null;
            for (WrapperEntity entity : world.getEntitiesWithin(new BoundingBox(this.position, 16.0, 16.0, 16.0))) {
                if (!(entity instanceof WrapperPlayer) || !((WrapperPlayer)entity).getID().equals(playerUUID)) continue;
                foundPlayer = (WrapperPlayer)entity;
                break;
            }
            if (foundPlayer != null) {
                this.player = foundPlayer;
            } else {
                this.player = null;
                this.remove();
                return;
            }
        }
        if (world.isClient()) {
            if (playerClientGuns.containsKey(this.player.getID())) {
                playerClientGuns.get(this.player.getID()).remove();
            }
            playerClientGuns.put(this.player.getID(), this);
        } else {
            if (playerServerGuns.containsKey(this.player.getID())) {
                playerServerGuns.get(this.player.getID()).remove();
            }
            playerServerGuns.put(this.player.getID(), this);
        }
    }

    @Override
    public JSONPlayerGun generateDefaultDefinition() {
        JSONPlayerGun defaultDefinition = new JSONPlayerGun();
        defaultDefinition.packID = "dummy";
        defaultDefinition.systemName = "dummy";
        defaultDefinition.general = new AJSONItem.General(defaultDefinition);
        defaultDefinition.general.health = 100;
        JSONPartDefinition fakeDef = new JSONPartDefinition();
        fakeDef.pos = new Point3d();
        fakeDef.rot = new Point3d();
        fakeDef.types = new ArrayList<String>();
        for (AItemPack<?> packItem : PackParserSystem.getAllPackItems()) {
            if (!(packItem instanceof ItemPartGun)) continue;
            ItemPartGun gunItem = (ItemPartGun)packItem;
            if (!((JSONPart)gunItem.definition).gun.handHeld || fakeDef.types.contains(((JSONPart)gunItem.definition).generic.type)) continue;
            fakeDef.types.add(((JSONPart)gunItem.definition).generic.type);
        }
        fakeDef.maxValue = Float.MAX_VALUE;
        defaultDefinition.parts = new ArrayList();
        defaultDefinition.parts.add(fakeDef);
        return defaultDefinition;
    }

    @Override
    public boolean update() {
        if (super.update()) {
            if (this.player != null && this.player.isValid()) {
                ItemPartGun heldGun;
                AItemBase heldItem;
                this.position.setTo(this.player.getPosition());
                this.motion.setTo(this.player.getVelocity());
                PartGun partGun = this.activeGun = this.parts.isEmpty() ? null : (PartGun)this.parts.get(0);
                if (this.activeGun != null && this.gunStack == null) {
                    heldItem = this.player.getHeldItem();
                    if (heldItem instanceof ItemPartGun) {
                        heldGun = (ItemPartGun)heldItem;
                        if (((JSONPart)heldGun.definition).gun.handHeld) {
                            this.gunStack = this.player.getHeldStack();
                            this.hotbarSelected = this.player.getHotbarIndex();
                        }
                    }
                    if (this.activeGun != null && this.gunStack == null) {
                        this.removePart(this.activeGun, null);
                        this.activeGun = null;
                    }
                }
                if (!this.world.isClient()) {
                    if (!(this.activeGun == null || this.activeGun.getItem().equals(this.player.getHeldItem()) && this.hotbarSelected == this.player.getHotbarIndex())) {
                        this.saveGun(true);
                    }
                    if (this.activeGun == null && (heldItem = this.player.getHeldItem()) instanceof ItemPartGun) {
                        heldGun = (ItemPartGun)heldItem;
                        if (((JSONPart)heldGun.definition).gun.handHeld) {
                            this.gunStack = this.player.getHeldStack();
                            this.addPartFromItem(heldGun, this.player, this.gunStack.getData(), new Point3d(), false);
                            this.hotbarSelected = this.player.getHotbarIndex();
                        }
                    }
                }
                if (this.activeGun != null) {
                    Point3d heldVector = this.activeGun.isHandHeldGunAimed ? ((JSONPart)this.activeGun.definition).gun.handHeldAimedOffset : ((JSONPart)this.activeGun.definition).gun.handHeldNormalOffset;
                    this.angles.set(this.player.getPitch(), this.player.getYaw(), 0.0);
                    Point3d armRotation = new Point3d(this.angles.x, 0.0, 0.0);
                    this.position.setTo(heldVector).rotateFine(armRotation);
                    armRotation.set(0.0, this.angles.y, 0.0);
                    this.position.add(-0.3125, 0.0, 0.0).rotateFine(armRotation);
                    this.position.add(this.player.getPosition()).add(0.0, this.player.isSneaking() ? 1.1125 : 1.3125, 0.0);
                    if (this.player.getEntityRiding() != null) {
                        this.position.add(this.player.getEntityRiding().motion.copy().multiply(EntityVehicleF_Physics.SPEED_FACTOR));
                    }
                    if (!this.world.isClient()) {
                        if (this.activeGun.state.isAtLeast(PartGun.GunState.FIRING_CURRENTLY)) {
                            this.didGunFireLastTick = true;
                        } else if (this.didGunFireLastTick) {
                            this.saveGun(false);
                        }
                    } else if (this.player.equals(InterfaceClient.getClientPlayer())) {
                        ControlSystem.controlPlayerGun(this);
                    }
                }
            } else {
                this.remove();
                return false;
            }
            this.updatePostMovement();
            if (this.activeGun != null) {
                this.activeGun.isDisabled = this.player != null && this.player.isSpectator();
            }
            return true;
        }
        return false;
    }

    @Override
    public void remove() {
        super.remove();
        if (this.player != null) {
            if (this.world.isClient()) {
                playerClientGuns.remove(this.player.getID());
            } else {
                playerServerGuns.remove(this.player.getID());
            }
        }
    }

    @Override
    public boolean shouldRenderBeams() {
        return (Boolean)ConfigSystem.configObject.clientRendering.vehicleBeams.value;
    }

    @Override
    protected void updateCollisionBoxes() {
    }

    private void saveGun(boolean remove) {
        this.gunStack.setData(this.activeGun.save(this.gunStack.getData()));
        this.didGunFireLastTick = false;
        if (remove) {
            this.removePart(this.activeGun, null);
            this.activeGun = null;
        }
    }

    public RenderPlayerGun getRenderer() {
        if (renderer == null) {
            renderer = new RenderPlayerGun();
        }
        return renderer;
    }

    @Override
    public WrapperNBT save(WrapperNBT data) {
        super.save(data);
        if (this.player != null) {
            data.setUUID("playerUUID", this.player.getID());
        }
        return data;
    }
}

