/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.packets.instances.PacketEntityGUIRequest;
import minecrafttransportsimulator.sound.RadioManager;
import minecrafttransportsimulator.sound.RadioStation;
import minecrafttransportsimulator.sound.SoundInstance;

public class EntityRadio
extends AEntityB_Existing {
    public boolean randomOrder;
    public int preset;
    public String currentURL;
    public int volume;
    public String displayText;
    public RadioStation currentStation;
    private final AEntityB_Existing provider;
    private RadioManager.RadioSources currentSource;
    private SoundInstance currentSound;

    public EntityRadio(AEntityB_Existing provider, WrapperNBT data) {
        super(provider.world, null, data);
        this.provider = provider;
        if (this.world.isClient()) {
            if (data.getBoolean("savedRadio")) {
                this.changeSource(RadioManager.RadioSources.values()[data.getInteger("currentSource")]);
                this.changeVolume(data.getInteger("volume"));
                this.preset = data.getInteger("preset");
                this.currentURL = data.getString("currentURL");
                if (this.preset > 0) {
                    if (this.currentSource.equals((Object)RadioManager.RadioSources.LOCAL)) {
                        this.startLocalPlayback(this.preset, data.getBoolean("randomOrder"));
                    } else {
                        this.startInternetPlayback(this.currentURL, this.preset);
                    }
                }
            } else {
                this.changeSource(RadioManager.RadioSources.LOCAL);
                this.changeVolume(10);
            }
        } else {
            this.setProperties(RadioManager.RadioSources.values()[data.getInteger("currentSource")], data.getInteger("volume"), data.getInteger("preset"), data.getBoolean("randomOrder"), data.getString("currentURL"));
        }
    }

    @Override
    public boolean shouldSavePosition() {
        return false;
    }

    @Override
    public boolean update() {
        if (super.update()) {
            this.position.setTo(this.provider.position);
            return true;
        }
        return false;
    }

    @Override
    public boolean interact(WrapperPlayer player) {
        player.sendPacket(new PacketEntityGUIRequest(this, player, PacketEntityGUIRequest.EntityGUIType.RADIO));
        return true;
    }

    public void start() {
        this.currentSound = new SoundInstance(this, "Radio_" + this.uniqueUUID, null, this);
        this.currentSound.volume = (float)this.volume / 10.0f;
    }

    public void stop() {
        if (this.currentStation != null) {
            this.currentStation.removeRadio(this);
            this.currentStation = null;
            if (this.currentSound != null) {
                this.currentSound.stopSound = true;
            }
            this.displayText = "Radio turned off.";
        }
        this.preset = 0;
    }

    public void changeSource(RadioManager.RadioSources source) {
        this.stop();
        this.currentSource = source;
        switch (source) {
            case LOCAL: {
                this.displayText = "Ready to play from files on your PC.\nPress a station number to start.\nFiles are in folders in the mts_music directory.";
                break;
            }
            case SERVER: {
                this.displayText = "Ready to play from files on the server.\nPress a station number to start.";
                break;
            }
            case INTERNET: {
                this.displayText = "Ready to play from internet streams.\nPress a station number to start.\nOr press SET to set a station URL.";
            }
        }
    }

    public RadioManager.RadioSources getSource() {
        return this.currentSource;
    }

    public void changeVolume(int setVolume) {
        int n = this.volume = setVolume == 0 ? 10 : setVolume;
        if (this.currentSound != null) {
            this.currentSound.volume = (float)setVolume / 10.0f;
        }
    }

    public boolean isPlaying() {
        return this.currentSound != null && !this.currentSound.stopSound;
    }

    public SoundInstance getPlayingSound() {
        return this.currentSound;
    }

    public void startLocalPlayback(int index, boolean randomRequested) {
        this.stop();
        this.preset = index;
        this.randomOrder = randomRequested;
        this.currentStation = RadioManager.getLocalStation(this.preset - 1, this.randomOrder);
        this.currentStation.addRadio(this);
    }

    public void startServerPlayback(int index) {
        this.stop();
        this.preset = index;
        this.displayText = "This method of playback is not supported .... yet!";
    }

    public void startInternetPlayback(String newURL, int presetPressed) {
        this.stop();
        this.currentURL = newURL;
        this.preset = presetPressed;
        this.currentStation = RadioManager.getInternetStation(this.currentURL);
        this.currentStation.addRadio(this);
    }

    public void setProperties(RadioManager.RadioSources source, int volume, int preset, boolean randomOrder, String currentURL) {
        this.currentSource = source;
        this.volume = volume;
        this.preset = preset;
        this.randomOrder = randomOrder;
        this.currentURL = currentURL;
    }

    @Override
    public WrapperNBT save(WrapperNBT data) {
        super.save(data);
        data.setInteger("currentSource", this.currentSource.ordinal());
        data.setInteger("volume", this.volume);
        data.setBoolean("savedRadio", true);
        data.setBoolean("randomOrder", this.randomOrder);
        data.setInteger("preset", this.preset);
        data.setString("currentURL", this.currentURL);
        return data;
    }
}

