/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.HashSet;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.baseclasses.TrailerConnection;
import minecrafttransportsimulator.entities.instances.AEntityVehicleE_Powered;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityBullet;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.entities.instances.PartPropeller;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONVariableModifier;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableIncrement;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableSet;
import minecrafttransportsimulator.rendering.instances.RenderVehicle;
import minecrafttransportsimulator.systems.ConfigSystem;

public class EntityVehicleF_Physics
extends AEntityVehicleE_Powered {
    public double aileronAngle;
    public double aileronTrim;
    public static final double MAX_AILERON_ANGLE = 25.0;
    public static final double MAX_AILERON_TRIM = 10.0;
    public static final double AILERON_DAMPEN_RATE = 0.6;
    public static final String AILERON_VARIABLE = "aileron";
    public static final String AILERON_TRIM_VARIABLE = "trim_aileron";
    public double elevatorAngle;
    public double elevatorTrim;
    public static final double MAX_ELEVATOR_ANGLE = 25.0;
    public static final double MAX_ELEVATOR_TRIM = 10.0;
    public static final double ELEVATOR_DAMPEN_RATE = 0.6;
    public static final String ELEVATOR_VARIABLE = "elevator";
    public static final String ELEVATOR_TRIM_VARIABLE = "trim_elevator";
    public double rudderAngle;
    public double rudderTrim;
    public static final double MAX_RUDDER_ANGLE = 45.0;
    public static final double MAX_RUDDER_TRIM = 10.0;
    public static final double RUDDER_DAMPEN_RATE = 2.0;
    public static final String RUDDER_VARIABLE = "rudder";
    public static final String RUDDER_TRIM_VARIABLE = "trim_rudder";
    public static final short MAX_FLAP_ANGLE_REFERENCE = 350;
    public double flapDesiredAngle;
    public double flapCurrentAngle;
    public static final String FLAPS_VARIABLE = "flaps_setpoint";
    public boolean turningLeft;
    public boolean turningRight;
    public byte turningCooldown;
    public double autopilotSetting;
    public static final String AUTOPILOT_VARIABLE = "autopilot";
    public static final String AUTOLEVEL_VARIABLE = "auto_level";
    public boolean hasRotors;
    private double pitchDirectionFactor;
    public double trackAngle;
    private final Set<EntityVehicleF_Physics> towedVehiclesCheckedForWeights = new HashSet<EntityVehicleF_Physics>();
    public float currentWingArea;
    public float currentWingSpan;
    public float currentAileronArea;
    public float currentElevatorArea;
    public float currentRudderArea;
    public float currentDragCoefficient;
    public float currentBallastVolume;
    public float currentAxleRatio;
    private double wingLiftCoeff;
    private double aileronLiftCoeff;
    private double elevatorLiftCoeff;
    private double rudderLiftCoeff;
    private double dragCoeff;
    private double dragForce;
    private double wingForce;
    private double aileronForce;
    private double elevatorForce;
    private double rudderForce;
    private double ballastForce;
    private double gravitationalForce;
    private Point3d thrustForce = new Point3d();
    private Point3d totalAxialForce = new Point3d();
    private Point3d totalMotiveForce = new Point3d();
    private Point3d totalGlobalForce = new Point3d();
    private Point3d totalForce = new Point3d();
    private double momentRoll;
    private double momentPitch;
    private double momentYaw;
    private double aileronTorque;
    private double elevatorTorque;
    private double rudderTorque;
    private Point3d thrustTorque = new Point3d();
    private Point3d totalTorque = new Point3d();
    private Point3d rotorRotation = new Point3d();
    private static RenderVehicle renderer;

    public EntityVehicleF_Physics(WrapperWorld world, WrapperPlayer placingPlayer, WrapperNBT data) {
        super(world, placingPlayer, data);
        this.flapCurrentAngle = data.getDouble("flapCurrentAngle");
    }

    @Override
    public boolean update() {
        if (super.update()) {
            this.world.beginProfiling("VehicleF_Level", true);
            this.aileronAngle = this.getVariable(AILERON_VARIABLE);
            this.aileronTrim = this.getVariable(AILERON_TRIM_VARIABLE);
            this.elevatorAngle = this.getVariable(ELEVATOR_VARIABLE);
            this.elevatorTrim = this.getVariable(ELEVATOR_TRIM_VARIABLE);
            this.rudderAngle = this.getVariable(RUDDER_VARIABLE);
            this.rudderTrim = this.getVariable(RUDDER_TRIM_VARIABLE);
            this.autopilotSetting = this.getVariable(AUTOPILOT_VARIABLE);
            this.flapDesiredAngle = this.getVariable(FLAPS_VARIABLE);
            if (((JSONVehicle)this.definition).motorized.flapNotches != null && !((JSONVehicle)this.definition).motorized.flapNotches.isEmpty()) {
                if (this.flapCurrentAngle < this.flapDesiredAngle) {
                    this.flapCurrentAngle += (double)((JSONVehicle)this.definition).motorized.flapSpeed;
                } else if (this.flapCurrentAngle > this.flapDesiredAngle) {
                    this.flapCurrentAngle -= (double)((JSONVehicle)this.definition).motorized.flapSpeed;
                }
                if (Math.abs(this.flapCurrentAngle - this.flapDesiredAngle) < (double)((JSONVehicle)this.definition).motorized.flapSpeed) {
                    this.flapCurrentAngle = this.flapDesiredAngle;
                }
            }
            this.world.endProfiling();
            return true;
        }
        return false;
    }

    @Override
    public double getMass() {
        double combinedMass = super.getMass();
        if (!this.towingConnections.isEmpty()) {
            EntityVehicleF_Physics otherVehicle = null;
            for (TrailerConnection connection : this.towingConnections) {
                otherVehicle = connection.hookupVehicle;
                if (this.towedVehiclesCheckedForWeights.contains(otherVehicle)) {
                    InterfaceCore.logError("Infinite loop detected on weight checking code!  Is a trailer towing the thing that's towing it?");
                    break;
                }
                this.towedVehiclesCheckedForWeights.add(otherVehicle);
                combinedMass += otherVehicle.getMass();
                otherVehicle = null;
                this.towedVehiclesCheckedForWeights.clear();
            }
            if (otherVehicle != null) {
                this.disconnectTrailer(otherVehicle.towedByConnection);
            }
        }
        return combinedMass;
    }

    @Override
    protected double getSteeringAngle() {
        return -this.rudderAngle / 45.0;
    }

    @Override
    protected void addToSteeringAngle(float degrees) {
        double delta = 0.0;
        delta = this.rudderAngle - (double)degrees > 45.0 ? 45.0 - this.rudderAngle : (this.rudderAngle - (double)degrees < -45.0 ? -45.0 - this.rudderAngle : (double)(-degrees));
        this.setVariable(RUDDER_VARIABLE, this.rudderAngle + delta);
        InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, RUDDER_VARIABLE, delta));
    }

    @Override
    protected void updateVariableModifiers() {
        this.currentWingArea = (float)((double)((JSONVehicle)this.definition).motorized.wingArea + (double)(((JSONVehicle)this.definition).motorized.wingArea * 0.15f) * this.flapCurrentAngle / 350.0);
        this.currentWingSpan = ((JSONVehicle)this.definition).motorized.wingSpan;
        this.currentAileronArea = ((JSONVehicle)this.definition).motorized.aileronArea;
        this.currentElevatorArea = ((JSONVehicle)this.definition).motorized.elevatorArea;
        this.currentRudderArea = ((JSONVehicle)this.definition).motorized.rudderArea;
        this.currentDragCoefficient = ((JSONVehicle)this.definition).motorized.dragCoefficient;
        this.currentBallastVolume = ((JSONVehicle)this.definition).motorized.ballastVolume;
        this.currentDownForce = ((JSONVehicle)this.definition).motorized.downForce;
        this.currentBrakingFactor = ((JSONVehicle)this.definition).motorized.brakingFactor;
        this.currentOverSteer = ((JSONVehicle)this.definition).motorized.overSteer;
        this.currentUnderSteer = ((JSONVehicle)this.definition).motorized.underSteer;
        this.currentAxleRatio = ((JSONVehicle)this.definition).motorized.axleRatio;
        if (((JSONVehicle)this.definition).variableModifiers != null) {
            block28: for (JSONVariableModifier modifier : ((JSONVehicle)this.definition).variableModifiers) {
                switch (modifier.variable) {
                    case "wingArea": {
                        this.currentWingArea = this.adjustVariable(modifier, this.currentWingArea);
                        continue block28;
                    }
                    case "wingSpan": {
                        this.currentWingSpan = this.adjustVariable(modifier, this.currentWingSpan);
                        continue block28;
                    }
                    case "aileronArea": {
                        this.currentAileronArea = this.adjustVariable(modifier, this.currentAileronArea);
                        continue block28;
                    }
                    case "elevatorArea": {
                        this.currentElevatorArea = this.adjustVariable(modifier, this.currentElevatorArea);
                        continue block28;
                    }
                    case "rudderArea": {
                        this.currentRudderArea = this.adjustVariable(modifier, this.currentRudderArea);
                        continue block28;
                    }
                    case "dragCoefficient": {
                        this.currentDragCoefficient = this.adjustVariable(modifier, this.currentDragCoefficient);
                        continue block28;
                    }
                    case "ballastVolume": {
                        this.currentBallastVolume = this.adjustVariable(modifier, this.currentBallastVolume);
                        continue block28;
                    }
                    case "downForce": {
                        this.currentDownForce = this.adjustVariable(modifier, this.currentDownForce);
                        continue block28;
                    }
                    case "brakingFactor": {
                        this.currentBrakingFactor = this.adjustVariable(modifier, this.currentBrakingFactor);
                        continue block28;
                    }
                    case "overSteer": {
                        this.currentOverSteer = this.adjustVariable(modifier, this.currentOverSteer);
                        continue block28;
                    }
                    case "underSteer": {
                        this.currentUnderSteer = this.adjustVariable(modifier, this.currentUnderSteer);
                        continue block28;
                    }
                    case "axleRatio": {
                        this.currentAxleRatio = this.adjustVariable(modifier, this.currentAxleRatio);
                        continue block28;
                    }
                }
                this.setVariable(modifier.variable, this.adjustVariable(modifier, (float)this.getVariable(modifier.variable)));
            }
        }
    }

    @Override
    protected void getForcesAndMotions() {
        if (this.towedByConnection == null) {
            this.momentRoll = (double)((JSONVehicle)this.definition).motorized.emptyMass * (1.5 + this.fuelTank.getFluidLevel() / 10000.0);
            this.momentPitch = 2.0 * this.currentMass;
            this.momentYaw = 3.0 * this.currentMass;
            this.thrustForce.set(0.0, 0.0, 0.0);
            this.thrustTorque.set(0.0, 0.0, 0.0);
            this.rotorRotation.set(0.0, 0.0, 0.0);
            for (APart part : this.parts) {
                Point3d partForce;
                boolean isPropeller = false;
                boolean isRotor = false;
                double jetPower = 0.0;
                if (part instanceof PartEngine) {
                    partForce = ((PartEngine)part).getForceOutput();
                    jetPower = ((JSONPart)part.definition).engine.jetPowerFactor;
                } else {
                    if (!(part instanceof PartPropeller)) continue;
                    partForce = ((PartPropeller)part).getForceOutput();
                    isPropeller = true;
                    isRotor = ((JSONPart)part.definition).propeller.isRotor;
                }
                this.thrustForce.add(partForce);
                if (isPropeller || jetPower > 0.0) {
                    this.thrustTorque.add(partForce.y * -part.localOffset.z, partForce.z * part.localOffset.x, partForce.y * part.localOffset.x);
                }
                if (isRotor && !this.groundDeviceCollective.isAnythingOnGround() && partForce.length() > 1.0) {
                    this.hasRotors = true;
                    if (this.getVariable(AUTOLEVEL_VARIABLE) != 0.0) {
                        this.rotorRotation.set((-(this.elevatorAngle + this.elevatorTrim) - this.angles.x) / 25.0, -5.0 * this.rudderAngle / 45.0, (this.aileronAngle + this.aileronTrim - this.angles.z) / 25.0);
                        continue;
                    }
                    if (this.autopilotSetting == 0.0) {
                        this.rotorRotation.add(-5.0 * this.elevatorAngle / 25.0, -5.0 * this.rudderAngle / 45.0, 5.0 * this.aileronAngle / 25.0);
                        continue;
                    }
                    this.rotorRotation.x = this.angles.x < -1.0 ? 1.0 : (this.angles.x > 1.0 ? -1.0 : -this.angles.x);
                    this.rotorRotation.z = this.angles.z < -1.0 ? 1.0 : (this.angles.z > 1.0 ? -1.0 : -this.angles.z);
                    this.rotorRotation.y = -5.0 * this.rudderAngle / 45.0;
                    continue;
                }
                this.rotorRotation.set(0.0, 0.0, 0.0);
            }
            double d = this.gravitationalForce = this.currentBallastVolume == 0.0f ? this.currentMass * 0.0245 : 0.0;
            if (!((JSONVehicle)this.definition).motorized.isAircraft) {
                this.gravitationalForce *= ((Double)ConfigSystem.configObject.general.gravityFactor.value).doubleValue();
            }
            this.trackAngle = -Math.toDegrees(Math.asin(this.verticalVector.dotProduct(this.normalizedVelocityVector)));
            if (((JSONVehicle)this.definition).motorized.isBlimp) {
                if (this.aileronAngle < 0.0 && this.aileronAngle < this.rudderAngle || this.aileronAngle > 0.0 && this.aileronAngle > this.rudderAngle) {
                    this.rudderAngle = this.aileronAngle;
                }
                if (Math.abs(this.velocity) < 0.15 && (this.brake > 0.0 || this.parkingBrakeOn)) {
                    this.motion.x = 0.0;
                    this.motion.z = 0.0;
                    this.thrustForce.set(0.0, 0.0, 0.0);
                    this.thrustTorque.set(0.0, 0.0, 0.0);
                }
            }
            double yawAngleDelta = Math.toDegrees(Math.asin(this.sideVector.dotProduct(this.normalizedVelocityVector)));
            this.wingLiftCoeff = EntityVehicleF_Physics.getLiftCoeff(this.trackAngle, 2.0 + this.flapCurrentAngle / 350.0);
            this.aileronLiftCoeff = EntityVehicleF_Physics.getLiftCoeff(this.aileronAngle + this.aileronTrim, 2.0);
            this.elevatorLiftCoeff = EntityVehicleF_Physics.getLiftCoeff(-2.5 + this.trackAngle - (this.elevatorAngle + this.elevatorTrim), 2.0);
            this.rudderLiftCoeff = EntityVehicleF_Physics.getLiftCoeff(this.rudderAngle + this.rudderTrim - yawAngleDelta, 2.0);
            if (((JSONVehicle)this.definition).motorized.isBlimp) {
                this.dragCoeff = (double)0.004f * Math.pow(Math.abs(yawAngleDelta), 2.0) + (double)this.currentDragCoefficient;
            } else if (((JSONVehicle)this.definition).motorized.isAircraft) {
                this.dragCoeff = (double)4.0E-4f * Math.pow(this.trackAngle, 2.0) + (double)this.currentDragCoefficient;
            } else {
                this.dragCoeff = this.currentDragCoefficient;
                if (this.groundDeviceCollective.groundedGroundDevices.isEmpty()) {
                    this.dragCoeff *= 3.0;
                }
            }
            this.dragForce = ((JSONVehicle)this.definition).motorized.crossSectionalArea > 0.0f ? 0.5 * this.airDensity * this.velocity * this.velocity * (double)((JSONVehicle)this.definition).motorized.crossSectionalArea * this.dragCoeff : (this.currentWingSpan > 0.0f ? 0.5 * this.airDensity * this.velocity * this.velocity * (double)this.currentWingArea * (this.dragCoeff + this.wingLiftCoeff * this.wingLiftCoeff / (Math.PI * (double)((JSONVehicle)this.definition).motorized.wingSpan * (double)((JSONVehicle)this.definition).motorized.wingSpan / (double)this.currentWingArea * 0.8)) : 0.5 * this.airDensity * this.velocity * this.velocity * 5.0 * this.dragCoeff);
            if (this.currentBallastVolume > 0.0f) {
                this.ballastForce = this.elevatorAngle < 0.0 ? this.airDensity * (double)this.currentBallastVolume * -this.elevatorAngle / 10.0 : (this.elevatorAngle > 0.0 ? 1.225 * (double)this.currentBallastVolume * -this.elevatorAngle / 10.0 : 1.225 * (double)this.currentBallastVolume * 10.0 * -this.motion.y);
                if (this.motion.y * this.ballastForce != 0.0) {
                    this.ballastForce /= Math.pow(1.0 + Math.abs(this.motion.y), 2.0);
                }
            }
            this.wingForce = 0.5 * this.airDensity * this.axialVelocity * this.axialVelocity * (double)this.currentWingArea * this.wingLiftCoeff;
            this.aileronForce = 0.5 * this.airDensity * this.axialVelocity * this.axialVelocity * (double)this.currentAileronArea * this.aileronLiftCoeff;
            this.elevatorForce = 0.5 * this.airDensity * this.axialVelocity * this.axialVelocity * (double)this.currentElevatorArea * this.elevatorLiftCoeff;
            this.rudderForce = 0.5 * this.airDensity * this.axialVelocity * this.axialVelocity * (double)this.currentRudderArea * this.rudderLiftCoeff;
            this.aileronTorque = this.aileronForce * (double)this.currentWingSpan * 0.5 * 0.75;
            this.elevatorTorque = this.elevatorForce * (double)((JSONVehicle)this.definition).motorized.tailDistance;
            this.rudderTorque = this.rudderForce * (double)((JSONVehicle)this.definition).motorized.tailDistance;
            if (Math.abs(this.elevatorTorque) < 2.0 * this.currentMass / 400.0) {
                this.elevatorTorque = 0.0;
            }
            if (((JSONVehicle)this.definition).motorized.isBlimp) {
                this.aileronTorque = this.angles.z > 0.0 ? -Math.min(0.5, this.angles.z) * this.currentMass / 100.0 : (this.angles.z < 0.0 ? -Math.max(-0.5, this.angles.z) * this.currentMass / 100.0 : 0.0);
                this.elevatorTorque = this.angles.x > 0.0 ? -Math.min(0.5, this.angles.x) * this.currentMass / 100.0 : (this.angles.x < 0.0 ? -Math.max(-0.5, this.angles.x) * this.currentMass / 100.0 : 0.0);
                if (this.rudderTorque * this.rudderAngle <= 0.0) {
                    this.rudderTorque = 0.0;
                }
            }
            if (this.currentWingArea > 0.0f && this.trackAngle > 40.0 && this.angles.x < 45.0 && !this.groundDeviceCollective.isAnythingOnGround()) {
                this.elevatorTorque += 100.0;
            }
            if (this.damageAmount == (double)((JSONVehicle)this.definition).general.health) {
                this.wingForce = 0.0;
                this.elevatorForce = 0.0;
                this.aileronForce = 0.0;
                this.rudderForce = 0.0;
                this.elevatorTorque = 0.0;
                this.aileronTorque = 0.0;
                this.rudderTorque = 0.0;
                this.ballastForce = 0.0;
            }
            this.totalAxialForce.set(0.0, this.wingForce - this.elevatorForce, 0.0).add(this.thrustForce).rotateFine(this.angles);
            this.totalMotiveForce.set(-this.dragForce, -this.dragForce, -this.dragForce).multiply(this.normalizedVelocityVector);
            this.totalGlobalForce.set(0.0, this.ballastForce - this.gravitationalForce, 0.0);
            this.totalForce.setTo(this.totalAxialForce).add(this.totalMotiveForce).add(this.totalGlobalForce).multiply(1.0 / this.currentMass);
            this.motion.add(this.totalForce);
            this.pitchDirectionFactor = Math.abs(this.angles.z % 360.0);
            this.pitchDirectionFactor = this.pitchDirectionFactor < 90.0 || this.pitchDirectionFactor > 270.0 ? 1.0 : -1.0;
            this.totalTorque.set(this.elevatorTorque, this.rudderTorque, this.aileronTorque).add(this.thrustTorque).multiply(57.29577951308232);
            this.rotation.x = (this.pitchDirectionFactor * (1.0 - Math.abs(this.sideVector.y)) * this.totalTorque.x + this.sideVector.y * this.totalTorque.y) / this.momentPitch;
            this.rotation.y = (this.sideVector.y * this.totalTorque.x - this.verticalVector.y * this.totalTorque.y) / this.momentYaw;
            this.rotation.z = this.totalTorque.z / this.momentRoll;
            this.rotation.add(this.rotorRotation);
        } else if (!this.lockedOnRoad) {
            if (this.towedByConnection.hitchConnection.mounted) {
                Point3d hitchRotatedOffset = this.towedByConnection.getHitchCurrentPosition();
                Point3d hookupRotatedOffset = this.towedByConnection.getHookupCurrentPosition();
                this.motion.setTo(hitchRotatedOffset).subtract(hookupRotatedOffset).multiply(1.0 / SPEED_FACTOR);
                this.rotation.setTo(this.towedByConnection.hitchEntity.angles).add(this.towedByConnection.hitchConnection.rot).subtract(this.angles);
            } else {
                Point3d trailerHookupOffset;
                double rotationDelta;
                Point3d tractorHitchPrevOffsetXZ = this.towedByConnection.getHitchPrevPosition().subtract(this.prevPosition);
                Point3d tractorHitchCurrentOffsetXZ = this.towedByConnection.getHitchCurrentPosition().subtract(this.position);
                Point3d tractorHitchCurrentOffset = tractorHitchCurrentOffsetXZ.copy();
                tractorHitchPrevOffsetXZ.y = 0.0;
                tractorHitchCurrentOffsetXZ.y = 0.0;
                tractorHitchPrevOffsetXZ.normalize();
                tractorHitchCurrentOffsetXZ.normalize();
                if (this.towedByConnection.hitchConnection.restricted) {
                    rotationDelta = this.towedByConnection.hitchEntity.angles.y - this.angles.y;
                } else {
                    rotationDelta = Math.toDegrees(Math.acos(tractorHitchPrevOffsetXZ.dotProduct(tractorHitchCurrentOffsetXZ)));
                    rotationDelta *= Math.signum(tractorHitchPrevOffsetXZ.crossProduct((Point3d)tractorHitchCurrentOffsetXZ).y);
                }
                if (!Double.isNaN(rotationDelta)) {
                    this.rotation.y = rotationDelta;
                    this.angles.y += rotationDelta;
                    trailerHookupOffset = this.towedByConnection.getHookupCurrentPosition().subtract(this.position);
                    this.angles.y -= rotationDelta;
                } else {
                    trailerHookupOffset = this.towedByConnection.getHookupCurrentPosition().subtract(this.position);
                }
                this.motion.setTo(tractorHitchCurrentOffset.subtract(trailerHookupOffset).multiply(1.0 / SPEED_FACTOR));
                this.rotation.x = 0.0;
                this.rotation.z = 0.0;
            }
        } else {
            this.motion.setTo(this.towedByConnection.hitchVehicle.motion);
            this.rotation.set(0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void adjustControlSurfaces() {
        if (!((JSONVehicle)this.definition).motorized.isAircraft && this.autopilotSetting != 0.0) {
            if (this.velocity < this.autopilotSetting) {
                if (this.throttle < 1.0) {
                    this.throttle += 0.01;
                    this.setVariable("throttle", this.throttle);
                    InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, "throttle", 0.01));
                }
            } else if (this.velocity > this.autopilotSetting && this.throttle > 0.0) {
                this.throttle -= 0.01;
                this.setVariable("throttle", this.throttle);
                InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, "throttle", -0.01));
            }
        }
        if (this.hasRotors) {
            if (this.autopilotSetting != 0.0) {
                if (this.ticksExisted % 10L == 0L) {
                    if (this.motion.y < 0.0 && this.throttle < 1.0) {
                        this.throttle += 0.01;
                        this.setVariable("throttle", this.throttle);
                        InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, "throttle", 0.01));
                    } else if (this.motion.y > 0.0 && this.throttle < 1.0) {
                        this.throttle -= 0.01;
                        this.setVariable("throttle", this.throttle);
                        InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, "throttle", -0.01));
                    }
                }
                double forwardsVelocity = this.motion.dotProduct(this.headingVector);
                double sidewaysVelocity = this.motion.dotProduct(this.sideVector);
                double forwardsDelta = forwardsVelocity - this.prevMotion.dotProduct(this.headingVector);
                double sidewaysDelta = sidewaysVelocity - this.prevMotion.dotProduct(this.sideVector);
                if (forwardsDelta > 0.0 && forwardsVelocity > 0.0 && this.elevatorTrim < 10.0) {
                    this.setVariable(ELEVATOR_TRIM_VARIABLE, this.elevatorTrim + 1.0);
                    InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, ELEVATOR_TRIM_VARIABLE, 1.0));
                } else if (forwardsDelta < 0.0 && forwardsVelocity < 0.0 && this.elevatorTrim > -10.0) {
                    this.setVariable(ELEVATOR_TRIM_VARIABLE, this.elevatorTrim - 1.0);
                    InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, ELEVATOR_TRIM_VARIABLE, -1.0));
                }
                if (sidewaysVelocity > 0.0 && sidewaysDelta > 0.0 && this.aileronTrim < 10.0) {
                    this.setVariable(AILERON_TRIM_VARIABLE, this.aileronTrim + 1.0);
                    InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, AILERON_TRIM_VARIABLE, 1.0));
                } else if (sidewaysVelocity < 0.0 && sidewaysDelta < 0.0 && this.aileronTrim > -10.0) {
                    this.setVariable(AILERON_TRIM_VARIABLE, this.aileronTrim - 1.0);
                    InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, AILERON_TRIM_VARIABLE, -1.0));
                }
            } else {
                if (this.elevatorTrim < 0.0) {
                    this.setVariable(ELEVATOR_TRIM_VARIABLE, this.elevatorTrim + 1.0);
                    InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, ELEVATOR_TRIM_VARIABLE, 1.0));
                } else if (this.elevatorTrim > 0.0) {
                    this.setVariable(ELEVATOR_TRIM_VARIABLE, this.elevatorTrim - 1.0);
                    InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, ELEVATOR_TRIM_VARIABLE, -1.0));
                }
                if (this.aileronTrim < 0.0) {
                    this.setVariable(AILERON_TRIM_VARIABLE, this.aileronTrim + 1.0);
                    InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, AILERON_TRIM_VARIABLE, 1.0));
                } else if (this.aileronTrim > 0.0) {
                    this.setVariable(AILERON_TRIM_VARIABLE, this.aileronTrim - 1.0);
                    InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, AILERON_TRIM_VARIABLE, -1.0));
                }
            }
        } else if (((JSONVehicle)this.definition).motorized.isAircraft && this.autopilotSetting != 0.0) {
            if (-this.motion.y * 100.0 > this.elevatorTrim + 1.0 && this.elevatorTrim < 10.0) {
                this.setVariable(ELEVATOR_TRIM_VARIABLE, this.elevatorTrim + 0.1);
                InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, ELEVATOR_TRIM_VARIABLE, 0.1));
            } else if (-this.motion.y * 100.0 < this.elevatorTrim - 1.0 && this.elevatorTrim > -10.0) {
                this.setVariable(ELEVATOR_TRIM_VARIABLE, this.elevatorTrim - 0.1);
                InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, ELEVATOR_TRIM_VARIABLE, -0.1));
            }
            if (-this.angles.z > this.aileronTrim + 0.1 && this.aileronTrim < 10.0) {
                this.setVariable(AILERON_TRIM_VARIABLE, this.aileronTrim + 0.1);
                InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, AILERON_TRIM_VARIABLE, 0.1));
            } else if (-this.angles.z < this.aileronTrim - 0.1 && this.aileronTrim > -10.0) {
                this.setVariable(AILERON_TRIM_VARIABLE, this.aileronTrim - 0.1);
                InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, AILERON_TRIM_VARIABLE, -0.1));
            }
        }
        boolean haveController = false;
        for (Point3d partPos : this.locationRiderMap.keySet()) {
            APart part = this.getPartAtLocation(partPos);
            if (!(part instanceof PartSeat) || !part.placementDefinition.isController) continue;
            haveController = true;
            break;
        }
        if (!haveController && !this.lockedOnRoad) {
            if (this.aileronAngle > 0.6) {
                this.setVariable(AILERON_VARIABLE, this.aileronAngle - 0.6);
                InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, AILERON_VARIABLE, -0.6, 0.0, 25.0));
            } else if (this.aileronAngle < -0.6) {
                this.setVariable(AILERON_VARIABLE, this.aileronAngle + 0.6);
                InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, AILERON_VARIABLE, 0.6, -25.0, 0.0));
            } else if (this.aileronAngle != 0.0) {
                this.setVariable(AILERON_VARIABLE, 0.0);
                InterfacePacket.sendToAllClients(new PacketEntityVariableSet(this, AILERON_VARIABLE, 0.0));
            }
            if (this.elevatorAngle > 0.6) {
                this.setVariable(ELEVATOR_VARIABLE, this.elevatorAngle - 0.6);
                InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, ELEVATOR_VARIABLE, -0.6, 0.0, 25.0));
            } else if (this.elevatorAngle < -0.6) {
                this.setVariable(ELEVATOR_VARIABLE, this.elevatorAngle + 0.6);
                InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, ELEVATOR_VARIABLE, 0.6, -25.0, 0.0));
            } else if (this.elevatorAngle != 0.0) {
                this.setVariable(ELEVATOR_VARIABLE, 0.0);
                InterfacePacket.sendToAllClients(new PacketEntityVariableSet(this, ELEVATOR_VARIABLE, 0.0));
            }
            if (this.rudderAngle > 2.0) {
                this.setVariable(RUDDER_VARIABLE, this.rudderAngle - 2.0);
                InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, RUDDER_VARIABLE, -2.0, 0.0, 45.0));
            } else if (this.rudderAngle < -2.0) {
                this.setVariable(RUDDER_VARIABLE, this.rudderAngle + 2.0);
                InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, RUDDER_VARIABLE, 2.0, -45.0, 0.0));
            } else if (this.rudderAngle != 0.0) {
                this.setVariable(RUDDER_VARIABLE, 0.0);
                InterfacePacket.sendToAllClients(new PacketEntityVariableSet(this, RUDDER_VARIABLE, 0.0));
            }
        }
    }

    protected static double getLiftCoeff(double angleOfAttack, double maxLiftCoeff) {
        if (angleOfAttack == 0.0) {
            return 0.0;
        }
        if (Math.abs(angleOfAttack) <= 18.75) {
            return maxLiftCoeff * Math.sin(1.5707963267948966 * angleOfAttack / 15.0);
        }
        if (Math.abs(angleOfAttack) <= 22.5) {
            if (angleOfAttack > 0.0) {
                return maxLiftCoeff * (0.4 + 1.0 / (angleOfAttack - 15.0));
            }
            return maxLiftCoeff * (-0.4 + 1.0 / (angleOfAttack + 15.0));
        }
        return maxLiftCoeff * Math.sin(0.5235987755982988 * angleOfAttack / 15.0);
    }

    @Override
    public boolean shouldRenderBeams() {
        return (Boolean)ConfigSystem.configObject.clientRendering.vehicleBeams.value;
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        if (((JSONVehicle)this.definition).motorized.isTrailer && this.towedByConnection != null && ((JSONVehicle)this.definition).motorized.hookupVariables.contains(variable)) {
            return this.towedByConnection.hitchVehicle.getRawVariableValue(variable, partialTicks);
        }
        switch (variable) {
            case "yaw": {
                return this.angles.y;
            }
            case "heading": {
                int heading = (int)(-this.angles.y);
                if (((Boolean)ConfigSystem.configObject.clientControls.north360.value).booleanValue()) {
                    heading += 180;
                }
                while (heading < 1) {
                    heading += 360;
                }
                while (heading > 360) {
                    heading -= 360;
                }
                return heading;
            }
            case "pitch": {
                return this.angles.x;
            }
            case "roll": {
                return this.angles.z;
            }
            case "altitude": {
                return this.position.y;
            }
            case "speed": {
                return this.axialVelocity * SPEED_FACTOR * 20.0;
            }
            case "speed_scaled": {
                return this.axialVelocity * 20.0;
            }
            case "acceleration": {
                return this.motion.length() - this.prevMotion.length();
            }
            case "fuel": {
                return this.fuelTank.getFluidLevel() / (double)this.fuelTank.getMaxLevel();
            }
            case "electric_power": {
                return this.electricPower;
            }
            case "electric_usage": {
                return this.electricFlow * 20.0;
            }
            case "engines_on": {
                return this.enginesOn ? 1.0 : 0.0;
            }
            case "engines_running": {
                return this.enginesRunning ? 1.0 : 0.0;
            }
            case "reverser": {
                return this.reverseThrust ? 1.0 : 0.0;
            }
            case "locked": {
                return this.locked ? 1.0 : 0.0;
            }
            case "door": {
                return this.parkingBrakeOn && this.velocity < 0.25 ? 1.0 : 0.0;
            }
            case "fueling": {
                return this.beingFueled ? 1.0 : 0.0;
            }
            case "flaps_actual": {
                return this.flapCurrentAngle;
            }
            case "flaps_moving": {
                return this.flapCurrentAngle != this.flapDesiredAngle ? 1.0 : 0.0;
            }
            case "vertical_speed": {
                return this.motion.y * SPEED_FACTOR * 20.0;
            }
            case "lift_reserve": {
                return -this.trackAngle;
            }
            case "turn_coordinator": {
                return ((this.angles.z - this.prevAngles.z) / 10.0 + this.angles.y - this.prevAngles.y) / 0.15 * 25.0;
            }
            case "turn_indicator": {
                return (this.angles.y - this.prevAngles.y) / (double)0.15f * 25.0;
            }
            case "slip": {
                return 75.0 * this.sideVector.dotProduct(this.normalizedVelocityVector);
            }
            case "gear_moving": {
                return (this.isVariableActive("gear_setpoint") ? this.gearMovementTime != ((JSONVehicle)this.definition).motorized.gearSequenceDuration : this.gearMovementTime != 0) ? 1.0 : 0.0;
            }
            case "beacon_direction": {
                return this.selectedBeacon != null ? this.angles.getClampedYDelta(Math.toDegrees(Math.atan2(this.selectedBeacon.position.x - this.position.x, this.selectedBeacon.position.z - this.position.z))) : 0.0;
            }
            case "beacon_bearing_setpoint": {
                return this.selectedBeacon != null ? this.selectedBeacon.bearing : 0.0;
            }
            case "beacon_bearing_delta": {
                return this.selectedBeacon != null ? this.selectedBeacon.getBearingDelta(this) : 0.0;
            }
            case "beacon_glideslope_setpoint": {
                return this.selectedBeacon != null ? this.selectedBeacon.glideSlope : 0.0;
            }
            case "beacon_glideslope_actual": {
                return this.selectedBeacon != null ? Math.toDegrees(Math.asin((this.position.y - this.selectedBeacon.position.y) / this.position.distanceTo(this.selectedBeacon.position))) : 0.0;
            }
            case "beacon_glideslope_delta": {
                return this.selectedBeacon != null ? this.selectedBeacon.glideSlope - Math.toDegrees(Math.asin((this.position.y - this.selectedBeacon.position.y) / this.position.distanceTo(this.selectedBeacon.position))) : 0.0;
            }
        }
        if (variable.startsWith("missile_")) {
            String missileVariable = variable.substring(variable.lastIndexOf("_") + 1);
            int missileNumber = EntityVehicleF_Physics.getVariableNumber(variable.substring(0, variable.lastIndexOf(95)));
            if (missileNumber != -1) {
                if (this.missilesIncoming.size() <= missileNumber) {
                    return 0.0;
                }
                switch (missileVariable) {
                    case "distance": {
                        return ((EntityBullet)this.missilesIncoming.get((int)missileNumber)).targetDistance;
                    }
                    case "direction": {
                        Point3d missilePos = ((EntityBullet)this.missilesIncoming.get((int)missileNumber)).position;
                        return Math.toDegrees(Math.atan2(-missilePos.z + this.position.z, -missilePos.x + this.position.x)) + 90.0 + this.angles.y;
                    }
                }
            } else if (missileVariable.equals("incoming")) {
                return this.missilesIncoming.isEmpty() ? 0.0 : 1.0;
            }
        }
        return super.getRawVariableValue(variable, partialTicks);
    }

    public RenderVehicle getRenderer() {
        if (renderer == null) {
            renderer = new RenderVehicle();
        }
        return renderer;
    }

    @Override
    public WrapperNBT save(WrapperNBT data) {
        super.save(data);
        data.setDouble("flapCurrentAngle", this.flapCurrentAngle);
        return data;
    }
}

