/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.packets.instances.PacketPartEffector;

public class PartEffector
extends APart {
    private final List<WrapperItemStack> drops = new ArrayList<WrapperItemStack>();
    public int blocksBroken;
    private final Point3d flooredCenter = new Point3d();
    private final Map<BoundingBox, Point3d> boxLastPositionsFloored = new HashMap<BoundingBox, Point3d>();
    private final Map<BoundingBox, Integer> boxTimeSpentAtPosition = new HashMap<BoundingBox, Integer>();
    private final Set<Point3d> blockFlooredPositionsBrokeThisTick = new HashSet<Point3d>();

    public PartEffector(AEntityF_Multipart<?> entityOn, WrapperPlayer placingPlayer, JSONPartDefinition placementDefinition, WrapperNBT data, APart parentPart) {
        super(entityOn, placingPlayer, placementDefinition, data, parentPart);
        this.blocksBroken = data.getInteger("blocksBroken");
    }

    @Override
    public boolean update() {
        if (super.update()) {
            if (this.isActive && !this.world.isClient() && this.damageAmount < (double)((JSONPart)this.definition).general.health) {
                this.drops.clear();
                this.blockFlooredPositionsBrokeThisTick.clear();
                for (BoundingBox box : this.entityCollisionBoxes) {
                    switch (((JSONPart)this.definition).effector.type) {
                        case FERTILIZER: {
                            WrapperItemStack stack;
                            int i;
                            block9: for (APart part : this.entityOn.parts) {
                                if (!(part instanceof PartInteractable) || !((JSONPart)part.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.CRATE) || !part.isActive || !((JSONPart)part.definition).interactable.feedsVehicles) continue;
                                EntityInventoryContainer entityInventoryContainer = ((PartInteractable)part).inventory;
                                for (i = 0; i < entityInventoryContainer.getSize(); ++i) {
                                    stack = entityInventoryContainer.getStack(i);
                                    if (!this.world.fertilizeBlock(box.globalCenter, stack)) continue;
                                    entityInventoryContainer.removeFromSlot(i, 1);
                                    continue block9;
                                }
                            }
                            break;
                        }
                        case HARVESTER: {
                            this.drops.addAll(this.world.harvestBlock(box.globalCenter));
                            break;
                        }
                        case PLANTER: {
                            WrapperItemStack stack;
                            int i;
                            block11: for (APart part : this.entityOn.parts) {
                                if (!(part instanceof PartInteractable) || !((JSONPart)part.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.CRATE) || !part.isActive || !((JSONPart)part.definition).interactable.feedsVehicles) continue;
                                EntityInventoryContainer entityInventoryContainer = ((PartInteractable)part).inventory;
                                for (i = 0; i < entityInventoryContainer.getSize(); ++i) {
                                    stack = entityInventoryContainer.getStack(i);
                                    if (!this.world.plantBlock(box.globalCenter, stack)) continue;
                                    entityInventoryContainer.removeFromSlot(i, 1);
                                    continue block11;
                                }
                            }
                            break;
                        }
                        case PLOW: {
                            List<WrapperItemStack> harvestedDrops;
                            if (!this.world.plowBlock(box.globalCenter) || (harvestedDrops = this.world.harvestBlock(box.globalCenter)).isEmpty()) break;
                            for (WrapperItemStack wrapperItemStack : harvestedDrops) {
                                if (wrapperItemStack.getSize() <= 0) continue;
                                this.world.spawnItemStack(wrapperItemStack, this.position);
                            }
                            break;
                        }
                        case SNOWPLOW: {
                            this.world.removeSnow(box.globalCenter);
                            break;
                        }
                        case DRILL: {
                            float blockHardness;
                            if (!this.world.isAir(box.globalCenter) && (blockHardness = this.world.getBlockHardness(box.globalCenter)) <= ((JSONPart)this.definition).effector.drillHardness) {
                                if (!this.boxLastPositionsFloored.containsKey(box)) {
                                    this.boxLastPositionsFloored.put(box, new Point3d());
                                    this.boxTimeSpentAtPosition.put(box, 0);
                                }
                                this.flooredCenter.set(Math.floor(box.globalCenter.x), Math.floor(box.globalCenter.y), Math.floor(box.globalCenter.z));
                                if (this.boxLastPositionsFloored.get(box).equals(this.flooredCenter) && !this.blockFlooredPositionsBrokeThisTick.contains(this.flooredCenter)) {
                                    int timeSpentBreaking = this.boxTimeSpentAtPosition.get(box);
                                    if ((float)timeSpentBreaking >= ((JSONPart)this.definition).effector.drillSpeed * blockHardness / ((JSONPart)this.definition).effector.drillHardness) {
                                        this.drops.addAll(this.world.getBlockDrops(this.flooredCenter));
                                        this.world.destroyBlock(this.flooredCenter, false);
                                        this.boxTimeSpentAtPosition.put(box, 0);
                                        this.blockFlooredPositionsBrokeThisTick.add(this.flooredCenter.copy());
                                        if (++this.blocksBroken == ((JSONPart)this.definition).effector.drillDurability) {
                                            this.isValid = false;
                                            break;
                                        }
                                        InterfacePacket.sendToAllClients(new PacketPartEffector(this));
                                        break;
                                    }
                                    this.boxTimeSpentAtPosition.put(box, timeSpentBreaking + 1);
                                    break;
                                }
                                this.boxLastPositionsFloored.put(box, this.flooredCenter.copy());
                            }
                            this.boxTimeSpentAtPosition.put(box, 0);
                        }
                    }
                    if (this.drops.isEmpty()) continue;
                    Iterator<WrapperItemStack> iterator = this.drops.iterator();
                    block14: while (iterator.hasNext()) {
                        WrapperItemStack dropStack = iterator.next();
                        for (APart part : this.entityOn.parts) {
                            if (!(part instanceof PartInteractable) || !part.isActive || !((JSONPart)part.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.CRATE) || !((PartInteractable)part).inventory.addStack(dropStack)) continue;
                            iterator.remove();
                            continue block14;
                        }
                    }
                    for (WrapperItemStack wrapperItemStack : this.drops) {
                        this.world.spawnItemStack(wrapperItemStack, this.position);
                    }
                    this.drops.clear();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        switch (variable) {
            case "effector_active": {
                return this.isActive ? 1.0 : 0.0;
            }
            case "effector_drill_broken": {
                return this.blocksBroken;
            }
            case "effector_drill_max": {
                return ((JSONPart)this.definition).effector.drillDurability;
            }
            case "effector_drill_percentage": {
                return (double)this.blocksBroken / (double)((JSONPart)this.definition).effector.drillDurability;
            }
        }
        return super.getRawVariableValue(variable, partialTicks);
    }

    @Override
    public WrapperNBT save(WrapperNBT data) {
        super.save(data);
        data.setInteger("blocksBroken", this.blocksBroken);
        return data;
    }
}

