/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartGroundDevice;
import minecrafttransportsimulator.entities.instances.PartPropeller;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONVariableModifier;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperEntity;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableIncrement;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableToggle;
import minecrafttransportsimulator.packets.instances.PacketPartEngine;
import minecrafttransportsimulator.systems.ConfigSystem;

public class PartEngine
extends APart {
    public boolean isCreative;
    public boolean oilLeak;
    public boolean fuelLeak;
    public boolean brokenStarter;
    public boolean backfired;
    public boolean badShift;
    public boolean running;
    public boolean magnetoOn;
    public boolean electricStarterEngaged;
    public boolean handStarterEngaged;
    public byte forwardsGears;
    public byte reverseGears;
    public byte currentGear;
    public int upshiftCountdown;
    public int downshiftCountdown;
    public int internalFuel;
    public double hours;
    public double rpm;
    public double temp = 20.0;
    public double pressure;
    public float propellerGearboxRatio;
    public double fuelFlow;
    public PartEngine linkedEngine;
    private float currentMaxRPM;
    private float currentMaxSafeRPM;
    private float currentRevlimitRPM;
    private float currentIdleRPM;
    private float currentFuelConsumption;
    private float currentHeatingCoefficient;
    private float currentCoolingCoefficient;
    private float currentSuperchargerFuelConsumption;
    private float currentSuperchargerEfficiency;
    private boolean isPropellerInLiquid;
    private boolean autoStarterEngaged;
    private int starterLevel;
    private int shiftCooldown;
    private int backfireCooldown;
    private float currentGearRatio;
    private double lowestWheelVelocity;
    private double desiredWheelVelocity;
    private double propellerAxialVelocity;
    private double engineAxialVelocity;
    private float wheelFriction;
    private double ambientTemp;
    private double coolingFactor;
    private double engineTargetRPM;
    private double engineRotation;
    private double prevEngineRotation;
    private double driveshaftRotation;
    private double prevDriveshaftRotation;
    private PartPropeller attachedPropeller;
    private final Point3d engineForce = new Point3d();
    public static final String MAGNETO_VARIABLE = "engine_magneto";
    public static final String ELECTRIC_STARTER_VARIABLE = "engine_starter";
    public static final String HAND_STARTER_VARIABLE = "engine_starter_hand";
    public static final String UP_SHIFT_VARIABLE = "engine_shift_up";
    public static final String DOWN_SHIFT_VARIABLE = "engine_shift_down";
    public static final String NEUTRAL_SHIFT_VARIABLE = "engine_shift_neutral";
    public static final String GEAR_VARIABLE = "engine_gear";
    public static final float COLD_TEMP = 30.0f;
    public static final float OVERHEAT_TEMP_1 = 115.556f;
    public static final float OVERHEAT_TEMP_2 = 121.111f;
    public static final float FAILURE_TEMP = 132.222f;
    public static final float LOW_OIL_PRESSURE = 40.0f;
    public static final float MAX_SHIFT_SPEED = 0.35f;

    public PartEngine(AEntityF_Multipart<?> entityOn, WrapperPlayer placingPlayer, JSONPartDefinition placementDefinition, WrapperNBT data, APart parentPart) {
        super(entityOn, placingPlayer, placementDefinition, data, parentPart);
        this.isCreative = data.getBoolean("isCreative");
        this.oilLeak = data.getBoolean("oilLeak");
        this.fuelLeak = data.getBoolean("fuelLeak");
        this.brokenStarter = data.getBoolean("brokenStarter");
        this.running = data.getBoolean("running");
        this.hours = data.getDouble("hours");
        this.rpm = data.getDouble("rpm");
        this.temp = data.getDouble("temp");
        this.pressure = data.getDouble("pressure");
        for (float gear : ((JSONPart)this.definition).engine.gearRatios) {
            if (gear < 0.0f) {
                this.reverseGears = (byte)(this.reverseGears + 1);
                continue;
            }
            if (!(gear > 0.0f)) continue;
            this.forwardsGears = (byte)(this.forwardsGears + 1);
        }
        if (this.vehicleOn != null && ((JSONVehicle)this.vehicleOn.definition).motorized.isAircraft) {
            this.setVariable(GEAR_VARIABLE, 1.0);
        }
    }

    @Override
    public void attack(Damage damage) {
        super.attack(damage);
        if (!damage.isWater) {
            if (((JSONPart)this.definition).engine.disableAutomaticStarter && damage.entityResponsible instanceof WrapperPlayer && ((WrapperPlayer)damage.entityResponsible).getHeldStack().isEmpty() && !this.entityOn.equals(damage.entityResponsible.getEntityRiding())) {
                if (!this.magnetoOn) {
                    this.setVariable(MAGNETO_VARIABLE, 1.0);
                    InterfacePacket.sendToAllClients(new PacketEntityVariableToggle(this, MAGNETO_VARIABLE));
                }
                this.handStartEngine();
                InterfacePacket.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.HS_ON));
                return;
            }
            if (!this.isCreative) {
                if (damage.isExplosion) {
                    this.hours += damage.amount * 20.0 * (Double)ConfigSystem.configObject.general.engineHoursFactor.value;
                    if (!((JSONPart)this.definition).engine.isSteamPowered) {
                        if (!this.oilLeak) {
                            boolean bl = this.oilLeak = Math.random() < (Double)ConfigSystem.configObject.damage.engineLeakProbability.value * 10.0;
                        }
                        if (!this.fuelLeak) {
                            boolean bl = this.fuelLeak = Math.random() < (Double)ConfigSystem.configObject.damage.engineLeakProbability.value * 10.0;
                        }
                        if (!this.brokenStarter) {
                            this.brokenStarter = Math.random() < 0.05;
                        }
                    }
                    InterfacePacket.sendToAllClients(new PacketPartEngine(this, damage.amount * 10.0 * (Double)ConfigSystem.configObject.general.engineHoursFactor.value, this.oilLeak, this.fuelLeak, this.brokenStarter));
                } else {
                    this.hours += damage.amount * 2.0 * (Double)ConfigSystem.configObject.general.engineHoursFactor.value;
                    if (!((JSONPart)this.definition).engine.isSteamPowered) {
                        if (!this.oilLeak) {
                            boolean bl = this.oilLeak = Math.random() < (Double)ConfigSystem.configObject.damage.engineLeakProbability.value;
                        }
                        if (!this.fuelLeak) {
                            this.fuelLeak = Math.random() < (Double)ConfigSystem.configObject.damage.engineLeakProbability.value;
                        }
                    }
                    InterfacePacket.sendToAllClients(new PacketPartEngine(this, damage.amount * (Double)ConfigSystem.configObject.general.engineHoursFactor.value, this.oilLeak, this.fuelLeak, this.brokenStarter));
                }
            }
        } else {
            this.stallEngine(PacketPartEngine.Signal.DROWN);
            InterfacePacket.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.DROWN));
        }
    }

    @Override
    public boolean update() {
        block104: {
            block105: {
                block106: {
                    block107: {
                        block108: {
                            if (!super.update()) break block104;
                            this.backfired = false;
                            this.badShift = false;
                            this.magnetoOn = this.isVariableActive(MAGNETO_VARIABLE);
                            this.electricStarterEngaged = this.isVariableActive(ELECTRIC_STARTER_VARIABLE);
                            this.handStarterEngaged = this.isVariableActive(HAND_STARTER_VARIABLE);
                            this.currentGear = (byte)this.getVariable(GEAR_VARIABLE);
                            if (this.running && !this.magnetoOn) {
                                this.running = false;
                                this.internalFuel = 200;
                            }
                            this.fuelFlow = 0.0;
                            if (this.upshiftCountdown > 0) {
                                --this.upshiftCountdown;
                            }
                            if (this.downshiftCountdown > 0) {
                                --this.downshiftCountdown;
                            }
                            this.currentGearRatio = ((JSONPart)this.definition).engine.gearRatios.get(this.currentGear + this.reverseGears).floatValue();
                            if (this.vehicleOn == null) break block105;
                            if (this.linkedEngine != null) {
                                if (this.linkedEngine.position.distanceTo(this.position) > 16.0) {
                                    this.linkedEngine.linkedEngine = null;
                                    this.linkedEngine = null;
                                    if (this.world.isClient()) {
                                        for (WrapperEntity entity : this.world.getEntitiesWithin(new BoundingBox(this.position, 16.0, 16.0, 16.0))) {
                                            if (!(entity instanceof WrapperPlayer)) continue;
                                            ((WrapperPlayer)entity).displayChatMessage("interact.jumpercable.linkdropped");
                                        }
                                    }
                                } else if (this.vehicleOn.electricPower + 0.5 < this.linkedEngine.vehicleOn.electricPower) {
                                    this.linkedEngine.vehicleOn.electricPower -= (double)0.005f;
                                    this.vehicleOn.electricPower += (double)0.005f;
                                } else if (this.vehicleOn.electricPower > this.linkedEngine.vehicleOn.electricPower + 0.5) {
                                    this.vehicleOn.electricPower -= (double)0.005f;
                                    this.linkedEngine.vehicleOn.electricPower += (double)0.005f;
                                } else {
                                    this.linkedEngine.linkedEngine = null;
                                    this.linkedEngine = null;
                                    if (this.world.isClient()) {
                                        for (WrapperEntity entity : this.world.getEntitiesWithin(new BoundingBox(this.position, 16.0, 16.0, 16.0))) {
                                            if (!(entity instanceof WrapperPlayer)) continue;
                                            ((WrapperPlayer)entity).displayChatMessage("interact.jumpercable.powerequal");
                                        }
                                    }
                                }
                            }
                            this.ambientTemp = (double)(25.0f * this.world.getTemperature(this.position) + 5.0f) * (Double)ConfigSystem.configObject.general.engineBiomeTempFactor.value;
                            this.coolingFactor = 0.001 * (double)this.currentCoolingCoefficient - (double)(this.currentSuperchargerEfficiency / 1000.0f) * (this.rpm / 2000.0) + this.vehicleOn.velocity / 1000.0 * (double)this.currentCoolingCoefficient;
                            this.temp -= (this.temp - this.ambientTemp) * this.coolingFactor;
                            if (this.electricStarterEngaged) {
                                if (this.starterLevel == 0) {
                                    if (this.vehicleOn.electricPower > 1.0) {
                                        this.starterLevel += 4;
                                    } else {
                                        this.setVariable(ELECTRIC_STARTER_VARIABLE, 0.0);
                                        InterfacePacket.sendToAllClients(new PacketEntityVariableToggle(this, ELECTRIC_STARTER_VARIABLE));
                                    }
                                }
                                if (this.starterLevel > 0) {
                                    if (!this.isCreative) {
                                        this.vehicleOn.electricUsage += (double)0.05f;
                                    }
                                    if (!this.isCreative) {
                                        this.fuelFlow += this.vehicleOn.fuelTank.drain(this.vehicleOn.fuelTank.getFluid(), (double)this.getTotalFuelConsumption() * (Double)ConfigSystem.configObject.general.fuelUsageFactor.value, !this.world.isClient());
                                    }
                                }
                                if (this.autoStarterEngaged && this.running) {
                                    this.setVariable(ELECTRIC_STARTER_VARIABLE, 0.0);
                                    InterfacePacket.sendToAllClients(new PacketEntityVariableToggle(this, ELECTRIC_STARTER_VARIABLE));
                                }
                            } else if (this.handStarterEngaged) {
                                if (this.starterLevel == 0) {
                                    this.setVariable(HAND_STARTER_VARIABLE, 0.0);
                                }
                            } else {
                                this.starterLevel = 0;
                                this.autoStarterEngaged = false;
                            }
                            if (this.starterLevel > 0) {
                                --this.starterLevel;
                                this.rpm = this.rpm < (double)(((JSONPart)this.definition).engine.startRPM * 2) ? Math.min(this.rpm + (double)((JSONPart)this.definition).engine.starterPower, (double)(((JSONPart)this.definition).engine.startRPM * 2)) : Math.max(this.rpm - (double)((JSONPart)this.definition).engine.starterPower, (double)(((JSONPart)this.definition).engine.startRPM * 2));
                            }
                            if (!this.isCreative && this.rpm > (double)this.currentMaxSafeRPM) {
                                this.hours += (this.rpm - (double)this.currentMaxSafeRPM) / (double)this.currentMaxSafeRPM * this.getTotalWearFactor();
                            }
                            if (this.isVariableActive(UP_SHIFT_VARIABLE)) {
                                this.shiftUp(false);
                                this.toggleVariable(UP_SHIFT_VARIABLE);
                            } else if (this.isVariableActive(DOWN_SHIFT_VARIABLE)) {
                                this.shiftDown(false);
                                this.toggleVariable(DOWN_SHIFT_VARIABLE);
                            } else if (this.isVariableActive(NEUTRAL_SHIFT_VARIABLE)) {
                                this.shiftNeutral();
                                this.toggleVariable(NEUTRAL_SHIFT_VARIABLE);
                            }
                            if (this.vehicleOn != null && ((JSONVehicle)this.vehicleOn.definition).motorized.isBlimp && this.attachedPropeller != null) {
                                if (this.vehicleOn.reverseThrust && this.currentGear > 0) {
                                    this.currentGear = (byte)-1;
                                } else if (!this.vehicleOn.reverseThrust && this.currentGear < 0) {
                                    this.currentGear = 1;
                                }
                            }
                            if (this.running) {
                                this.vehicleOn.electricUsage -= 0.05 * this.rpm / (double)this.currentMaxRPM;
                                if (!this.isCreative) {
                                    this.hours += 0.001 * this.getTotalWearFactor();
                                }
                                if (!((JSONPart)this.definition).engine.isSteamPowered) {
                                    if (!this.isCreative && !this.vehicleOn.fuelTank.getFluid().isEmpty()) {
                                        if (!ConfigSystem.configObject.fuel.fuels.containsKey(((JSONPart)this.definition).engine.fuelType)) {
                                            throw new IllegalArgumentException("Engine:" + ((JSONPart)this.definition).packID + ":" + ((JSONPart)this.definition).systemName + " wanted fuel configs for fuel of type:" + ((JSONPart)this.definition).engine.fuelType + ", but these do not exist in the config file.  Fuels currently in the file are:" + ConfigSystem.configObject.fuel.fuels.keySet().toString() + "If you are on a server, this means the server and client configs are not the same.  If this is a modpack, TELL THE AUTHOR IT IS BORKEN!");
                                        }
                                        if (!ConfigSystem.configObject.fuel.fuels.get(((JSONPart)this.definition).engine.fuelType).containsKey(this.vehicleOn.fuelTank.getFluid())) {
                                            this.vehicleOn.fuelTank.drain(this.vehicleOn.fuelTank.getFluid(), this.vehicleOn.fuelTank.getFluidLevel(), true);
                                        } else {
                                            this.fuelFlow += this.vehicleOn.fuelTank.drain(this.vehicleOn.fuelTank.getFluid(), (double)this.getTotalFuelConsumption() * (Double)ConfigSystem.configObject.general.fuelUsageFactor.value / ConfigSystem.configObject.fuel.fuels.get(((JSONPart)this.definition).engine.fuelType).get(this.vehicleOn.fuelTank.getFluid()) * this.rpm * (double)(this.fuelLeak ? 1.5f : 1.0f) / (double)this.currentMaxRPM, !this.world.isClient());
                                        }
                                    }
                                    this.temp += Math.max(0.0, (7.0 * this.rpm / (double)this.currentMaxRPM - this.temp / 60.0) / 20.0) * (double)this.currentHeatingCoefficient * (Double)ConfigSystem.configObject.general.engineSpeedTempFactor.value;
                                    if (this.currentIdleRPM != 0.0f) {
                                        this.pressure = Math.min(90.0 - this.temp / 10.0, this.pressure + this.rpm / (double)this.currentIdleRPM - 0.5 * (double)(this.oilLeak ? 5.0f : 1.0f) * (this.pressure / 40.0));
                                        if (this.pressure < 40.0 && !this.isCreative) {
                                            this.temp += Math.max(0.0, 20.0 * this.rpm / (double)this.currentMaxRPM / 20.0);
                                            this.hours += 0.01 * this.getTotalWearFactor();
                                        }
                                    }
                                    if (this.temp > (double)115.556f && !this.isCreative) {
                                        this.hours += 0.001 * (this.temp - (double)115.556f) * this.getTotalWearFactor();
                                        if (this.temp > (double)132.222f && !this.world.isClient()) {
                                            this.explodeEngine();
                                        }
                                    }
                                    if (this.hours > 250.0 && !this.world.isClient() && Math.random() < this.hours / 2.0 / (250.0 + (10000.0 - this.hours)) * ((double)this.currentMaxSafeRPM / (this.rpm + (double)this.currentMaxSafeRPM / 1.5))) {
                                        this.backfireEngine();
                                        InterfacePacket.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.BACKFIRE));
                                    }
                                    if (!this.world.isClient()) {
                                        if (!this.world.isClient() && this.isInLiquid()) {
                                            this.stallEngine(PacketPartEngine.Signal.DROWN);
                                            InterfacePacket.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.DROWN));
                                        } else if (!this.isCreative && this.vehicleOn.fuelTank.getFluidLevel() == 0.0) {
                                            this.stallEngine(PacketPartEngine.Signal.FUEL_OUT);
                                            InterfacePacket.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.FUEL_OUT));
                                        } else if (this.rpm < (double)((JSONPart)this.definition).engine.stallRPM) {
                                            this.stallEngine(PacketPartEngine.Signal.TOO_SLOW);
                                            InterfacePacket.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.TOO_SLOW));
                                        } else if (!this.isActive) {
                                            this.stallEngine(PacketPartEngine.Signal.FUEL_OUT);
                                            InterfacePacket.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.FUEL_OUT));
                                        } else if (this.vehicleOn.damageAmount == (double)((JSONVehicle)this.vehicleOn.definition).general.health) {
                                            this.stallEngine(PacketPartEngine.Signal.DEAD_VEHICLE);
                                            InterfacePacket.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.DEAD_VEHICLE));
                                        }
                                    }
                                }
                                if (((JSONPart)this.definition).engine.isAutomatic && !this.world.isClient() && this.currentGear != 0) {
                                    if (this.shiftCooldown == 0) {
                                        if (this.currentGear > 0 ? this.currentGear < this.forwardsGears : -this.currentGear < this.reverseGears) {
                                            double d = ((JSONPart)this.definition).engine.upShiftRPM != null ? (double)((JSONPart)this.definition).engine.upShiftRPM.get(this.currentGear + this.reverseGears).intValue() : (double)this.currentMaxSafeRPM * 0.9;
                                            if (this.rpm > d * 0.5 * (1.0 + this.vehicleOn.throttle)) {
                                                if (this.currentGear > 0) {
                                                    if (this.shiftUp(true)) {
                                                        InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, GEAR_VARIABLE, 1.0));
                                                    }
                                                } else if (this.shiftDown(true)) {
                                                    InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, GEAR_VARIABLE, -1.0));
                                                }
                                            }
                                        }
                                        if (this.currentGear > 1 || this.currentGear < -1) {
                                            double d = ((JSONPart)this.definition).engine.downShiftRPM != null ? (double)((JSONPart)this.definition).engine.downShiftRPM.get(this.currentGear + this.reverseGears).intValue() * 0.5 * (1.0 + this.vehicleOn.throttle) : (double)this.currentMaxSafeRPM * 0.9 * 0.25 * (1.0 + this.vehicleOn.throttle);
                                            if (this.rpm < d) {
                                                if (this.currentGear > 0) {
                                                    if (this.shiftDown(true)) {
                                                        InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, GEAR_VARIABLE, -1.0));
                                                    }
                                                } else if (this.shiftUp(true)) {
                                                    InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, GEAR_VARIABLE, 1.0));
                                                }
                                            }
                                        }
                                    } else {
                                        --this.shiftCooldown;
                                    }
                                }
                            } else {
                                if (!((JSONPart)this.definition).engine.isSteamPowered) {
                                    this.pressure = 0.0;
                                    this.fuelFlow = 0.0;
                                }
                                if (this.internalFuel > 0) {
                                    --this.internalFuel;
                                    if (this.rpm < 500.0) {
                                        this.internalFuel = 0;
                                    }
                                }
                                if (this.rpm >= (double)((JSONPart)this.definition).engine.startRPM && !this.world.isClient() && this.vehicleOn.damageAmount < (double)((JSONVehicle)this.vehicleOn.definition).general.health && (this.isCreative || this.vehicleOn.fuelTank.getFluidLevel() > 0.0) && !this.isInLiquid() && this.magnetoOn) {
                                    this.startEngine();
                                    InterfacePacket.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.START));
                                }
                            }
                            if (((JSONPart)this.definition).engine.jetPowerFactor != 0.0f || !((JSONVehicle)this.vehicleOn.definition).motorized.isFrontWheelDrive && !((JSONVehicle)this.vehicleOn.definition).motorized.isRearWheelDrive) break block106;
                            this.lowestWheelVelocity = 999.0;
                            this.desiredWheelVelocity = -999.0;
                            this.wheelFriction = 0.0f;
                            this.engineTargetRPM = !this.electricStarterEngaged ? this.vehicleOn.throttle * (double)(this.currentMaxRPM - this.currentIdleRPM) / (1.0 + this.hours / 1250.0) + (double)this.currentIdleRPM : (double)((JSONPart)this.definition).engine.startRPM;
                            for (PartGroundDevice wheel : this.vehicleOn.groundDeviceCollective.drivenWheels) {
                                if (!this.vehicleOn.groundDeviceCollective.groundedGroundDevices.contains(wheel)) continue;
                                this.wheelFriction += Math.max(wheel.getMotiveFriction() - wheel.getFrictionLoss(), 0.0f);
                                this.lowestWheelVelocity = Math.min(wheel.angularVelocity, this.lowestWheelVelocity);
                                this.desiredWheelVelocity = Math.max(wheel.getDesiredAngularVelocity(), this.desiredWheelVelocity);
                            }
                            if (this.currentGearRatio == 0.0f || this.starterLevel != 0) break block106;
                            if (!(this.wheelFriction > 0.0f)) break block107;
                            double desiredRPM = this.lowestWheelVelocity * 1200.0 * (double)this.currentGearRatio * (double)this.vehicleOn.currentAxleRatio;
                            this.rpm += (desiredRPM - this.rpm) / (double)((JSONPart)this.definition).engine.revResistance;
                            if (!(this.rpm < (double)this.currentIdleRPM) || !this.running || this.backfireCooldown > 0) break block108;
                            this.rpm = this.currentIdleRPM;
                            break block106;
                        }
                        if (!(this.rpm < (double)((JSONPart)this.definition).engine.stallRPM) || !this.running) break block106;
                        this.rpm = ((JSONPart)this.definition).engine.stallRPM;
                        --this.backfireCooldown;
                        break block106;
                    }
                    for (PartGroundDevice wheel : this.vehicleOn.groundDeviceCollective.drivenWheels) {
                        if (this.currentGearRatio != 0.0f) {
                            wheel.angularVelocity = this.rpm / (double)this.currentGearRatio / (double)this.vehicleOn.currentAxleRatio / 1200.0;
                            continue;
                        }
                        if (wheel.angularVelocity > 0.0) {
                            wheel.angularVelocity = Math.max(0.0, wheel.angularVelocity - 0.01);
                            continue;
                        }
                        wheel.angularVelocity = Math.min(0.0, wheel.angularVelocity + 0.01);
                    }
                }
                this.attachedPropeller = null;
                for (APart part : this.childParts) {
                    if (!(part instanceof PartPropeller)) continue;
                    this.attachedPropeller = (PartPropeller)part;
                    Point3d propellerThrustAxis = new Point3d(0.0, 0.0, 1.0).rotateFine(this.attachedPropeller.localAngles.copy().add(this.vehicleOn.angles));
                    this.propellerAxialVelocity = this.vehicleOn.motion.dotProduct(propellerThrustAxis);
                    this.propellerGearboxRatio = Math.signum(this.currentGearRatio) * (((JSONPart)this.definition).engine.propellerRatio != 0.0f ? ((JSONPart)this.definition).engine.propellerRatio : Math.abs(this.currentGearRatio));
                    if (this.wheelFriction != 0.0f || this.currentGearRatio == 0.0f) continue;
                    this.isPropellerInLiquid = this.attachedPropeller.isInLiquid();
                    double propellerForcePenalty = Math.max(0.0f, (float)(((JSONPart)this.attachedPropeller.definition).propeller.diameter - 75) / (50.0f * (this.currentFuelConsumption + this.currentSuperchargerFuelConsumption * this.currentSuperchargerEfficiency) - 15.0f));
                    double propellerDesiredSpeed = 0.0254 * (double)this.attachedPropeller.currentPitch * this.rpm / (double)this.propellerGearboxRatio / 60.0 / 20.0;
                    double propellerFeedback = (propellerDesiredSpeed - this.propellerAxialVelocity) * (double)(this.isPropellerInLiquid ? 130 : 40);
                    if (this.currentGear < 0 || this.attachedPropeller.currentPitch < 0) {
                        propellerFeedback *= -1.0;
                    }
                    if (this.running) {
                        propellerFeedback += propellerForcePenalty * 50.0;
                        this.engineTargetRPM = this.vehicleOn.throttle * (double)(this.currentMaxRPM - this.currentIdleRPM) / (1.0 + this.hours / 1250.0) + (double)this.currentIdleRPM;
                        double engineRPMDifference = this.engineTargetRPM - this.rpm;
                        if (this.rpm + engineRPMDifference / (double)((JSONPart)this.definition).engine.revResistance > (double)((JSONPart)this.definition).engine.stallRPM && this.rpm + engineRPMDifference / (double)((JSONPart)this.definition).engine.revResistance - propellerFeedback < (double)((JSONPart)this.definition).engine.stallRPM) {
                            this.rpm = ((JSONPart)this.definition).engine.stallRPM;
                            continue;
                        }
                        this.rpm += engineRPMDifference / (double)((JSONPart)this.definition).engine.revResistance - propellerFeedback;
                        continue;
                    }
                    if (this.electricStarterEngaged || this.handStarterEngaged) continue;
                    this.rpm -= (1.0 + propellerFeedback) * (double)Math.abs(this.propellerGearboxRatio);
                    if (!(this.rpm < 0.0)) continue;
                    this.rpm = 0.0;
                }
                if (this.wheelFriction == 0.0f && this.attachedPropeller == null || this.currentGearRatio == 0.0f) {
                    if (this.running) {
                        this.engineTargetRPM = this.vehicleOn.throttle * (double)(this.currentMaxRPM - this.currentIdleRPM) / (1.0 + this.hours / 1250.0) + (double)this.currentIdleRPM;
                        this.rpm += (this.engineTargetRPM - this.rpm) / (double)(((JSONPart)this.definition).engine.revResistance * 3);
                        if (this.currentRevlimitRPM == -1.0f) {
                            if (this.rpm > (double)this.currentMaxSafeRPM) {
                                this.rpm -= Math.abs(this.engineTargetRPM - this.rpm) / 60.0;
                            }
                        } else if (this.rpm > (double)this.currentRevlimitRPM) {
                            this.rpm -= Math.abs(this.engineTargetRPM - this.rpm) / (double)((JSONPart)this.definition).engine.revlimitBounce;
                        }
                    } else if (!this.electricStarterEngaged && !this.handStarterEngaged) {
                        this.rpm = Math.max(this.rpm - (double)((JSONPart)this.definition).engine.engineWinddownRate, 0.0);
                    }
                }
                if (((JSONPart)this.definition).engine.jetPowerFactor > 0.0f) {
                    Point3d engineThrustAxis = new Point3d(0.0, 0.0, 1.0).rotateFine(this.localAngles.copy().add(this.vehicleOn.angles));
                    this.engineAxialVelocity = this.vehicleOn.motion.dotProduct(engineThrustAxis);
                    if (!this.world.isClient() && this.rpm >= 5000.0) {
                        this.boundingBox.widthRadius += 0.25;
                        this.boundingBox.heightRadius += 0.25;
                        this.boundingBox.depthRadius += 0.25;
                        this.boundingBox.globalCenter.add(this.vehicleOn.headingVector);
                        Damage jetIntake = new Damage("jet_intake", (double)((JSONPart)this.definition).engine.jetPowerFactor * (Double)ConfigSystem.configObject.damage.jetDamageFactor.value * this.rpm / 1000.0, this.boundingBox, this, this.vehicleOn.getController());
                        this.world.attackEntities(jetIntake, null);
                        this.boundingBox.globalCenter.subtract(this.vehicleOn.headingVector);
                        this.boundingBox.globalCenter.subtract(this.vehicleOn.headingVector);
                        Damage jetExhaust = new Damage("jet_exhaust", (double)((JSONPart)this.definition).engine.jetPowerFactor * (Double)ConfigSystem.configObject.damage.jetDamageFactor.value * this.rpm / 2000.0, this.boundingBox, this, jetIntake.entityResponsible).setFire();
                        this.world.attackEntities(jetExhaust, null);
                        this.boundingBox.globalCenter.add(this.vehicleOn.headingVector);
                        this.boundingBox.widthRadius -= 0.25;
                        this.boundingBox.heightRadius -= 0.25;
                        this.boundingBox.depthRadius -= 0.25;
                    }
                }
                this.prevEngineRotation = this.engineRotation;
                this.engineRotation += 360.0 * this.rpm / 1200.0;
                if (this.engineRotation > 3600000.0) {
                    this.engineRotation -= 3600000.0;
                    this.prevEngineRotation -= 3600000.0;
                } else if (this.engineRotation < -3600000.0) {
                    this.engineRotation += 3600000.0;
                    this.prevEngineRotation += 3600000.0;
                }
                this.prevDriveshaftRotation = this.driveshaftRotation;
                double driveshaftDesiredSpeed = -999.0;
                for (PartGroundDevice wheel : this.vehicleOn.groundDeviceCollective.drivenWheels) {
                    driveshaftDesiredSpeed = Math.max(wheel.angularVelocity, driveshaftDesiredSpeed);
                }
                this.driveshaftRotation = driveshaftDesiredSpeed != -999.0 ? (this.driveshaftRotation += 360.0 * driveshaftDesiredSpeed * EntityVehicleF_Physics.SPEED_FACTOR) : (this.driveshaftRotation += 360.0 * this.rpm / 1200.0 / (double)this.currentGearRatio);
                if (this.driveshaftRotation > 3600000.0) {
                    this.driveshaftRotation -= 3600000.0;
                    this.prevDriveshaftRotation -= 3600000.0;
                } else if (this.driveshaftRotation < -3600000.0) {
                    this.driveshaftRotation += 3600000.0;
                    this.prevDriveshaftRotation += 3600000.0;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected void updateVariableModifiers() {
        this.currentMaxRPM = ((JSONPart)this.definition).engine.maxRPM;
        this.currentMaxSafeRPM = ((JSONPart)this.definition).engine.maxSafeRPM;
        this.currentRevlimitRPM = ((JSONPart)this.definition).engine.revlimitRPM;
        this.currentIdleRPM = ((JSONPart)this.definition).engine.idleRPM;
        this.currentFuelConsumption = ((JSONPart)this.definition).engine.fuelConsumption;
        this.currentHeatingCoefficient = ((JSONPart)this.definition).engine.heatingCoefficient;
        this.currentCoolingCoefficient = ((JSONPart)this.definition).engine.coolingCoefficient;
        this.currentSuperchargerFuelConsumption = ((JSONPart)this.definition).engine.superchargerFuelConsumption;
        this.currentSuperchargerEfficiency = ((JSONPart)this.definition).engine.superchargerEfficiency;
        if (((JSONPart)this.definition).variableModifiers != null) {
            block22: for (JSONVariableModifier modifier : ((JSONPart)this.definition).variableModifiers) {
                switch (modifier.variable) {
                    case "maxRPM": {
                        this.currentMaxRPM = this.adjustVariable(modifier, this.currentMaxRPM);
                        continue block22;
                    }
                    case "maxSafeRPM": {
                        this.currentMaxSafeRPM = this.adjustVariable(modifier, this.currentMaxSafeRPM);
                        continue block22;
                    }
                    case "revlimitRPM": {
                        this.currentRevlimitRPM = this.adjustVariable(modifier, this.currentRevlimitRPM);
                        continue block22;
                    }
                    case "idleRPM": {
                        this.currentIdleRPM = this.adjustVariable(modifier, this.currentIdleRPM);
                        continue block22;
                    }
                    case "fuelConsumption": {
                        this.currentFuelConsumption = this.adjustVariable(modifier, this.currentFuelConsumption);
                        continue block22;
                    }
                    case "heatingCoefficient": {
                        this.currentHeatingCoefficient = this.adjustVariable(modifier, this.currentHeatingCoefficient);
                        continue block22;
                    }
                    case "coolingCoefficient": {
                        this.currentCoolingCoefficient = this.adjustVariable(modifier, this.currentCoolingCoefficient);
                        continue block22;
                    }
                    case "superchargerFuelConsumption": {
                        this.currentSuperchargerFuelConsumption = this.adjustVariable(modifier, this.currentSuperchargerFuelConsumption);
                        continue block22;
                    }
                    case "superchargerEfficiency": {
                        this.currentSuperchargerEfficiency = this.adjustVariable(modifier, this.currentSuperchargerEfficiency);
                        continue block22;
                    }
                }
                this.setVariable(modifier.variable, this.adjustVariable(modifier, (float)this.getVariable(modifier.variable)));
            }
        }
    }

    @Override
    public boolean isInLiquid() {
        return this.world.isBlockLiquid(this.position.copy().add(0.0, this.placementDefinition.intakeOffset, 0.0));
    }

    @Override
    public void remove() {
        super.remove();
        this.running = false;
        if (this.vehicleOn != null) {
            for (PartGroundDevice wheel : this.vehicleOn.groundDeviceCollective.drivenWheels) {
                wheel.skipAngularCalcs = false;
            }
        }
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        switch (variable) {
            case "engine_isautomatic": {
                return ((JSONPart)this.definition).engine.isAutomatic ? 1.0 : 0.0;
            }
            case "engine_rotation": {
                return this.getEngineRotation(partialTicks);
            }
            case "engine_sin": {
                return Math.sin(Math.toRadians(this.getEngineRotation(partialTicks)));
            }
            case "engine_cos": {
                return Math.cos(Math.toRadians(this.getEngineRotation(partialTicks)));
            }
            case "engine_driveshaft_rotation": {
                return this.getDriveshaftRotation(partialTicks);
            }
            case "engine_driveshaft_sin": {
                return Math.sin(Math.toRadians(this.getDriveshaftRotation(partialTicks)));
            }
            case "engine_driveshaft_cos": {
                return Math.cos(Math.toRadians(this.getDriveshaftRotation(partialTicks)));
            }
            case "engine_rpm": {
                return this.rpm;
            }
            case "engine_rpm_safe": {
                return this.currentMaxSafeRPM;
            }
            case "engine_rpm_max": {
                return this.currentMaxRPM;
            }
            case "engine_rpm_percent": {
                return this.rpm / (double)this.currentMaxRPM;
            }
            case "engine_rpm_percent_safe": {
                return this.rpm / (double)this.currentMaxSafeRPM;
            }
            case "engine_fuel_flow": {
                return this.fuelFlow * 20.0 * 60.0 / 1000.0;
            }
            case "engine_temp": {
                return this.temp;
            }
            case "engine_pressure": {
                return this.pressure;
            }
            case "engine_gear": {
                return this.currentGear;
            }
            case "engine_gearshift": {
                return this.getGearshiftRotation();
            }
            case "engine_gearshift_hvertical": {
                return this.getGearshiftPosition_Vertical();
            }
            case "engine_gearshift_hhorizontal": {
                return this.getGearshiftPosition_Horizontal();
            }
            case "engine_clutch_upshift": {
                return this.upshiftCountdown > 0 ? 1.0 : 0.0;
            }
            case "engine_clutch_downshift": {
                return this.downshiftCountdown > 0 ? 1.0 : 0.0;
            }
            case "engine_badshift": {
                return this.badShift ? 1.0 : 0.0;
            }
            case "engine_reversed": {
                return this.currentGear < 0 ? 1.0 : 0.0;
            }
            case "engine_running": {
                return this.running ? 1.0 : 0.0;
            }
            case "engine_powered": {
                return this.running || this.internalFuel > 0 ? 1.0 : 0.0;
            }
            case "engine_backfired": {
                return this.backfired ? 1.0 : 0.0;
            }
            case "engine_jumper_cable": {
                return this.linkedEngine != null ? 1.0 : 0.0;
            }
            case "engine_hours": {
                return this.hours;
            }
            case "engine_oilleak": {
                return this.oilLeak ? 1.0 : 0.0;
            }
            case "engine_fuelleak": {
                return this.fuelLeak ? 1.0 : 0.0;
            }
        }
        if (variable.startsWith("engine_piston_")) {
            if (this.running) {
                String pistonVariable = variable.substring("engine_piston_".length());
                int pistonNumber = Integer.parseInt(pistonVariable.substring(0, pistonVariable.indexOf("_")));
                pistonVariable.substring(pistonVariable.indexOf("_"));
                int totalPistons = Integer.parseInt(pistonVariable.substring(0, pistonVariable.indexOf("_")));
                long engineCycleTime = (long)(2.0 * (1.0 / (this.rpm / 60.0 / 1000.0)));
                if (engineCycleTime != 0L) {
                    long currentEngineTime = (long)((double)((float)this.ticksExisted + partialTicks) * 50.0);
                    long engineTimeInCycle = currentEngineTime % engineCycleTime;
                    long pistonCycleTime = totalPistons > 1 ? engineCycleTime / (long)totalPistons : engineCycleTime / 2L;
                    long camMin = (long)(pistonNumber - 1) * pistonCycleTime;
                    long camMax = camMin + pistonCycleTime;
                    if (camMax > engineCycleTime) {
                        return engineTimeInCycle < camMin && engineTimeInCycle > camMax ? 1.0 : 0.0;
                    }
                    return engineTimeInCycle > camMin && engineTimeInCycle < camMax ? 1.0 : 0.0;
                }
            }
            return 0.0;
        }
        return super.getRawVariableValue(variable, partialTicks);
    }

    public void startEngine() {
        this.running = true;
        if (!((JSONPart)this.definition).engine.isSteamPowered) {
            this.pressure = 60.0;
        }
    }

    public void handStartEngine() {
        this.setVariable(HAND_STARTER_VARIABLE, 1.0);
        this.starterLevel += 4;
    }

    public void autoStartEngine() {
        if (!this.running && (this.isCreative || this.vehicleOn.fuelTank.getFluidLevel() > 0.0)) {
            this.autoStarterEngaged = true;
            this.setVariable(MAGNETO_VARIABLE, 1.0);
            this.setVariable(ELECTRIC_STARTER_VARIABLE, 1.0);
        }
    }

    public void stallEngine(PacketPartEngine.Signal signal) {
        this.running = false;
        if (this.world.isClient() && !signal.equals((Object)PacketPartEngine.Signal.DROWN)) {
            this.internalFuel = 100;
        }
    }

    public void backfireEngine() {
        this.backfired = true;
        this.rpm -= this.currentMaxRPM < 15000.0f ? 100.0 : 500.0;
        this.backfireCooldown = 4;
    }

    public void badShiftEngine() {
        this.badShift = true;
    }

    protected void explodeEngine() {
        if (((Boolean)ConfigSystem.configObject.damage.explosions.value).booleanValue()) {
            this.world.spawnExplosion(this.position, 1.0, true);
        } else {
            this.world.spawnExplosion(this.position, 0.0, false);
        }
        this.isValid = false;
    }

    public float getGearshiftRotation() {
        return ((JSONPart)this.definition).engine.isAutomatic ? (float)Math.min(1, this.currentGear) * 15.0f : (float)(this.currentGear * 5);
    }

    public float getGearshiftPosition_Vertical() {
        if (this.currentGear < 0) {
            return ((JSONPart)this.definition).engine.gearRatios.size() % 2 == 0 ? 15.0f : -15.0f;
        }
        if (this.currentGear == 0) {
            return 0.0f;
        }
        return this.currentGear % 2 == 0 ? -15.0f : 15.0f;
    }

    public float getGearshiftPosition_Horizontal() {
        float columnAngleDelta;
        int columns = ((JSONPart)this.definition).engine.gearRatios.size() / 2;
        int firstColumnAngle = columns / 2 * -5;
        float f = columnAngleDelta = columns != 1 ? (float)(-firstColumnAngle * 2 / (columns - 1)) : 0.0f;
        if (this.currentGear < 0) {
            return -firstColumnAngle;
        }
        if (this.currentGear == 0) {
            return 0.0f;
        }
        return (float)firstColumnAngle + (float)((this.currentGear - 1) / 2) * columnAngleDelta;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shiftUp(boolean autoTransRequest) {
        byte nextGear = 0;
        boolean doShift = false;
        if (((JSONPart)this.definition).engine.jetPowerFactor != 0.0f) return doShift;
        if (this.currentGear == this.forwardsGears) {
            return false;
        }
        if (this.currentGear == 0) {
            nextGear = 1;
            doShift = this.vehicleOn.axialVelocity < (double)0.35f || this.wheelFriction == 0.0f || !this.vehicleOn.goingInReverse;
        } else if (!autoTransRequest && ((JSONPart)this.definition).engine.isAutomatic) {
            if (this.currentGear >= 0) return false;
            nextGear = 0;
            doShift = true;
        } else {
            nextGear = (byte)(this.currentGear + 1);
            doShift = true;
        }
        if (doShift) {
            this.currentGear = nextGear;
            this.setVariable(GEAR_VARIABLE, this.currentGear);
            this.shiftCooldown = ((JSONPart)this.definition).engine.shiftSpeed;
            this.upshiftCountdown = ((JSONPart)this.definition).engine.clutchTime;
            return doShift;
        } else {
            if (this.world.isClient()) return doShift;
            InterfacePacket.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.BAD_SHIFT));
        }
        return doShift;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shiftDown(boolean autoTransRequest) {
        int nextGear = 0;
        boolean doShift = false;
        if (((JSONPart)this.definition).engine.jetPowerFactor != 0.0f) return doShift;
        if (this.currentGear < 0 && -this.currentGear == this.reverseGears) {
            return false;
        }
        if (this.currentGear == 0) {
            nextGear = -1;
            doShift = this.vehicleOn.axialVelocity < (double)0.35f || this.wheelFriction == 0.0f || this.vehicleOn.goingInReverse;
        } else if (!autoTransRequest && ((JSONPart)this.definition).engine.isAutomatic) {
            if (this.currentGear <= 0) return false;
            nextGear = 0;
            doShift = true;
        } else {
            nextGear = (byte)(this.currentGear - 1);
            doShift = true;
        }
        if (doShift) {
            this.currentGear = (byte)nextGear;
            this.setVariable(GEAR_VARIABLE, this.currentGear);
            this.shiftCooldown = ((JSONPart)this.definition).engine.shiftSpeed;
            this.downshiftCountdown = ((JSONPart)this.definition).engine.clutchTime;
            return doShift;
        } else {
            if (this.world.isClient()) return doShift;
            InterfacePacket.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.BAD_SHIFT));
        }
        return doShift;
    }

    private void shiftNeutral() {
        if (((JSONPart)this.definition).engine.jetPowerFactor == 0.0f && this.currentGear != 0) {
            if (this.currentGear > 0) {
                this.downshiftCountdown = ((JSONPart)this.definition).engine.clutchTime;
            } else {
                this.upshiftCountdown = ((JSONPart)this.definition).engine.clutchTime;
            }
            this.shiftCooldown = ((JSONPart)this.definition).engine.shiftSpeed;
            this.currentGear = 0;
            this.setVariable(GEAR_VARIABLE, this.currentGear);
        }
    }

    public float getTotalFuelConsumption() {
        return this.currentFuelConsumption + this.currentSuperchargerFuelConsumption;
    }

    public double getTotalWearFactor() {
        if (this.currentSuperchargerEfficiency > 1.0f) {
            return (double)(((JSONPart)this.definition).engine.engineWearFactor * this.currentSuperchargerEfficiency) * (Double)ConfigSystem.configObject.general.engineHoursFactor.value;
        }
        return (double)((JSONPart)this.definition).engine.engineWearFactor * (Double)ConfigSystem.configObject.general.engineHoursFactor.value;
    }

    public double getEngineRotation(float partialTicks) {
        return this.engineRotation + (this.engineRotation - this.prevEngineRotation) * (double)partialTicks;
    }

    public double getDriveshaftRotation(float partialTicks) {
        return this.driveshaftRotation + (this.driveshaftRotation - this.prevDriveshaftRotation) * (double)partialTicks;
    }

    public Point3d getForceOutput() {
        this.engineForce.set(0.0, 0.0, 0.0);
        if (((JSONPart)this.definition).engine.jetPowerFactor == 0.0f && this.wheelFriction != 0.0f) {
            double wheelForce = 0.0;
            if (this.running || this.electricStarterEngaged) {
                wheelForce = this.rpm > (double)this.currentRevlimitRPM && this.currentRevlimitRPM != -1.0f ? -this.rpm / (double)this.currentMaxRPM * (double)Math.signum(this.currentGear) * 60.0 : (this.engineTargetRPM - this.rpm) / (double)this.currentMaxRPM * (double)this.currentGearRatio * (double)this.vehicleOn.currentAxleRatio * (double)(this.currentFuelConsumption + this.currentSuperchargerFuelConsumption * this.currentSuperchargerEfficiency) * (double)0.6f * 30.0;
                if (wheelForce != 0.0) {
                    if (Math.abs(wheelForce / 300.0) > (double)this.wheelFriction || Math.abs(this.lowestWheelVelocity) - Math.abs(this.desiredWheelVelocity) > 0.1 && Math.abs(this.lowestWheelVelocity) - Math.abs(this.desiredWheelVelocity) < Math.abs(wheelForce / 300.0)) {
                        wheelForce *= this.vehicleOn.currentMass / 100000.0 * (double)this.wheelFriction / Math.abs(wheelForce / 300.0);
                        for (PartGroundDevice wheel : this.vehicleOn.groundDeviceCollective.drivenWheels) {
                            wheel.angularVelocity = this.currentGearRatio > 0.0f ? (wheelForce >= 0.0 ? Math.min(this.engineTargetRPM / 1200.0 / (double)this.currentGearRatio / (double)this.vehicleOn.currentAxleRatio, wheel.angularVelocity + 0.01) : Math.max(this.engineTargetRPM / 1200.0 / (double)this.currentGearRatio / (double)this.vehicleOn.currentAxleRatio, wheel.angularVelocity - 0.01)) : (wheelForce >= 0.0 ? Math.min(this.engineTargetRPM / 1200.0 / (double)this.currentGearRatio / (double)this.vehicleOn.currentAxleRatio, wheel.angularVelocity + 0.01) : Math.max(this.engineTargetRPM / 1200.0 / (double)this.currentGearRatio / (double)this.vehicleOn.currentAxleRatio, wheel.angularVelocity - 0.01));
                            wheel.skipAngularCalcs = true;
                        }
                    } else {
                        for (PartGroundDevice wheel : this.vehicleOn.groundDeviceCollective.drivenWheels) {
                            wheel.skipAngularCalcs = false;
                            if (this.vehicleOn.groundDeviceCollective.groundedGroundDevices.contains(wheel)) continue;
                            wheel.angularVelocity = this.lowestWheelVelocity;
                        }
                    }
                } else if (this.currentGearRatio == 0.0f) {
                    for (PartGroundDevice wheel : this.vehicleOn.groundDeviceCollective.drivenWheels) {
                        wheel.skipAngularCalcs = false;
                    }
                }
                if ((wheelForce < 0.0 && this.currentGear > 0 || wheelForce > 0.0 && this.currentGear < 0) && this.vehicleOn.velocity < 0.25) {
                    wheelForce = 0.0;
                }
            } else {
                wheelForce = -this.rpm / (double)this.currentMaxRPM * (double)Math.signum(this.currentGear) * 30.0;
            }
            this.engineForce.z += wheelForce;
        }
        if (((JSONPart)this.definition).engine.jetPowerFactor > 0.0f && this.running) {
            double safeRPMFactor = this.rpm / (double)this.currentMaxSafeRPM;
            double coreContribution = Math.max(10.0 * this.airDensity * (double)this.currentFuelConsumption * safeRPMFactor - (double)((JSONPart)this.definition).engine.bypassRatio, 0.0);
            double fanVelocityFactor = (6.35 * this.rpm / 60.0 / 20.0 - this.engineAxialVelocity) / 200.0;
            double fanContribution = 10.0 * this.airDensity * safeRPMFactor * fanVelocityFactor * (double)((JSONPart)this.definition).engine.bypassRatio;
            double thrust = (this.vehicleOn.reverseThrust ? -(coreContribution + fanContribution) : coreContribution + fanContribution) * (double)((JSONPart)this.definition).engine.jetPowerFactor;
            this.engineForce.add(new Point3d(0.0, 0.0, thrust).rotateFine(this.localAngles));
        }
        return this.engineForce;
    }

    @Override
    public WrapperNBT save(WrapperNBT data) {
        super.save(data);
        data.setBoolean("isCreative", this.isCreative);
        data.setBoolean("oilLeak", this.oilLeak);
        data.setBoolean("fuelLeak", this.fuelLeak);
        data.setBoolean("brokenStarter", this.brokenStarter);
        data.setBoolean("running", this.running);
        data.setDouble("hours", this.hours);
        data.setDouble("rpm", this.rpm);
        data.setDouble("temp", this.temp);
        data.setDouble("pressure", this.pressure);
        return data;
    }
}

