/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartGroundDeviceFake;
import minecrafttransportsimulator.items.instances.ItemPartGroundDevice;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONVariableModifier;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.packets.instances.PacketPartGroundDevice;
import minecrafttransportsimulator.systems.ConfigSystem;

public class PartGroundDevice
extends APart {
    public static final Point3d groundDetectionOffset = new Point3d(0.0, -0.05f, 0.0);
    public static final Point3d groundOperationOffset = new Point3d(0.0, -0.25, 0.0);
    public boolean skipAngularCalcs = false;
    public double angularPosition;
    public double angularVelocity;
    private float currentMotiveFriction;
    private float currentLateralFriction;
    public boolean isFlat;
    public boolean contactThisTick = false;
    private boolean animateAsOnGround;
    private int ticksCalcsSkipped = 0;
    private double prevAngularVelocity;
    private final PartGroundDeviceFake fakePart;

    public PartGroundDevice(AEntityF_Multipart<?> entityOn, WrapperPlayer placingPlayer, JSONPartDefinition placementDefinition, WrapperNBT data, APart parentPart) {
        super(entityOn, placingPlayer, placementDefinition, data, parentPart);
        this.isFlat = data.getBoolean("isFlat");
        if (!this.isFake() && this.getLongPartOffset() != 0.0f && !placementDefinition.isSpare) {
            Point3d actualPlacement = placementDefinition.pos;
            placementDefinition.pos = placementDefinition.pos.copy().add(0.0, 0.0, this.getLongPartOffset());
            this.fakePart = new PartGroundDeviceFake(this, placingPlayer, placementDefinition, data, null);
            placementDefinition.pos = actualPlacement;
            this.vehicleOn.partsFromNBT.add(this.fakePart);
        } else {
            this.fakePart = null;
        }
    }

    @Override
    public void attack(Damage damage) {
        super.attack(damage);
        if (!damage.isWater && (damage.isExplosion || Math.random() < 0.5 || this.damageAmount > (double)((JSONPart)this.definition).general.health)) {
            this.setFlatState(true);
        }
    }

    @Override
    public boolean update() {
        if (super.update()) {
            if (this.vehicleOn != null && !this.placementDefinition.isSpare) {
                if (this.vehicleOn.groundDeviceCollective.groundedGroundDevices.contains(this)) {
                    this.animateAsOnGround = true;
                    if (!this.skipAngularCalcs) {
                        this.prevAngularVelocity = this.angularVelocity;
                        this.angularVelocity = this.getDesiredAngularVelocity();
                    }
                    if (((JSONPart)this.definition).ground.isWheel) {
                        Point3d blockPositionBelow;
                        this.contactThisTick = false;
                        if (Math.abs(this.prevAngularVelocity) / (this.vehicleOn.groundVelocity / ((double)this.getHeight() * Math.PI)) < 0.25 && this.vehicleOn.velocity > 0.3 && !this.world.isAir(blockPositionBelow = this.position.copy().add(0.0, -1.0, 0.0)) && (double)this.world.getBlockHardness(blockPositionBelow) >= 1.25) {
                            this.contactThisTick = true;
                        }
                        if (!this.vehicleOn.world.isClient() && !this.isFlat) {
                            if (!this.skipAngularCalcs) {
                                if (this.ticksCalcsSkipped > 0) {
                                    --this.ticksCalcsSkipped;
                                }
                            } else {
                                ++this.ticksCalcsSkipped;
                                if (Math.random() * 50000.0 < (double)this.ticksCalcsSkipped) {
                                    this.setFlatState(true);
                                }
                            }
                        }
                    }
                    if (!this.vehicleOn.world.isClient() && this.vehicleOn.velocity >= (Double)ConfigSystem.configObject.damage.wheelDamageMinimumVelocity.value) {
                        this.boundingBox.widthRadius += 0.25;
                        this.boundingBox.depthRadius += 0.25;
                        double wheelDamageAmount = (Boolean)ConfigSystem.configObject.damage.wheelDamageIgnoreVelocity.value == false ? (Double)ConfigSystem.configObject.damage.wheelDamageFactor.value * this.vehicleOn.velocity * this.vehicleOn.currentMass / 1000.0 : (Double)ConfigSystem.configObject.damage.wheelDamageFactor.value * this.vehicleOn.currentMass / 1000.0;
                        Damage wheelDamage = new Damage("wheel", wheelDamageAmount, this.boundingBox, this, this.vehicleOn.getController());
                        this.vehicleOn.world.attackEntities(wheelDamage, null);
                        this.boundingBox.widthRadius -= 0.25;
                        this.boundingBox.depthRadius -= 0.25;
                    }
                } else {
                    if (!this.vehicleOn.groundDeviceCollective.drivenWheels.contains(this)) {
                        if (this.vehicleOn.brake > 0.0 || this.vehicleOn.parkingBrakeOn) {
                            this.angularVelocity = 0.0;
                        } else if (this.angularVelocity > 0.0) {
                            this.angularVelocity = (float)Math.max(this.angularVelocity - 0.05, 0.0);
                        }
                    }
                    if (this.animateAsOnGround && !this.vehicleOn.groundDeviceCollective.isActuallyOnGround(this)) {
                        this.animateAsOnGround = false;
                    }
                }
                this.angularPosition += this.angularVelocity;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void updateVariableModifiers() {
        this.currentMotiveFriction = ((JSONPart)this.definition).ground.motiveFriction;
        this.currentLateralFriction = ((JSONPart)this.definition).ground.lateralFriction;
        if (((JSONPart)this.definition).variableModifiers != null) {
            block8: for (JSONVariableModifier modifier : ((JSONPart)this.definition).variableModifiers) {
                switch (modifier.variable) {
                    case "motiveFriction": {
                        this.currentMotiveFriction = this.adjustVariable(modifier, this.currentMotiveFriction);
                        continue block8;
                    }
                    case "lateralFriction": {
                        this.currentLateralFriction = this.adjustVariable(modifier, this.currentLateralFriction);
                        continue block8;
                    }
                }
                this.setVariable(modifier.variable, this.adjustVariable(modifier, (float)this.getVariable(modifier.variable)));
            }
        }
    }

    @Override
    public void remove() {
        super.remove();
        if (this.fakePart != null) {
            this.fakePart.remove();
        }
    }

    @Override
    public ItemPartGroundDevice getItem() {
        return this.isFlat ? null : (ItemPartGroundDevice)super.getItem();
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        switch (variable) {
            case "ground_rotation": {
                return EntityVehicleF_Physics.SPEED_FACTOR * (this.angularPosition + this.angularVelocity * (double)partialTicks) * 360.0;
            }
            case "ground_rotation_normalized": {
                return EntityVehicleF_Physics.SPEED_FACTOR * (this.angularPosition + this.angularVelocity * (double)partialTicks) * 360.0 % 360.0;
            }
            case "ground_onground": {
                return this.vehicleOn != null && this.animateAsOnGround ? 1.0 : 0.0;
            }
            case "ground_inliquid": {
                return this.isInLiquid() ? 1.0 : 0.0;
            }
            case "ground_isflat": {
                return this.isFlat ? 1.0 : 0.0;
            }
            case "ground_contacted": {
                return this.contactThisTick ? 1.0 : 0.0;
            }
            case "ground_skidding": {
                return this.skipAngularCalcs ? 1.0 : 0.0;
            }
            case "ground_slipping": {
                return this.vehicleOn != null && this.vehicleOn.slipping && this.animateAsOnGround ? 1.0 : 0.0;
            }
        }
        return super.getRawVariableValue(variable, partialTicks);
    }

    @Override
    public float getWidth() {
        return ((JSONPart)this.definition).ground.width * this.scale;
    }

    @Override
    public float getHeight() {
        return (this.isFlat ? ((JSONPart)this.definition).ground.flatHeight : ((JSONPart)this.definition).ground.height) * this.scale;
    }

    @Override
    public Point3d getRenderingRotation(float partialTicks) {
        return new Point3d(((JSONPart)this.definition).ground.isWheel ? EntityVehicleF_Physics.SPEED_FACTOR * (this.angularPosition + this.angularVelocity * (double)partialTicks) * 360.0 : 0.0, 0.0, 0.0);
    }

    public void setFlatState(boolean setFlat) {
        if (!this.world.isClient()) {
            if (setFlat ? this.isFlat || ((JSONPart)this.definition).ground.flatHeight == 0.0f || (Boolean)ConfigSystem.configObject.damage.wheelBreakage.value == false : !this.isFlat) {
                return;
            }
            InterfacePacket.sendToAllClients(new PacketPartGroundDevice(this, setFlat));
        }
        this.isFlat = setFlat;
        this.boundingBox.heightRadius = this.getHeight();
        if (this.vehicleOn != null) {
            this.vehicleOn.groundDeviceCollective.updateBounds();
        }
    }

    public float getFrictionLoss() {
        Point3d groundPosition = this.position.copy().add(0.0, -1.0, 0.0);
        if (!this.world.isAir(groundPosition)) {
            Float modifier = ((JSONPart)this.definition).ground.frictionModifiers.get((Object)this.world.getBlockMaterial(groundPosition));
            if (modifier == null) {
                return this.world.getBlockSlipperiness(groundPosition) - 0.6f;
            }
            return this.world.getBlockSlipperiness(groundPosition) - 0.6f - modifier.floatValue();
        }
        return 0.0f;
    }

    public double getDesiredAngularVelocity() {
        if (this.vehicleOn != null && (((JSONPart)this.definition).ground.isWheel || ((JSONPart)this.definition).ground.isTread)) {
            if (this.vehicleOn.skidSteerActive) {
                if (this.placementOffset.x > 0.0) {
                    return this.getLongPartOffset() == 0.0f ? this.vehicleOn.rudderAngle / 200.0 / ((double)this.getHeight() * Math.PI) : this.vehicleOn.rudderAngle / 200.0;
                }
                if (this.placementOffset.x < 0.0) {
                    return this.getLongPartOffset() == 0.0f ? -this.vehicleOn.rudderAngle / 200.0 / ((double)this.getHeight() * Math.PI) : -this.vehicleOn.rudderAngle / 200.0;
                }
                return 0.0;
            }
            if (this.vehicleOn.goingInReverse) {
                return this.getLongPartOffset() == 0.0f ? -this.vehicleOn.groundVelocity / ((double)this.getHeight() * Math.PI) : -this.vehicleOn.groundVelocity;
            }
            return this.getLongPartOffset() == 0.0f ? this.vehicleOn.groundVelocity / ((double)this.getHeight() * Math.PI) : this.vehicleOn.groundVelocity;
        }
        return 0.0;
    }

    public float getMotiveFriction() {
        return !this.isFlat ? this.currentMotiveFriction : this.currentMotiveFriction / 10.0f;
    }

    public float getLateralFriction() {
        return !this.isFlat ? this.currentLateralFriction : this.currentLateralFriction / 10.0f;
    }

    public float getLongPartOffset() {
        return this.placementDefinition.extraCollisionBoxOffset != 0.0f ? this.placementDefinition.extraCollisionBoxOffset : ((JSONPart)this.definition).ground.extraCollisionBoxOffset;
    }

    @Override
    public WrapperNBT save(WrapperNBT data) {
        super.save(data);
        data.setBoolean("isFlat", this.isFlat);
        return data;
    }
}

