/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityBullet;
import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import minecrafttransportsimulator.entities.instances.EntityPlayerGun;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.items.instances.ItemBullet;
import minecrafttransportsimulator.jsondefs.AJSONPartProvider;
import minecrafttransportsimulator.jsondefs.JSONBullet;
import minecrafttransportsimulator.jsondefs.JSONMuzzle;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperEntity;
import minecrafttransportsimulator.mcinterface.WrapperInventory;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.packets.instances.PacketPartGun;
import minecrafttransportsimulator.rendering.components.RenderableObject;
import minecrafttransportsimulator.systems.PackParserSystem;

public class PartGun
extends APart {
    private final double minYaw;
    private final double maxYaw;
    private final double minPitch;
    private final double maxPitch;
    private final double defaultYaw;
    private final double defaultPitch;
    private final long millisecondFiringDelay;
    private final AItemPart gunItem;
    public int bulletsFired;
    public int bulletsLeft;
    public int bulletsReloading;
    public int bulletsRemovedThisRequest;
    public int currentMuzzleGroupIndex;
    public final Point3d currentGunOrientation;
    public final Point3d prevGunOrientation;
    public ItemBullet loadedBullet;
    public GunState state;
    public boolean firedThisRequest;
    public boolean firedThisCheck;
    public boolean playerHoldingTrigger;
    public boolean isHandHeldGunAimed;
    public int ticksFiring;
    public int reloadTimeRemaining;
    public int windupTimeCurrent;
    public int windupRotation;
    public int currentMuzzle;
    public WrapperEntity lastController;
    private WrapperEntity entityTarget;
    private long millisecondCamOffset;
    private long lastTimeFired;
    public final List<Integer> bulletsHitOnServer = new ArrayList<Integer>();
    public final RenderableObject muzzleWireframe = new RenderableObject(new BoundingBox(new Point3d(), 0.25, 0.25, 0.25), ColorRGB.BLUE, false);

    public PartGun(AEntityF_Multipart<?> entityOn, WrapperPlayer placingPlayer, JSONPartDefinition placementDefinition, WrapperNBT data, APart parentPart) {
        super(entityOn, placingPlayer, placementDefinition, data, parentPart);
        if (placementDefinition.minYaw == -180.0f && placementDefinition.maxYaw == 180.0f) {
            this.minYaw = -180.0;
            this.maxYaw = 180.0;
        } else {
            this.minYaw = ((JSONPart)this.definition).gun.minYaw != 0.0f ? (placementDefinition.minYaw != 0.0f ? (double)Math.max(((JSONPart)this.definition).gun.minYaw, placementDefinition.minYaw) : (double)((JSONPart)this.definition).gun.minYaw) : (double)placementDefinition.minYaw;
            this.maxYaw = ((JSONPart)this.definition).gun.maxYaw != 0.0f ? (placementDefinition.maxYaw != 0.0f ? (double)Math.min(((JSONPart)this.definition).gun.maxYaw, placementDefinition.maxYaw) : (double)((JSONPart)this.definition).gun.maxYaw) : (double)placementDefinition.maxYaw;
        }
        this.minPitch = ((JSONPart)this.definition).gun.minPitch != 0.0f ? (placementDefinition.maxPitch != 0.0f ? (double)(-Math.max(((JSONPart)this.definition).gun.maxPitch, placementDefinition.maxPitch)) : (double)(-((JSONPart)this.definition).gun.maxPitch)) : (double)(-placementDefinition.maxPitch);
        this.maxPitch = ((JSONPart)this.definition).gun.minPitch != 0.0f ? (placementDefinition.minPitch != 0.0f ? (double)(-Math.min(((JSONPart)this.definition).gun.minPitch, placementDefinition.minPitch)) : (double)(-((JSONPart)this.definition).gun.minPitch)) : (double)(-placementDefinition.minPitch);
        this.defaultYaw = placementDefinition.defaultYaw != 0.0f && (double)placementDefinition.defaultYaw >= this.minYaw && (double)placementDefinition.defaultYaw <= this.maxYaw ? (double)placementDefinition.defaultYaw : (double)((JSONPart)this.definition).gun.defaultYaw;
        this.defaultPitch = placementDefinition.defaultPitch != 0.0f && (double)(-placementDefinition.defaultPitch) >= this.minPitch && (double)(-placementDefinition.defaultPitch) <= this.maxPitch ? (double)(-placementDefinition.defaultPitch) : (double)(-((JSONPart)this.definition).gun.defaultPitch);
        this.millisecondFiringDelay = (long)(((JSONPart)this.definition).gun.fireDelay * 50.0f);
        this.gunItem = (AItemPart)this.getItem();
        this.state = GunState.values()[data.getInteger("state")];
        this.bulletsFired = data.getInteger("shotsFired");
        this.bulletsLeft = data.getInteger("bulletsLeft");
        this.bulletsReloading = data.getInteger("bulletsReloading");
        this.currentMuzzleGroupIndex = data.getInteger("currentMuzzleGroupIndex");
        this.currentGunOrientation = data.getPoint3d("currentOrientation");
        this.prevGunOrientation = this.currentGunOrientation.copy();
        String loadedBulletPack = data.getString("loadedBulletPack");
        String loadedBulletName = data.getString("loadedBulletName");
        if (!loadedBulletPack.isEmpty()) {
            this.loadedBullet = (ItemBullet)PackParserSystem.getItem(loadedBulletPack, loadedBulletName);
        }
        if (this.loadedBullet == null) {
            this.bulletsLeft = 0;
        }
    }

    @Override
    public boolean interact(WrapperPlayer player) {
        AItemBase heldItem = player.getHeldItem();
        if (heldItem instanceof ItemBullet && this.tryToReload((ItemBullet)heldItem) && !player.isCreative()) {
            player.getInventory().removeFromSlot(player.getHotbarIndex(), 1);
        }
        return true;
    }

    @Override
    public boolean update() {
        this.firedThisCheck = false;
        if (this.isActive && !this.placementDefinition.isSpare) {
            boolean ableToFire;
            WrapperEntity controller = this.getController();
            if (controller != null) {
                this.lastController = controller;
                if (this.entityOn instanceof EntityPlayerGun) {
                    this.state = this.state.promote(GunState.CONTROLLED);
                } else {
                    PartSeat controllerSeat = (PartSeat)this.entityOn.getPartAtLocation((Point3d)this.entityOn.locationRiderMap.inverse().get((Object)controller));
                    if (controller != null && controllerSeat != null && this.gunItem.equals(controllerSeat.activeGun) && (!((JSONPart)this.definition).gun.fireSolo || this.entityOn.partsByItem.get(this.gunItem).get(controllerSeat.gunIndex).equals(this))) {
                        this.state = this.state.promote(GunState.CONTROLLED);
                    } else {
                        this.state = this.state.demote(GunState.ACTIVE);
                        controller = null;
                    }
                }
            }
            if (controller == null) {
                if (!this.childParts.isEmpty()) {
                    for (APart part : this.childParts) {
                        if (!(part instanceof PartGun) || !part.placementDefinition.isCoAxial || (controller = ((PartGun)part).getController()) == null) continue;
                        this.state = this.state.promote(GunState.CONTROLLED);
                        break;
                    }
                }
                if (controller == null) {
                    this.state = this.state.demote(GunState.ACTIVE);
                }
            }
            if (this.state.isAtLeast(GunState.CONTROLLED)) {
                this.handleControl(controller);
            }
            boolean bl = ableToFire = this.windupTimeCurrent == ((JSONPart)this.definition).gun.windupTime && this.bulletsLeft > 0 && (!((JSONPart)this.definition).gun.isSemiAuto || !this.firedThisRequest);
            if (ableToFire && this.state.isAtLeast(GunState.FIRING_REQUESTED)) {
                long timeSinceFiring = System.currentTimeMillis() - this.lastTimeFired;
                if (!this.state.isAtLeast(GunState.FIRING_CURRENTLY) && timeSinceFiring >= this.millisecondFiringDelay) {
                    List<APart> allGuns = this.entityOn.partsByItem.get(this.gunItem);
                    int sequenceIndex = allGuns.indexOf(this);
                    APart lastPrimaryPart = this.entityOn.lastPrimaryPart.get(this.gunItem);
                    if (lastPrimaryPart != null && (sequenceIndex = sequenceIndex - 1 - allGuns.indexOf(lastPrimaryPart)) < 0) {
                        sequenceIndex += allGuns.size();
                    }
                    this.state = this.state.promote(GunState.FIRING_CURRENTLY);
                    this.millisecondCamOffset = ((JSONPart)this.definition).gun.fireSolo ? 0L : this.millisecondFiringDelay * (long)sequenceIndex / (long)allGuns.size();
                    this.lastTimeFired = System.currentTimeMillis() + this.millisecondCamOffset;
                    if (this.world.isClient()) {
                        this.lastTimeFired -= this.millisecondFiringDelay;
                    }
                }
            } else if (!ableToFire) {
                this.state = this.state.demote(GunState.FIRING_REQUESTED);
                this.ticksFiring = 0;
                if (!this.state.isAtLeast(GunState.FIRING_REQUESTED)) {
                    this.firedThisRequest = false;
                }
            }
            if (!this.world.isClient()) {
                if (this.state.isAtLeast(GunState.FIRING_CURRENTLY)) {
                    int bulletsToRemove;
                    int n = bulletsToRemove = ((JSONPart)this.definition).gun.isSemiAuto ? 1 : (int)(((float)(++this.ticksFiring) + ((JSONPart)this.definition).gun.fireDelay - (float)(this.millisecondCamOffset / 50L)) / ((JSONPart)this.definition).gun.fireDelay - (float)this.bulletsRemovedThisRequest);
                    if (bulletsToRemove > 0) {
                        this.firedThisRequest = true;
                        this.bulletsLeft -= (bulletsToRemove *= ((JSONPart)this.definition).gun.muzzleGroups.get((int)this.currentMuzzleGroupIndex).muzzles.size());
                        this.bulletsRemovedThisRequest += bulletsToRemove;
                        this.bulletsFired += bulletsToRemove;
                        this.entityOn.lastPrimaryPart.put(this.gunItem, this);
                        if (((JSONPart)this.definition).gun.muzzleGroups.size() == ++this.currentMuzzleGroupIndex) {
                            this.currentMuzzleGroupIndex = 0;
                        }
                        if (this.bulletsLeft <= 0) {
                            this.bulletsLeft = 0;
                            this.loadedBullet = null;
                        }
                    }
                } else {
                    this.bulletsRemovedThisRequest = 0;
                }
            }
            if (!this.world.isClient() && this.bulletsLeft < ((JSONPart)this.definition).gun.capacity && this.bulletsReloading == 0) {
                if (this.entityOn instanceof EntityPlayerGun) {
                    if (((JSONPart)this.definition).gun.autoReload || this.bulletsLeft == 0) {
                        WrapperInventory inventory = ((WrapperPlayer)this.lastController).getInventory();
                        for (int i = 0; i < inventory.getSize(); ++i) {
                            WrapperItemStack stack = inventory.getStack(i);
                            AItemBase item = stack.getItem();
                            if (!(item instanceof ItemBullet) || !this.tryToReload((ItemBullet)item)) continue;
                            inventory.removeFromSlot(i, 1);
                            break;
                        }
                    }
                } else if (((JSONPart)this.definition).gun.autoReload) {
                    block2: for (APart part : this.entityOn.parts) {
                        if (!(part instanceof PartInteractable) || !((JSONPart)part.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.CRATE) || !part.isActive || !((JSONPart)part.definition).interactable.feedsVehicles) continue;
                        EntityInventoryContainer inventory = ((PartInteractable)part).inventory;
                        for (int i = 0; i < inventory.getSize(); ++i) {
                            WrapperItemStack stack = inventory.getStack(i);
                            AItemBase item = stack.getItem();
                            if (!(item instanceof ItemBullet) || !this.tryToReload((ItemBullet)item)) continue;
                            inventory.removeFromSlot(i, 1);
                            continue block2;
                        }
                    }
                }
            }
            if (this.reloadTimeRemaining > 0) {
                --this.reloadTimeRemaining;
            } else if (this.bulletsReloading != 0) {
                this.bulletsLeft += this.bulletsReloading;
                this.bulletsReloading = 0;
            }
        } else {
            this.state = GunState.INACTIVE;
            this.entityTarget = null;
            if (((JSONPart)this.definition).gun.resetPosition) {
                this.handleMovement(this.defaultYaw, this.defaultPitch);
            }
        }
        if (this.state.isAtLeast(GunState.FIRING_REQUESTED)) {
            if (this.windupTimeCurrent < ((JSONPart)this.definition).gun.windupTime) {
                ++this.windupTimeCurrent;
            }
        } else if (this.windupTimeCurrent > 0) {
            --this.windupTimeCurrent;
        }
        this.windupRotation += this.windupTimeCurrent;
        if (!this.state.isAtLeast(GunState.FIRING_REQUESTED)) {
            this.firedThisRequest = false;
        }
        return super.update();
    }

    private void handleControl(WrapperEntity controller) {
        if (!(controller instanceof WrapperPlayer)) {
            Point3d targetAngles = new Point3d();
            if (this.entityTarget != null) {
                if (this.entityTarget.isValid()) {
                    Point3d positionDelta = this.entityTarget.getPosition().add(0.0, this.entityTarget.getEyeHeight() / 2.0, 0.0).subtract(this.position);
                    targetAngles.setTo(positionDelta).getAngles(true).subtract(this.angles);
                    if (targetAngles.y < -180.0) {
                        targetAngles.y += 360.0;
                    }
                    if (targetAngles.y > 180.0) {
                        targetAngles.y -= 360.0;
                    }
                    if ((this.minYaw != -180.0 || this.maxYaw != 180.0) && (targetAngles.y < this.minYaw || targetAngles.y > this.maxYaw) || targetAngles.x < this.minPitch || targetAngles.x > this.maxPitch || this.world.getBlockHit(this.position, positionDelta) != null) {
                        this.entityTarget = null;
                    }
                } else {
                    this.entityTarget = null;
                }
            }
            if (this.entityTarget == null || !this.entityTarget.isValid()) {
                for (WrapperEntity entity : this.world.getEntitiesHostile(controller, 48.0)) {
                    Point3d positionDelta = entity.getPosition().add(0.0, entity.getEyeHeight() / 2.0, 0.0).subtract(this.position);
                    targetAngles.setTo(positionDelta).getAngles(true).subtract(this.angles);
                    if (targetAngles.y < -180.0) {
                        targetAngles.y += 360.0;
                    }
                    if (targetAngles.y > 180.0) {
                        targetAngles.y -= 360.0;
                    }
                    if (this.entityTarget != null && !(this.position.distanceTo(this.entityTarget.getPosition()) > this.position.distanceTo(entity.getPosition())) || (this.minYaw != -180.0 || this.maxYaw != 180.0) && (!(targetAngles.y >= this.minYaw) || !(targetAngles.y <= this.maxYaw)) || !(targetAngles.x >= this.minPitch) || !(targetAngles.x <= this.maxPitch) || this.world.getBlockHit(this.position, positionDelta) != null) continue;
                    this.entityTarget = entity;
                }
            }
            if (this.entityTarget != null) {
                double ticksToTarget = this.entityTarget.getPosition().distanceTo(this.position) / (double)((JSONPart)this.definition).gun.muzzleVelocity / 20.0 / 10.0;
                targetAngles = this.entityTarget.getPosition().add(0.0, this.entityTarget.getEyeHeight() / 2.0, 0.0).add(this.entityTarget.getVelocity().multiply(ticksToTarget)).subtract(this.position).getAngles(true);
                controller.setYaw(targetAngles.y);
                controller.setPitch(targetAngles.x);
                this.state = this.state.promote(GunState.FIRING_REQUESTED);
            } else {
                this.state = this.state.demote(GunState.CONTROLLED);
            }
        } else {
            if (this.world.isClient() && this.loadedBullet != null && ((JSONBullet)this.loadedBullet.definition).bullet.turnFactor > 0.0f) {
                this.entityTarget = this.world.getEntityLookingAt(controller, 750.0f);
            }
            this.state = this.playerHoldingTrigger ? this.state.promote(GunState.FIRING_REQUESTED) : this.state.demote(GunState.CONTROLLED);
        }
        if (!(this.entityOn instanceof EntityPlayerGun)) {
            double partYawContribution = this.localAngles.y - this.prevGunOrientation.y;
            double partPitchContribution = ((JSONPart)this.definition).gun.pitchIsInternal ? this.localAngles.x : this.localAngles.x - this.prevGunOrientation.x;
            double entityPitchContribution = (this.entityOn.angles.x + partPitchContribution) * Math.cos(Math.toRadians(partYawContribution));
            double entityRollContribution = (this.entityOn.angles.z + this.localAngles.z) * Math.sin(Math.toRadians(partYawContribution));
            double targetYaw = (double)controller.getYaw() - (this.entityOn.angles.y + partYawContribution);
            double targetPitch = (double)controller.getPitch() - (entityPitchContribution + entityRollContribution);
            this.handleMovement(targetYaw, targetPitch);
        }
    }

    private void handleMovement(double targetYaw, double targetPitch) {
        this.prevGunOrientation.setTo(this.currentGunOrientation);
        double deltaYaw = -this.currentGunOrientation.getClampedYDelta(targetYaw);
        if (deltaYaw < 0.0) {
            if (deltaYaw < (double)(-((JSONPart)this.definition).gun.yawSpeed)) {
                deltaYaw = -((JSONPart)this.definition).gun.yawSpeed;
            }
            this.currentGunOrientation.y += deltaYaw;
        } else if (deltaYaw > 0.0) {
            if (deltaYaw > (double)((JSONPart)this.definition).gun.yawSpeed) {
                deltaYaw = ((JSONPart)this.definition).gun.yawSpeed;
            }
            this.currentGunOrientation.y += deltaYaw;
        }
        if (this.minYaw == -180.0 && this.maxYaw == 180.0) {
            if (this.currentGunOrientation.y > 180.0) {
                this.currentGunOrientation.y -= 360.0;
                this.prevGunOrientation.y -= 360.0;
            } else if (this.currentGunOrientation.y < -180.0) {
                this.currentGunOrientation.y += 360.0;
                this.prevGunOrientation.y += 360.0;
            }
        } else {
            if (this.currentGunOrientation.y > this.maxYaw) {
                this.currentGunOrientation.y = this.maxYaw;
            }
            if (this.currentGunOrientation.y < this.minYaw) {
                this.currentGunOrientation.y = this.minYaw;
            }
        }
        double deltaPitch = targetPitch - this.currentGunOrientation.x;
        if (deltaPitch < 0.0) {
            if (deltaPitch < (double)(-((JSONPart)this.definition).gun.pitchSpeed)) {
                deltaPitch = -((JSONPart)this.definition).gun.pitchSpeed;
            }
            this.currentGunOrientation.x += deltaPitch;
        } else if (deltaPitch > 0.0) {
            if (deltaPitch > (double)((JSONPart)this.definition).gun.pitchSpeed) {
                deltaPitch = ((JSONPart)this.definition).gun.pitchSpeed;
            }
            this.currentGunOrientation.x += deltaPitch;
        }
        if (this.currentGunOrientation.x > this.maxPitch) {
            this.currentGunOrientation.x = this.maxPitch;
        }
        if (this.currentGunOrientation.x < this.minPitch) {
            this.currentGunOrientation.x = this.minPitch;
        }
    }

    public boolean tryToReload(ItemBullet item) {
        if (((JSONBullet)item.definition).bullet != null) {
            boolean isNewBulletValid;
            boolean bl = isNewBulletValid = ((JSONBullet)item.definition).bullet.diameter == ((JSONPart)this.definition).gun.diameter && ((JSONBullet)item.definition).bullet.caseLength >= ((JSONPart)this.definition).gun.minCaseLength && ((JSONBullet)item.definition).bullet.caseLength <= ((JSONPart)this.definition).gun.maxCaseLength;
            if ((this.bulletsReloading == 0 && (this.loadedBullet != null ? this.loadedBullet.equals(item) : isNewBulletValid) || this.world.isClient()) && (((JSONBullet)item.definition).bullet.quantity + this.bulletsLeft <= ((JSONPart)this.definition).gun.capacity || this.world.isClient())) {
                this.loadedBullet = item;
                this.bulletsReloading = ((JSONBullet)item.definition).bullet.quantity;
                this.reloadTimeRemaining = ((JSONPart)this.definition).gun.reloadTime;
                if (!this.world.isClient()) {
                    InterfacePacket.sendToAllClients(new PacketPartGun(this, this.loadedBullet));
                }
                return true;
            }
        }
        return false;
    }

    public WrapperEntity getController() {
        if (this.entityOn.damageAmount == (double)((AJSONPartProvider)this.entityOn.definition).general.health) {
            return null;
        }
        if (this.entityOn instanceof EntityPlayerGun) {
            return ((EntityPlayerGun)this.entityOn).player;
        }
        if (this.parentPart instanceof PartSeat) {
            return (WrapperEntity)this.entityOn.locationRiderMap.get((Object)this.parentPart.placementOffset);
        }
        for (APart childPart : this.childParts) {
            if (!(childPart instanceof PartSeat)) continue;
            return (WrapperEntity)this.entityOn.locationRiderMap.get((Object)childPart.placementOffset);
        }
        for (APart vehiclePart : this.entityOn.parts) {
            WrapperEntity controller;
            if (!(vehiclePart instanceof PartSeat) || !vehiclePart.placementDefinition.isController || (controller = (WrapperEntity)this.entityOn.locationRiderMap.get((Object)vehiclePart.placementOffset)) == null) continue;
            return controller;
        }
        return null;
    }

    public void setBulletSpawn(Point3d bulletPosition, Point3d bulletVelocity, JSONMuzzle muzzle) {
        if (((JSONPart)this.definition).gun.muzzleVelocity > 0) {
            bulletVelocity.set(0.0, 0.0, (double)((JSONPart)this.definition).gun.muzzleVelocity / 20.0 / 10.0);
        } else {
            bulletVelocity.set(0.0, 0.0, 0.0);
        }
        if (((JSONPart)this.definition).gun.pitchIsInternal) {
            bulletVelocity.rotateFine(new Point3d(this.currentGunOrientation.x, 0.0, 0.0));
        }
        bulletVelocity.rotateFine(muzzle.rot);
        if (((JSONPart)this.definition).gun.bulletSpreadFactor > 0.0f) {
            bulletVelocity.rotateFine(new Point3d((Math.random() - 0.5) * (double)((JSONPart)this.definition).gun.bulletSpreadFactor, (Math.random() - 0.5) * (double)((JSONPart)this.definition).gun.bulletSpreadFactor, 0.0));
        }
        bulletVelocity.rotateFine(this.localAngles).rotateFine(this.entityOn.angles);
        bulletVelocity.addScaled(this.motion, EntityVehicleF_Physics.SPEED_FACTOR);
        if (((JSONPart)this.definition).gun.pitchIsInternal) {
            Point3d muzzleDelta = muzzle.pos.copy().subtract(muzzle.center);
            bulletPosition.setTo(muzzleDelta).rotateFine(new Point3d(this.currentGunOrientation.x, 0.0, 0.0)).subtract(muzzleDelta);
            bulletPosition.add(muzzle.pos);
        } else {
            bulletPosition.setTo(muzzle.pos);
        }
        bulletPosition.rotateFine(this.localAngles).rotateFine(this.entityOn.angles).add(this.position);
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        switch (variable) {
            case "gun_inhand": {
                return this.entityOn instanceof EntityPlayerGun ? 1.0 : 0.0;
            }
            case "gun_active": {
                return this.state.isAtLeast(GunState.CONTROLLED) ? 1.0 : 0.0;
            }
            case "gun_firing": {
                return this.state.isAtLeast(GunState.FIRING_CURRENTLY) ? 1.0 : 0.0;
            }
            case "gun_fired": {
                return this.firedThisCheck ? 1.0 : 0.0;
            }
            case "gun_lockedon": {
                return this.entityTarget != null ? 1.0 : 0.0;
            }
            case "gun_pitch": {
                return this.prevGunOrientation.x + (this.currentGunOrientation.x - this.prevGunOrientation.x) * (double)partialTicks;
            }
            case "gun_yaw": {
                return this.prevGunOrientation.y + (this.currentGunOrientation.y - this.prevGunOrientation.y) * (double)partialTicks;
            }
            case "gun_pitching": {
                return this.prevGunOrientation.x != this.currentGunOrientation.x ? 1.0 : 0.0;
            }
            case "gun_yawing": {
                return this.prevGunOrientation.y != this.currentGunOrientation.y ? 1.0 : 0.0;
            }
            case "gun_cooldown": {
                return this.state.isAtLeast(GunState.FIRING_CURRENTLY) && this.lastTimeFired != 0L ? (double)(System.currentTimeMillis() - this.lastTimeFired) / 50.0 : 0.0;
            }
            case "gun_windup_time": {
                return this.windupTimeCurrent;
            }
            case "gun_windup_rotation": {
                return this.windupRotation;
            }
            case "gun_windup_complete": {
                return this.windupTimeCurrent == ((JSONPart)this.definition).gun.windupTime ? 1.0 : 0.0;
            }
            case "gun_reload": {
                return this.reloadTimeRemaining > 0 ? 1.0 : 0.0;
            }
            case "gun_ammo_count": {
                return this.bulletsLeft;
            }
            case "gun_ammo_percent": {
                return this.bulletsLeft / ((JSONPart)this.definition).gun.capacity;
            }
            case "gun_active_muzzlegroup": {
                return this.currentMuzzleGroupIndex + 1;
            }
        }
        return super.getRawVariableValue(variable, partialTicks);
    }

    @Override
    public void spawnParticles(float partialTicks) {
        super.spawnParticles(partialTicks);
        long timeSinceFiring = System.currentTimeMillis() - this.lastTimeFired;
        if (!(!this.state.isAtLeast(GunState.FIRING_CURRENTLY) || this.bulletsLeft <= 0 || ((JSONPart)this.definition).gun.isSemiAuto && this.firedThisRequest || timeSinceFiring < this.millisecondFiringDelay)) {
            Point3d bulletPosition = new Point3d();
            Point3d bulletVelocity = new Point3d();
            for (JSONMuzzle muzzle : ((JSONPart)this.definition).gun.muzzleGroups.get((int)this.currentMuzzleGroupIndex).muzzles) {
                EntityBullet newBullet;
                this.setBulletSpawn(bulletPosition, bulletVelocity, muzzle);
                if (((JSONBullet)this.loadedBullet.definition).bullet.turnFactor > 0.0f) {
                    if (this.entityTarget != null) {
                        newBullet = new EntityBullet(bulletPosition, bulletVelocity, this, this.entityTarget);
                    } else {
                        Point3d lineOfSight = this.lastController.getLineOfSight(2000.0);
                        Point3d blockTarget = this.world.getBlockHit(this.lastController.getPosition().add(0.0, this.lastController.getEyeHeight(), 0.0), lineOfSight);
                        newBullet = blockTarget != null ? new EntityBullet(bulletPosition, bulletVelocity, this, blockTarget) : new EntityBullet(bulletPosition, bulletVelocity, this);
                    }
                } else {
                    newBullet = new EntityBullet(bulletPosition, bulletVelocity, this);
                }
                this.world.addEntity(newBullet);
                --this.bulletsLeft;
                ++this.bulletsFired;
                if (this.bulletsLeft != 0) continue;
                break;
            }
            this.entityOn.lastPrimaryPart.put(this.gunItem, this);
            this.lastTimeFired += this.millisecondFiringDelay;
            this.firedThisRequest = true;
            this.firedThisCheck = true;
            if (((JSONPart)this.definition).gun.muzzleGroups.size() == ++this.currentMuzzleGroupIndex) {
                this.currentMuzzleGroupIndex = 0;
            }
        } else if (this.millisecondFiringDelay < 50L) {
            this.firedThisCheck = false;
        }
    }

    @Override
    public WrapperNBT save(WrapperNBT data) {
        super.save(data);
        data.setInteger("state", (byte)this.state.ordinal());
        data.setInteger("shotsFired", this.bulletsFired);
        data.setInteger("bulletsLeft", this.bulletsLeft);
        data.setInteger("bulletsReloading", this.bulletsReloading);
        data.setInteger("currentMuzzleGroupIndex", this.currentMuzzleGroupIndex);
        data.setPoint3d("currentOrientation", this.currentGunOrientation);
        if (this.loadedBullet != null) {
            data.setString("loadedBulletPack", ((JSONBullet)this.loadedBullet.definition).packID);
            data.setString("loadedBulletName", ((JSONBullet)this.loadedBullet.definition).systemName);
        }
        return data;
    }

    public static enum GunState {
        INACTIVE,
        ACTIVE,
        CONTROLLED,
        FIRING_REQUESTED,
        FIRING_CURRENTLY;


        public GunState promote(GunState newState) {
            return newState.ordinal() > this.ordinal() ? newState : this;
        }

        public GunState demote(GunState newState) {
            return newState.ordinal() < this.ordinal() ? newState : this;
        }

        public boolean isAtLeast(GunState testState) {
            return this.ordinal() >= testState.ordinal();
        }
    }
}

