/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityFluidTank;
import minecrafttransportsimulator.entities.instances.EntityFurnace;
import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperEntity;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.packets.instances.PacketFurnaceFuelAdd;
import minecrafttransportsimulator.packets.instances.PacketPartInteractable;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.systems.ConfigSystem;

public final class PartInteractable
extends APart {
    public final EntityFurnace furnace;
    public final EntityInventoryContainer inventory;
    public final EntityFluidTank tank;
    public String jerrycanFluid;
    public PartInteractable linkedPart;
    public EntityVehicleF_Physics linkedVehicle;

    public PartInteractable(AEntityF_Multipart<?> entityOn, WrapperPlayer placingPlayer, JSONPartDefinition placementDefinition, WrapperNBT data, APart parentPart) {
        super(entityOn, placingPlayer, placementDefinition, data, parentPart);
        if (((JSONPart)this.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.FURNACE)) {
            this.furnace = new EntityFurnace(this.world, data.getDataOrNew("furnace"), ((JSONPart)this.definition).interactable);
            this.inventory = this.furnace;
            this.world.addEntity(this.furnace);
        } else {
            this.furnace = null;
            if (((JSONPart)this.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.CRATE)) {
                this.inventory = new EntityInventoryContainer(this.world, data.getDataOrNew("inventory"), (int)(((JSONPart)this.definition).interactable.inventoryUnits * 9.0f));
                this.world.addEntity(this.inventory);
            } else {
                this.inventory = null;
            }
        }
        if (((JSONPart)this.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.BARREL)) {
            this.tank = new EntityFluidTank(this.world, data.getDataOrNew("tank"), (int)((JSONPart)this.definition).interactable.inventoryUnits * 10000);
            this.world.addEntity(this.tank);
        } else {
            this.tank = null;
        }
        this.jerrycanFluid = data.getString("jerrycanFluid");
    }

    @Override
    public boolean interact(WrapperPlayer player) {
        if (!this.entityOn.locked) {
            if (((JSONPart)this.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.CRATE) || ((JSONPart)this.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.CRAFTING_BENCH) || ((JSONPart)this.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.FURNACE)) {
                player.sendPacket(new PacketPartInteractable(this, player));
            } else if (((JSONPart)this.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.CRAFTING_TABLE)) {
                player.openCraftingGUI();
            } else if (((JSONPart)this.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.JERRYCAN)) {
                this.entityOn.removePart(this, null);
                WrapperNBT data = new WrapperNBT();
                this.save(data);
                this.world.spawnItem((AItemBase)this.getItem(), data, this.position);
            } else if (this.tank != null) {
                player.getHeldStack().interactWith(this.tank, player);
            }
        } else {
            player.sendPacket(new PacketPlayerChatMessage(player, "interact.failure.vehiclelocked"));
        }
        return true;
    }

    @Override
    public void attack(Damage damage) {
        super.attack(damage);
        if (!damage.isWater && (damage.amount > 25.0 || this.damageAmount > (double)((JSONPart)this.definition).general.health)) {
            this.destroy(damage.box);
        }
    }

    @Override
    public void destroy(BoundingBox box) {
        double explosivePower = this.getExplosiveContribution();
        if (explosivePower > 0.0 && this.isValid) {
            super.destroy(box);
            this.world.spawnExplosion(this.position, explosivePower, true);
            this.entityOn.destroy(this.boundingBox);
        } else {
            super.destroy(box);
        }
    }

    @Override
    public boolean update() {
        if (super.update()) {
            if (this.furnace != null) {
                this.furnace.update();
                if (!this.world.isClient() && this.furnace.ticksLeftOfFuel == 0 && this.furnace.ticksLeftToSmelt > 0) {
                    this.addFurnaceFuel();
                }
                if (this.vehicleOn != null) {
                    this.vehicleOn.electricUsage += this.furnace.powerToDrawPerTick;
                }
            }
            if (!this.world.isClient()) {
                EntityFluidTank linkedTank = null;
                String linkedMessage = null;
                if (this.linkedVehicle != null) {
                    if (this.linkedVehicle.position.distanceTo(this.position) > 16.0) {
                        linkedMessage = "interact.fuelhose.linkdropped";
                    } else {
                        linkedTank = this.linkedVehicle.fuelTank;
                    }
                } else if (this.linkedPart != null) {
                    if (this.linkedPart.position.distanceTo(this.position) > 16.0) {
                        linkedMessage = "interact.fuelhose.linkdropped";
                    } else {
                        linkedTank = this.linkedPart.tank;
                    }
                }
                if (linkedTank != null) {
                    String fluidToTransfer = this.tank.getFluid();
                    if (!fluidToTransfer.isEmpty()) {
                        double amountToTransfer = linkedTank.fill(fluidToTransfer, 10.0, false);
                        if (amountToTransfer > 0.0) {
                            if ((amountToTransfer = this.tank.drain(fluidToTransfer, amountToTransfer, true)) > 0.0) {
                                linkedTank.fill(fluidToTransfer, amountToTransfer, true);
                            } else {
                                linkedMessage = "interact.fuelhose.tankempty";
                            }
                        } else {
                            linkedMessage = "interact.fuelhose.tankfull";
                        }
                    } else {
                        linkedMessage = "interact.fuelhose.tankempty";
                    }
                }
                if (linkedMessage != null) {
                    this.linkedVehicle = null;
                    this.linkedPart = null;
                    for (WrapperEntity entity : this.world.getEntitiesWithin(new BoundingBox(this.position, 16.0, 16.0, 16.0))) {
                        if (!(entity instanceof WrapperPlayer)) continue;
                        ((WrapperPlayer)entity).sendPacket(new PacketPlayerChatMessage((WrapperPlayer)entity, linkedMessage));
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void addFurnaceFuel() {
        switch (this.furnace.definition.furnaceType) {
            case STANDARD: {
                WrapperItemStack currentFuel = this.furnace.getStack(2);
                if (!currentFuel.isEmpty() && currentFuel.getMaxSize() >= currentFuel.getSize()) break;
                for (APart part : this.entityOn.parts) {
                    if (!(part instanceof PartInteractable) || !part.isActive || !((JSONPart)part.definition).interactable.feedsVehicles || !((JSONPart)part.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.CRATE)) continue;
                    PartInteractable crate = (PartInteractable)part;
                    for (int i = 0; i < crate.inventory.getSize(); ++i) {
                        WrapperItemStack stack = crate.inventory.getStack(i);
                        if (stack.getFuelValue() == 0 || !currentFuel.isEmpty() && !stack.isCompleteMatch(currentFuel)) continue;
                        this.furnace.ticksLeftOfFuel = this.furnace.ticksAddedOfFuel = stack.getFuelValue();
                        crate.inventory.removeFromSlot(i, 1);
                        InterfacePacket.sendToAllClients(new PacketFurnaceFuelAdd(this.furnace));
                        return;
                    }
                }
                break;
            }
            case FUEL: {
                for (APart part : this.entityOn.parts) {
                    if (!(part instanceof PartInteractable) || !part.isActive || !((JSONPart)part.definition).interactable.feedsVehicles || !((JSONPart)part.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.BARREL)) continue;
                    PartInteractable barrel = (PartInteractable)part;
                    if (!(barrel.tank.getFluidLevel() > 0.0) || !ConfigSystem.configObject.fuel.fuels.get("furnace").containsKey(barrel.tank.getFluid())) continue;
                    this.furnace.ticksLeftOfFuel = this.furnace.ticksAddedOfFuel = (int)(ConfigSystem.configObject.fuel.fuels.get("furnace").get(barrel.tank.getFluid()) * 20.0 * (double)this.furnace.definition.furnaceEfficiency);
                    barrel.tank.drain(barrel.tank.getFluid(), 1.0, true);
                    InterfacePacket.sendToAllClients(new PacketFurnaceFuelAdd(this.furnace));
                }
                break;
            }
            case ELECTRIC: {
                this.furnace.powerToDrawPerTick = 0.0;
                if (this.vehicleOn == null || !(this.vehicleOn.electricPower > 1.0)) break;
                int ticksToDrawPower = (int)(500.0f * this.furnace.definition.furnaceEfficiency);
                this.furnace.powerToDrawPerTick = 1.0 / (double)ticksToDrawPower;
                this.furnace.ticksLeftOfFuel = this.furnace.ticksAddedOfFuel = ticksToDrawPower;
                InterfacePacket.sendToAllClients(new PacketFurnaceFuelAdd(this.furnace));
            }
        }
    }

    @Override
    public double getMass() {
        double currentMass = super.getMass();
        if (this.inventory != null) {
            currentMass += this.inventory.getMass();
        } else if (this.tank != null) {
            currentMass += this.tank.getMass();
        }
        return currentMass;
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        switch (variable) {
            case "interactable_count": {
                if (this.inventory != null) {
                    return this.inventory.getCount();
                }
                return 0.0;
            }
            case "interactable_percent": {
                if (this.inventory != null) {
                    return (double)this.inventory.getCount() / (double)this.inventory.getSize();
                }
                if (this.tank != null) {
                    return this.tank.getFluidLevel() / (double)this.tank.getMaxLevel();
                }
                return 0.0;
            }
            case "interactable_capacity": {
                if (this.inventory != null) {
                    return this.inventory.getSize();
                }
                if (this.tank != null) {
                    return this.tank.getMaxLevel() / 1000;
                }
                return 0.0;
            }
        }
        return super.getRawVariableValue(variable, partialTicks);
    }

    public double getExplosiveContribution() {
        if (this.inventory != null) {
            return this.inventory.getExplosiveness();
        }
        if (this.tank != null) {
            return this.tank.getExplosiveness();
        }
        return 0.0;
    }

    @Override
    public WrapperNBT save(WrapperNBT data) {
        super.save(data);
        if (this.furnace != null) {
            data.setData("furnace", this.furnace.save(new WrapperNBT()));
        } else if (this.inventory != null) {
            data.setData("inventory", this.inventory.save(new WrapperNBT()));
        } else if (this.tank != null) {
            data.setData("tank", this.tank.save(new WrapperNBT()));
        } else if (((JSONPart)this.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.JERRYCAN)) {
            data.setString("jerrycanFluid", this.jerrycanFluid);
        }
        return data;
    }
}

