/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.packets.instances.PacketPartEngine;
import minecrafttransportsimulator.systems.ConfigSystem;

public class PartPropeller
extends APart {
    public double angularPosition;
    public double angularVelocity;
    public int currentPitch;
    private final PartEngine connectedEngine;
    private final Point3d propellerForce = new Point3d();
    private final BoundingBox damageBounds;
    public static final int MIN_DYNAMIC_PITCH = 45;

    public PartPropeller(AEntityF_Multipart<?> entityOn, WrapperPlayer placingPlayer, JSONPartDefinition placementDefinition, WrapperNBT data, APart parentPart) {
        super(entityOn, placingPlayer, placementDefinition, data, parentPart);
        this.currentPitch = ((JSONPart)this.definition).propeller.pitch;
        this.connectedEngine = (PartEngine)parentPart;
        double propellerRadius = (double)((JSONPart)this.definition).propeller.diameter * 0.0254 / 2.0;
        this.damageBounds = ((JSONPart)this.definition).propeller.isRotor ? new BoundingBox(this.position, propellerRadius, 0.25, propellerRadius) : new BoundingBox(this.position, propellerRadius, propellerRadius, propellerRadius);
    }

    @Override
    public void attack(Damage damage) {
        super.attack(damage);
        if (!damage.isWater) {
            if (damage.entityResponsible instanceof WrapperPlayer && ((WrapperPlayer)damage.entityResponsible).getHeldStack().isEmpty()) {
                if (!this.entityOn.equals(damage.entityResponsible.getEntityRiding())) {
                    this.connectedEngine.handStartEngine();
                    InterfacePacket.sendToAllClients(new PacketPartEngine(this.connectedEngine, PacketPartEngine.Signal.HS_ON));
                }
                return;
            }
            if (this.damageAmount == (double)((JSONPart)this.definition).general.health) {
                if (((Boolean)ConfigSystem.configObject.damage.explosions.value).booleanValue()) {
                    this.world.spawnExplosion(this.position, 1.0, true);
                } else {
                    this.world.spawnExplosion(this.position, 0.0, false);
                }
                this.remove();
            }
        }
    }

    @Override
    public boolean update() {
        if (super.update()) {
            if (this.connectedEngine == null) {
                this.isValid = false;
                return false;
            }
            if (this.vehicleOn != null) {
                if (((JSONPart)this.definition).propeller.isRotor) {
                    double throttlePitchSetting;
                    double d = throttlePitchSetting = this.connectedEngine.running ? (this.vehicleOn.throttle * 1.35 - 0.35) * (double)((JSONPart)this.definition).propeller.pitch : 0.0;
                    if (throttlePitchSetting < (double)this.currentPitch) {
                        --this.currentPitch;
                    } else if (throttlePitchSetting > (double)this.currentPitch) {
                        ++this.currentPitch;
                    }
                } else if (((JSONPart)this.definition).propeller.isDynamicPitch) {
                    if (this.vehicleOn.reverseThrust && this.currentPitch > -45) {
                        --this.currentPitch;
                    } else if (!this.vehicleOn.reverseThrust && this.currentPitch < 45) {
                        ++this.currentPitch;
                    } else if (this.connectedEngine.rpm < (double)((JSONPart)this.connectedEngine.definition).engine.maxSafeRPM * 0.6 && this.currentPitch > 45) {
                        --this.currentPitch;
                    } else if (this.connectedEngine.rpm > (double)((JSONPart)this.connectedEngine.definition).engine.maxSafeRPM * 0.85 && this.currentPitch < ((JSONPart)this.definition).propeller.pitch) {
                        ++this.currentPitch;
                    }
                }
            }
            this.angularVelocity = this.connectedEngine.propellerGearboxRatio != 0.0f ? (double)((float)(this.connectedEngine.rpm / (double)this.connectedEngine.propellerGearboxRatio / 60.0 / 20.0)) : (this.angularVelocity > 0.01 ? (this.angularVelocity -= 0.01) : (this.angularVelocity < -0.01 ? (this.angularVelocity += 0.01) : 0.0));
            this.angularPosition += this.angularVelocity;
            if (this.angularPosition > 3600000.0) {
                this.angularPosition -= 3600000.0;
                this.angularPosition -= 3600000.0;
            } else if (this.angularPosition < -3600000.0) {
                this.angularPosition += 3600000.0;
                this.angularPosition += 3600000.0;
            }
            if (!this.world.isClient() && this.connectedEngine.rpm >= 100.0) {
                this.boundingBox.widthRadius += 0.2;
                this.boundingBox.heightRadius += 0.2;
                this.boundingBox.depthRadius += 0.2;
                Damage propellerDamage = new Damage("propellor", (Double)ConfigSystem.configObject.damage.propellerDamageFactor.value * this.connectedEngine.rpm * (double)this.connectedEngine.propellerGearboxRatio / 500.0, this.damageBounds, this, this.vehicleOn != null ? this.vehicleOn.getController() : null);
                this.world.attackEntities(propellerDamage, null);
                this.boundingBox.widthRadius -= 0.2;
                this.boundingBox.heightRadius -= 0.2;
                this.boundingBox.depthRadius -= 0.2;
            }
            return true;
        }
        return false;
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        switch (variable) {
            case "propeller_pitch_deg": {
                return Math.toDegrees(Math.atan((double)this.currentPitch / ((double)((JSONPart)this.definition).propeller.diameter * 0.75 * Math.PI)));
            }
            case "propeller_pitch_in": {
                return this.currentPitch;
            }
            case "propeller_pitch_percent": {
                return 1.0 * (double)(this.currentPitch - 45) / (double)(((JSONPart)this.definition).propeller.pitch - 45);
            }
            case "propeller_rotation": {
                return (this.angularPosition + this.angularVelocity * (double)partialTicks) * 360.0;
            }
        }
        return super.getRawVariableValue(variable, partialTicks);
    }

    @Override
    public Point3d getRenderingRotation(float partialTicks) {
        return new Point3d(0.0, 0.0, (this.angularPosition + this.angularVelocity * (double)partialTicks) * 360.0);
    }

    public Point3d getForceOutput() {
        this.propellerForce.set(0.0, 0.0, 0.0);
        if (this.connectedEngine != null && this.connectedEngine.running) {
            Point3d propellerThrustAxis = new Point3d(0.0, 0.0, 1.0).rotateFine(this.localAngles.copy().add(this.entityOn.angles));
            double currentLinearVelocity = 20.0 * this.entityOn.motion.dotProduct(propellerThrustAxis);
            double desiredLinearVelocity = 0.0254 * (double)(this.currentPitch + 20) * 20.0 * this.angularVelocity;
            if (desiredLinearVelocity != 0.0) {
                double thrust = desiredLinearVelocity - currentLinearVelocity;
                thrust *= Math.PI * Math.pow(0.0254 * (double)((JSONPart)this.definition).propeller.diameter / 2.0, 2.0);
                thrust *= this.airDensity / 25.0 * 1.5;
                double angleOfAttack = (desiredLinearVelocity - currentLinearVelocity) / (this.connectedEngine.rpm / (double)this.connectedEngine.propellerGearboxRatio / 60.0) / ((double)((JSONPart)this.definition).propeller.diameter * Math.PI * 0.0254);
                if (Math.abs(angleOfAttack) > 0.4663) {
                    thrust *= 0.4663 / Math.abs(angleOfAttack);
                }
                if (this.isInLiquid()) {
                    thrust *= 50.0;
                }
                this.propellerForce.add(new Point3d(0.0, 0.0, thrust).rotateFine(this.localAngles));
            }
        }
        return this.propellerForce;
    }
}

