/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.items.instances.ItemPartGun;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperEntity;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.packets.instances.PacketPartSeat;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.systems.PackParserSystem;

public final class PartSeat
extends APart {
    public boolean canControlGuns;
    public ItemPartGun activeGun;
    public int gunIndex;

    public PartSeat(AEntityF_Multipart<?> entityOn, WrapperPlayer placingPlayer, JSONPartDefinition placementDefinition, WrapperNBT data, APart parentPart) {
        super(entityOn, placingPlayer, placementDefinition, data, parentPart);
        this.activeGun = (ItemPartGun)PackParserSystem.getItem(data.getString("activeGunPackID"), data.getString("activeGunSystemName"), data.getString("activeGunSubName"));
    }

    @Override
    public boolean interact(WrapperPlayer player) {
        if (this.isActive) {
            if (!this.entityOn.locked || this.entityOn.equals(player.getEntityRiding())) {
                WrapperEntity riderForSeat = (WrapperEntity)this.entityOn.locationRiderMap.get((Object)this.placementOffset);
                if (riderForSeat != null) {
                    if (riderForSeat instanceof WrapperPlayer) {
                        if (!player.equals(riderForSeat)) {
                            player.sendPacket(new PacketPlayerChatMessage(player, "interact.failure.seattaken"));
                        }
                    } else if (!riderForSeat.leashTo(player)) {
                        player.sendPacket(new PacketPlayerChatMessage(player, "interact.failure.seattaken"));
                    }
                } else {
                    WrapperEntity leashedEntity = player.getLeashedEntity();
                    if (leashedEntity != null) {
                        this.entityOn.addRider(leashedEntity, this.placementOffset);
                    } else if (!player.isSneaking()) {
                        if (player.getEntityRiding() != null && !this.entityOn.equals(player.getEntityRiding())) {
                            player.getEntityRiding().removeRider(player, null);
                        }
                        this.entityOn.addRider(player, this.placementOffset);
                        if (this.activeGun == null) {
                            this.setNextActiveGun();
                            InterfacePacket.sendToAllClients(new PacketPartSeat(this));
                        } else {
                            for (AItemPart partItem : this.entityOn.partsByItem.keySet()) {
                                if (((JSONPart)partItem.definition).gun == null) continue;
                                for (APart part : this.entityOn.partsByItem.get(partItem)) {
                                    if (!player.equals(((PartGun)part).getController()) || !partItem.equals(this.activeGun)) continue;
                                    return true;
                                }
                            }
                            this.activeGun = null;
                            this.setNextActiveGun();
                            InterfacePacket.sendToAllClients(new PacketPartSeat(this));
                        }
                    }
                }
            } else {
                player.sendPacket(new PacketPlayerChatMessage(player, "interact.failure.vehiclelocked"));
            }
        }
        return true;
    }

    public void setNextActiveGun() {
        if (this.activeGun == null) {
            WrapperEntity rider = (WrapperEntity)this.entityOn.locationRiderMap.get((Object)this.placementOffset);
            for (AItemPart partItem : this.entityOn.partsByItem.keySet()) {
                if (!(partItem instanceof ItemPartGun)) continue;
                for (APart part : this.entityOn.partsByItem.get(partItem)) {
                    if (!rider.equals(((PartGun)part).getController())) continue;
                    this.activeGun = (ItemPartGun)partItem;
                    this.gunIndex = 0;
                    return;
                }
            }
        } else {
            this.activeGun = this.getNextActiveGun();
        }
    }

    private ItemPartGun getNextActiveGun() {
        WrapperEntity rider = (WrapperEntity)this.entityOn.locationRiderMap.get((Object)this.placementOffset);
        boolean pastActiveGun = false;
        ItemPartGun firstPossibleGun = null;
        block0: for (AItemPart partItem : this.entityOn.partsByItem.keySet()) {
            if (!(partItem instanceof ItemPartGun)) continue;
            for (APart part : this.entityOn.partsByItem.get(partItem)) {
                if (!rider.equals(((PartGun)part).getController())) continue;
                if (pastActiveGun) {
                    return (ItemPartGun)partItem;
                }
                if (firstPossibleGun == null) {
                    firstPossibleGun = (ItemPartGun)partItem;
                }
                if (!partItem.equals(this.activeGun)) continue block0;
                if (((JSONPart)part.definition).gun.fireSolo) {
                    if (this.entityOn.partsByItem.get(partItem).size() <= ++this.gunIndex) {
                        this.gunIndex = 0;
                        pastActiveGun = true;
                        continue block0;
                    }
                    return (ItemPartGun)partItem;
                }
                pastActiveGun = true;
                continue block0;
            }
        }
        return this.placementDefinition.canDisableGun && this.activeGun != null ? null : firstPossibleGun;
    }

    @Override
    public boolean update() {
        if (super.update()) {
            if (!this.canControlGuns && this.activeGun != null) {
                this.canControlGuns = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public void remove() {
        super.remove();
        WrapperEntity rider = (WrapperEntity)this.entityOn.locationRiderMap.get((Object)this.placementOffset);
        if (rider != null) {
            this.entityOn.removeRider(rider, null);
        }
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        double value = super.getRawVariableValue(variable, partialTicks);
        if (!Double.isNaN(value)) {
            return value;
        }
        WrapperEntity riderForSeat = (WrapperEntity)this.entityOn.locationRiderMap.get((Object)this.placementOffset);
        switch (variable) {
            case "seat_occupied": {
                return riderForSeat != null ? 1.0 : 0.0;
            }
            case "seat_occupied_client": {
                return InterfaceClient.getClientPlayer().equals(riderForSeat) ? 1.0 : 0.0;
            }
            case "seat_rider_yaw": {
                if (riderForSeat != null) {
                    double riderYaw;
                    for (riderYaw = (double)riderForSeat.getYaw() - this.entityOn.angles.y; riderYaw < -180.0; riderYaw += 360.0) {
                    }
                    while (riderYaw > 180.0) {
                        riderYaw -= 360.0;
                    }
                    return riderYaw;
                }
                return 0.0;
            }
            case "seat_rider_pitch": {
                if (riderForSeat != null) {
                    double pitch;
                    double roll = this.entityOn.angles.z;
                    double riderYaw = (double)riderForSeat.getYaw() - this.entityOn.angles.y;
                    for (pitch = this.entityOn.angles.x; pitch > 180.0; pitch -= 360.0) {
                    }
                    while (pitch < -180.0) {
                        pitch += 360.0;
                    }
                    while (roll > 180.0) {
                        roll -= 360.0;
                    }
                    while (roll < -180.0) {
                        roll += 360.0;
                    }
                    double rollRollComponent = -Math.sin(Math.toRadians(riderYaw)) * roll;
                    double pitchRollComponent = Math.cos(Math.toRadians(riderYaw)) * pitch;
                    return (double)riderForSeat.getPitch() - (rollRollComponent + pitchRollComponent);
                }
                return 0.0;
            }
        }
        return Double.NaN;
    }

    @Override
    public WrapperNBT save(WrapperNBT data) {
        super.save(data);
        if (this.activeGun != null) {
            data.setString("activeGunPackID", ((JSONPart)this.activeGun.definition).packID);
            data.setString("activeGunSystemName", ((JSONPart)this.activeGun.definition).systemName);
            data.setString("activeGunSubName", this.activeGun.subName);
        }
        return data;
    }
}

