/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.components;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.guis.components.AGUIComponent;
import minecrafttransportsimulator.guis.components.GUIComponent3DModel;
import minecrafttransportsimulator.guis.components.GUIComponentCutout;
import minecrafttransportsimulator.guis.components.GUIComponentInstrument;
import minecrafttransportsimulator.guis.components.GUIComponentItem;
import minecrafttransportsimulator.guis.instances.GUIOverlay;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.InterfaceInput;
import minecrafttransportsimulator.mcinterface.InterfaceRender;

public abstract class AGUIBase {
    public static final int STANDARD_GUI_WIDTH = 256;
    public static final int STANDARD_GUI_HEIGHT = 192;
    public static final String STANDARD_TEXTURE_NAME = "mts:textures/guis/standard.png";
    protected static final int STANDARD_COLOR_WIDTH = 20;
    protected static final int STANDARD_COLOR_HEIGHT = 20;
    protected static final int STANDARD_COLOR_WIDTH_OFFSET = 236;
    protected static final int STANDARD_RED_HEIGHT_OFFSET = 196;
    protected static final int STANDARD_YELLOW_HEIGHT_OFFSET = 216;
    protected static final int STANDARD_BLACK_HEIGHT_OFFSET = 236;
    private GUIComponentCutout background;
    public final List<AGUIComponent> components = new ArrayList<AGUIComponent>();
    public static final List<AGUIBase> activeGUIs = new ArrayList<AGUIBase>();
    public static AGUIBase activeInputGUI;
    protected int screenWidth;
    protected int screenHeight;
    protected int guiLeft;
    protected int guiTop;

    public AGUIBase() {
        activeGUIs.add(this);
        if (this.capturesPlayer()) {
            activeInputGUI = this;
            InterfaceClient.setActiveGUI(this);
            InterfaceInput.setKeyboardRepeat(true);
        }
    }

    public void setupComponentsInit(int screenWidth, int screenHeight) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.guiLeft = (screenWidth - this.getWidth()) / 2;
        this.guiTop = this.renderFlushBottom() ? screenHeight - this.getHeight() : (screenHeight - this.getHeight()) / 2;
        this.setupComponents();
    }

    public void setupComponents() {
        this.components.clear();
        if (this.renderBackgroundFullTexture()) {
            this.background = new GUIComponentCutout(this.guiLeft, this.guiTop, this.getWidth(), this.getHeight());
            this.addComponent(this.background);
        } else {
            this.background = new GUIComponentCutout(this.guiLeft, this.guiTop, this.getWidth(), this.getHeight(), 0, 0, this.getWidth(), this.getHeight());
            this.addComponent(this.background);
        }
    }

    public void addRenderToBuffer(FloatBuffer buffer, int offsetX, int offsetY, int width, int height, float u, float v, float U, float V, int textureWidth, int textureHeight) {
        u /= (float)textureWidth;
        U /= (float)textureWidth;
        v /= (float)textureHeight;
        V /= (float)textureHeight;
        for (int i = 0; i < 6; ++i) {
            buffer.put(0.0f);
            buffer.put(0.0f);
            buffer.put(1.0f);
            switch (i) {
                case 0: {
                    buffer.put(U);
                    buffer.put(V);
                    buffer.put(offsetX + width);
                    buffer.put(offsetY - height);
                    break;
                }
                case 1: {
                    buffer.put(U);
                    buffer.put(v);
                    buffer.put(offsetX + width);
                    buffer.put(offsetY);
                    break;
                }
                case 2: {
                    buffer.put(u);
                    buffer.put(v);
                    buffer.put(offsetX);
                    buffer.put(offsetY);
                    break;
                }
                case 3: {
                    buffer.put(U);
                    buffer.put(V);
                    buffer.put(offsetX + width);
                    buffer.put(offsetY - height);
                    break;
                }
                case 4: {
                    buffer.put(u);
                    buffer.put(v);
                    buffer.put(offsetX);
                    buffer.put(offsetY);
                    break;
                }
                case 5: {
                    buffer.put(u);
                    buffer.put(V);
                    buffer.put(offsetX);
                    buffer.put(offsetY - height);
                }
            }
            buffer.put(0.0f);
        }
    }

    public void setStates() {
        this.background.visible = this.renderBackground();
    }

    public final void render(int mouseX, int mouseY, boolean blendingEnabled, float partialTicks) {
        boolean ignoreLightState;
        if (!blendingEnabled) {
            this.setStates();
        }
        if (!(ignoreLightState = this.getGUILightMode().equals((Object)GUILightingMode.NONE))) {
            InterfaceRender.setLightingToPosition(this.getGUILightSource().position);
        }
        if (!(this.renderTranslucent() ^ blendingEnabled)) {
            for (AGUIComponent aGUIComponent : this.components) {
                if (!aGUIComponent.visible || aGUIComponent instanceof GUIComponentInstrument) continue;
                aGUIComponent.render(this, mouseX, mouseY, ignoreLightState, false, blendingEnabled, partialTicks);
            }
            if (this.getGUILightMode().equals((Object)GUILightingMode.LIT)) {
                for (AGUIComponent aGUIComponent : this.components) {
                    if (!aGUIComponent.visible || aGUIComponent instanceof GUIComponentInstrument || aGUIComponent instanceof GUIComponentItem) continue;
                    aGUIComponent.render(this, mouseX, mouseY, true, true, true, partialTicks);
                }
            }
            boolean isTextLit = !this.getGUILightMode().equals((Object)GUILightingMode.DARK);
            for (AGUIComponent component : this.components) {
                if (!component.visible || component.text == null || component.text.isEmpty()) continue;
                component.renderText(isTextLit);
            }
        }
        for (AGUIComponent aGUIComponent : this.components) {
            if (!(aGUIComponent instanceof GUIComponentInstrument)) continue;
            aGUIComponent.render(this, mouseX, mouseY, false, false, blendingEnabled, partialTicks);
        }
        if (!blendingEnabled) {
            for (AGUIComponent aGUIComponent : this.components) {
                if (!aGUIComponent.visible || !aGUIComponent.isMouseInBounds(mouseX, mouseY)) continue;
                aGUIComponent.renderTooltip(this, mouseX, mouseY);
            }
        }
    }

    public void close() {
        if (activeGUIs.contains(this)) {
            activeGUIs.remove(this);
            if (this.capturesPlayer()) {
                activeInputGUI = null;
                InterfaceClient.closeGUI();
                InterfaceInput.setKeyboardRepeat(false);
            }
            GUIComponent3DModel.clearModelCaches();
        }
    }

    public static void closeIfOpen(Class<? extends AGUIBase> guiClass) {
        AGUIBase guiToClose = null;
        for (AGUIBase gui : activeGUIs) {
            if (!gui.getClass().equals(guiClass)) continue;
            guiToClose = gui;
            break;
        }
        if (guiToClose != null) {
            guiToClose.close();
        }
    }

    protected boolean renderBackground() {
        return true;
    }

    protected boolean renderBackgroundFullTexture() {
        return false;
    }

    protected GUILightingMode getGUILightMode() {
        return GUILightingMode.NONE;
    }

    protected AEntityB_Existing getGUILightSource() {
        return null;
    }

    public boolean pauseOnOpen() {
        return false;
    }

    public boolean capturesPlayer() {
        return true;
    }

    public int getWidth() {
        return 256;
    }

    public int getHeight() {
        return 192;
    }

    public boolean renderFlushBottom() {
        return false;
    }

    public boolean renderTranslucent() {
        return false;
    }

    protected final int getTextureWidth() {
        return this.getWidth() <= 256 ? 256 : (this.getWidth() <= 512 ? 512 : (this.getWidth() <= 1024 ? 1024 : 2048));
    }

    protected final int getTextureHeight() {
        return this.getHeight() <= 256 ? 256 : (this.getHeight() <= 512 ? 512 : (this.getHeight() <= 1024 ? 1024 : 2048));
    }

    protected String getTexture() {
        return STANDARD_TEXTURE_NAME;
    }

    protected void addComponent(AGUIComponent component) {
        this.components.add(component);
    }

    protected static boolean inClockPeriod(int totalPeriod, int onPeriod) {
        return (double)System.currentTimeMillis() * 0.02 % (double)totalPeriod <= (double)onPeriod;
    }

    static {
        new GUIOverlay();
    }

    protected static enum GUILightingMode {
        NONE,
        DARK,
        LIT;

    }
}

