/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.components;

import java.nio.FloatBuffer;
import java.util.List;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.rendering.components.RenderableObject;
import minecrafttransportsimulator.rendering.instances.RenderText;
import org.lwjgl.opengl.GL11;

public abstract class AGUIComponent {
    public final int constructedX;
    public final int constructedY;
    public final Point3d position;
    public final Point3d textPosition;
    public int width;
    public int height;
    public boolean visible = true;
    public boolean ignoreGUILightingState;
    public String text;
    protected RenderableObject renderable;
    private static final RenderableObject mutableTooltipRenderable = new RenderableObject("gui_tooltip", "mts:textures/guis/standard.png", ColorRGB.WHITE, FloatBuffer.allocate(432), false);
    private static final Point3d mutableTooltipPosition = new Point3d();
    protected static final int TEXT_DEFAULT_ZOFFSET = 200;
    protected static final int MODEL_DEFAULT_ZOFFSET = 100;
    private static final int TOOLTIP_BORDER_PADDING = 4;
    private static final int TOOLTIP_SECTION_WIDTH = 100;
    private static final int TOOLTIP_SECTION_HEIGHT = 60;
    private static final int TOOLTIP_SECTION_BORDER = 3;
    private static final int TOOLTIP_SECTION_WIDTH_OFFSET = 100;
    private static final int TOOLTIP_SECTION_HEIGHT_OFFSET = 196;
    private static final int TOOLTIP_TEXTURE_WIDTH = 256;
    private static final int TOOLTIP_TEXTURE_HEIGHT = 256;

    public AGUIComponent(int x, int y, int width, int height) {
        this.constructedX = x;
        this.constructedY = y;
        this.position = new Point3d(x, -y, this.getZOffset());
        this.textPosition = new Point3d(this.position.x, this.position.y, this.position.z + 200.0);
        this.width = width;
        this.height = height;
    }

    public int getZOffset() {
        return 0;
    }

    public boolean isMouseInBounds(int mouseX, int mouseY) {
        return (double)mouseX >= this.position.x && (double)mouseY >= -this.position.y && (double)mouseX < this.position.x + (double)this.width && (double)mouseY < -this.position.y + (double)this.height;
    }

    public abstract void render(AGUIBase var1, int var2, int var3, boolean var4, boolean var5, boolean var6, float var7);

    public void renderText(boolean renderTextLit) {
    }

    public void renderTooltip(AGUIBase gui, int mouseX, int mouseY) {
        List<String> tooltipTextLines = this.getTooltipText();
        if (tooltipTextLines != null && !tooltipTextLines.isEmpty()) {
            int wrapWidth = gui.screenWidth - mouseX > mouseX ? gui.screenWidth - mouseX - 8 : mouseX - 8;
            float longestLineWidth = 0.0f;
            int linesOfText = 0;
            String tooltipCombinedText = "";
            for (String tooltipText : tooltipTextLines) {
                float lineWidth = RenderText.getStringWidth(tooltipText, null);
                linesOfText = (int)((double)linesOfText + Math.ceil(lineWidth / (float)wrapWidth));
                tooltipCombinedText = tooltipCombinedText + tooltipText + "\n";
                if (!(lineWidth > longestLineWidth)) continue;
                longestLineWidth = lineWidth;
            }
            int actualStringWidth = (int)(longestLineWidth > (float)wrapWidth ? (float)wrapWidth : longestLineWidth);
            int actualStringHeight = (int)Math.ceil(RenderText.getHeight(linesOfText, null));
            int xOffset = gui.screenWidth - mouseX > mouseX ? mouseX + 4 : mouseX - actualStringWidth - 8;
            int yOffset = gui.screenHeight - mouseY > mouseY ? mouseY + 4 : mouseY - actualStringHeight - 8;
            AGUIComponent.mutableTooltipRenderable.vertices.clear();
            int horizontalSegmentSize = actualStringWidth + 8;
            int verticalSegmentSize = actualStringHeight + 8;
            gui.addRenderToBuffer(AGUIComponent.mutableTooltipRenderable.vertices, xOffset, -yOffset, 3, 3, 100.0f, 196.0f, 103.0f, 199.0f, 256, 256);
            gui.addRenderToBuffer(AGUIComponent.mutableTooltipRenderable.vertices, xOffset + horizontalSegmentSize - 3, -yOffset, 3, 3, 197.0f, 196.0f, 200.0f, 199.0f, 256, 256);
            gui.addRenderToBuffer(AGUIComponent.mutableTooltipRenderable.vertices, xOffset, -(yOffset + verticalSegmentSize - 3), 3, 3, 100.0f, 253.0f, 103.0f, 256.0f, 256, 256);
            gui.addRenderToBuffer(AGUIComponent.mutableTooltipRenderable.vertices, xOffset + horizontalSegmentSize - 3, -(yOffset + verticalSegmentSize - 3), 3, 3, 197.0f, 253.0f, 200.0f, 256.0f, 256, 256);
            gui.addRenderToBuffer(AGUIComponent.mutableTooltipRenderable.vertices, xOffset + 3, -yOffset, horizontalSegmentSize - 6, 3, 103.0f, 196.0f, 197.0f, 199.0f, 256, 256);
            gui.addRenderToBuffer(AGUIComponent.mutableTooltipRenderable.vertices, xOffset + 3, -(yOffset + verticalSegmentSize - 3), horizontalSegmentSize - 6, 3, 103.0f, 253.0f, 197.0f, 256.0f, 256, 256);
            gui.addRenderToBuffer(AGUIComponent.mutableTooltipRenderable.vertices, xOffset, -(yOffset + 3), 3, verticalSegmentSize - 6, 100.0f, 199.0f, 103.0f, 253.0f, 256, 256);
            gui.addRenderToBuffer(AGUIComponent.mutableTooltipRenderable.vertices, xOffset + horizontalSegmentSize - 3, -(yOffset + 3), 3, verticalSegmentSize - 6, 197.0f, 199.0f, 200.0f, 253.0f, 256, 256);
            gui.addRenderToBuffer(AGUIComponent.mutableTooltipRenderable.vertices, xOffset + 3, -(yOffset + 3), horizontalSegmentSize - 6, verticalSegmentSize - 6, 103.0f, 199.0f, 197.0f, 253.0f, 256, 256);
            AGUIComponent.mutableTooltipRenderable.vertices.flip();
            AGUIComponent.mutableTooltipRenderable.disableLighting = true;
            GL11.glTranslated((double)0.0, (double)0.0, (double)(this.textPosition.z + 25.0));
            mutableTooltipRenderable.render();
            GL11.glTranslated((double)0.0, (double)0.0, (double)(-this.textPosition.z - 25.0));
            mutableTooltipPosition.set(xOffset + 4, -(yOffset + 4), this.textPosition.z + 50.0);
            RenderText.drawText(tooltipCombinedText, null, mutableTooltipPosition, null, ColorRGB.WHITE, RenderText.TextAlignment.LEFT_ALIGNED, 1.0f, false, wrapWidth, 1.0f, true);
        }
    }

    public List<String> getTooltipText() {
        return null;
    }
}

