/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.components;

import java.nio.FloatBuffer;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.AGUIComponent;
import minecrafttransportsimulator.rendering.components.RenderableObject;
import org.lwjgl.opengl.GL11;

public class GUIComponentCutout
extends AGUIComponent {
    private boolean renderFullScreen;
    public int textureXOffset;
    public int textureYOffset;
    public int textureSectionWidth;
    public int textureSectionHeight;

    public GUIComponentCutout(int x, int y, int width, int height) {
        this(x, y, width, height, 0, 0, width, height);
        this.renderFullScreen = true;
    }

    public GUIComponentCutout(int x, int y, int width, int height, int textureXOffset, int textureYOffset) {
        this(x, y, width, height, textureXOffset, textureYOffset, width, height);
    }

    public GUIComponentCutout(int x, int y, int width, int height, int textureXOffset, int textureYOffset, int textureSectionWidth, int textureSectionHeight) {
        super(x, y, width, height);
        this.textureXOffset = textureXOffset;
        this.textureYOffset = textureYOffset;
        this.textureSectionWidth = textureSectionWidth;
        this.textureSectionHeight = textureSectionHeight;
    }

    @Override
    public void render(AGUIBase gui, int mouseX, int mouseY, boolean renderBright, boolean renderLitTexture, boolean blendingEnabled, float partialTicks) {
        if (this.renderable == null || !this.renderable.texture.equals(gui.getTexture())) {
            this.renderable = new RenderableObject("gui_cutout", gui.getTexture(), ColorRGB.WHITE, FloatBuffer.allocate(48), false);
        }
        if (this.renderable.vertices.position() == 0) {
            if (this.renderFullScreen) {
                gui.addRenderToBuffer(this.renderable.vertices, 0, 0, this.width, this.height, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            } else {
                gui.addRenderToBuffer(this.renderable.vertices, 0, 0, this.width, this.height, this.textureXOffset, this.textureYOffset, this.textureXOffset + this.textureSectionWidth, this.textureYOffset + this.textureSectionHeight, gui.getTextureWidth(), gui.getTextureHeight());
            }
            this.renderable.vertices.flip();
        }
        GL11.glTranslated((double)this.position.x, (double)this.position.y, (double)this.position.z);
        this.renderable.disableLighting = renderBright || this.ignoreGUILightingState;
        this.renderable.texture = renderLitTexture ? gui.getTexture().replace(".png", "_lit.png") : gui.getTexture();
        this.renderable.render();
        GL11.glTranslated((double)(-this.position.x), (double)(-this.position.y), (double)(-this.position.z));
    }
}

