/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.components;

import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.AGUIComponent;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentTextBox;
import minecrafttransportsimulator.rendering.instances.RenderText;

public class GUIComponentLabel
extends AGUIComponent {
    public final ColorRGB color;
    public final String fontName;
    public final RenderText.TextAlignment alignment;
    public final int wrapWidth;
    public final float scale;
    public final boolean autoScale;
    private GUIComponentButton button;
    private GUIComponentTextBox box;

    public GUIComponentLabel(int x, int y, ColorRGB color, String text) {
        this(x, y, color, text, RenderText.TextAlignment.LEFT_ALIGNED, 1.0f, 0, null, false);
    }

    public GUIComponentLabel(int x, int y, ColorRGB color, String text, RenderText.TextAlignment alignment, float scale) {
        this(x, y, color, text, alignment, scale, 0, null, false);
    }

    public GUIComponentLabel(int x, int y, ColorRGB color, String text, RenderText.TextAlignment alignment, float scale, int wrapWidth) {
        this(x, y, color, text, alignment, scale, wrapWidth, null, false);
    }

    public GUIComponentLabel(int x, int y, ColorRGB color, String text, RenderText.TextAlignment alignment, float scale, int wrapWidth, String fontName, boolean autoScale) {
        super(x, y, 0, 0);
        this.color = color;
        this.text = text;
        this.fontName = fontName;
        this.alignment = alignment;
        this.scale = scale;
        this.wrapWidth = wrapWidth;
        this.autoScale = autoScale;
    }

    public GUIComponentLabel setButton(GUIComponentButton button) {
        this.button = button;
        return this;
    }

    public GUIComponentLabel setBox(GUIComponentTextBox box) {
        this.box = box;
        return this;
    }

    @Override
    public void render(AGUIBase gui, int mouseX, int mouseY, boolean renderBright, boolean renderLitTexture, boolean blendingEnabled, float partialTicks) {
    }

    @Override
    public void renderText(boolean renderTextLit) {
        if (this.button == null ? this.box == null || this.box.visible : this.button.visible) {
            RenderText.drawText(this.text, this.fontName, this.textPosition, null, this.color, this.alignment, this.scale, this.autoScale, this.wrapWidth, 1.0f, renderTextLit || this.ignoreGUILightingState);
        }
    }
}

