/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.components;

import java.nio.FloatBuffer;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.rendering.components.RenderableObject;
import minecrafttransportsimulator.rendering.instances.RenderText;
import org.lwjgl.opengl.GL11;

public abstract class GUIComponentSelector
extends GUIComponentButton {
    public final ColorRGB regularColor;
    public final ColorRGB litColor;
    private RenderableObject renderable4;
    public int selectorState = 0;

    public GUIComponentSelector(int x, int y, int width, int height, String text, ColorRGB regularColor, ColorRGB litColor, int textureXOffset, int textureYOffset, int textureSectionWidth, int textureSectionHeight) {
        super(x, y, width, height, textureXOffset, textureYOffset, textureSectionWidth, textureSectionHeight);
        this.text = text;
        this.textPosition.set(this.position.x + (double)(width / 2), this.position.y - (double)height - 1.0, this.textPosition.z);
        this.regularColor = regularColor != null ? regularColor : ColorRGB.WHITE;
        this.litColor = regularColor != null ? litColor : ColorRGB.WHITE;
    }

    @Override
    public void render(AGUIBase gui, int mouseX, int mouseY, boolean renderBright, boolean renderLitTexture, boolean blendingEnabled, float partialTicks) {
        if (this.renderable == null) {
            for (int i = 0; i < 4; ++i) {
                int textureUStart = this.textureYOffset + i * this.textureSectionHeight;
                FloatBuffer buffer = FloatBuffer.allocate(48);
                gui.addRenderToBuffer(buffer, 0, 0, this.width, this.height, this.textureXOffset, textureUStart, this.textureXOffset + this.textureSectionWidth, textureUStart + this.textureSectionHeight, gui.getTextureWidth(), gui.getTextureHeight());
                buffer.flip();
                if (i == 0) {
                    this.renderable = new RenderableObject("gui_selector_0", gui.getTexture(), ColorRGB.WHITE, buffer, false);
                    continue;
                }
                if (i == 1) {
                    this.renderable2 = new RenderableObject("gui_selector_1", gui.getTexture(), ColorRGB.WHITE, buffer, false);
                    continue;
                }
                if (i == 2) {
                    this.renderable3 = new RenderableObject("gui_selector_2", gui.getTexture(), ColorRGB.WHITE, buffer, false);
                    continue;
                }
                this.renderable4 = new RenderableObject("gui_selector_3", gui.getTexture(), ColorRGB.WHITE, buffer, false);
            }
        }
        GL11.glTranslated((double)this.position.x, (double)this.position.y, (double)this.position.z);
        if (this.selectorState == 0) {
            this.renderable.disableLighting = renderBright || this.ignoreGUILightingState;
            this.renderable.texture = renderLitTexture ? gui.getTexture().replace(".png", "_lit.png") : gui.getTexture();
            this.renderable.render();
        } else if (this.selectorState == 1) {
            this.renderable2.disableLighting = renderBright || this.ignoreGUILightingState;
            this.renderable2.texture = renderLitTexture ? gui.getTexture().replace(".png", "_lit.png") : gui.getTexture();
            this.renderable2.render();
        } else if (this.selectorState == 2) {
            this.renderable3.disableLighting = renderBright || this.ignoreGUILightingState;
            this.renderable3.texture = renderLitTexture ? gui.getTexture().replace(".png", "_lit.png") : gui.getTexture();
            this.renderable3.render();
        } else {
            this.renderable4.disableLighting = renderBright || this.ignoreGUILightingState;
            this.renderable4.texture = renderLitTexture ? gui.getTexture().replace(".png", "_lit.png") : gui.getTexture();
            this.renderable4.render();
        }
        GL11.glTranslated((double)(-this.position.x), (double)(-this.position.y), (double)(-this.position.z));
    }

    @Override
    public void renderText(boolean renderTextLit) {
        RenderText.drawText(this.text, null, this.textPosition, null, renderTextLit || this.ignoreGUILightingState ? this.litColor : this.regularColor, RenderText.TextAlignment.CENTERED, 0.75f, false, 0, 1.0f, renderTextLit || this.ignoreGUILightingState);
    }
}

