/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.components;

import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentCutout;
import minecrafttransportsimulator.rendering.instances.RenderText;

public class GUIComponentTextBox
extends GUIComponentCutout {
    private static final String VALID_SPECIAL_CHARS = "/*!@#$%^&*()\"{}_[]|\\?/<>,.- ";
    public ColorRGB fontColor;
    public boolean enabled = true;
    public boolean focused = false;
    private int textIndex;
    private int maxTextLength;
    private String flashText;

    public GUIComponentTextBox(int x, int y, int width, String text) {
        this(x, y, width, 20, text, ColorRGB.WHITE, 32);
    }

    public GUIComponentTextBox(int x, int y, int width, int height, String text, ColorRGB fontColor, int maxTextLength) {
        this(x, y, width, height, text, fontColor, maxTextLength, 236, 236, 20, 20);
    }

    public GUIComponentTextBox(int x, int y, int width, int height, String text, ColorRGB fontColor, int maxTextLength, int textureXOffset, int textureYOffset, int textureSectionWidth, int textureSectionHeight) {
        super(x, y, width, height, textureXOffset, textureYOffset, textureSectionWidth, textureSectionHeight);
        this.textPosition.set(this.position.x + 4.0, this.position.y - (double)(height >= 20 ? 5 : 1 + height / 10), this.textPosition.z);
        this.fontColor = fontColor;
        this.maxTextLength = maxTextLength;
        this.setText(text);
    }

    public void updateFocus(int mouseX, int mouseY) {
        this.focused = this.visible && this.enabled && this.isMouseInBounds(mouseX, mouseY);
    }

    public void handleKeyTyped(char typedChar, int typedCode, TextBoxControlKey control) {
        if (control != null) {
            if (control.equals((Object)TextBoxControlKey.BACKSPACE)) {
                if (this.textIndex != 0) {
                    this.text = this.text.substring(0, this.textIndex - 1) + this.text.substring(this.textIndex, this.text.length());
                    --this.textIndex;
                    if (this.isTextValid(this.text)) {
                        this.handleTextChange();
                    }
                }
            } else if (control.equals((Object)TextBoxControlKey.DELETE)) {
                if (this.textIndex != this.text.length()) {
                    this.text = this.text.substring(0, this.textIndex) + this.text.substring(this.textIndex + 1, this.text.length());
                    if (this.isTextValid(this.text)) {
                        this.handleTextChange();
                    }
                }
            } else if (control.equals((Object)TextBoxControlKey.LEFT)) {
                if (this.textIndex > 0) {
                    --this.textIndex;
                }
            } else if (control.equals((Object)TextBoxControlKey.RIGHT) && this.textIndex < this.text.length()) {
                ++this.textIndex;
            }
        } else if ((Character.isLetterOrDigit(typedChar) || VALID_SPECIAL_CHARS.contains(Character.toString(typedChar))) && this.text.length() < this.maxTextLength) {
            this.text = this.text.substring(0, this.textIndex) + typedChar + this.text.substring(this.textIndex, this.text.length());
            ++this.textIndex;
            if (this.isTextValid(this.text)) {
                this.handleTextChange();
            }
        }
        this.flashText = this.text.isEmpty() ? "_" : (this.textIndex == this.text.length() ? this.text + "_" : this.text.substring(0, this.textIndex) + "_" + this.text.substring(this.textIndex + 1, this.text.length()));
    }

    public boolean isTextValid(String newText) {
        return true;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String newText) {
        this.text = newText.length() > this.maxTextLength ? newText.substring(0, this.maxTextLength) : newText;
        this.textIndex = this.text.length();
        this.flashText = this.text.isEmpty() ? "_" : (this.textIndex == 0 ? "_" + this.text.substring(1) : (this.textIndex == this.text.length() ? this.text + "_" : this.text.substring(0, this.textIndex) + this.text.substring(this.textIndex + 1)));
    }

    public void handleTextChange() {
    }

    @Override
    public void renderText(boolean renderTextLit) {
        if (this.enabled) {
            if (this.focused && AGUIBase.inClockPeriod(20, 10)) {
                RenderText.drawText(this.flashText, null, this.textPosition, null, this.fontColor, RenderText.TextAlignment.LEFT_ALIGNED, 1.0f, false, this.width, 1.0f, renderTextLit || this.ignoreGUILightingState);
            } else {
                RenderText.drawText(this.text, null, this.textPosition, null, this.fontColor, RenderText.TextAlignment.LEFT_ALIGNED, 1.0f, false, this.width, 1.0f, renderTextLit || this.ignoreGUILightingState);
            }
        } else {
            RenderText.drawText(this.text, null, this.textPosition, null, ColorRGB.GRAY, RenderText.TextAlignment.LEFT_ALIGNED, 1.0f, false, this.width, 1.0f, renderTextLit || this.ignoreGUILightingState);
        }
    }

    public static enum TextBoxControlKey {
        BACKSPACE,
        DELETE,
        LEFT,
        RIGHT;

    }
}

