/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.TrailerConnection;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.entities.instances.PartPropeller;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentInstrument;
import minecrafttransportsimulator.jsondefs.AJSONInteractableEntity;
import minecrafttransportsimulator.jsondefs.JSONConnectionGroup;
import minecrafttransportsimulator.jsondefs.JSONInstrumentDefinition;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableToggle;

public abstract class AGUIPanel
extends AGUIBase {
    protected static final int PANEL_WIDTH = 400;
    protected static final int PANEL_HEIGHT = 140;
    protected static final int GAP_BETWEEN_SELECTORS = 12;
    protected static final int SELECTOR_SIZE = 20;
    protected static final int SELECTOR_TEXTURE_SIZE = 20;
    protected static final byte ENGINE_SINGLE_SELECTOR_INDEX = -1;
    protected static final int BEACON_TEXTURE_WIDTH_OFFSET = 340;
    protected static final int BEACON_TEXTURE_HEIGHT_OFFSET = 196;
    protected final EntityVehicleF_Physics vehicle;
    protected final boolean haveReverseThrustOption;
    protected final List<SwitchEntry> trailerSwitchDefs = new ArrayList<SwitchEntry>();
    protected int xOffset;

    public AGUIPanel(EntityVehicleF_Physics vehicle) {
        this.vehicle = vehicle;
        if (((JSONVehicle)vehicle.definition).motorized.isBlimp) {
            this.haveReverseThrustOption = true;
        } else {
            boolean foundReversingPart = false;
            for (APart part : vehicle.parts) {
                if (part instanceof PartPropeller) {
                    if (!((JSONPart)part.definition).propeller.isDynamicPitch) continue;
                    foundReversingPart = true;
                    break;
                }
                if (!(part instanceof PartEngine) || !(((JSONPart)part.definition).engine.jetPowerFactor > 0.0f)) continue;
                foundReversingPart = true;
                break;
            }
            this.haveReverseThrustOption = foundReversingPart;
        }
        this.setupTowingButtons(vehicle);
    }

    private void setupTowingButtons(AEntityE_Interactable<?> entity) {
        if (((AJSONInteractableEntity)entity.definition).connectionGroups != null) {
            for (JSONConnectionGroup connectionGroup : ((AJSONInteractableEntity)entity.definition).connectionGroups) {
                if (!connectionGroup.canIntiateConnections) continue;
                this.trailerSwitchDefs.add(new SwitchEntry(entity, connectionGroup));
            }
            if (!(entity instanceof APart)) {
                for (TrailerConnection connection : entity.getTowingConnections()) {
                    if (!connection.hookupConnectionGroup.canIntiateSubConnections) continue;
                    this.setupTowingButtons(connection.hookupVehicle);
                }
            }
        }
        if (entity instanceof AEntityF_Multipart) {
            for (APart part : ((AEntityF_Multipart)entity).parts) {
                if (((JSONPart)part.definition).connectionGroups == null) continue;
                for (JSONConnectionGroup connectionGroup : ((JSONPart)part.definition).connectionGroups) {
                    if (!connectionGroup.canIntiateConnections) continue;
                    this.trailerSwitchDefs.add(new SwitchEntry(part, connectionGroup));
                }
            }
        }
    }

    public void handleConnectionChange(AEntityE_Interactable<?> hitchEntity, AEntityE_Interactable<?> hookupEntity) {
        boolean recreatePanel = false;
        for (SwitchEntry entry : this.trailerSwitchDefs) {
            if (!entry.entityOn.equals(hitchEntity) && !entry.entityOn.equals(hookupEntity)) continue;
            recreatePanel = true;
            break;
        }
        if (recreatePanel) {
            this.setupComponents();
        }
    }

    @Override
    public final void setupComponents() {
        super.setupComponents();
        this.xOffset = 12;
        this.setupLightComponents(this.guiLeft, this.guiTop);
        this.xOffset += 32;
        this.setupEngineComponents(this.guiLeft, this.guiTop);
        this.xOffset += 32;
        this.setupGeneralComponents(this.guiLeft, this.guiTop);
        this.xOffset += 32;
        this.setupCustomComponents(this.guiLeft, this.guiTop);
        for (Integer instrumentNumber : this.vehicle.instruments.keySet()) {
            if (!((JSONInstrumentDefinition)((JSONVehicle)this.vehicle.definition).instruments.get((int)instrumentNumber.intValue())).placeOnPanel) continue;
            this.addComponent(new GUIComponentInstrument(this.guiLeft, this.guiTop, (int)instrumentNumber, this.vehicle));
        }
        for (APart part : this.vehicle.parts) {
            for (Integer instrumentNumber : part.instruments.keySet()) {
                if (!((JSONInstrumentDefinition)((JSONPart)part.definition).instruments.get((int)instrumentNumber.intValue())).placeOnPanel) continue;
                this.addComponent(new GUIComponentInstrument(this.guiLeft, this.guiTop, (int)instrumentNumber, part));
            }
        }
    }

    protected abstract void setupLightComponents(int var1, int var2);

    protected abstract void setupEngineComponents(int var1, int var2);

    protected abstract void setupGeneralComponents(int var1, int var2);

    protected abstract void setupCustomComponents(int var1, int var2);

    @Override
    protected AGUIBase.GUILightingMode getGUILightMode() {
        return this.vehicle.renderTextLit() ? AGUIBase.GUILightingMode.LIT : AGUIBase.GUILightingMode.DARK;
    }

    @Override
    protected EntityVehicleF_Physics getGUILightSource() {
        return this.vehicle;
    }

    @Override
    public int getWidth() {
        return 400;
    }

    @Override
    public int getHeight() {
        return 140;
    }

    @Override
    public boolean renderFlushBottom() {
        return true;
    }

    @Override
    public boolean renderTranslucent() {
        return true;
    }

    @Override
    protected String getTexture() {
        return ((JSONVehicle)this.vehicle.definition).motorized.panelTexture != null ? ((JSONVehicle)this.vehicle.definition).motorized.panelTexture : "mts:textures/guis/panel.png";
    }

    @Override
    public void close() {
        super.close();
        for (PartEngine engine : this.vehicle.engines.values()) {
            if (!engine.electricStarterEngaged) continue;
            InterfacePacket.sendToServer(new PacketEntityVariableToggle(engine, "engine_starter"));
        }
    }

    protected static class SwitchEntry {
        protected final AEntityE_Interactable<?> entityOn;
        protected final JSONConnectionGroup connectionGroup;
        protected final int connectionGroupIndex;

        private SwitchEntry(AEntityE_Interactable<?> entityOn, JSONConnectionGroup connectionGroup) {
            this.entityOn = entityOn;
            this.connectionGroup = connectionGroup;
            this.connectionGroupIndex = ((AJSONInteractableEntity)entityOn.definition).connectionGroups.indexOf(connectionGroup);
        }
    }
}

