/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.items.instances.ItemItem;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.InterfaceInput;
import minecrafttransportsimulator.rendering.instances.RenderText;

public class GUIBooklet
extends AGUIBase {
    private GUIComponentButton leftButton;
    private GUIComponentButton rightButton;
    private GUIComponentButton contentsButton;
    private List<List<GUIComponentLabel>> pageTextLabels = new ArrayList<List<GUIComponentLabel>>();
    private List<GUIComponentButton> contentsButtons = new ArrayList<GUIComponentButton>();
    private final ItemItem booklet;
    private final int totalPages;

    public GUIBooklet(ItemItem booklet) {
        this.booklet = booklet;
        this.totalPages = ((JSONItem)booklet.definition).booklet.disableTOC ? 1 + ((JSONItem)booklet.definition).booklet.pages.size() : 2 + ((JSONItem)booklet.definition).booklet.pages.size();
    }

    @Override
    public void setupComponents() {
        super.setupComponents();
        this.pageTextLabels.clear();
        this.leftButton = new GUIComponentButton(this.guiLeft + 20, this.guiTop + 150, 20, 20, 0, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                --((GUIBooklet)GUIBooklet.this).booklet.pageNumber;
            }
        };
        this.addComponent(this.leftButton);
        this.rightButton = new GUIComponentButton(this.guiLeft + ((JSONItem)this.booklet.definition).booklet.textureWidth - 40, this.guiTop + 150, 20, 20, 20, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                ++((GUIBooklet)GUIBooklet.this).booklet.pageNumber;
            }
        };
        this.addComponent(this.rightButton);
        ArrayList<GUIComponentLabel> titleLabels = new ArrayList<GUIComponentLabel>();
        for (JSONText text : ((JSONItem)this.booklet.definition).booklet.titleText) {
            GUIComponentLabel titleLabel = new GUIComponentLabel(this.guiLeft + (int)text.pos.x, this.guiTop + (int)text.pos.y, text.color, text.defaultText, RenderText.TextAlignment.values()[text.renderPosition], text.scale, text.wrapWidth, text.fontName, text.autoScale);
            titleLabels.add(titleLabel);
            this.addComponent(titleLabel);
        }
        this.pageTextLabels.add(titleLabels);
        if (!((JSONItem)this.booklet.definition).booklet.disableTOC) {
            GUIComponentLabel contentsLabel = new GUIComponentLabel(this.guiLeft + ((JSONItem)this.booklet.definition).booklet.textureWidth / 4 - 20, this.guiTop + 25, ColorRGB.BLACK, "CONTENTS");
            this.addComponent(contentsLabel);
            ArrayList<GUIComponentLabel> contentsLabels = new ArrayList<GUIComponentLabel>();
            contentsLabels.add(contentsLabel);
            this.pageTextLabels.add(contentsLabels);
            this.contentsButtons.clear();
            int leftSideOffset = this.guiLeft + 20;
            int rightSideOffset = this.guiLeft + ((JSONItem)this.booklet.definition).booklet.textureWidth / 2 + 20;
            for (int i = 0; i < ((JSONItem)this.booklet.definition).booklet.pages.size(); ++i) {
                GUIComponentButton contentsHyperlink = new GUIComponentButton(i < 10 ? leftSideOffset : rightSideOffset, this.guiTop + 45 + 10 * (i % 10), 110, 10, i + 1 + ": " + ((JSONItem)this.booklet.definition).booklet.pages.get((int)i).title, false, ((JSONItem)this.booklet.definition).booklet.pages.get((int)i).pageText.get((int)0).color, false){

                    @Override
                    public void onClicked(boolean leftSide) {
                        ((GUIBooklet)GUIBooklet.this).booklet.pageNumber = GUIBooklet.this.contentsButtons.indexOf(this) + 2;
                    }
                };
                this.contentsButtons.add(contentsHyperlink);
                this.addComponent(contentsHyperlink);
            }
            this.contentsButton = new GUIComponentButton(this.leftButton.constructedX + this.leftButton.width, this.guiTop + 150, 20, 20, 40, 196, 20, 20){

                @Override
                public void onClicked(boolean leftSide) {
                    ((GUIBooklet)GUIBooklet.this).booklet.pageNumber = 1;
                }
            };
            this.addComponent(this.contentsButton);
        }
        for (JSONItem.JSONBooklet.BookletPage page : ((JSONItem)this.booklet.definition).booklet.pages) {
            ArrayList<GUIComponentLabel> pageLabels = new ArrayList<GUIComponentLabel>();
            for (JSONText text : page.pageText) {
                try {
                    GUIComponentLabel pageLabel = new GUIComponentLabel(this.guiLeft + (int)text.pos.x, this.guiTop + (int)text.pos.y, text.color, text.defaultText, RenderText.TextAlignment.values()[text.renderPosition], text.scale, text.wrapWidth, text.fontName, text.autoScale);
                    pageLabels.add(pageLabel);
                    this.addComponent(pageLabel);
                }
                catch (Exception e) {
                    int pageNumber = -1;
                    for (int i = 0; i < ((JSONItem)this.booklet.definition).booklet.pages.size(); i = (int)((byte)(i + 1))) {
                        if (!((JSONItem)this.booklet.definition).booklet.pages.get(i).equals(page)) continue;
                        pageNumber = i + 1;
                    }
                    InterfaceCore.logError("An error was encountered when creating booklet page #" + pageNumber);
                    InterfaceCore.logError(e.getMessage());
                }
            }
            this.pageTextLabels.add(pageLabels);
        }
    }

    @Override
    public void setStates() {
        super.setStates();
        this.leftButton.visible = this.booklet.pageNumber > 0;
        this.rightButton.visible = this.booklet.pageNumber + 1 < this.totalPages;
        int wheelMovement = InterfaceInput.getTrackedMouseWheel();
        if (wheelMovement < 0 && this.rightButton.visible) {
            ++this.booklet.pageNumber;
        } else if (wheelMovement > 0 && this.leftButton.visible) {
            --this.booklet.pageNumber;
        }
        for (int i = 0; i < this.pageTextLabels.size(); ++i) {
            for (GUIComponentLabel label : this.pageTextLabels.get(i)) {
                label.visible = this.booklet.pageNumber == i;
            }
        }
        for (GUIComponentButton button : this.contentsButtons) {
            button.visible = this.booklet.pageNumber == 1 && !((JSONItem)this.booklet.definition).booklet.disableTOC;
        }
        if (this.contentsButton != null) {
            this.contentsButton.visible = this.booklet.pageNumber > 1;
        }
    }

    @Override
    public int getWidth() {
        return ((JSONItem)this.booklet.definition).booklet.textureWidth;
    }

    @Override
    public int getHeight() {
        return ((JSONItem)this.booklet.definition).booklet.textureHeight;
    }

    @Override
    protected String getTexture() {
        if (this.booklet.pageNumber == 0) {
            return ((JSONItem)this.booklet.definition).booklet.coverTexture;
        }
        if (!((JSONItem)this.booklet.definition).booklet.disableTOC) {
            if (this.booklet.pageNumber == 1) {
                return ((JSONItem)this.booklet.definition).booklet.pages.get((int)0).pageTexture;
            }
            return ((JSONItem)this.booklet.definition).booklet.pages.get((int)(this.booklet.pageNumber - 2)).pageTexture;
        }
        return ((JSONItem)this.booklet.definition).booklet.pages.get((int)(this.booklet.pageNumber - 1)).pageTexture;
    }
}

