/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentCutout;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.guis.components.GUIComponentTextBox;
import minecrafttransportsimulator.jsondefs.JSONConfig;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.InterfaceInput;
import minecrafttransportsimulator.rendering.instances.RenderText;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.ControlSystem;

public class GUIConfig
extends AGUIBase {
    private GUIComponentButton renderConfigScreenButton;
    private GUIComponentButton controlConfigScreenButton;
    private GUIComponentButton controlScreenButton;
    private boolean configuringControls = true;
    private boolean configuringRendering = false;
    private Map<GUIComponentButton, JSONConfig.JSONConfigEntry<Boolean>> renderConfigButtons = new HashMap<GUIComponentButton, JSONConfig.JSONConfigEntry<Boolean>>();
    private Map<GUIComponentButton, JSONConfig.JSONConfigEntry<Boolean>> controlConfigButtons = new HashMap<GUIComponentButton, JSONConfig.JSONConfigEntry<Boolean>>();
    private String vehicleConfiguring = "";
    private String[] vehicleTypes = new String[]{"car", "aircraft"};
    private Map<GUIComponentButton, String> vehicleSelectionButtons = new HashMap<GUIComponentButton, String>();
    private GUIComponentLabel vehicleSelectionFaultLabel;
    private GUIComponentButton finishKeyboardBindingsButton;
    private boolean configuringKeyboard;
    private Map<String, Map<GUIComponentTextBox, ControlSystem.ControlsKeyboard>> keyboardBoxes = new HashMap<String, Map<GUIComponentTextBox, ControlSystem.ControlsKeyboard>>();
    private Map<String, Map<GUIComponentLabel, ControlSystem.ControlsKeyboardDynamic>> keyboardLabels = new HashMap<String, Map<GUIComponentLabel, ControlSystem.ControlsKeyboardDynamic>>();
    private List<GUIComponentButton> joystickSelectionButtons = new ArrayList<GUIComponentButton>();
    private int scrollSpot = 0;
    private int selectedJoystickComponentCount = 0;
    private String selectedJoystickName;
    private GUIComponentButton componentListUpButton;
    private GUIComponentButton componentListDownButton;
    private GUIComponentButton deadzone_moreButton;
    private GUIComponentButton deadzone_lessButton;
    private GUIComponentTextBox deadzone_text;
    private List<GUIComponentButton> joystickComponentSelectionButtons = new ArrayList<GUIComponentButton>();
    private List<GUIComponentCutout> joystickComponentStateBackgrounds = new ArrayList<GUIComponentCutout>();
    private List<GUIComponentCutout> joystickComponentStateForegrounds = new ArrayList<GUIComponentCutout>();
    private boolean assigningDigital;
    private int joystickComponentId = -1;
    private GUIComponentButton cancelAssignmentButton;
    private GUIComponentButton clearAssignmentButton;
    private Map<String, Map<GUIComponentButton, ControlSystem.ControlsJoystick>> digitalAssignButtons = new HashMap<String, Map<GUIComponentButton, ControlSystem.ControlsJoystick>>();
    private Map<String, Map<GUIComponentButton, ControlSystem.ControlsJoystick>> analogAssignButtons = new HashMap<String, Map<GUIComponentButton, ControlSystem.ControlsJoystick>>();
    private boolean calibrating = false;
    private ControlSystem.ControlsJoystick controlCalibrating;
    private GUIComponentButton confirmBoundsButton;
    private GUIComponentButton invertAxisButton;
    private GUIComponentTextBox axisMinBoundsTextBox;
    private GUIComponentTextBox axisMaxBoundsTextBox;

    public GUIConfig() {
        if (!InterfaceInput.isJoystickSupportEnabled()) {
            InterfaceInput.initJoysticks();
        }
    }

    @Override
    public void setupComponents() {
        int i;
        super.setupComponents();
        this.renderConfigScreenButton = new GUIComponentButton(this.guiLeft + 0, this.guiTop - 20, 85, 20, InterfaceCore.translate("gui.config.header.config.rendering")){

            @Override
            public void onClicked(boolean leftSide) {
                GUIConfig.this.configuringControls = false;
                GUIConfig.this.configuringRendering = true;
                GUIConfig.this.vehicleConfiguring = "";
                GUIConfig.this.selectedJoystickName = null;
                GUIConfig.this.scrollSpot = 0;
                GUIConfig.this.joystickComponentId = -1;
                GUIConfig.this.calibrating = false;
            }
        };
        this.addComponent(this.renderConfigScreenButton);
        this.controlConfigScreenButton = new GUIComponentButton(this.guiLeft + 85, this.guiTop - 20, 85, 20, InterfaceCore.translate("gui.config.header.config.controls")){

            @Override
            public void onClicked(boolean leftSide) {
                GUIConfig.this.configuringControls = false;
                GUIConfig.this.configuringRendering = false;
                GUIConfig.this.vehicleConfiguring = "";
                GUIConfig.this.selectedJoystickName = null;
                GUIConfig.this.scrollSpot = 0;
                GUIConfig.this.joystickComponentId = -1;
                GUIConfig.this.calibrating = false;
            }
        };
        this.addComponent(this.controlConfigScreenButton);
        this.controlScreenButton = new GUIComponentButton(this.guiLeft + 171, this.guiTop - 20, 85, 20, InterfaceCore.translate("gui.config.header.controls")){

            @Override
            public void onClicked(boolean leftSide) {
                GUIConfig.this.configuringControls = true;
            }
        };
        this.addComponent(this.controlScreenButton);
        this.populateConfigButtonList(this.renderConfigButtons, ConfigSystem.configObject.clientRendering);
        this.populateConfigButtonList(this.controlConfigButtons, ConfigSystem.configObject.clientControls);
        this.vehicleSelectionButtons.clear();
        this.vehicleSelectionFaultLabel = new GUIComponentLabel(this.guiLeft + 10, this.guiTop + 90, ColorRGB.BLACK, "", RenderText.TextAlignment.LEFT_ALIGNED, 0.8f, 240);
        this.addComponent(this.vehicleSelectionFaultLabel);
        for (String vehicleType : this.vehicleTypes) {
            GUIComponentButton buttonKeyboard = new GUIComponentButton(this.guiLeft + 68, this.guiTop + 30 + 20 * this.vehicleSelectionButtons.size(), 120, 20, InterfaceCore.translate("gui.config.controls." + vehicleType + ".keyboard")){

                @Override
                public void onClicked(boolean leftSide) {
                    String lookupString = (String)GUIConfig.this.vehicleSelectionButtons.get(this);
                    GUIConfig.this.vehicleConfiguring = lookupString.substring(0, lookupString.indexOf(46));
                    GUIConfig.this.configuringKeyboard = true;
                }
            };
            this.vehicleSelectionButtons.put(buttonKeyboard, vehicleType + ".keyboard");
            this.addComponent(buttonKeyboard);
            if (this.vehicleSelectionButtons.size() != 1) continue;
            this.addComponent(new GUIComponentLabel(this.guiLeft + 20, this.guiTop + 10, ColorRGB.BLACK, InterfaceCore.translate("gui.config.controls.title")).setButton(buttonKeyboard));
        }
        for (String vehicleType : this.vehicleTypes) {
            GUIComponentButton buttonJoystick = new GUIComponentButton(this.guiLeft + 68, this.guiTop + 70 + 20 * this.vehicleSelectionButtons.size(), 120, 20, InterfaceCore.translate("gui.config.controls." + vehicleType + ".joystick")){

                @Override
                public void onClicked(boolean leftSide) {
                    String lookupString = (String)GUIConfig.this.vehicleSelectionButtons.get(this);
                    GUIConfig.this.vehicleConfiguring = lookupString.substring(0, lookupString.indexOf(46));
                    GUIConfig.this.configuringKeyboard = false;
                }
            };
            this.vehicleSelectionButtons.put(buttonJoystick, vehicleType + ".joystick");
            this.addComponent(buttonJoystick);
        }
        this.keyboardBoxes.clear();
        this.keyboardLabels.clear();
        for (String vehicleType : this.vehicleTypes) {
            int verticalOffset = 20;
            int horizontalOffset = 80;
            HashMap<6, ControlSystem.ControlsKeyboard> boxesForVehicle = new HashMap<6, ControlSystem.ControlsKeyboard>();
            for (ControlSystem.ControlsKeyboard keyboardControl : ControlSystem.ControlsKeyboard.values()) {
                if (!keyboardControl.systemName.contains(vehicleType)) continue;
                GUIComponentTextBox box = new GUIComponentTextBox(this.guiLeft + horizontalOffset, this.guiTop + verticalOffset, 40, 10, "", ColorRGB.WHITE, 5){

                    @Override
                    public void handleKeyTyped(char typedChar, int typedCode, GUIComponentTextBox.TextBoxControlKey control) {
                        this.setText(InterfaceInput.getNameForKeyCode(typedCode));
                        ((ControlSystem.ControlsKeyboard)((Object)((Map)((GUIConfig)GUIConfig.this).keyboardBoxes.get((Object)((GUIConfig)GUIConfig.this).vehicleConfiguring)).get((Object)this))).config.keyCode = typedCode;
                        ConfigSystem.saveToDisk();
                        this.focused = false;
                    }
                };
                boxesForVehicle.put(box, keyboardControl);
                this.addComponent(box);
                this.addComponent(new GUIComponentLabel(box.constructedX - 70, box.constructedY + 2, ColorRGB.BLACK, keyboardControl.translatedName + ":").setBox(box));
                if ((verticalOffset += 11) <= 119) continue;
                verticalOffset = 20;
                horizontalOffset += 120;
            }
            this.keyboardBoxes.put(vehicleType, boxesForVehicle);
            int offset = 0;
            HashMap<GUIComponentLabel, ControlSystem.ControlsKeyboardDynamic> dynamicLabels = new HashMap<GUIComponentLabel, ControlSystem.ControlsKeyboardDynamic>();
            for (ControlSystem.ControlsKeyboardDynamic controlsKeyboardDynamic : ControlSystem.ControlsKeyboardDynamic.values()) {
                if (!controlsKeyboardDynamic.name().toLowerCase().contains(vehicleType)) continue;
                GUIComponentLabel label = new GUIComponentLabel(this.guiLeft + 10, this.guiTop + 135 + offset, ColorRGB.BLACK, "");
                dynamicLabels.put(label, controlsKeyboardDynamic);
                this.addComponent(label);
                offset = (byte)(offset + 11);
            }
            this.keyboardLabels.put(vehicleType, dynamicLabels);
        }
        this.finishKeyboardBindingsButton = new GUIComponentButton(this.guiLeft + 180, this.guiTop + 150, 50, 20, InterfaceCore.translate("gui.config.controls.confirm")){

            @Override
            public void onClicked(boolean leftSide) {
                GUIConfig.this.vehicleConfiguring = "";
            }
        };
        this.addComponent(this.finishKeyboardBindingsButton);
        this.joystickSelectionButtons.clear();
        for (i = 0; i < 9; ++i) {
            GUIComponentButton button = new GUIComponentButton(this.guiLeft + 10, this.guiTop + 40 + 20 * this.joystickSelectionButtons.size(), 235, 20, ""){

                @Override
                public void onClicked(boolean leftSide) {
                    GUIConfig.this.selectedJoystickName = InterfaceInput.getAllJoystickNames().get(GUIConfig.this.joystickSelectionButtons.indexOf(this));
                    GUIConfig.this.selectedJoystickComponentCount = InterfaceInput.getJoystickComponentCount(GUIConfig.this.selectedJoystickName);
                }
            };
            this.joystickSelectionButtons.add(button);
            this.addComponent(button);
            if (this.joystickSelectionButtons.size() != 1) continue;
            this.addComponent(new GUIComponentLabel(this.guiLeft + 20, this.guiTop + 10, ColorRGB.BLACK, InterfaceCore.translate("gui.config.joystick.select")).setButton(button));
            this.addComponent(new GUIComponentLabel(this.guiLeft + 15, this.guiTop + 25, ColorRGB.BLACK, InterfaceCore.translate("gui.config.joystick.name")).setButton(button));
        }
        this.joystickComponentSelectionButtons.clear();
        this.joystickComponentStateBackgrounds.clear();
        this.joystickComponentStateForegrounds.clear();
        for (i = 0; i < 9; ++i) {
            GUIComponentButton button = new GUIComponentButton(this.guiLeft + 10, this.guiTop + 45 + 15 * i, 215, 15, "", false, ColorRGB.DARK_GRAY, true){

                @Override
                public void onClicked(boolean leftSide) {
                    GUIConfig.this.joystickComponentId = GUIConfig.this.joystickComponentSelectionButtons.indexOf(this) + GUIConfig.this.scrollSpot;
                    if (InterfaceInput.isJoystickComponentAxis(GUIConfig.this.selectedJoystickName, GUIConfig.this.joystickComponentId)) {
                        GUIConfig.this.assigningDigital = false;
                    } else {
                        GUIConfig.this.assigningDigital = true;
                    }
                }
            };
            this.joystickComponentSelectionButtons.add(button);
            this.addComponent(button);
            GUIComponentCutout componentBackground = new GUIComponentCutout(button.constructedX + 100, button.constructedY + 2, 40, 10, 236, 236, 20, 20);
            this.joystickComponentStateBackgrounds.add(componentBackground);
            this.addComponent(componentBackground);
            GUIComponentCutout componentForeground = new GUIComponentCutout(button.constructedX + 100, button.constructedY + 2, 40, 10, 236, 0, 20, 20);
            this.joystickComponentStateForegrounds.add(componentForeground);
            this.addComponent(componentForeground);
        }
        this.componentListUpButton = new GUIComponentButton(this.guiLeft + 225, this.guiTop + 45, 20, 20, "/\\"){

            @Override
            public void onClicked(boolean leftSide) {
                GUIConfig.this.scrollSpot = GUIConfig.this.scrollSpot - 9;
            }
        };
        this.addComponent(this.componentListUpButton);
        this.componentListDownButton = new GUIComponentButton(this.guiLeft + 225, this.guiTop + 155, 20, 20, "\\/"){

            @Override
            public void onClicked(boolean leftSide) {
                GUIConfig.this.scrollSpot = GUIConfig.this.scrollSpot + 9;
            }
        };
        this.addComponent(this.componentListDownButton);
        this.deadzone_lessButton = new GUIComponentButton(this.guiLeft + 100, this.guiTop + 10, 20, 20, "<"){

            @Override
            public void onClicked(boolean leftSide) {
                ConfigSystem.configObject.clientControls.joystickDeadZone.value = ((Double)ConfigSystem.configObject.clientControls.joystickDeadZone.value * 100.0 - 1.0) / 100.0;
            }
        };
        this.addComponent(this.deadzone_lessButton);
        this.deadzone_moreButton = new GUIComponentButton(this.guiLeft + 220, this.guiTop + 10, 20, 20, ">"){

            @Override
            public void onClicked(boolean leftSide) {
                ConfigSystem.configObject.clientControls.joystickDeadZone.value = ((Double)ConfigSystem.configObject.clientControls.joystickDeadZone.value * 100.0 + 1.0) / 100.0;
            }
        };
        this.addComponent(this.deadzone_moreButton);
        this.deadzone_text = new GUIComponentTextBox(this.guiLeft + 120, this.guiTop + 10, 100, "");
        this.addComponent(this.deadzone_text);
        this.addComponent(new GUIComponentLabel(this.guiLeft + 15, this.guiTop + 20, ColorRGB.BLACK, InterfaceCore.translate("gui.config.joystick.mapping")).setButton(this.componentListUpButton));
        this.addComponent(new GUIComponentLabel(this.guiLeft + 15, this.guiTop + 35, ColorRGB.BLACK, "#").setButton(this.componentListUpButton));
        this.addComponent(new GUIComponentLabel(this.guiLeft + 30, this.guiTop + 35, ColorRGB.BLACK, InterfaceCore.translate("gui.config.joystick.name")).setButton(this.componentListUpButton));
        this.addComponent(new GUIComponentLabel(this.guiLeft + 100, this.guiTop + 35, ColorRGB.BLACK, InterfaceCore.translate("gui.config.joystick.state")).setButton(this.componentListUpButton));
        this.addComponent(new GUIComponentLabel(this.guiLeft + 140, this.guiTop + 35, ColorRGB.BLACK, InterfaceCore.translate("gui.config.joystick.assignment")).setButton(this.componentListUpButton));
        this.cancelAssignmentButton = new GUIComponentButton(this.guiLeft + 125, this.guiTop + 160, 100, 20, InterfaceCore.translate("gui.config.joystick.cancel")){

            @Override
            public void onClicked(boolean leftSide) {
                GUIConfig.this.joystickComponentId = -1;
                GUIConfig.this.calibrating = false;
            }
        };
        this.addComponent(this.cancelAssignmentButton);
        this.clearAssignmentButton = new GUIComponentButton(this.guiLeft + 25, this.guiTop + 160, 100, 20, InterfaceCore.translate("gui.config.joystick.clear")){

            @Override
            public void onClicked(boolean leftSide) {
                for (ControlSystem.ControlsJoystick joystickControl : ControlSystem.ControlsJoystick.values()) {
                    if (!GUIConfig.this.selectedJoystickName.equals(joystickControl.config.joystickName) || !(joystickControl.isAxis ^ GUIConfig.this.assigningDigital) || joystickControl.config.buttonIndex != GUIConfig.this.joystickComponentId || !joystickControl.systemName.startsWith(GUIConfig.this.vehicleConfiguring)) continue;
                    joystickControl.clearControl();
                }
                GUIConfig.this.joystickComponentId = -1;
            }
        };
        this.addComponent(this.clearAssignmentButton);
        this.addComponent(new GUIComponentLabel(this.guiLeft + 20, this.guiTop + 10, ColorRGB.BLACK, InterfaceCore.translate("gui.config.joystick.choosemap")).setButton(this.clearAssignmentButton));
        this.digitalAssignButtons.clear();
        this.analogAssignButtons.clear();
        for (String vehicleType : this.vehicleTypes) {
            int leftOffsetDigital = 0;
            int topOffsetDigital = 0;
            int topOffsetAnalog = 0;
            HashMap<17, Enum> digitalControlButtons = new HashMap<17, Enum>();
            HashMap<17, Enum> analogControlButtons = new HashMap<17, Enum>();
            for (Enum enum_ : ControlSystem.ControlsJoystick.values()) {
                if (((ControlSystem.ControlsJoystick)enum_).systemName.startsWith(vehicleType)) {
                    GUIComponentButton button;
                    if (!((ControlSystem.ControlsJoystick)enum_).isAxis) {
                        button = new GUIComponentButton(this.guiLeft + 8 + leftOffsetDigital, this.guiTop + 20 + topOffsetDigital, 80, 15, ((ControlSystem.ControlsJoystick)enum_).translatedName){

                            @Override
                            public void onClicked(boolean leftSide) {
                                ((ControlSystem.ControlsJoystick)((Object)((Map)GUIConfig.this.digitalAssignButtons.get(GUIConfig.this.vehicleConfiguring)).get(this))).setControl(GUIConfig.this.selectedJoystickName, GUIConfig.this.joystickComponentId);
                                GUIConfig.this.joystickComponentId = -1;
                            }
                        };
                        digitalControlButtons.put(button, enum_);
                        this.addComponent(button);
                        topOffsetDigital = (short)(topOffsetDigital + button.height);
                    } else {
                        button = new GUIComponentButton(this.guiLeft + 85, this.guiTop + 40 + topOffsetAnalog, 80, 20, ((ControlSystem.ControlsJoystick)enum_).translatedName){

                            @Override
                            public void onClicked(boolean leftSide) {
                                GUIConfig.this.controlCalibrating = (ControlSystem.ControlsJoystick)((Object)((Map)GUIConfig.this.analogAssignButtons.get(GUIConfig.this.vehicleConfiguring)).get(this));
                                GUIConfig.this.axisMinBoundsTextBox.setText("0.0");
                                GUIConfig.this.axisMaxBoundsTextBox.setText("0.0");
                                GUIConfig.this.calibrating = true;
                            }
                        };
                        analogControlButtons.put(button, enum_);
                        this.addComponent(button);
                        topOffsetAnalog = (short)(topOffsetAnalog + button.height);
                    }
                }
                if (topOffsetDigital < 135) continue;
                topOffsetDigital = 0;
                leftOffsetDigital = (short)(leftOffsetDigital + 80);
            }
            this.digitalAssignButtons.put(vehicleType, digitalControlButtons);
            this.analogAssignButtons.put(vehicleType, analogControlButtons);
        }
        this.confirmBoundsButton = new GUIComponentButton(this.guiLeft + 25, this.guiTop + 160, 100, 20, InterfaceCore.translate("gui.config.joystick.confirm")){

            @Override
            public void onClicked(boolean leftSide) {
                boolean isInverted = ((GUIConfig)GUIConfig.this).invertAxisButton.text.contains(InterfaceCore.translate("gui.config.joystick.invert"));
                GUIConfig.this.controlCalibrating.setAxisControl(GUIConfig.this.selectedJoystickName, GUIConfig.this.joystickComponentId, Double.valueOf(GUIConfig.this.axisMinBoundsTextBox.getText()), Double.valueOf(GUIConfig.this.axisMaxBoundsTextBox.getText()), isInverted);
                GUIConfig.this.joystickComponentId = -1;
                GUIConfig.this.calibrating = false;
            }
        };
        this.addComponent(this.confirmBoundsButton);
        this.invertAxisButton = new GUIComponentButton(this.guiLeft + 50, this.guiTop + 120, 150, 20, InterfaceCore.translate("gui.config.joystick.axismode") + InterfaceCore.translate("gui.config.joystick.normal")){

            @Override
            public void onClicked(boolean leftSide) {
                this.text = this.text.contains(InterfaceCore.translate("gui.config.joystick.invert")) ? InterfaceCore.translate("gui.config.joystick.axismode") + InterfaceCore.translate("gui.config.joystick.normal") : InterfaceCore.translate("gui.config.joystick.axismode") + InterfaceCore.translate("gui.config.joystick.invert");
            }
        };
        this.addComponent(this.invertAxisButton);
        this.axisMinBoundsTextBox = new GUIComponentTextBox(this.guiLeft + 50, this.guiTop + 90, 150, "0.0");
        this.addComponent(this.axisMinBoundsTextBox);
        this.axisMinBoundsTextBox.enabled = false;
        this.axisMaxBoundsTextBox = new GUIComponentTextBox(this.guiLeft + 50, this.guiTop + 60, 150, "0.0");
        this.addComponent(this.axisMaxBoundsTextBox);
        this.axisMaxBoundsTextBox.enabled = false;
        this.addComponent(new GUIComponentLabel(this.guiLeft + 20, this.guiTop + 10, ColorRGB.BLACK, InterfaceCore.translate("gui.config.joystick.calibrate1")).setButton(this.confirmBoundsButton));
        this.addComponent(new GUIComponentLabel(this.guiLeft + 20, this.guiTop + 20, ColorRGB.BLACK, InterfaceCore.translate("gui.config.joystick.calibrate2")).setButton(this.confirmBoundsButton));
    }

    @Override
    public void setStates() {
        super.setStates();
        this.renderConfigScreenButton.enabled = this.configuringControls || !this.configuringControls && !this.configuringRendering;
        this.controlConfigScreenButton.enabled = this.configuringControls || !this.configuringControls && this.configuringRendering;
        this.controlScreenButton.enabled = !this.configuringControls;
        for (GUIComponentButton button : this.renderConfigButtons.keySet()) {
            button.visible = !this.renderConfigScreenButton.enabled;
        }
        for (GUIComponentButton button : this.controlConfigButtons.keySet()) {
            button.visible = !this.controlConfigScreenButton.enabled;
        }
        boolean bl = this.vehicleSelectionFaultLabel.visible = !InterfaceInput.isJoystickSupportEnabled() && this.configuringControls && !this.configuringKeyboard;
        if (this.vehicleSelectionFaultLabel.visible) {
            this.vehicleSelectionFaultLabel.text = InterfaceInput.isJoystickSupportBlocked() ? InterfaceCore.translate("gui.config.joystick.disabled") : InterfaceCore.translate("gui.config.joystick.error");
        }
        for (GUIComponentButton button : this.vehicleSelectionButtons.keySet()) {
            button.visible = this.configuringControls && this.vehicleConfiguring.isEmpty() && (!this.vehicleSelectionButtons.get(button).endsWith(".joystick") || InterfaceInput.isJoystickSupportEnabled());
        }
        this.finishKeyboardBindingsButton.visible = this.configuringControls && !this.vehicleConfiguring.isEmpty() && this.configuringKeyboard;
        for (String vehicleType : this.keyboardBoxes.keySet()) {
            for (GUIComponentTextBox textBox : this.keyboardBoxes.get(vehicleType).keySet()) {
                boolean bl2 = textBox.visible = this.finishKeyboardBindingsButton.visible && vehicleType.equals(this.vehicleConfiguring);
                if (textBox.focused) {
                    textBox.setText("");
                    continue;
                }
                textBox.setText(InterfaceInput.getNameForKeyCode(this.keyboardBoxes.get((Object)vehicleType).get((Object)textBox).config.keyCode));
            }
            for (GUIComponentLabel label : this.keyboardLabels.get(vehicleType).keySet()) {
                label.visible = this.finishKeyboardBindingsButton.visible && vehicleType.equals(this.vehicleConfiguring);
                ControlSystem.ControlsKeyboardDynamic dynamicControl = this.keyboardLabels.get(vehicleType).get(label);
                label.text = dynamicControl.translatedName + ": " + InterfaceInput.getNameForKeyCode(dynamicControl.modControl.config.keyCode) + " + " + InterfaceInput.getNameForKeyCode(dynamicControl.mainControl.config.keyCode);
            }
        }
        List<String> allJoystickNames = InterfaceInput.getAllJoystickNames();
        for (int i = 0; i < 9; i = (int)((byte)(i + 1))) {
            GUIComponentButton button = this.joystickSelectionButtons.get(i);
            if (allJoystickNames.size() > i) {
                button.visible = this.configuringControls && !this.configuringKeyboard && !this.vehicleConfiguring.isEmpty() && this.selectedJoystickName == null;
                button.text = String.format(" %-30.28s", allJoystickNames.get(i));
                continue;
            }
            button.visible = false;
        }
        boolean onComponentSelectScreen = this.selectedJoystickName != null && this.joystickComponentId == -1;
        for (int i = 0; i < 9; i = (int)((byte)(i + 1))) {
            GUIComponentButton button = this.joystickComponentSelectionButtons.get(i);
            GUIComponentCutout componentBackground = this.joystickComponentStateBackgrounds.get(i);
            GUIComponentCutout componentForeground = this.joystickComponentStateForegrounds.get(i);
            componentBackground.visible = button.visible = onComponentSelectScreen && i + this.scrollSpot < this.selectedJoystickComponentCount;
            componentForeground.visible = button.visible;
            if (!button.visible) continue;
            int controlIndex = i + this.scrollSpot;
            button.text = String.format(" %02d  %-15.15s", controlIndex + 1, InterfaceInput.getJoystickComponentName(this.selectedJoystickName, controlIndex));
            for (ControlSystem.ControlsJoystick joystickControl : ControlSystem.ControlsJoystick.values()) {
                if (!this.selectedJoystickName.equals(joystickControl.config.joystickName) || joystickControl.config.buttonIndex != controlIndex || !joystickControl.systemName.startsWith(this.vehicleConfiguring)) continue;
                button.text = button.text + String.format("          %s", joystickControl.translatedName);
            }
            float pollData = InterfaceInput.getJoystickAxisValue(this.selectedJoystickName, controlIndex);
            if (InterfaceInput.isJoystickComponentAxis(this.selectedJoystickName, controlIndex)) {
                int pollDataInt = (int)(pollData * 20.0f);
                componentBackground.visible = true;
                componentForeground.position.x = componentForeground.constructedX;
                if (pollDataInt > 0) {
                    componentForeground.position.x += 20.0;
                    componentForeground.width = pollDataInt;
                } else {
                    componentForeground.position.x += (double)(20 + pollDataInt);
                    componentForeground.width = -pollDataInt;
                }
                componentForeground.textureYOffset = 196;
                continue;
            }
            componentBackground.visible = false;
            componentForeground.position.x = componentForeground.constructedX + 15;
            componentForeground.width = 10;
            componentForeground.textureYOffset = pollData == 0.0f ? 236 : (pollData == 1.0f ? 196 : 216);
        }
        this.componentListUpButton.visible = onComponentSelectScreen;
        this.componentListDownButton.visible = onComponentSelectScreen;
        this.deadzone_lessButton.visible = onComponentSelectScreen;
        this.deadzone_moreButton.visible = onComponentSelectScreen;
        this.deadzone_text.visible = onComponentSelectScreen;
        if (onComponentSelectScreen) {
            this.componentListUpButton.enabled = this.scrollSpot - 9 >= 0;
            this.componentListDownButton.enabled = this.scrollSpot + 9 < this.selectedJoystickComponentCount;
            this.deadzone_lessButton.enabled = (Double)ConfigSystem.configObject.clientControls.joystickDeadZone.value > 0.0;
            this.deadzone_moreButton.enabled = (Double)ConfigSystem.configObject.clientControls.joystickDeadZone.value < 1.0;
            this.deadzone_text.enabled = false;
            this.deadzone_text.setText(InterfaceCore.translate("gui.config.joystick.deadzone") + " " + String.valueOf(ConfigSystem.configObject.clientControls.joystickDeadZone.value));
        }
        this.cancelAssignmentButton.enabled = this.cancelAssignmentButton.visible = this.joystickComponentId != -1;
        this.clearAssignmentButton.visible = this.cancelAssignmentButton.visible && !this.calibrating;
        this.clearAssignmentButton.enabled = this.cancelAssignmentButton.visible && !this.calibrating;
        for (String vehicleType : this.digitalAssignButtons.keySet()) {
            for (GUIComponentButton button : this.digitalAssignButtons.get(vehicleType).keySet()) {
                button.visible = this.joystickComponentId != -1 && this.vehicleConfiguring.equals(vehicleType) && this.assigningDigital;
            }
        }
        for (String vehicleType : this.analogAssignButtons.keySet()) {
            for (GUIComponentButton button : this.analogAssignButtons.get(vehicleType).keySet()) {
                button.visible = this.joystickComponentId != -1 && this.vehicleConfiguring.equals(vehicleType) && !this.assigningDigital && !this.calibrating;
            }
        }
        this.confirmBoundsButton.visible = this.calibrating;
        this.cancelAssignmentButton.visible = this.calibrating;
        this.invertAxisButton.visible = this.calibrating;
        this.axisMinBoundsTextBox.visible = this.calibrating;
        this.axisMaxBoundsTextBox.visible = this.calibrating;
        if (this.calibrating) {
            float pollData = InterfaceInput.getJoystickAxisValue(this.selectedJoystickName, this.joystickComponentId);
            if (pollData < 0.0f) {
                this.axisMinBoundsTextBox.setText(String.valueOf(Math.min(Double.valueOf(this.axisMinBoundsTextBox.getText()), (double)pollData)));
            } else {
                this.axisMaxBoundsTextBox.setText(String.valueOf(Math.max(Double.valueOf(this.axisMaxBoundsTextBox.getText()), (double)pollData)));
            }
        }
    }

    private void populateConfigButtonList(final Map<GUIComponentButton, JSONConfig.JSONConfigEntry<Boolean>> configButtons, Object configObject) {
        configButtons.clear();
        for (Field field : configObject.getClass().getFields()) {
            if (!field.getType().equals(JSONConfig.JSONConfigEntry.class)) continue;
            try {
                final JSONConfig.JSONConfigEntry configEntry = (JSONConfig.JSONConfigEntry)field.get(configObject);
                if (!configEntry.value.getClass().equals(Boolean.class)) continue;
                GUIComponentButton button = new GUIComponentButton(this.guiLeft + 85 + 120 * (configButtons.size() % 2), this.guiTop + 20 + 16 * (configButtons.size() / 2), 40, 16, String.valueOf(configEntry.value)){

                    @Override
                    public void onClicked(boolean leftSide) {
                        ((JSONConfig.JSONConfigEntry)configButtons.get((Object)this)).value = Boolean.valueOf(this.text) == false;
                        ConfigSystem.saveToDisk();
                        this.text = String.valueOf(((JSONConfig.JSONConfigEntry)configButtons.get((Object)this)).value);
                    }

                    @Override
                    public List<String> getTooltipText() {
                        ArrayList<String> tooltipText = new ArrayList<String>();
                        tooltipText.add(configEntry.comment);
                        return tooltipText;
                    }
                };
                this.addComponent(button);
                configButtons.put(button, configEntry);
                this.addComponent(new GUIComponentLabel(button.constructedX - 75, button.constructedY + 5, ColorRGB.BLACK, field.getName()).setButton(button));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

