/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityFuelPump;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentItem;
import minecrafttransportsimulator.guis.components.GUIComponentTextBox;
import minecrafttransportsimulator.guis.instances.AGUIInventory;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.packets.instances.PacketInventoryContainerChange;
import minecrafttransportsimulator.packets.instances.PacketTileEntityFuelPumpDispense;

public class GUIFuelPump
extends AGUIInventory {
    private final TileEntityFuelPump pump;
    private final boolean configuring;
    private final List<GUIComponentTextBox> interactableSlotBoxes = new ArrayList<GUIComponentTextBox>();

    public GUIFuelPump(TileEntityFuelPump pump, boolean configuring) {
        super(null);
        this.pump = pump;
        this.configuring = configuring;
    }

    @Override
    public void setupComponents() {
        super.setupComponents();
        this.interactableSlotBoxes.clear();
        int xOffset = 8;
        for (int i = 0; i < this.pump.fuelItems.getSize(); ++i) {
            WrapperItemStack stack = this.pump.fuelItems.getStack(i);
            GUIComponentButton itemButton = new GUIComponentButton(this.guiLeft + xOffset, this.guiTop + 12 + 22 * (i % 5), true){

                @Override
                public void onClicked(boolean leftSide) {
                    if (GUIFuelPump.this.configuring) {
                        WrapperItemStack changedStack = ((GUIFuelPump)GUIFuelPump.this).pump.fuelItems.getStack(GUIFuelPump.this.interactableSlotButtons.indexOf(this));
                        changedStack.add(-changedStack.getSize());
                        InterfacePacket.sendToServer(new PacketInventoryContainerChange(((GUIFuelPump)GUIFuelPump.this).pump.fuelItems, GUIFuelPump.this.interactableSlotButtons.indexOf(this), changedStack));
                    } else {
                        InterfacePacket.sendToServer(new PacketTileEntityFuelPumpDispense(GUIFuelPump.this.pump, GUIFuelPump.this.player, GUIFuelPump.this.interactableSlotButtons.indexOf(this)));
                    }
                }
            };
            itemButton.visible = !stack.isEmpty() || this.configuring;
            this.addComponent(itemButton);
            this.interactableSlotButtons.add(itemButton);
            GUIComponentItem itemIcon = new GUIComponentItem(itemButton);
            itemIcon.stack = stack;
            this.addComponent(itemIcon);
            this.interactableSlotIcons.add(itemIcon);
            GUIComponentTextBox fuelAmount = new GUIComponentTextBox(itemButton.constructedX + itemButton.width + 4, itemButton.constructedY, 50, String.valueOf(this.pump.fuelAmounts.get(i))){

                @Override
                public boolean isTextValid(String newText) {
                    return newText.matches("[0-9]+");
                }

                @Override
                public void handleTextChange() {
                    InterfacePacket.sendToServer(new PacketTileEntityFuelPumpDispense(GUIFuelPump.this.pump, GUIFuelPump.this.player, GUIFuelPump.this.interactableSlotBoxes.indexOf(this), Integer.valueOf(this.getText())));
                }
            };
            fuelAmount.visible = !stack.isEmpty() || this.configuring;
            fuelAmount.enabled = this.configuring;
            this.addComponent(fuelAmount);
            this.interactableSlotBoxes.add(fuelAmount);
            if (i != 4) continue;
            xOffset += 100;
        }
    }

    @Override
    public void setStates() {
        super.setStates();
        if (this.configuring) {
            for (int i = 0; i < this.interactableSlotButtons.size(); ++i) {
                ((GUIComponentItem)this.interactableSlotIcons.get((int)i)).stack = this.pump.fuelItems.getStack(i);
            }
        }
    }

    @Override
    protected void handlePlayerItemClick(int slotClicked) {
        if (this.configuring) {
            for (int i = 0; i < this.pump.fuelItems.getSize(); ++i) {
                WrapperItemStack stack = this.pump.fuelItems.getStack(i);
                if (!stack.isEmpty()) continue;
                InterfacePacket.sendToServer(new PacketInventoryContainerChange(this.pump.fuelItems, i, this.playerInventory.getStack(slotClicked)));
                return;
            }
        }
    }
}

