/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import minecrafttransportsimulator.entities.instances.EntityFurnace;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentCutout;
import minecrafttransportsimulator.guis.components.GUIComponentItem;
import minecrafttransportsimulator.guis.instances.AGUIInventory;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.packets.instances.PacketPlayerItemTransfer;

public class GUIFurnace
extends AGUIInventory {
    private GUIComponentCutout fuelIcon;
    private GUIComponentCutout smeltingProgress;
    private final EntityFurnace furnace;

    public GUIFurnace(EntityFurnace furnace, String texture) {
        super(texture != null ? texture : "mts:textures/guis/furnace.png");
        this.furnace = furnace;
    }

    @Override
    public void setupComponents() {
        super.setupComponents();
        this.interactableSlotButtons.clear();
        this.interactableSlotIcons.clear();
        GUIComponentButton smeltingItemButton = new GUIComponentButton(this.guiLeft + 51, this.guiTop + 20, false){

            @Override
            public void onClicked(boolean leftSide) {
                InterfacePacket.sendToServer(new PacketPlayerItemTransfer(GUIFurnace.this.furnace, GUIFurnace.this.player, GUIFurnace.this.interactableSlotButtons.indexOf(this), -1, false));
            }
        };
        this.addComponent(smeltingItemButton);
        this.interactableSlotButtons.add(smeltingItemButton);
        GUIComponentItem smeltingItemIcon = new GUIComponentItem(smeltingItemButton);
        this.addComponent(smeltingItemIcon);
        this.interactableSlotIcons.add(smeltingItemIcon);
        GUIComponentButton smeltedItemButton = new GUIComponentButton(this.guiLeft + 110, this.guiTop + 21, false){

            @Override
            public void onClicked(boolean leftSide) {
                InterfacePacket.sendToServer(new PacketPlayerItemTransfer(GUIFurnace.this.furnace, GUIFurnace.this.player, GUIFurnace.this.interactableSlotButtons.indexOf(this), -1, false));
            }
        };
        this.addComponent(smeltedItemButton);
        this.interactableSlotButtons.add(smeltedItemButton);
        GUIComponentItem smeltedItemIcon = new GUIComponentItem(smeltedItemButton);
        this.addComponent(smeltedItemIcon);
        this.interactableSlotIcons.add(smeltedItemIcon);
        if (this.furnace.definition.furnaceType.equals((Object)JSONPart.FurnaceComponentType.STANDARD)) {
            GUIComponentButton fuelItemButton = new GUIComponentButton(this.guiLeft + 79, this.guiTop + 53, false){

                @Override
                public void onClicked(boolean leftSide) {
                    InterfacePacket.sendToServer(new PacketPlayerItemTransfer(GUIFurnace.this.furnace, GUIFurnace.this.player, GUIFurnace.this.interactableSlotButtons.indexOf(this), -1, false));
                }
            };
            this.addComponent(fuelItemButton);
            this.interactableSlotButtons.add(fuelItemButton);
            GUIComponentItem fuelItemIcon = new GUIComponentItem(fuelItemButton);
            this.addComponent(fuelItemIcon);
            this.interactableSlotIcons.add(fuelItemIcon);
        }
        int backplaneOffset = 0;
        switch (this.furnace.definition.furnaceType) {
            case STANDARD: {
                backplaneOffset = 31;
                break;
            }
            case FUEL: {
                backplaneOffset = 49;
                break;
            }
            case ELECTRIC: {
                backplaneOffset = 67;
            }
        }
        this.addComponent(new GUIComponentCutout(this.guiLeft + 61, this.guiTop + 53, 54, 18, 176, backplaneOffset));
        this.fuelIcon = new GUIComponentCutout(this.guiLeft + 81, this.guiTop + 38, 14, 14, 176, 0);
        this.addComponent(this.fuelIcon);
        this.smeltingProgress = new GUIComponentCutout(this.guiLeft + 77, this.guiTop + 20, 24, 17, 176, 14);
        this.addComponent(this.smeltingProgress);
    }

    @Override
    public void setStates() {
        int pixelsRemoved;
        super.setStates();
        for (int i = 0; i < this.interactableSlotButtons.size(); ++i) {
            WrapperItemStack stack = this.furnace.getStack(i);
            ((GUIComponentButton)this.interactableSlotButtons.get((int)i)).enabled = !stack.isEmpty();
            ((GUIComponentItem)this.interactableSlotIcons.get((int)i)).stack = stack;
        }
        boolean bl = this.fuelIcon.visible = this.furnace.ticksLeftOfFuel > 0;
        if (!this.furnace.definition.furnaceType.equals((Object)JSONPart.FurnaceComponentType.ELECTRIC)) {
            pixelsRemoved = (int)((double)this.fuelIcon.textureSectionHeight - (double)this.fuelIcon.textureSectionHeight * ((double)this.furnace.ticksLeftOfFuel / (double)this.furnace.ticksAddedOfFuel));
            if (pixelsRemoved < 0) {
                pixelsRemoved = 0;
            }
            this.fuelIcon.position.y = -this.fuelIcon.constructedY - pixelsRemoved;
            this.fuelIcon.height = 14 - pixelsRemoved;
            this.fuelIcon.textureYOffset = pixelsRemoved;
        }
        if (this.furnace.ticksNeededToSmelt > 0 && this.furnace.ticksLeftToSmelt > 0) {
            pixelsRemoved = (int)(24.0 * ((double)this.furnace.ticksLeftToSmelt / (double)this.furnace.ticksNeededToSmelt));
            this.smeltingProgress.width = 24 - pixelsRemoved;
            this.smeltingProgress.textureSectionWidth = 24 - pixelsRemoved;
            this.smeltingProgress.visible = true;
        } else {
            this.smeltingProgress.visible = false;
        }
    }

    @Override
    protected void handlePlayerItemClick(int slotClicked) {
        InterfacePacket.sendToServer(new PacketPlayerItemTransfer(this.furnace, this.player, -1, slotClicked, false));
    }

    @Override
    protected int getPlayerInventoryOffset() {
        return 142;
    }

    @Override
    public int getWidth() {
        return 176;
    }

    @Override
    public int getHeight() {
        return 166;
    }
}

