/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentInstrument;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.jsondefs.JSONInstrumentDefinition;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.rendering.instances.RenderText;
import minecrafttransportsimulator.systems.CameraSystem;
import minecrafttransportsimulator.systems.ConfigSystem;

public class GUIHUD
extends AGUIBase {
    private static final int HUD_WIDTH = 400;
    private static final int HUD_HEIGHT = 140;
    private final EntityVehicleF_Physics vehicle;
    private final PartSeat seat;
    private final List<GUIComponentInstrument> instruments = new ArrayList<GUIComponentInstrument>();
    private GUIComponentLabel healthLabel;
    private GUIComponentLabel gunTypeLabel;
    private boolean halfHUDActive;

    public GUIHUD(EntityVehicleF_Physics vehicle, PartSeat seat) {
        this.vehicle = vehicle;
        this.seat = seat;
        this.halfHUDActive = InterfaceClient.inFirstPerson() ? !((Boolean)ConfigSystem.configObject.clientRendering.fullHUD_1P.value).booleanValue() : (Boolean)ConfigSystem.configObject.clientRendering.fullHUD_3P.value == false;
    }

    @Override
    public void setupComponents() {
        if (this.halfHUDActive) {
            this.guiTop += this.getHeight() / 2;
        }
        super.setupComponents();
        this.instruments.clear();
        for (Integer instrumentNumber : this.vehicle.instruments.keySet()) {
            if (((JSONInstrumentDefinition)((JSONVehicle)this.vehicle.definition).instruments.get((int)instrumentNumber.intValue())).placeOnPanel) continue;
            GUIComponentInstrument instrument = new GUIComponentInstrument(this.guiLeft, this.guiTop, (int)instrumentNumber, this.vehicle);
            this.instruments.add(instrument);
            this.addComponent(instrument);
        }
        for (APart part : this.vehicle.parts) {
            for (Integer instrumentNumber : part.instruments.keySet()) {
                if (((JSONInstrumentDefinition)((JSONPart)part.definition).instruments.get((int)instrumentNumber.intValue())).placeOnPanel) continue;
                GUIComponentInstrument instrument = new GUIComponentInstrument(this.guiLeft, this.guiTop, (int)instrumentNumber, this.vehicle);
                this.instruments.add(instrument);
                this.addComponent(instrument);
            }
        }
        if (this.halfHUDActive) {
            this.guiTop -= this.getHeight() / 2;
        }
        this.healthLabel = new GUIComponentLabel(this.screenWidth, 0, ColorRGB.WHITE, "", RenderText.TextAlignment.RIGHT_ALIGNED, 1.0f);
        this.addComponent(this.healthLabel);
        this.healthLabel.ignoreGUILightingState = true;
        this.gunTypeLabel = new GUIComponentLabel(this.screenWidth, 8, ColorRGB.WHITE, "", RenderText.TextAlignment.RIGHT_ALIGNED, 1.0f);
        this.addComponent(this.gunTypeLabel);
        this.gunTypeLabel.ignoreGUILightingState = true;
    }

    @Override
    public void setStates() {
        boolean bl = InterfaceClient.inFirstPerson() ? !((Boolean)ConfigSystem.configObject.clientRendering.fullHUD_1P.value).booleanValue() : (Boolean)ConfigSystem.configObject.clientRendering.fullHUD_3P.value == false;
        if (this.halfHUDActive ^ bl) {
            this.halfHUDActive = !this.halfHUDActive;
            this.setupComponents();
        }
        super.setStates();
        for (GUIComponentInstrument instrument : this.instruments) {
            instrument.visible = CameraSystem.customCameraOverlay == null && this.seat.placementDefinition.isController && (InterfaceClient.inFirstPerson() ? (Boolean)ConfigSystem.configObject.clientRendering.renderHUD_1P.value : (Boolean)ConfigSystem.configObject.clientRendering.renderHUD_3P.value) != false;
        }
        this.healthLabel.text = String.format("Health:%3.1f%%", 100.0 * ((double)((JSONVehicle)this.vehicle.definition).general.health - this.vehicle.damageAmount) / (double)((JSONVehicle)this.vehicle.definition).general.health);
        this.healthLabel.visible = this.seat.placementDefinition.isController;
        if (this.seat.canControlGuns && !InterfaceClient.isChatOpen()) {
            this.gunTypeLabel.visible = true;
            this.gunTypeLabel.text = "Active Gun: ";
            this.gunTypeLabel.text = this.seat.activeGun != null ? this.gunTypeLabel.text + this.seat.activeGun.getItemName() + (((JSONPart)this.seat.activeGun.definition).gun.fireSolo ? " [" + (this.seat.gunIndex + 1) + "]" : "") : this.gunTypeLabel.text + "None";
        } else {
            this.gunTypeLabel.visible = false;
        }
    }

    @Override
    protected boolean renderBackground() {
        return CameraSystem.customCameraOverlay == null && this.seat.placementDefinition.isController && (InterfaceClient.inFirstPerson() ? (Boolean)ConfigSystem.configObject.clientRendering.renderHUD_1P.value != false && (Boolean)ConfigSystem.configObject.clientRendering.transpHUD_1P.value == false : (Boolean)ConfigSystem.configObject.clientRendering.renderHUD_3P.value != false && (Boolean)ConfigSystem.configObject.clientRendering.transpHUD_3P.value == false);
    }

    @Override
    protected AGUIBase.GUILightingMode getGUILightMode() {
        return this.vehicle.renderTextLit() ? AGUIBase.GUILightingMode.LIT : AGUIBase.GUILightingMode.DARK;
    }

    @Override
    protected EntityVehicleF_Physics getGUILightSource() {
        return this.vehicle;
    }

    @Override
    public boolean capturesPlayer() {
        return false;
    }

    @Override
    public int getWidth() {
        return 400;
    }

    @Override
    public int getHeight() {
        return 140;
    }

    @Override
    public boolean renderFlushBottom() {
        return true;
    }

    @Override
    public boolean renderTranslucent() {
        return true;
    }

    @Override
    protected String getTexture() {
        return ((JSONVehicle)this.vehicle.definition).motorized.hudTexture != null ? ((JSONVehicle)this.vehicle.definition).motorized.hudTexture : "mts:textures/guis/hud.png";
    }
}

