/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentCutout;
import minecrafttransportsimulator.guis.components.GUIComponentInstrument;
import minecrafttransportsimulator.guis.components.GUIComponentItem;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.instances.ItemInstrument;
import minecrafttransportsimulator.jsondefs.AJSONInteractableEntity;
import minecrafttransportsimulator.jsondefs.JSONInstrumentDefinition;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.packets.instances.PacketEntityInstrumentChange;
import minecrafttransportsimulator.rendering.instances.RenderText;
import minecrafttransportsimulator.systems.PackParserSystem;

public class GUIInstruments
extends AGUIBase {
    private final EntityVehicleF_Physics vehicle;
    private final WrapperPlayer player;
    private final TreeMap<String, List<ItemInstrument>> playerInstruments = new TreeMap();
    private GUIComponentButton prevPackButton;
    private GUIComponentButton nextPackButton;
    private GUIComponentButton clearButton;
    private static String currentPack;
    private GUIComponentLabel packName;
    private boolean hudSelected = true;
    private GUIComponentButton hudButton;
    private GUIComponentButton panelButton;
    private GUIComponentLabel infoLabel;
    private AEntityE_Interactable<?> selectedEntity;
    private JSONInstrumentDefinition selectedInstrumentDefinition;
    private final List<GUIComponentButton> instrumentSlots = new ArrayList<GUIComponentButton>();
    private final List<GUIComponentItem> instrumentSlotIcons = new ArrayList<GUIComponentItem>();
    private final Map<AEntityE_Interactable<?>, List<InstrumentSlotBlock>> entityInstrumentBlocks = new HashMap();

    public GUIInstruments(EntityVehicleF_Physics vehicle) {
        this.vehicle = vehicle;
        this.player = InterfaceClient.getClientPlayer();
    }

    @Override
    public void setupComponents() {
        super.setupComponents();
        this.prevPackButton = new GUIComponentButton(this.guiLeft, this.guiTop - 74, 20, 20, "<", true, ColorRGB.WHITE, false){

            @Override
            public void onClicked(boolean leftSide) {
                currentPack = GUIInstruments.this.playerInstruments.lowerKey(currentPack);
            }
        };
        this.addComponent(this.prevPackButton);
        this.nextPackButton = new GUIComponentButton(this.guiLeft, this.guiTop - 52, 20, 20, ">", true, ColorRGB.WHITE, false){

            @Override
            public void onClicked(boolean leftSide) {
                currentPack = GUIInstruments.this.playerInstruments.higherKey(currentPack);
            }
        };
        this.addComponent(this.nextPackButton);
        this.instrumentSlots.clear();
        this.instrumentSlotIcons.clear();
        for (int i = 0; i < 36; i = (int)((byte)(i + 1))) {
            GUIComponentButton instrumentButton = new GUIComponentButton(this.guiLeft + 23 + 18 * (i / 2), this.guiTop - 75 + 18 * (i % 2), false){

                @Override
                public void onClicked(boolean leftSide) {
                    InterfacePacket.sendToServer(new PacketEntityInstrumentChange(GUIInstruments.this.selectedEntity, GUIInstruments.this.player, ((AJSONInteractableEntity)((GUIInstruments)GUIInstruments.this).selectedEntity.definition).instruments.indexOf(GUIInstruments.this.selectedInstrumentDefinition), (ItemInstrument)((List)GUIInstruments.this.playerInstruments.get(currentPack)).get(GUIInstruments.this.instrumentSlots.indexOf(this))));
                    GUIInstruments.this.selectedEntity = null;
                    GUIInstruments.this.selectedInstrumentDefinition = null;
                }
            };
            this.addComponent(instrumentButton);
            this.instrumentSlots.add(instrumentButton);
            GUIComponentItem instrumentItem = new GUIComponentItem(instrumentButton);
            this.addComponent(instrumentItem);
            this.instrumentSlotIcons.add(instrumentItem);
        }
        this.packName = new GUIComponentLabel(this.guiLeft + 40, this.guiTop - 85, ColorRGB.WHITE, "");
        this.addComponent(this.packName);
        this.clearButton = new GUIComponentButton(this.guiLeft + this.getWidth() - 36, this.guiTop - 75, 36, 36, InterfaceCore.translate("gui.instruments.clear"), true, ColorRGB.WHITE, false){

            @Override
            public void onClicked(boolean leftSide) {
                InterfacePacket.sendToServer(new PacketEntityInstrumentChange(GUIInstruments.this.selectedEntity, GUIInstruments.this.player, ((AJSONInteractableEntity)((GUIInstruments)GUIInstruments.this).selectedEntity.definition).instruments.indexOf(GUIInstruments.this.selectedInstrumentDefinition), null));
                GUIInstruments.this.selectedEntity = null;
                GUIInstruments.this.selectedInstrumentDefinition = null;
            }
        };
        this.addComponent(this.clearButton);
        this.addComponent(new GUIComponentCutout(this.clearButton.constructedX, this.clearButton.constructedY, this.clearButton.width, this.clearButton.height, 448, 0, 64, 64));
        this.hudButton = new GUIComponentButton(this.guiLeft, this.guiTop - 20, 100, 20, InterfaceCore.translate("gui.instruments.main"), true, ColorRGB.WHITE, false){

            @Override
            public void onClicked(boolean leftSide) {
                GUIInstruments.this.hudSelected = true;
                GUIInstruments.this.selectedEntity = null;
                GUIInstruments.this.selectedInstrumentDefinition = null;
                GUIInstruments.this.setupComponents();
            }
        };
        this.addComponent(this.hudButton);
        this.panelButton = new GUIComponentButton(this.guiLeft + this.getWidth() - 100, this.guiTop - 20, 100, 20, InterfaceCore.translate("gui.instruments.control"), true, ColorRGB.WHITE, false){

            @Override
            public void onClicked(boolean leftSide) {
                GUIInstruments.this.hudSelected = false;
                GUIInstruments.this.selectedEntity = null;
                GUIInstruments.this.selectedInstrumentDefinition = null;
                GUIInstruments.this.setupComponents();
            }
        };
        this.addComponent(this.panelButton);
        this.infoLabel = new GUIComponentLabel(this.guiLeft + this.getWidth() / 2, this.guiTop - 20, ColorRGB.WHITE, "", RenderText.TextAlignment.CENTERED, 1.0f);
        this.addComponent(this.infoLabel);
        ArrayList<AEntityE_Interactable> entitiesWithInstruments = new ArrayList<AEntityE_Interactable>();
        if (((JSONVehicle)this.vehicle.definition).instruments != null) {
            entitiesWithInstruments.add(this.vehicle);
        }
        for (APart part : this.vehicle.parts) {
            if (((JSONPart)part.definition).instruments == null) continue;
            entitiesWithInstruments.add(part);
        }
        this.entityInstrumentBlocks.clear();
        for (AEntityE_Interactable entity : entitiesWithInstruments) {
            ArrayList<InstrumentSlotBlock> instrumentBlocks = new ArrayList<InstrumentSlotBlock>();
            for (JSONInstrumentDefinition packInstrument : ((AJSONInteractableEntity)entity.definition).instruments) {
                if (!(this.hudSelected ^ packInstrument.placeOnPanel)) continue;
                instrumentBlocks.add(new InstrumentSlotBlock(this.guiLeft, this.guiTop, entity, packInstrument));
            }
            this.entityInstrumentBlocks.put(entity, instrumentBlocks);
        }
    }

    @Override
    public void setStates() {
        super.setStates();
        this.prevPackButton.visible = this.playerInstruments.lowerKey(currentPack) != null;
        this.nextPackButton.visible = this.playerInstruments.higherKey(currentPack) != null;
        this.playerInstruments.clear();
        String firstPackSeen = null;
        for (String packID : PackParserSystem.getAllPackIDs()) {
            for (AItemPack<?> packItem : PackParserSystem.getAllItemsForPack(packID, true)) {
                if (!(packItem instanceof ItemInstrument) || !this.player.isCreative() && this.player.getInventory().getSlotForStack(packItem.getNewStack(null)) == -1) continue;
                if (!this.playerInstruments.containsKey(packID)) {
                    this.playerInstruments.put(packID, new ArrayList());
                    if (firstPackSeen == null) {
                        firstPackSeen = packID;
                    }
                }
                this.playerInstruments.get(packID).add((ItemInstrument)packItem);
            }
        }
        if (currentPack == null || this.playerInstruments.get(currentPack) == null) {
            currentPack = firstPackSeen;
        }
        if (currentPack != null) {
            this.packName.text = PackParserSystem.getPackConfiguration((String)GUIInstruments.currentPack).packName;
        }
        for (int i = 0; i < this.instrumentSlots.size(); ++i) {
            if (currentPack != null && this.playerInstruments.get(currentPack).size() > i) {
                this.instrumentSlots.get((int)i).visible = true;
                this.instrumentSlots.get((int)i).enabled = this.selectedInstrumentDefinition != null;
                this.instrumentSlotIcons.get((int)i).stack = this.playerInstruments.get(currentPack).get(i).getNewStack(null);
                continue;
            }
            this.instrumentSlots.get((int)i).visible = false;
            this.instrumentSlotIcons.get((int)i).stack = null;
        }
        for (AEntityE_Interactable<?> entity : this.entityInstrumentBlocks.keySet()) {
            for (InstrumentSlotBlock block : this.entityInstrumentBlocks.get(entity)) {
                ((InstrumentSlotBlock)block).selectorOverlay.visible = entity.equals(this.selectedEntity) && block.definition.equals(this.selectedInstrumentDefinition) && GUIInstruments.inClockPeriod(40, 20);
                boolean bl = ((InstrumentSlotBlock)block).instrument.visible = !((InstrumentSlotBlock)block).selectorOverlay.visible && entity.instruments.containsKey(((InstrumentSlotBlock)block).instrument.instrumentPackIndex);
                if (((InstrumentSlotBlock)block).instrument.visible) {
                    ((InstrumentSlotBlock)block).instrument.instrument = entity.instruments.get(((InstrumentSlotBlock)block).instrument.instrumentPackIndex);
                }
                ((InstrumentSlotBlock)block).blank.visible = !((InstrumentSlotBlock)block).selectorOverlay.visible && !((InstrumentSlotBlock)block).instrument.visible;
            }
        }
        this.hudButton.enabled = !this.hudSelected;
        this.panelButton.enabled = this.hudSelected;
        this.infoLabel.text = this.selectedInstrumentDefinition == null ? "\\/  " + InterfaceCore.translate("gui.instruments.idle") + "  \\/" : "/\\  " + InterfaceCore.translate("gui.instruments.decide") + "  /\\";
        this.clearButton.enabled = this.selectedInstrumentDefinition != null && this.selectedEntity.instruments.containsKey(((AJSONInteractableEntity)this.selectedEntity.definition).instruments.indexOf(this.selectedInstrumentDefinition));
    }

    @Override
    protected EntityVehicleF_Physics getGUILightSource() {
        return this.vehicle;
    }

    @Override
    public int getWidth() {
        return 400;
    }

    @Override
    public int getHeight() {
        return 140;
    }

    @Override
    public boolean renderFlushBottom() {
        return true;
    }

    @Override
    protected String getTexture() {
        if (this.hudSelected) {
            return ((JSONVehicle)this.vehicle.definition).motorized.hudTexture != null ? ((JSONVehicle)this.vehicle.definition).motorized.hudTexture : "mts:textures/guis/hud.png";
        }
        return ((JSONVehicle)this.vehicle.definition).motorized.panelTexture != null ? ((JSONVehicle)this.vehicle.definition).motorized.panelTexture : "mts:textures/guis/panel.png";
    }

    private class InstrumentSlotBlock {
        private final JSONInstrumentDefinition definition;
        private final GUIComponentInstrument instrument;
        private final GUIComponentButton button;
        private final GUIComponentCutout blank;
        private final GUIComponentCutout selectorOverlay;

        private InstrumentSlotBlock(int guiLeft, int guiTop, final AEntityE_Interactable<?> entity, final JSONInstrumentDefinition definition) {
            this.definition = definition;
            int instrumentRadius = (int)(64.0f * definition.hudScale);
            this.instrument = new GUIComponentInstrument(guiLeft, guiTop, ((AJSONInteractableEntity)entity.definition).instruments.indexOf(definition), entity);
            GUIInstruments.this.addComponent(this.instrument);
            this.button = new GUIComponentButton(guiLeft + definition.hudX - instrumentRadius, guiTop + definition.hudY - instrumentRadius, 2 * instrumentRadius, 2 * instrumentRadius){

                @Override
                public void onClicked(boolean leftSide) {
                    GUIInstruments.this.selectedEntity = entity;
                    GUIInstruments.this.selectedInstrumentDefinition = definition;
                }
            };
            GUIInstruments.this.addComponent(this.button);
            this.blank = new GUIComponentCutout(guiLeft + definition.hudX - instrumentRadius, guiTop + definition.hudY - instrumentRadius, 2 * instrumentRadius, 2 * instrumentRadius, 448, 0, 64, 64);
            GUIInstruments.this.addComponent(this.blank);
            this.selectorOverlay = new GUIComponentCutout(guiLeft + definition.hudX - instrumentRadius, guiTop + definition.hudY - instrumentRadius, 2 * instrumentRadius, 2 * instrumentRadius, 448, 64, 64, 64);
            GUIInstruments.this.addComponent(this.selectorOverlay);
        }
    }
}

