/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.MasterLoader;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityFluidLoader;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityFluidTank;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentItem;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.InterfaceSound;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.rendering.instances.RenderText;
import minecrafttransportsimulator.sound.SoundInstance;
import minecrafttransportsimulator.systems.CameraSystem;
import minecrafttransportsimulator.systems.PackParserSystem;

public class GUIOverlay
extends AGUIBase {
    private GUIComponentLabel mouseoverLabel;
    private GUIComponentItem scannerItem;
    private List<String> tooltipText = new ArrayList<String>();

    @Override
    public void setupComponents() {
        super.setupComponents();
        this.mouseoverLabel = new GUIComponentLabel(this.screenWidth / 2, this.screenHeight / 2, ColorRGB.WHITE, "", RenderText.TextAlignment.LEFT_ALIGNED, 1.0f);
        this.addComponent(this.mouseoverLabel);
        this.scannerItem = new GUIComponentItem(0, this.screenHeight / 4, 6.0f){

            @Override
            public boolean isMouseInBounds(int mouseX, int mouseY) {
                return true;
            }

            @Override
            public void renderTooltip(AGUIBase gui, int mouseX, int mouseY) {
                super.renderTooltip(gui, ((GUIOverlay)GUIOverlay.this).scannerItem.constructedX, ((GUIOverlay)GUIOverlay.this).scannerItem.constructedY + 144);
            }

            @Override
            public List<String> getTooltipText() {
                return GUIOverlay.this.tooltipText;
            }
        };
        this.addComponent(this.scannerItem);
    }

    @Override
    public void setStates() {
        EntityFluidTank tank;
        super.setStates();
        this.mouseoverLabel.text = "";
        this.scannerItem.stack = null;
        this.tooltipText.clear();
        AEntityF_Multipart<?> mousedOverEntity = InterfaceClient.getMousedOverEntity();
        WrapperPlayer player = InterfaceClient.getClientPlayer();
        if (player.isHoldingItemType(JSONItem.ItemComponentType.SCANNER)) {
            if (mousedOverEntity instanceof APart) {
                mousedOverEntity = ((APart)((Object)mousedOverEntity)).entityOn;
            }
            if (mousedOverEntity instanceof EntityVehicleF_Physics) {
                EntityVehicleF_Physics vehicle = (EntityVehicleF_Physics)mousedOverEntity;
                Point3d playerEyesStartVector = player.getPosition().add(0.0, player.getEyeHeight(), 0.0);
                Point3d playerEyesEndVector = playerEyesStartVector.copy().add(player.getLineOfSight(10.0));
                BoundingBox mousedOverBox = null;
                for (BoundingBox box : vehicle.allPartSlotBoxes.keySet()) {
                    if (box.getIntersectionPoint(playerEyesStartVector, playerEyesEndVector) == null || mousedOverBox != null && !(box.globalCenter.distanceTo(playerEyesStartVector) < mousedOverBox.globalCenter.distanceTo(playerEyesStartVector))) continue;
                    mousedOverBox = box;
                }
                if (mousedOverBox != null) {
                    JSONPartDefinition packVehicleDef = (JSONPartDefinition)vehicle.allPartSlotBoxes.get(mousedOverBox);
                    ArrayList<AItemPart> validParts = new ArrayList<AItemPart>();
                    for (AItemPack<?> packItem : PackParserSystem.getAllPackItems()) {
                        AItemPart part;
                        if (!(packItem instanceof AItemPart) || !(part = (AItemPart)packItem).isPartValidForPackDef(packVehicleDef, vehicle.subName, true)) continue;
                        validParts.add(part);
                    }
                    this.tooltipText.add("Types: " + packVehicleDef.types.toString());
                    this.tooltipText.add("Min/Max: " + String.valueOf(packVehicleDef.minValue) + "/" + String.valueOf(packVehicleDef.maxValue));
                    if (packVehicleDef.customTypes != null) {
                        this.tooltipText.add("CustomTypes: " + packVehicleDef.customTypes.toString());
                    } else {
                        this.tooltipText.add("CustomTypes: None");
                    }
                    if (!validParts.isEmpty()) {
                        int cycle = player.isSneaking() ? 30 : 15;
                        AItemPart partToRender = (AItemPart)validParts.get((int)(vehicle.ticksExisted / (long)cycle % (long)validParts.size()));
                        this.tooltipText.add(partToRender.getItemName());
                        this.scannerItem.stack = partToRender.getNewStack(null);
                        if (vehicle.ticksExisted % (long)cycle == 0L) {
                            InterfaceSound.playQuickSound(new SoundInstance((AEntityB_Existing)vehicle, MasterLoader.resourceDomain + ":scanner_beep"));
                        }
                    }
                }
            }
        } else if (mousedOverEntity instanceof PartInteractable) {
            EntityFluidTank tank2 = ((PartInteractable)((Object)mousedOverEntity)).tank;
            if (tank2 != null) {
                this.mouseoverLabel.text = tank2.getFluid().isEmpty() ? "EMPTY" : tank2.getFluid().toUpperCase() + " : " + tank2.getFluidLevel() + "/" + tank2.getMaxLevel();
            }
        } else if (mousedOverEntity instanceof TileEntityFluidLoader && (tank = ((TileEntityFluidLoader)((Object)mousedOverEntity)).getTank()) != null) {
            this.mouseoverLabel.text = tank.getFluid().isEmpty() ? "EMPTY" : tank.getFluid().toUpperCase() + " : " + tank.getFluidLevel() + "/" + tank.getMaxLevel();
        }
    }

    @Override
    protected boolean renderBackground() {
        return CameraSystem.customCameraOverlay != null;
    }

    @Override
    protected boolean renderBackgroundFullTexture() {
        return true;
    }

    @Override
    public boolean capturesPlayer() {
        return false;
    }

    @Override
    public int getWidth() {
        return this.screenWidth;
    }

    @Override
    public int getHeight() {
        return this.screenHeight;
    }

    @Override
    public boolean renderFlushBottom() {
        return true;
    }

    @Override
    public boolean renderTranslucent() {
        return true;
    }

    @Override
    protected String getTexture() {
        return CameraSystem.customCameraOverlay;
    }
}

