/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import minecrafttransportsimulator.MasterLoader;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponent3DModel;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.guis.components.GUIComponentTextBox;
import minecrafttransportsimulator.guis.instances.GUIPackEditor;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.packloading.JSONParser;
import minecrafttransportsimulator.systems.PackParserSystem;

public class GUIPackExporter
extends AGUIBase {
    private GUIComponentButton modelRenderButton;
    private GUIComponentButton packExportButton;
    private GUIComponentButton packImportButton;
    private GUIComponentButton packEditorButton;
    private GUIComponentTextBox debug;
    private final EntityVehicleF_Physics vehicleClicked;
    private List<GUIComponentTextBox> dataEntryBoxes = new ArrayList<GUIComponentTextBox>();
    private List<GUIComponentLabel> dataEntryLabels = new ArrayList<GUIComponentLabel>();
    private GUIComponentButton backButton;
    private GUIComponentButton confirmButton;
    private GUIComponent3DModel componentItemModel;

    public GUIPackExporter(EntityVehicleF_Physics vehicleClicked) {
        this.vehicleClicked = vehicleClicked;
    }

    @Override
    public void setupComponents() {
        super.setupComponents();
        int buttonWidth = 87;
        int buttonOffset = -(350 - this.getWidth()) / 2;
        this.packExportButton = new GUIComponentButton(this.guiLeft + buttonOffset, this.guiTop + 0, buttonWidth, 20, "EXPORT PACKS"){

            @Override
            public void onClicked(boolean leftSide) {
                File jsonDir = new File(MasterLoader.gameDirectory, "mts_dev");
                if (!jsonDir.exists() && !jsonDir.mkdir()) {
                    GUIPackExporter.this.debug.setText("ERROR: Could not create dev folder: " + jsonDir.getAbsolutePath() + "\nIs this location write-protected?");
                    return;
                }
                File lastModifiedFile = new File(jsonDir, "lastexported.txt");
                if (lastModifiedFile.exists()) {
                    GUIPackExporter.this.debug.setText("\nWARNING: Existing export detected!  Exporting will not continue.  Either delete the mts_dev folder, or the lastexported.txt file and try again.");
                    return;
                }
                long lastTimeModified = 0L;
                GUIPackExporter.this.debug.setText("Export dir is: " + jsonDir.getAbsolutePath());
                for (String packID : PackParserSystem.getAllPackIDs()) {
                    File packDir = new File(jsonDir, packID);
                    if (!packDir.exists() && !packDir.mkdir()) {
                        GUIPackExporter.this.debug.setText("ERROR: Could not create pack folder: " + packDir.getAbsolutePath() + "\nIs this location write-protected?");
                        return;
                    }
                    for (AItemPack<?> packItem : PackParserSystem.getAllItemsForPack(packID, false)) {
                        try {
                            File jsonFile = new File(packDir, ((AJSONItem)packItem.definition).classification.toDirectory() + ((AJSONItem)packItem.definition).prefixFolders);
                            jsonFile.mkdirs();
                            jsonFile = new File(jsonFile, ((AJSONItem)packItem.definition).systemName + ".json");
                            FileWriter writer = new FileWriter(jsonFile);
                            JSONParser.exportStream(packItem.definition, writer);
                            lastTimeModified = jsonFile.lastModified();
                            writer.flush();
                            writer.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            GUIPackExporter.this.debug.setText("ERROR: Could not save pack definition to disk.  Error is:\n" + e.getMessage());
                            return;
                        }
                    }
                    GUIPackExporter.this.debug.setText(GUIPackExporter.this.debug.getText() + "\nExported pack: " + packID);
                }
                try {
                    FileWriter writer = new FileWriter(lastModifiedFile);
                    writer.write(String.valueOf(lastTimeModified));
                    writer.flush();
                    writer.close();
                    GUIPackExporter.this.debug.setText(GUIPackExporter.this.debug.getText() + "\nExporting finished.");
                }
                catch (IOException e) {
                    GUIPackExporter.this.debug.setText("\nERROR: Could not save last modified timestamp to disk.  Error is:\n" + e.getMessage());
                    return;
                }
            }
        };
        this.addComponent(this.packExportButton);
        this.packImportButton = new GUIComponentButton(this.guiLeft + buttonWidth + buttonOffset, this.guiTop + 0, buttonWidth, 20, "IMPORT PACKS"){

            @Override
            public void onClicked(boolean leftSide) {
                File jsonDir = new File(MasterLoader.gameDirectory, "mts_dev");
                if (jsonDir.exists()) {
                    GUIPackExporter.this.debug.setText("Import dir is: " + jsonDir.getAbsolutePath());
                    File lastModifiedFile = new File(jsonDir, "lastexported.txt");
                    if (lastModifiedFile.exists()) {
                        long lastTimeModified;
                        try {
                            FileReader reader = new FileReader(lastModifiedFile);
                            BufferedReader buffer = new BufferedReader(reader);
                            lastTimeModified = Long.valueOf(buffer.readLine());
                            buffer.close();
                        }
                        catch (Exception e) {
                            GUIPackExporter.this.debug.setText("\nERROR: Could not read last modified timestamp from disk.  Error is:\n" + e.getMessage());
                            return;
                        }
                        HashSet<File> parsedFiles = new HashSet<File>();
                        for (String packID : PackParserSystem.getAllPackIDs()) {
                            File packDir = new File(jsonDir, packID);
                            if (!packDir.exists()) continue;
                            for (AItemPack<?> packItem : PackParserSystem.getAllItemsForPack(packID, false)) {
                                File jsonFile = new File(packDir, ((AJSONItem)packItem.definition).classification.toDirectory() + ((AJSONItem)packItem.definition).prefixFolders + ((AJSONItem)packItem.definition).systemName + ".json");
                                if (parsedFiles.contains(jsonFile)) continue;
                                if (jsonFile.lastModified() > lastTimeModified) {
                                    GUIPackExporter.this.debug.setText(GUIPackExporter.this.debug.getText() + JSONParser.hotloadJSON(jsonFile, packItem.definition));
                                }
                                parsedFiles.add(jsonFile);
                            }
                        }
                        GUIPackExporter.this.debug.setText(GUIPackExporter.this.debug.getText() + "\nImporting finished.");
                    } else {
                        GUIPackExporter.this.debug.setText("ERROR: No last modified timestamp file found at location: " + lastModifiedFile.getAbsolutePath() + "\nPlease re-export your pack data.");
                    }
                } else {
                    GUIPackExporter.this.debug.setText("ERROR: Could not find dev folder: " + jsonDir.getAbsolutePath());
                }
            }
        };
        this.addComponent(this.packImportButton);
        this.modelRenderButton = new GUIComponentButton(this.guiLeft + 2 * buttonWidth + buttonOffset, this.guiTop + 0, buttonWidth, 20, "MODEL RENDER"){

            @Override
            public void onClicked(boolean leftSide) {
                ((GUIPackExporter)GUIPackExporter.this).modelRenderButton.visible = false;
                ((GUIPackExporter)GUIPackExporter.this).packExportButton.visible = false;
                ((GUIPackExporter)GUIPackExporter.this).packImportButton.visible = false;
                ((GUIPackExporter)GUIPackExporter.this).packEditorButton.visible = false;
                ((GUIPackExporter)GUIPackExporter.this).debug.visible = false;
                ((GUIPackExporter)GUIPackExporter.this).componentItemModel.visible = true;
                ((GUIPackExporter)GUIPackExporter.this).backButton.visible = true;
                ((GUIPackExporter)GUIPackExporter.this).confirmButton.visible = true;
                for (int i = 0; i < GUIPackExporter.this.dataEntryBoxes.size(); i = (int)((byte)(i + 1))) {
                    ((GUIComponentTextBox)((GUIPackExporter)GUIPackExporter.this).dataEntryBoxes.get((int)i)).visible = true;
                }
            }
        };
        this.addComponent(this.modelRenderButton);
        this.packEditorButton = new GUIComponentButton(this.guiLeft + 3 * buttonWidth + buttonOffset, this.guiTop + 0, buttonWidth, 20, "PACK EDITOR"){

            @Override
            public void onClicked(boolean leftSide) {
                new GUIPackEditor();
            }
        };
        this.addComponent(this.packEditorButton);
        this.backButton = new GUIComponentButton(this.guiLeft + 20, this.guiTop + 140, 60, 20, "BACK"){

            @Override
            public void onClicked(boolean leftSide) {
                ((GUIPackExporter)GUIPackExporter.this).modelRenderButton.visible = true;
                ((GUIPackExporter)GUIPackExporter.this).packExportButton.visible = true;
                ((GUIPackExporter)GUIPackExporter.this).packImportButton.visible = true;
                ((GUIPackExporter)GUIPackExporter.this).packEditorButton.visible = true;
                ((GUIPackExporter)GUIPackExporter.this).debug.visible = true;
                ((GUIPackExporter)GUIPackExporter.this).componentItemModel.visible = false;
                ((GUIPackExporter)GUIPackExporter.this).backButton.visible = false;
                ((GUIPackExporter)GUIPackExporter.this).confirmButton.visible = false;
                for (int i = 0; i < GUIPackExporter.this.dataEntryBoxes.size(); i = (int)((byte)(i + 1))) {
                    ((GUIComponentTextBox)((GUIPackExporter)GUIPackExporter.this).dataEntryBoxes.get((int)i)).visible = false;
                }
            }
        };
        this.addComponent(this.backButton);
        this.confirmButton = new GUIComponentButton(this.guiLeft + 100, this.guiTop + 140, 60, 20, "CONFIRM"){

            @Override
            public void onClicked(boolean leftSide) {
                try {
                    int dataEntryBoxIndex = 0;
                    ((GUIPackExporter)GUIPackExporter.this).componentItemModel.modelLocation = String.valueOf(((GUIComponentTextBox)GUIPackExporter.this.dataEntryBoxes.get(dataEntryBoxIndex++)).getText());
                    ((GUIPackExporter)GUIPackExporter.this).componentItemModel.textureLocation = String.valueOf(((GUIComponentTextBox)GUIPackExporter.this.dataEntryBoxes.get(dataEntryBoxIndex++)).getText());
                    ((GUIPackExporter)GUIPackExporter.this).componentItemModel.position.x = ((GUIPackExporter)GUIPackExporter.this).componentItemModel.constructedX + Integer.valueOf(((GUIComponentTextBox)GUIPackExporter.this.dataEntryBoxes.get(dataEntryBoxIndex++)).getText());
                    ((GUIPackExporter)GUIPackExporter.this).componentItemModel.position.y = -((GUIPackExporter)GUIPackExporter.this).componentItemModel.constructedY - Integer.valueOf(((GUIComponentTextBox)GUIPackExporter.this.dataEntryBoxes.get(dataEntryBoxIndex++)).getText());
                    ((GUIPackExporter)GUIPackExporter.this).componentItemModel.scale = Float.valueOf(((GUIComponentTextBox)GUIPackExporter.this.dataEntryBoxes.get(dataEntryBoxIndex++)).getText()).floatValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.addComponent(this.confirmButton);
        this.debug = new GUIComponentTextBox(this.guiLeft + buttonOffset, this.guiTop + 20, 350, this.getHeight() - 20, "", ColorRGB.WHITE, 1200);
        this.addComponent(this.debug);
        this.dataEntryBoxes.clear();
        this.dataEntryLabels.clear();
        int currentRow = 15;
        for (int i = 0; i < 5; i = (int)((byte)(i + 1))) {
            int height = i < 2 ? 40 : 10;
            GUIComponentTextBox dataEntryBox = new GUIComponentTextBox(this.guiLeft + 100, this.guiTop + currentRow, 140, height, "", ColorRGB.WHITE, 100);
            GUIComponentLabel dataEntryLabel = new GUIComponentLabel(this.guiLeft + 15, dataEntryBox.constructedY, ColorRGB.WHITE, "").setBox(dataEntryBox);
            this.dataEntryBoxes.add(dataEntryBox);
            this.dataEntryLabels.add(dataEntryLabel);
            this.addComponent(dataEntryBox);
            this.addComponent(dataEntryLabel);
            currentRow += height + 1;
        }
        this.componentItemModel = new GUIComponent3DModel(this.guiLeft, this.guiTop, 1.0f, true, false, true);
        this.componentItemModel.position.add(208.0, -205.0, 0.0);
        this.componentItemModel.scale = 6.0f;
        this.addComponent(this.componentItemModel);
        int labelBoxIndex = 0;
        this.dataEntryLabels.get((int)labelBoxIndex).text = "Model:";
        this.dataEntryBoxes.get(labelBoxIndex++).setText(((JSONVehicle)this.vehicleClicked.definition).getModelLocation(this.vehicleClicked.subName));
        this.dataEntryLabels.get((int)labelBoxIndex).text = "Texture:";
        this.dataEntryBoxes.get(labelBoxIndex++).setText(((JSONVehicle)this.vehicleClicked.definition).getTextureLocation(this.vehicleClicked.subName));
        this.dataEntryLabels.get((int)labelBoxIndex).text = "X-Pos (px):";
        this.dataEntryBoxes.get(labelBoxIndex++).setText(String.valueOf((int)this.componentItemModel.position.x - this.componentItemModel.constructedX));
        this.dataEntryLabels.get((int)labelBoxIndex).text = "Y-Pos (px):";
        this.dataEntryBoxes.get(labelBoxIndex++).setText(String.valueOf((int)(-this.componentItemModel.position.y) + this.componentItemModel.constructedY));
        this.dataEntryLabels.get((int)labelBoxIndex).text = "Scale (1blk=1px):";
        this.dataEntryBoxes.get(labelBoxIndex++).setText(String.valueOf(this.componentItemModel.scale));
        this.backButton.onClicked(false);
    }

    @Override
    public void setStates() {
        super.setStates();
        try {
            this.componentItemModel.position.x = this.componentItemModel.constructedX + Integer.valueOf(this.dataEntryBoxes.get(2).getText());
            this.componentItemModel.position.y = this.componentItemModel.constructedY - Integer.valueOf(this.dataEntryBoxes.get(3).getText());
            this.componentItemModel.scale = Float.valueOf(this.dataEntryBoxes.get(4).getText()).floatValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected boolean renderBackground() {
        return this.componentItemModel != null && this.componentItemModel.visible;
    }

    @Override
    public int getWidth() {
        return super.getWidth();
    }
}

