/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponent3DModel;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentItem;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.packets.instances.PacketEntityColorChange;
import minecrafttransportsimulator.packloading.PackMaterialComponent;
import minecrafttransportsimulator.rendering.instances.RenderText;
import minecrafttransportsimulator.systems.PackParserSystem;

public class GUIPaintGun
extends AGUIBase {
    private final AEntityD_Definable<?> entity;
    private final WrapperPlayer player;
    private GUIComponentLabel partName;
    private GUIComponentButton prevColorButton;
    private GUIComponentButton nextColorButton;
    private GUIComponentButton confirmButton;
    private final List<GUIComponentItem> craftingItemIcons = new ArrayList<GUIComponentItem>();
    private GUIComponent3DModel modelRender;
    private AItemSubTyped<?> currentItem;
    private AItemSubTyped<?> prevSubItem;
    private AItemSubTyped<?> nextSubItem;

    public GUIPaintGun(AEntityD_Definable<?> entity, WrapperPlayer player) {
        this.entity = entity;
        this.player = player;
        this.currentItem = (AItemSubTyped)PackParserSystem.getItem(((AJSONMultiModelProvider)entity.definition).packID, ((AJSONMultiModelProvider)entity.definition).systemName, entity.subName);
    }

    @Override
    public void setupComponents() {
        super.setupComponents();
        this.prevColorButton = new GUIComponentButton(this.guiLeft + 38, this.guiTop + 135, 20, 20, 40, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPaintGun.this.currentItem = GUIPaintGun.this.prevSubItem;
                GUIPaintGun.this.updateNames();
            }
        };
        this.addComponent(this.prevColorButton);
        this.nextColorButton = new GUIComponentButton(this.guiLeft + 160, this.guiTop + 135, 20, 20, 60, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPaintGun.this.currentItem = GUIPaintGun.this.nextSubItem;
                GUIPaintGun.this.updateNames();
            }
        };
        this.addComponent(this.nextColorButton);
        this.partName = new GUIComponentLabel(this.guiLeft + 60, this.guiTop + 120, ColorRGB.WHITE, "", RenderText.TextAlignment.LEFT_ALIGNED, 1.0f, 98);
        this.addComponent(this.partName);
        this.craftingItemIcons.clear();
        for (int i = 0; i < 8; i = (int)((byte)(i + 1))) {
            GUIComponentItem craftingItem = new GUIComponentItem(this.guiLeft + 225 + 18 * (i / 4), this.guiTop + 26 + 18 * (i % 4), 1.0f);
            this.addComponent(craftingItem);
            this.craftingItemIcons.add(craftingItem);
        }
        this.modelRender = new GUIComponent3DModel(this.guiLeft + 109, this.guiTop + 57, 32.0f, true, true, false);
        this.addComponent(this.modelRender);
        this.confirmButton = new GUIComponentButton(this.guiLeft + 99, this.guiTop + 167, 20, 20, 20, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                InterfacePacket.sendToServer(new PacketEntityColorChange(GUIPaintGun.this.entity, GUIPaintGun.this.player, GUIPaintGun.this.currentItem));
                GUIPaintGun.this.close();
            }
        };
        this.addComponent(this.confirmButton);
        this.updateNames();
    }

    @Override
    public void setStates() {
        super.setStates();
        this.prevColorButton.enabled = this.prevSubItem != null;
        this.nextColorButton.enabled = this.nextSubItem != null;
        this.confirmButton.enabled = this.currentItem != null && (this.player.isCreative() || this.player.getInventory().hasMaterials(this.currentItem, false, true, false));
    }

    @Override
    public int getWidth() {
        return 327;
    }

    @Override
    public int getHeight() {
        return 196;
    }

    @Override
    protected String getTexture() {
        return "mts:textures/guis/repainting.png";
    }

    private void updateNames() {
        int i;
        List<AItemPack<?>> packItems = PackParserSystem.getAllItemsForPack(((AJSONMultiModelProvider)this.currentItem.definition).packID, true);
        int currentItemIndex = packItems.indexOf(this.currentItem);
        this.nextSubItem = null;
        if (currentItemIndex < packItems.size()) {
            for (i = currentItemIndex + 1; i < packItems.size() && this.nextSubItem == null; ++i) {
                if (!((AJSONItem)packItems.get((int)i).definition).systemName.equals(((AJSONMultiModelProvider)this.currentItem.definition).systemName)) continue;
                this.nextSubItem = (AItemSubTyped)packItems.get(i);
                break;
            }
        }
        this.prevSubItem = null;
        if (currentItemIndex > 0) {
            for (i = currentItemIndex - 1; i >= 0 && this.prevSubItem == null; --i) {
                if (!((AJSONItem)packItems.get((int)i).definition).systemName.equals(((AJSONMultiModelProvider)this.currentItem.definition).systemName)) continue;
                this.prevSubItem = (AItemSubTyped)packItems.get(i);
                break;
            }
        }
        this.partName.text = this.currentItem.getItemName();
        List<PackMaterialComponent> materials = PackMaterialComponent.parseFromJSON(this.currentItem, false, true, false, false);
        for (int i2 = 0; i2 < this.craftingItemIcons.size(); i2 = (int)((byte)(i2 + 1))) {
            this.craftingItemIcons.get((int)i2).stacks = i2 < materials.size() ? materials.get((int)i2).possibleItems : null;
        }
        this.modelRender.modelLocation = ((AJSONMultiModelProvider)this.currentItem.definition).getModelLocation(this.currentItem.subName);
        this.modelRender.textureLocation = ((AJSONMultiModelProvider)this.currentItem.definition).getTextureLocation(this.currentItem.subName);
    }
}

