/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.TrailerConnection;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.guis.components.GUIComponentSelector;
import minecrafttransportsimulator.guis.components.GUIComponentTextBox;
import minecrafttransportsimulator.guis.instances.AGUIPanel;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableIncrement;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableSet;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableToggle;
import minecrafttransportsimulator.packets.instances.PacketVehicleBeaconChange;
import minecrafttransportsimulator.rendering.instances.RenderText;
import minecrafttransportsimulator.systems.ConfigSystem;

public class GUIPanelAircraft
extends AGUIPanel {
    private static final int NAVIGATION_TEXTURE_WIDTH_OFFSET = 200;
    private static final int NAVIGATION_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int STROBE_TEXTURE_WIDTH_OFFSET = 220;
    private static final int STROBE_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int TAXI_TEXTURE_WIDTH_OFFSET = 240;
    private static final int TAXI_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int LANDING_TEXTURE_WIDTH_OFFSET = 260;
    private static final int LANDING_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int ENGINEMAG_TEXTURE_WIDTH_OFFSET = 280;
    private static final int ENGINEMAG_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int ENGINESTART_TEXTURE_WIDTH_OFFSET = 300;
    private static final int ENGINESTART_TEXTURE_HEIGHT_OFFSET = 196;
    private static final int REVERSE_TEXTURE_WIDTH_OFFSET = 320;
    private static final int REVERSE_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int TRIM_TEXTURE_WIDTH_OFFSET = 340;
    private static final int TRIM_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int AUTOPILOT_TEXTURE_WIDTH_OFFSET = 380;
    private static final int AUTOPILOT_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int GEAR_TEXTURE_WIDTH_OFFSET = 400;
    private static final int GEAR_TEXTURE_HEIGHT_OFFSET = 176;
    private static final int CUSTOM_TEXTURE_WIDTH_OFFSET = 420;
    private static final int CUSTOM_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int TRAILER_TEXTURE_WIDTH_OFFSET = 440;
    private static final int TRAILER_TEXTURE_HEIGHT_OFFSET = 216;
    private final Map<String, GUIComponentSelector> lightSelectors = new HashMap<String, GUIComponentSelector>();
    private final Map<Byte, GUIComponentSelector> magnetoSelectors = new HashMap<Byte, GUIComponentSelector>();
    private final Map<Byte, GUIComponentSelector> starterSelectors = new HashMap<Byte, GUIComponentSelector>();
    private final List<GUIComponentSelector> customSelectors = new ArrayList<GUIComponentSelector>();
    private GUIComponentSelector aileronTrimSelector;
    private GUIComponentSelector elevatorTrimSelector;
    private GUIComponentSelector rudderTrimSelector;
    private GUIComponentSelector reverseSelector;
    private GUIComponentSelector autopilotSelector;
    private GUIComponentSelector gearSelector;
    private GUIComponentSelector trailerSelector;
    private GUIComponentTextBox beaconBox;
    private GUIComponentSelector selectedTrimSelector;
    private String selectedTrimVariable = null;
    private double selectedTrimBounds = 0.0;
    private double selectedTrimIncrement = 0.0;
    private boolean appliedTrimThisRender;

    public GUIPanelAircraft(EntityVehicleF_Physics aircraft) {
        super(aircraft);
    }

    @Override
    protected void setupLightComponents(int guiLeft, int guiTop) {
        GUIComponentSelector lightSwitch;
        this.lightSelectors.clear();
        if (((JSONVehicle)this.vehicle.definition).motorized.hasNavLights) {
            lightSwitch = new GUIComponentSelector(guiLeft + this.xOffset, guiTop + 12 + this.lightSelectors.size() * 32, 20, 20, "NAV", ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 200, 216, 20, 20){

                @Override
                public void onClicked(boolean leftSide) {
                    InterfacePacket.sendToServer(new PacketEntityVariableToggle(GUIPanelAircraft.this.vehicle, "navigation_light"));
                }

                @Override
                public void onReleased() {
                }
            };
            this.lightSelectors.put("navigation_light", lightSwitch);
            this.addComponent(lightSwitch);
        }
        if (((JSONVehicle)this.vehicle.definition).motorized.hasStrobeLights) {
            lightSwitch = new GUIComponentSelector(guiLeft + this.xOffset, guiTop + 12 + this.lightSelectors.size() * 32, 20, 20, "STROBE", ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 220, 216, 20, 20){

                @Override
                public void onClicked(boolean leftSide) {
                    InterfacePacket.sendToServer(new PacketEntityVariableToggle(GUIPanelAircraft.this.vehicle, "strobe_light"));
                }

                @Override
                public void onReleased() {
                }
            };
            this.lightSelectors.put("strobe_light", lightSwitch);
            this.addComponent(lightSwitch);
        }
        if (((JSONVehicle)this.vehicle.definition).motorized.hasTaxiLights) {
            lightSwitch = new GUIComponentSelector(guiLeft + this.xOffset, guiTop + 12 + this.lightSelectors.size() * 32, 20, 20, "TAXI", ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 240, 216, 20, 20){

                @Override
                public void onClicked(boolean leftSide) {
                    InterfacePacket.sendToServer(new PacketEntityVariableToggle(GUIPanelAircraft.this.vehicle, "taxi_light"));
                }

                @Override
                public void onReleased() {
                }
            };
            this.lightSelectors.put("taxi_light", lightSwitch);
            this.addComponent(lightSwitch);
        }
        if (((JSONVehicle)this.vehicle.definition).motorized.hasLandingLights) {
            lightSwitch = new GUIComponentSelector(guiLeft + this.xOffset, guiTop + 12 + this.lightSelectors.size() * 32, 20, 20, "LAND", ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 260, 216, 20, 20){

                @Override
                public void onClicked(boolean leftSide) {
                    InterfacePacket.sendToServer(new PacketEntityVariableToggle(GUIPanelAircraft.this.vehicle, "landing_light"));
                }

                @Override
                public void onReleased() {
                }
            };
            this.lightSelectors.put("landing_light", lightSwitch);
            this.addComponent(lightSwitch);
        }
    }

    @Override
    protected void setupEngineComponents(int guiLeft, int guiTop) {
        this.magnetoSelectors.clear();
        this.starterSelectors.clear();
        if (((JSONVehicle)this.vehicle.definition).motorized.hasSingleEngineControl) {
            if (!this.vehicle.engines.isEmpty()) {
                GUIComponentSelector magnetoSwitch = new GUIComponentSelector(guiLeft + this.xOffset, guiTop + 12, 20, 20, InterfaceCore.translate("gui.panel.magneto"), ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 280, 216, 20, 20){

                    @Override
                    public void onClicked(boolean leftSide) {
                        for (PartEngine engine : GUIPanelAircraft.this.vehicle.engines.values()) {
                            InterfacePacket.sendToServer(new PacketEntityVariableToggle(engine, "engine_magneto"));
                        }
                    }

                    @Override
                    public void onReleased() {
                    }
                };
                this.magnetoSelectors.put((byte)-1, magnetoSwitch);
                this.addComponent(magnetoSwitch);
                GUIComponentSelector starterSwitch = new GUIComponentSelector(magnetoSwitch.constructedX + 20, magnetoSwitch.constructedY, 20, 20, InterfaceCore.translate("gui.panel.start"), ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 300, 196, 20, 20){

                    @Override
                    public void onClicked(boolean leftSide) {
                        for (PartEngine engine : GUIPanelAircraft.this.vehicle.engines.values()) {
                            if (!engine.magnetoOn || engine.electricStarterEngaged) continue;
                            InterfacePacket.sendToServer(new PacketEntityVariableToggle(engine, "engine_starter"));
                        }
                    }

                    @Override
                    public void onReleased() {
                        for (PartEngine engine : GUIPanelAircraft.this.vehicle.engines.values()) {
                            if (!engine.magnetoOn || !engine.electricStarterEngaged) continue;
                            InterfacePacket.sendToServer(new PacketEntityVariableToggle(engine, "engine_starter"));
                        }
                    }
                };
                this.starterSelectors.put((byte)-1, starterSwitch);
                this.addComponent(starterSwitch);
            }
        } else {
            for (final Byte engineNumber : this.vehicle.engines.keySet()) {
                if (engineNumber == 4) {
                    this.xOffset += 52;
                }
                GUIComponentSelector magnetoSwitch = new GUIComponentSelector(guiLeft + this.xOffset, guiTop + 12 + 32 * (engineNumber % 4), 20, 20, InterfaceCore.translate("gui.panel.magneto"), ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 280, 216, 20, 20){

                    @Override
                    public void onClicked(boolean leftSide) {
                        InterfacePacket.sendToServer(new PacketEntityVariableToggle((AEntityD_Definable)GUIPanelAircraft.this.vehicle.engines.get((Object)engineNumber), "engine_magneto"));
                    }

                    @Override
                    public void onReleased() {
                    }
                };
                this.magnetoSelectors.put(engineNumber, magnetoSwitch);
                this.addComponent(magnetoSwitch);
                GUIComponentSelector starterSwitch = new GUIComponentSelector(magnetoSwitch.constructedX + 20, magnetoSwitch.constructedY, 20, 20, InterfaceCore.translate("gui.panel.start"), ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 300, 196, 20, 20){

                    @Override
                    public void onClicked(boolean leftSide) {
                        PartEngine engine = (PartEngine)GUIPanelAircraft.this.vehicle.engines.get((Object)engineNumber);
                        if (engine.magnetoOn && !engine.electricStarterEngaged) {
                            InterfacePacket.sendToServer(new PacketEntityVariableToggle(engine, "engine_starter"));
                        }
                    }

                    @Override
                    public void onReleased() {
                        PartEngine engine = (PartEngine)GUIPanelAircraft.this.vehicle.engines.get((Object)engineNumber);
                        if (engine.magnetoOn && engine.electricStarterEngaged) {
                            InterfacePacket.sendToServer(new PacketEntityVariableToggle(engine, "engine_starter"));
                        }
                    }
                };
                this.starterSelectors.put(engineNumber, starterSwitch);
                this.addComponent(starterSwitch);
            }
        }
        this.xOffset += 20;
    }

    @Override
    protected void setupGeneralComponents(int guiLeft, int guiTop) {
        this.aileronTrimSelector = new GUIComponentSelector(guiLeft + this.xOffset, guiTop + 12 + 0, 40, 20, InterfaceCore.translate("gui.panel.trim_roll"), ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 340, 216, 40, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPanelAircraft.this.selectedTrimSelector = this;
                GUIPanelAircraft.this.selectedTrimVariable = "trim_aileron";
                GUIPanelAircraft.this.selectedTrimBounds = 10.0;
                GUIPanelAircraft.this.selectedTrimIncrement = !leftSide ? 0.1 : -0.1;
            }

            @Override
            public void onReleased() {
                GUIPanelAircraft.this.selectedTrimVariable = null;
            }
        };
        this.addComponent(this.aileronTrimSelector);
        this.elevatorTrimSelector = new GUIComponentSelector(guiLeft + this.xOffset, guiTop + 12 + 32, 40, 20, InterfaceCore.translate("gui.panel.trim_pitch"), ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 340, 216, 40, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPanelAircraft.this.selectedTrimSelector = this;
                GUIPanelAircraft.this.selectedTrimVariable = "trim_elevator";
                GUIPanelAircraft.this.selectedTrimBounds = 10.0;
                GUIPanelAircraft.this.selectedTrimIncrement = leftSide ? 0.1 : -0.1;
            }

            @Override
            public void onReleased() {
                GUIPanelAircraft.this.selectedTrimVariable = null;
            }
        };
        this.addComponent(this.elevatorTrimSelector);
        this.rudderTrimSelector = new GUIComponentSelector(guiLeft + this.xOffset, guiTop + 12 + 64, 40, 20, InterfaceCore.translate("gui.panel.trim_yaw"), ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 340, 216, 40, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPanelAircraft.this.selectedTrimSelector = this;
                GUIPanelAircraft.this.selectedTrimVariable = "trim_rudder";
                GUIPanelAircraft.this.selectedTrimBounds = 10.0;
                GUIPanelAircraft.this.selectedTrimIncrement = !leftSide ? 0.1 : -0.1;
            }

            @Override
            public void onReleased() {
                GUIPanelAircraft.this.selectedTrimVariable = null;
            }
        };
        this.addComponent(this.rudderTrimSelector);
        if (this.haveReverseThrustOption && ((JSONVehicle)this.vehicle.definition).motorized.hasAutopilot) {
            this.reverseSelector = new GUIComponentSelector(guiLeft + this.xOffset, guiTop + 12 + 96, 20, 20, InterfaceCore.translate("gui.panel.reverse"), ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 320, 216, 20, 20){

                @Override
                public void onClicked(boolean leftSide) {
                    InterfacePacket.sendToServer(new PacketEntityVariableToggle(GUIPanelAircraft.this.vehicle, "reverser"));
                }

                @Override
                public void onReleased() {
                }
            };
            this.addComponent(this.reverseSelector);
            this.autopilotSelector = new GUIComponentSelector(guiLeft + this.xOffset + 20, guiTop + 12 + 96, 20, 20, InterfaceCore.translate("gui.panel.autopilot"), ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 380, 216, 20, 20){

                @Override
                public void onClicked(boolean leftSide) {
                    if (GUIPanelAircraft.this.vehicle.autopilotSetting == 0.0) {
                        InterfacePacket.sendToServer(new PacketEntityVariableSet(GUIPanelAircraft.this.vehicle, "autopilot", GUIPanelAircraft.this.vehicle.position.y));
                    } else {
                        InterfacePacket.sendToServer(new PacketEntityVariableSet(GUIPanelAircraft.this.vehicle, "autopilot", 0.0));
                    }
                }

                @Override
                public void onReleased() {
                }
            };
            this.addComponent(this.autopilotSelector);
        } else if (this.haveReverseThrustOption) {
            this.reverseSelector = new GUIComponentSelector(guiLeft + this.xOffset + 10, guiTop + 12 + 96, 20, 20, InterfaceCore.translate("gui.panel.reverse"), ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 320, 216, 20, 20){

                @Override
                public void onClicked(boolean leftSide) {
                    InterfacePacket.sendToServer(new PacketEntityVariableToggle(GUIPanelAircraft.this.vehicle, "reverser"));
                }

                @Override
                public void onReleased() {
                }
            };
            this.addComponent(this.reverseSelector);
        } else if (((JSONVehicle)this.vehicle.definition).motorized.hasAutopilot) {
            this.autopilotSelector = new GUIComponentSelector(guiLeft + this.xOffset + 10, guiTop + 12 + 96, 20, 20, InterfaceCore.translate("gui.panel.autopilot"), ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 380, 216, 20, 20){

                @Override
                public void onClicked(boolean leftSide) {
                    if (GUIPanelAircraft.this.vehicle.autopilotSetting == 0.0) {
                        InterfacePacket.sendToServer(new PacketEntityVariableSet(GUIPanelAircraft.this.vehicle, "autopilot", GUIPanelAircraft.this.vehicle.position.y));
                    } else {
                        InterfacePacket.sendToServer(new PacketEntityVariableSet(GUIPanelAircraft.this.vehicle, "autopilot", 0.0));
                    }
                }

                @Override
                public void onReleased() {
                }
            };
            this.addComponent(this.autopilotSelector);
        }
        this.xOffset += 20;
    }

    @Override
    public void setupCustomComponents(int guiLeft, int guiTop) {
        LinkedHashSet<String> customVariables = new LinkedHashSet<String>();
        if (((JSONVehicle)this.vehicle.definition).rendering.customVariables != null) {
            customVariables.addAll(((JSONVehicle)this.vehicle.definition).rendering.customVariables);
        }
        for (APart part : this.vehicle.parts) {
            if (((JSONPart)part.definition).rendering == null || ((JSONPart)part.definition).rendering.customVariables == null) continue;
            customVariables.addAll(((JSONPart)part.definition).rendering.customVariables);
        }
        int variableNumber = 0;
        for (String customVariable : customVariables) {
            GUIComponentSelector customSelector = new GUIComponentSelector(guiLeft + this.xOffset + variableNumber % 2 * 20, guiTop + 12 + variableNumber / 2 * 32, 20, 20, customVariable, ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 420, 216, 20, 20){

                @Override
                public void onClicked(boolean leftSide) {
                    InterfacePacket.sendToServer(new PacketEntityVariableToggle(GUIPanelAircraft.this.vehicle, this.text));
                }

                @Override
                public void onReleased() {
                }
            };
            this.customSelectors.add(customSelector);
            this.addComponent(customSelector);
            ++variableNumber;
        }
        if (((JSONVehicle)this.vehicle.definition).motorized.hasRadioNav || ((Boolean)ConfigSystem.configObject.general.allPlanesWithNav.value).booleanValue()) {
            this.beaconBox = new GUIComponentTextBox(guiLeft + this.xOffset, guiTop + 12 + 64, 40, 20, this.vehicle.selectedBeaconName, this.vehicle.selectedBeacon != null ? ColorRGB.GREEN : ColorRGB.RED, 5, 340, 196, 40, 20){

                @Override
                public void handleKeyTyped(char typedChar, int typedCode, GUIComponentTextBox.TextBoxControlKey control) {
                    super.handleKeyTyped(typedChar, typedCode, control);
                    InterfacePacket.sendToServer(new PacketVehicleBeaconChange(GUIPanelAircraft.this.vehicle, this.getText()));
                }
            };
            this.addComponent(this.beaconBox);
            this.addComponent(new GUIComponentLabel(this.beaconBox.constructedX + this.beaconBox.width / 2, this.beaconBox.constructedY + this.beaconBox.height + 1, ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor != null ? ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor : ColorRGB.WHITE, InterfaceCore.translate("gui.panel.beacon"), RenderText.TextAlignment.CENTERED, 0.75f).setBox(this.beaconBox));
        }
        if (((JSONVehicle)this.vehicle.definition).motorized.gearSequenceDuration != 0 && !this.trailerSwitchDefs.isEmpty()) {
            this.gearSelector = new GUIComponentSelector(guiLeft + this.xOffset, guiTop + 12 + 96, 20, 20, InterfaceCore.translate("gui.panel.gear"), ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 400, 176, 20, 20){

                @Override
                public void onClicked(boolean leftSide) {
                    InterfacePacket.sendToServer(new PacketEntityVariableToggle(GUIPanelAircraft.this.vehicle, "gear_setpoint"));
                }

                @Override
                public void onReleased() {
                }
            };
            this.addComponent(this.gearSelector);
            this.trailerSelector = new GUIComponentSelector(guiLeft + this.xOffset + 20, guiTop + 12 + 96, 20, 20, ((AGUIPanel.SwitchEntry)this.trailerSwitchDefs.get((int)0)).connectionGroup.groupName, ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 440, 216, 20, 20){

                @Override
                public void onClicked(boolean leftSide) {
                    AGUIPanel.SwitchEntry switchDef = (AGUIPanel.SwitchEntry)GUIPanelAircraft.this.trailerSwitchDefs.get(0);
                    InterfacePacket.sendToServer(new PacketEntityVariableSet(switchDef.entityOn, "connection_requested", switchDef.connectionGroupIndex + 1));
                }

                @Override
                public void onReleased() {
                }
            };
            this.addComponent(this.trailerSelector);
        } else if (((JSONVehicle)this.vehicle.definition).motorized.gearSequenceDuration != 0) {
            this.gearSelector = new GUIComponentSelector(guiLeft + this.xOffset + 10, guiTop + 12 + 96, 20, 20, InterfaceCore.translate("gui.panel.gear"), ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 400, 176, 20, 20){

                @Override
                public void onClicked(boolean leftSide) {
                    InterfacePacket.sendToServer(new PacketEntityVariableToggle(GUIPanelAircraft.this.vehicle, "gear_setpoint"));
                }

                @Override
                public void onReleased() {
                }
            };
            this.addComponent(this.gearSelector);
        } else if (!this.trailerSwitchDefs.isEmpty()) {
            this.trailerSelector = new GUIComponentSelector(guiLeft + this.xOffset + 10, guiTop + 12 + 96, 20, 20, ((AGUIPanel.SwitchEntry)this.trailerSwitchDefs.get((int)0)).connectionGroup.groupName, ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 440, 216, 20, 20){

                @Override
                public void onClicked(boolean leftSide) {
                    AGUIPanel.SwitchEntry switchDef = (AGUIPanel.SwitchEntry)GUIPanelAircraft.this.trailerSwitchDefs.get(0);
                    InterfacePacket.sendToServer(new PacketEntityVariableSet(switchDef.entityOn, "connection_requested", switchDef.connectionGroupIndex + 1));
                }

                @Override
                public void onReleased() {
                }
            };
            this.addComponent(this.trailerSelector);
        }
    }

    @Override
    public void setStates() {
        super.setStates();
        Iterator<Map.Entry<Object, GUIComponentSelector>> iterator = this.lightSelectors.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, GUIComponentSelector> entry = iterator.next();
            entry.getValue().selectorState = this.vehicle.isVariableActive(entry.getKey()) ? 1 : 0;
        }
        if (((JSONVehicle)this.vehicle.definition).motorized.hasSingleEngineControl) {
            if (!this.vehicle.engines.isEmpty() && (iterator = this.vehicle.engines.values().iterator()).hasNext()) {
                PartEngine partEngine = (PartEngine)((Object)iterator.next());
                this.magnetoSelectors.get((Object)Byte.valueOf((byte)-1)).selectorState = partEngine.magnetoOn ? 1 : 0;
            }
        } else {
            for (Map.Entry<Object, GUIComponentSelector> entry : this.magnetoSelectors.entrySet()) {
                if (!this.vehicle.engines.containsKey(entry.getKey())) continue;
                entry.getValue().selectorState = ((PartEngine)this.vehicle.engines.get((Object)entry.getKey())).magnetoOn ? 1 : 0;
            }
        }
        if (((JSONVehicle)this.vehicle.definition).motorized.hasSingleEngineControl) {
            iterator = this.vehicle.engines.values().iterator();
            if (iterator.hasNext()) {
                PartEngine partEngine = (PartEngine)((Object)iterator.next());
                this.starterSelectors.get((Object)Byte.valueOf((byte)-1)).selectorState = partEngine.magnetoOn ? (partEngine.electricStarterEngaged ? 2 : 1) : 0;
                this.starterSelectors.get((Object)Byte.valueOf((byte)-1)).visible = !((JSONPart)partEngine.definition).engine.disableAutomaticStarter;
            }
        } else {
            for (Map.Entry<Object, GUIComponentSelector> entry : this.starterSelectors.entrySet()) {
                if (!this.vehicle.engines.containsKey(entry.getKey())) continue;
                PartEngine engine2 = (PartEngine)this.vehicle.engines.get(entry.getKey());
                entry.getValue().selectorState = engine2.magnetoOn ? (engine2.electricStarterEngaged ? 2 : 1) : 0;
                entry.getValue().visible = !((JSONPart)engine2.definition).engine.disableAutomaticStarter;
            }
        }
        if (this.selectedTrimVariable != null) {
            if (GUIPanelAircraft.inClockPeriod(3, 1)) {
                if (!this.appliedTrimThisRender) {
                    double currentTrim = this.vehicle.getVariable(this.selectedTrimVariable);
                    if (currentTrim + this.selectedTrimIncrement > -this.selectedTrimBounds && currentTrim + this.selectedTrimIncrement < this.selectedTrimBounds) {
                        this.selectedTrimSelector.selectorState = this.selectedTrimSelector.selectorState == 0 ? 1 : 0;
                        InterfacePacket.sendToServer(new PacketEntityVariableIncrement(this.vehicle, this.selectedTrimVariable, this.selectedTrimIncrement, -this.selectedTrimBounds, this.selectedTrimBounds));
                    }
                    this.appliedTrimThisRender = true;
                }
            } else {
                this.appliedTrimThisRender = false;
            }
        }
        if (this.reverseSelector != null) {
            if (((JSONVehicle)this.vehicle.definition).motorized.isBlimp) {
                this.reverseSelector.selectorState = 0;
                for (PartEngine partEngine : this.vehicle.engines.values()) {
                    if (partEngine.currentGear >= 0) continue;
                    this.reverseSelector.selectorState = 1;
                    break;
                }
            } else {
                int n = this.reverseSelector.selectorState = this.vehicle.reverseThrust ? 1 : 0;
            }
        }
        if (this.autopilotSelector != null) {
            int n = this.autopilotSelector.selectorState = this.vehicle.autopilotSetting != 0.0 ? 1 : 0;
        }
        if (this.gearSelector != null) {
            if (this.vehicle.isVariableActive("gear_setpoint")) {
                this.gearSelector.selectorState = this.vehicle.gearMovementTime == ((JSONVehicle)this.vehicle.definition).motorized.gearSequenceDuration ? 2 : 3;
            } else {
                int n = this.gearSelector.selectorState = this.vehicle.gearMovementTime == 0 ? 0 : 1;
            }
        }
        if (this.trailerSelector != null) {
            AGUIPanel.SwitchEntry switchDef = (AGUIPanel.SwitchEntry)this.trailerSwitchDefs.get(0);
            if (switchDef.connectionGroup.hookup) {
                this.trailerSelector.selectorState = switchDef.entityOn.towedByConnection != null ? 0 : 1;
            } else {
                this.trailerSelector.selectorState = 1;
                for (TrailerConnection connection : switchDef.entityOn.getTowingConnections()) {
                    if (connection.hitchGroupIndex != switchDef.connectionGroupIndex) continue;
                    this.trailerSelector.selectorState = 0;
                    break;
                }
            }
        }
        if (this.beaconBox != null) {
            this.beaconBox.fontColor = this.vehicle.selectedBeacon != null ? ColorRGB.GREEN : ColorRGB.RED;
        }
        for (GUIComponentSelector gUIComponentSelector : this.customSelectors) {
            gUIComponentSelector.selectorState = this.vehicle.isVariableActive(gUIComponentSelector.text) ? 1 : 0;
        }
    }
}

