/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.TrailerConnection;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.guis.components.GUIComponentSelector;
import minecrafttransportsimulator.guis.components.GUIComponentTextBox;
import minecrafttransportsimulator.guis.instances.AGUIPanel;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableSet;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableToggle;
import minecrafttransportsimulator.packets.instances.PacketVehicleBeaconChange;
import minecrafttransportsimulator.rendering.instances.RenderText;
import minecrafttransportsimulator.systems.ConfigSystem;

public class GUIPanelGround
extends AGUIPanel {
    private static final int LIGHT_TEXTURE_WIDTH_OFFSET = 0;
    private static final int LIGHT_TEXTURE_HEIGHT_OFFSET = 196;
    private static final int TURNSIGNAL_TEXTURE_WIDTH_OFFSET = 20;
    private static final int TURNSIGNAL_TEXTURE_HEIGHT_OFFSET = 176;
    private static final int ENGINE_TEXTURE_WIDTH_OFFSET = 80;
    private static final int ENGINE_TEXTURE_HEIGHT_OFFSET = 196;
    private static final int TRAILER_TEXTURE_WIDTH_OFFSET = 100;
    private static final int TRAILER_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int REVERSE_TEXTURE_WIDTH_OFFSET = 120;
    private static final int REVERSE_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int CRUISECONTROL_TEXTURE_WIDTH_OFFSET = 140;
    private static final int CRUISECONTROL_TEXTURE_HEIGHT_OFFSET = 216;
    private static final int GEAR_TEXTURE_WIDTH_OFFSET = 160;
    private static final int GEAR_TEXTURE_HEIGHT_OFFSET = 176;
    private static final int CUSTOM_TEXTURE_WIDTH_OFFSET = 180;
    private static final int CUSTOM_TEXTURE_HEIGHT_OFFSET = 216;
    private GUIComponentSelector lightSelector;
    private GUIComponentSelector turnSignalSelector;
    private GUIComponentSelector reverseSelector;
    private GUIComponentSelector cruiseControlSelector;
    private GUIComponentSelector gearSelector;
    private GUIComponentTextBox beaconBox;
    private final Map<Byte, GUIComponentSelector> engineSelectors = new HashMap<Byte, GUIComponentSelector>();
    private final List<GUIComponentSelector> trailerSelectors = new ArrayList<GUIComponentSelector>();
    private final List<GUIComponentSelector> customSelectors = new ArrayList<GUIComponentSelector>();

    public GUIPanelGround(EntityVehicleF_Physics groundVehicle) {
        super(groundVehicle);
    }

    @Override
    protected void setupLightComponents(int guiLeft, int guiTop) {
        if (((JSONVehicle)this.vehicle.definition).motorized.hasRunningLights || ((JSONVehicle)this.vehicle.definition).motorized.hasHeadlights) {
            this.lightSelector = new GUIComponentSelector(guiLeft + this.xOffset, guiTop + 12 + 0, 20, 20, "LIGHTS", ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 0, 196, 20, 20){

                @Override
                public void onClicked(boolean leftSide) {
                    if (leftSide) {
                        if (this.selectorState == 2) {
                            InterfacePacket.sendToServer(new PacketEntityVariableToggle(GUIPanelGround.this.vehicle, "headlight"));
                        } else if (this.selectorState == 1) {
                            InterfacePacket.sendToServer(new PacketEntityVariableToggle(GUIPanelGround.this.vehicle, "running_light"));
                        }
                    } else if (this.selectorState == 0) {
                        if (((JSONVehicle)GUIPanelGround.this.vehicle.definition).motorized.hasRunningLights) {
                            InterfacePacket.sendToServer(new PacketEntityVariableToggle(GUIPanelGround.this.vehicle, "running_light"));
                        } else {
                            InterfacePacket.sendToServer(new PacketEntityVariableToggle(GUIPanelGround.this.vehicle, "headlight"));
                        }
                    } else if (this.selectorState == 1) {
                        InterfacePacket.sendToServer(new PacketEntityVariableToggle(GUIPanelGround.this.vehicle, "headlight"));
                    }
                }

                @Override
                public void onReleased() {
                }
            };
            this.addComponent(this.lightSelector);
        }
        if (((JSONVehicle)this.vehicle.definition).motorized.hasTurnSignals) {
            this.turnSignalSelector = new GUIComponentSelector(guiLeft + this.xOffset, guiTop + 12 + 32, 20, 20, "TURNSGNL", ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 20, 176, 20, 20){

                @Override
                public void onClicked(boolean leftSide) {
                    if (leftSide) {
                        InterfacePacket.sendToServer(new PacketEntityVariableToggle(GUIPanelGround.this.vehicle, "left_turn_signal"));
                    } else {
                        InterfacePacket.sendToServer(new PacketEntityVariableToggle(GUIPanelGround.this.vehicle, "right_turn_signal"));
                    }
                }

                @Override
                public void onReleased() {
                }
            };
            this.addComponent(this.turnSignalSelector);
        }
        if (((JSONVehicle)this.vehicle.definition).motorized.hasRadioNav || ((Boolean)ConfigSystem.configObject.general.allPlanesWithNav.value).booleanValue()) {
            this.beaconBox = new GUIComponentTextBox(guiLeft + this.xOffset, guiTop + 12 + 96, 40, 20, this.vehicle.selectedBeaconName, this.vehicle.selectedBeacon != null ? ColorRGB.GREEN : ColorRGB.RED, 5, 340, 196, 40, 20){

                @Override
                public void handleKeyTyped(char typedChar, int typedCode, GUIComponentTextBox.TextBoxControlKey control) {
                    super.handleKeyTyped(typedChar, typedCode, control);
                    InterfacePacket.sendToServer(new PacketVehicleBeaconChange(GUIPanelGround.this.vehicle, this.getText()));
                }
            };
            this.addComponent(this.beaconBox);
            this.addComponent(new GUIComponentLabel(this.beaconBox.constructedX + this.beaconBox.width / 2, this.beaconBox.constructedY + this.beaconBox.height + 1, ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor != null ? ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor : ColorRGB.WHITE, InterfaceCore.translate("gui.panel.beacon"), RenderText.TextAlignment.CENTERED, 0.75f).setBox(this.beaconBox));
        }
    }

    @Override
    protected void setupEngineComponents(int guiLeft, int guiTop) {
        this.engineSelectors.clear();
        if (((JSONVehicle)this.vehicle.definition).motorized.hasSingleEngineControl) {
            if (!this.vehicle.engines.isEmpty()) {
                GUIComponentSelector engineSelector = new GUIComponentSelector(guiLeft + this.xOffset, guiTop + 12, 20, 20, InterfaceCore.translate("gui.panel.engine"), ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 80, 196, 20, 20){

                    @Override
                    public void onClicked(boolean leftSide) {
                        for (Byte engineNumber : GUIPanelGround.this.vehicle.engines.keySet()) {
                            if (this.selectorState == 1 && !leftSide) {
                                if (((JSONPart)((PartEngine)GUIPanelGround.this.vehicle.engines.get((Object)engineNumber)).definition).engine.disableAutomaticStarter) continue;
                                InterfacePacket.sendToServer(new PacketEntityVariableToggle((AEntityD_Definable)GUIPanelGround.this.vehicle.engines.get((Object)engineNumber), "engine_starter"));
                                continue;
                            }
                            InterfacePacket.sendToServer(new PacketEntityVariableToggle((AEntityD_Definable)GUIPanelGround.this.vehicle.engines.get((Object)engineNumber), "engine_magneto"));
                        }
                    }

                    @Override
                    public void onReleased() {
                        if (this.selectorState == 2) {
                            for (Byte engineNumber : GUIPanelGround.this.vehicle.engines.keySet()) {
                                if (((JSONPart)((PartEngine)GUIPanelGround.this.vehicle.engines.get((Object)engineNumber)).definition).engine.disableAutomaticStarter) continue;
                                InterfacePacket.sendToServer(new PacketEntityVariableToggle((AEntityD_Definable)GUIPanelGround.this.vehicle.engines.get((Object)engineNumber), "engine_starter"));
                            }
                        }
                    }
                };
                this.engineSelectors.put((byte)-1, engineSelector);
                this.addComponent(engineSelector);
            }
        } else {
            for (final Byte engineNumber : this.vehicle.engines.keySet()) {
                if (engineNumber == 5) {
                    this.xOffset += 32;
                }
                GUIComponentSelector engineSelector = new GUIComponentSelector(guiLeft + this.xOffset, guiTop + 12 + 32 * (engineNumber % 4), 20, 20, InterfaceCore.translate("gui.panel.engine"), ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 80, 196, 20, 20){

                    @Override
                    public void onClicked(boolean leftSide) {
                        if (this.selectorState == 1 && !leftSide) {
                            if (!((JSONPart)((PartEngine)GUIPanelGround.this.vehicle.engines.get((Object)engineNumber)).definition).engine.disableAutomaticStarter) {
                                InterfacePacket.sendToServer(new PacketEntityVariableToggle((AEntityD_Definable)GUIPanelGround.this.vehicle.engines.get((Object)engineNumber), "engine_starter"));
                            }
                        } else {
                            InterfacePacket.sendToServer(new PacketEntityVariableToggle((AEntityD_Definable)GUIPanelGround.this.vehicle.engines.get((Object)engineNumber), "engine_magneto"));
                        }
                    }

                    @Override
                    public void onReleased() {
                        if (this.selectorState == 2 && !((JSONPart)((PartEngine)GUIPanelGround.this.vehicle.engines.get((Object)engineNumber)).definition).engine.disableAutomaticStarter) {
                            InterfacePacket.sendToServer(new PacketEntityVariableToggle((AEntityD_Definable)GUIPanelGround.this.vehicle.engines.get((Object)engineNumber), "engine_starter"));
                        }
                    }
                };
                this.engineSelectors.put(engineNumber, engineSelector);
                this.addComponent(engineSelector);
            }
        }
        if (this.haveReverseThrustOption && ((JSONVehicle)this.vehicle.definition).motorized.hasAutopilot) {
            this.reverseSelector = new GUIComponentSelector(guiLeft + this.xOffset, guiTop + 12 + 96, 20, 20, InterfaceCore.translate("gui.panel.reverse"), ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 120, 216, 20, 20){

                @Override
                public void onClicked(boolean leftSide) {
                    InterfacePacket.sendToServer(new PacketEntityVariableToggle(GUIPanelGround.this.vehicle, "reverser"));
                }

                @Override
                public void onReleased() {
                }
            };
            this.addComponent(this.reverseSelector);
            this.cruiseControlSelector = new GUIComponentSelector(guiLeft + this.xOffset + 20, guiTop + 12 + 96, 20, 20, InterfaceCore.translate("gui.panel.cruisecontrol"), ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 140, 216, 20, 20){

                @Override
                public void onClicked(boolean leftSide) {
                    if (GUIPanelGround.this.vehicle.autopilotSetting == 0.0) {
                        InterfacePacket.sendToServer(new PacketEntityVariableSet(GUIPanelGround.this.vehicle, "autopilot", GUIPanelGround.this.vehicle.velocity));
                    } else {
                        InterfacePacket.sendToServer(new PacketEntityVariableSet(GUIPanelGround.this.vehicle, "autopilot", 0.0));
                    }
                }

                @Override
                public void onReleased() {
                }
            };
            this.addComponent(this.cruiseControlSelector);
        } else if (this.haveReverseThrustOption) {
            this.reverseSelector = new GUIComponentSelector(guiLeft + this.xOffset + 10, guiTop + 12 + 96, 20, 20, InterfaceCore.translate("gui.panel.reverse"), ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 120, 216, 20, 20){

                @Override
                public void onClicked(boolean leftSide) {
                    InterfacePacket.sendToServer(new PacketEntityVariableToggle(GUIPanelGround.this.vehicle, "reverser"));
                }

                @Override
                public void onReleased() {
                }
            };
            this.addComponent(this.reverseSelector);
        } else if (((JSONVehicle)this.vehicle.definition).motorized.hasAutopilot) {
            this.cruiseControlSelector = new GUIComponentSelector(guiLeft + this.xOffset + 10, guiTop + 12 + 96, 20, 20, InterfaceCore.translate("gui.panel.cruisecontrol"), ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 140, 216, 20, 20){

                @Override
                public void onClicked(boolean leftSide) {
                    if (GUIPanelGround.this.vehicle.autopilotSetting == 0.0) {
                        InterfacePacket.sendToServer(new PacketEntityVariableSet(GUIPanelGround.this.vehicle, "autopilot", GUIPanelGround.this.vehicle.velocity));
                    } else {
                        InterfacePacket.sendToServer(new PacketEntityVariableSet(GUIPanelGround.this.vehicle, "autopilot", 0.0));
                    }
                }

                @Override
                public void onReleased() {
                }
            };
            this.addComponent(this.cruiseControlSelector);
        }
    }

    @Override
    protected void setupGeneralComponents(int guiLeft, int guiTop) {
        this.trailerSelectors.clear();
        for (int i = 0; i < 8; ++i) {
            if (i == 4) {
                this.xOffset += 32;
            }
            if (this.trailerSwitchDefs.size() <= i) continue;
            final AGUIPanel.SwitchEntry switchDef = (AGUIPanel.SwitchEntry)this.trailerSwitchDefs.get(i);
            GUIComponentSelector trailerSelector = new GUIComponentSelector(guiLeft + this.xOffset, guiTop + 12 + i % 4 * 32, 20, 20, switchDef.connectionGroup.groupName, ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 100, 216, 20, 20){

                @Override
                public void onClicked(boolean leftSide) {
                    InterfacePacket.sendToServer(new PacketEntityVariableSet(switchDef.entityOn, "connection_requested", switchDef.connectionGroupIndex + 1));
                }

                @Override
                public void onReleased() {
                }
            };
            this.trailerSelectors.add(trailerSelector);
            this.addComponent(trailerSelector);
        }
        if (((JSONVehicle)this.vehicle.definition).motorized.gearSequenceDuration != 0) {
            this.gearSelector = new GUIComponentSelector(guiLeft + this.xOffset, guiTop + 12 + 96, 20, 20, InterfaceCore.translate("gui.panel.gear"), ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 160, 176, 20, 20){

                @Override
                public void onClicked(boolean leftSide) {
                    InterfacePacket.sendToServer(new PacketEntityVariableToggle(GUIPanelGround.this.vehicle, "gear_setpoint"));
                }

                @Override
                public void onReleased() {
                }
            };
            this.addComponent(this.gearSelector);
        }
    }

    @Override
    public void setupCustomComponents(int guiLeft, int guiTop) {
        LinkedHashSet<String> customVariables = new LinkedHashSet<String>();
        if (((JSONVehicle)this.vehicle.definition).rendering.customVariables != null) {
            customVariables.addAll(((JSONVehicle)this.vehicle.definition).rendering.customVariables);
        }
        for (APart part : this.vehicle.parts) {
            if (((JSONPart)part.definition).rendering == null || ((JSONPart)part.definition).rendering.customVariables == null) continue;
            customVariables.addAll(((JSONPart)part.definition).rendering.customVariables);
        }
        int variableNumber = 0;
        this.customSelectors.clear();
        for (String customVariable : customVariables) {
            GUIComponentSelector customSelector = new GUIComponentSelector(guiLeft + this.xOffset, guiTop + 12 + variableNumber % 4 * 32, 20, 20, customVariable, ((JSONVehicle)this.vehicle.definition).motorized.panelTextColor, ((JSONVehicle)this.vehicle.definition).motorized.panelLitTextColor, 180, 216, 20, 20){

                @Override
                public void onClicked(boolean leftSide) {
                    InterfacePacket.sendToServer(new PacketEntityVariableToggle(GUIPanelGround.this.vehicle, this.text));
                }

                @Override
                public void onReleased() {
                }
            };
            this.customSelectors.add(customSelector);
            this.addComponent(customSelector);
            ++variableNumber;
        }
    }

    @Override
    public void setStates() {
        super.setStates();
        if (this.lightSelector != null) {
            int n = this.vehicle.isVariableActive("headlight") ? 2 : (this.lightSelector.selectorState = this.vehicle.isVariableActive("running_light") ? 1 : 0);
        }
        if (this.turnSignalSelector != null) {
            boolean halfSecondClock = GUIPanelGround.inClockPeriod(20, 10);
            this.turnSignalSelector.selectorState = this.vehicle.isVariableActive("left_turn_signal") && halfSecondClock ? (this.vehicle.isVariableActive("right_turn_signal") ? 3 : 1) : (this.vehicle.isVariableActive("right_turn_signal") && halfSecondClock ? 2 : 0);
        }
        if (((JSONVehicle)this.vehicle.definition).motorized.hasSingleEngineControl) {
            Iterator halfSecondClock;
            if (!this.vehicle.engines.isEmpty() && (halfSecondClock = this.vehicle.engines.values().iterator()).hasNext()) {
                PartEngine engine = (PartEngine)halfSecondClock.next();
                this.engineSelectors.get((Object)Byte.valueOf((byte)-1)).selectorState = ((JSONPart)engine.definition).engine.disableAutomaticStarter ? (engine.magnetoOn ? 2 : 0) : (engine.magnetoOn ? (engine.electricStarterEngaged ? 2 : 1) : 0);
            }
        } else {
            for (Map.Entry<Byte, GUIComponentSelector> engineEntry : this.engineSelectors.entrySet()) {
                if (!this.vehicle.engines.containsKey((Object)engineEntry.getKey())) continue;
                PartEngine engine = (PartEngine)this.vehicle.engines.get((Object)engineEntry.getKey());
                if (((JSONPart)engine.definition).engine.disableAutomaticStarter) {
                    engineEntry.getValue().selectorState = engine.magnetoOn ? 2 : 0;
                    continue;
                }
                engineEntry.getValue().selectorState = engine.magnetoOn ? (engine.electricStarterEngaged ? 2 : 1) : 0;
            }
        }
        if (this.reverseSelector != null) {
            int n = this.reverseSelector.selectorState = this.vehicle.reverseThrust ? 1 : 0;
        }
        if (this.cruiseControlSelector != null) {
            int n = this.cruiseControlSelector.selectorState = this.vehicle.autopilotSetting != 0.0 ? 1 : 0;
        }
        if (this.gearSelector != null) {
            this.gearSelector.selectorState = this.vehicle.isVariableActive("gear_setpoint") ? (this.vehicle.gearMovementTime == ((JSONVehicle)this.vehicle.definition).motorized.gearSequenceDuration ? 2 : 3) : (this.vehicle.gearMovementTime == 0 ? 0 : 1);
        }
        block1: for (int i = 0; i < this.trailerSelectors.size(); ++i) {
            GUIComponentSelector trailerSelector = this.trailerSelectors.get(i);
            AGUIPanel.SwitchEntry switchDef = (AGUIPanel.SwitchEntry)this.trailerSwitchDefs.get(i);
            trailerSelector.visible = true;
            if (switchDef.connectionGroup.hookup) {
                trailerSelector.selectorState = switchDef.entityOn.towedByConnection != null ? 0 : 1;
                continue;
            }
            trailerSelector.selectorState = 1;
            for (TrailerConnection connection : switchDef.entityOn.getTowingConnections()) {
                if (connection.hitchGroupIndex != switchDef.connectionGroupIndex) continue;
                trailerSelector.selectorState = 0;
                continue block1;
            }
        }
        if (this.beaconBox != null) {
            this.beaconBox.fontColor = this.vehicle.selectedBeacon != null ? ColorRGB.GREEN : ColorRGB.RED;
        }
        for (GUIComponentSelector customSelector : this.customSelectors) {
            customSelector.selectorState = this.vehicle.isVariableActive(customSelector.text) ? 1 : 0;
        }
    }
}

