/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponent3DModel;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentItem;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.items.instances.ItemPoleComponent;
import minecrafttransportsimulator.items.instances.ItemVehicle;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.jsondefs.JSONCraftingBench;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.InterfaceInput;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.packets.instances.PacketPlayerCraftItem;
import minecrafttransportsimulator.packloading.PackMaterialComponent;
import minecrafttransportsimulator.rendering.instances.RenderText;
import minecrafttransportsimulator.systems.PackParserSystem;

public class GUIPartBench
extends AGUIBase {
    private static final Map<JSONCraftingBench, AItemPack<? extends AJSONItem>> lastOpenedItem = new HashMap<JSONCraftingBench, AItemPack<? extends AJSONItem>>();
    private final JSONCraftingBench definition;
    private final WrapperPlayer player;
    private GUIComponentButton prevPackButton;
    private GUIComponentButton nextPackButton;
    private GUIComponentLabel packName;
    private GUIComponentButton prevPartButton;
    private GUIComponentButton nextPartButton;
    private GUIComponentLabel partName;
    private GUIComponentButton prevColorButton;
    private GUIComponentButton nextColorButton;
    private GUIComponentLabel partInfo;
    private GUIComponentLabel vehicleInfo;
    private GUIComponentButton vehicleInfoButton;
    private GUIComponentButton vehicleDescriptionButton;
    private GUIComponentButton repairCraftingButton;
    private GUIComponentButton normalCraftingButton;
    private GUIComponentButton confirmButton;
    private final List<GUIComponentItem> craftingItemIcons = new ArrayList<GUIComponentItem>();
    private List<PackMaterialComponent> normalMaterials;
    private List<PackMaterialComponent> repairMaterials;
    private GUIComponentItem itemRender;
    private GUIComponent3DModel modelRender;
    private String prevPack;
    private String currentPack;
    private String nextPack;
    private boolean viewingRepair;
    private AItemPack<? extends AJSONItem> prevItem;
    private AItemPack<? extends AJSONItem> currentItem;
    private AItemPack<? extends AJSONItem> nextItem;
    private AItemPack<? extends AJSONItem> prevSubItem;
    private AItemPack<? extends AJSONItem> nextSubItem;
    boolean displayVehicleInfo = false;

    public GUIPartBench(JSONCraftingBench definition) {
        this.definition = definition;
        this.player = InterfaceClient.getClientPlayer();
        if (lastOpenedItem.containsKey(definition)) {
            this.currentItem = lastOpenedItem.get(definition);
            this.currentPack = ((AJSONItem)this.currentItem.definition).packID;
        } else {
            for (AItemPack<?> packItem : PackParserSystem.getAllPackItems()) {
                if (!packItem.isBenchValid(definition)) continue;
                this.currentItem = packItem;
                this.currentPack = ((AJSONItem)packItem.definition).packID;
                return;
            }
        }
    }

    @Override
    public void setupComponents() {
        super.setupComponents();
        this.prevPackButton = new GUIComponentButton(this.guiLeft + 17, this.guiTop + 11, 20, 20, 40, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPartBench.this.currentPack = GUIPartBench.this.prevPack;
                GUIPartBench.this.currentItem = null;
                GUIPartBench.this.updateNames();
            }
        };
        this.addComponent(this.prevPackButton);
        this.nextPackButton = new GUIComponentButton(this.guiLeft + 243, this.guiTop + 11, 20, 20, 60, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPartBench.this.currentPack = GUIPartBench.this.nextPack;
                GUIPartBench.this.currentItem = null;
                GUIPartBench.this.updateNames();
            }
        };
        this.addComponent(this.nextPackButton);
        int centerBetweenButtons = this.prevPackButton.constructedX + this.prevPackButton.width + (this.nextPackButton.constructedX - (this.prevPackButton.constructedX + this.prevPackButton.width)) / 2;
        this.packName = new GUIComponentLabel(centerBetweenButtons, this.guiTop + 16, ColorRGB.WHITE, "", RenderText.TextAlignment.CENTERED, 1.0f);
        this.addComponent(this.packName);
        this.prevPartButton = new GUIComponentButton(this.prevPackButton.constructedX, this.prevPackButton.constructedY + this.prevPackButton.height, 20, 20, 40, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPartBench.this.currentItem = GUIPartBench.this.prevItem;
                GUIPartBench.this.updateNames();
            }
        };
        this.addComponent(this.prevPartButton);
        this.nextPartButton = new GUIComponentButton(this.nextPackButton.constructedX, this.nextPackButton.constructedY + this.nextPackButton.height, 20, 20, 60, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPartBench.this.currentItem = GUIPartBench.this.nextItem;
                GUIPartBench.this.updateNames();
            }
        };
        this.addComponent(this.nextPartButton);
        this.partName = new GUIComponentLabel(this.packName.constructedX, this.packName.constructedY + this.prevPackButton.height, ColorRGB.WHITE, "", RenderText.TextAlignment.CENTERED, 0.75f);
        this.addComponent(this.partName);
        this.partInfo = new GUIComponentLabel(this.guiLeft + 17, this.guiTop + 60, ColorRGB.WHITE, "", RenderText.TextAlignment.LEFT_ALIGNED, 0.75f, 150);
        this.addComponent(this.partInfo);
        this.vehicleInfo = new GUIComponentLabel(this.guiLeft + 17, this.guiTop + 60, ColorRGB.WHITE, "", RenderText.TextAlignment.LEFT_ALIGNED, 1.0f, 150);
        this.addComponent(this.vehicleInfo);
        this.prevColorButton = new GUIComponentButton(this.guiLeft + 175, this.guiTop + 131, 20, 15, 40, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPartBench.this.currentItem = GUIPartBench.this.prevSubItem;
                GUIPartBench.this.updateNames();
            }
        };
        this.addComponent(this.prevColorButton);
        this.nextColorButton = new GUIComponentButton(this.guiLeft + 245, this.guiTop + 131, 20, 15, 60, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPartBench.this.currentItem = GUIPartBench.this.nextSubItem;
                GUIPartBench.this.updateNames();
            }
        };
        this.addComponent(this.nextColorButton);
        this.addComponent(new GUIComponentLabel(this.prevColorButton.constructedX + this.prevColorButton.width + (this.nextColorButton.constructedX - (this.prevColorButton.constructedX + this.prevColorButton.width)) / 2, this.guiTop + 136, ColorRGB.WHITE, InterfaceCore.translate("gui.vehicle_bench.color"), RenderText.TextAlignment.CENTERED, 1.0f).setButton(this.nextColorButton));
        this.craftingItemIcons.clear();
        for (int i = 0; i < 14; i = (int)((byte)(i + 1))) {
            GUIComponentItem craftingItem = new GUIComponentItem(this.guiLeft + 276 + 18 * (i / 7), this.guiTop + 20 + 18 * (i % 7), 1.0f);
            this.addComponent(craftingItem);
            this.craftingItemIcons.add(craftingItem);
        }
        this.itemRender = new GUIComponentItem(this.guiLeft + 175, this.guiTop + 56, 5.625f);
        this.addComponent(this.itemRender);
        this.modelRender = new GUIComponent3DModel(this.guiLeft + 220, this.guiTop + 101, 32.0f, true, true, false);
        this.addComponent(this.modelRender);
        this.vehicleInfoButton = new GUIComponentButton(this.guiLeft + 147, this.guiTop + 159, 20, 20, 100, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPartBench.this.displayVehicleInfo = true;
            }
        };
        this.addComponent(this.vehicleInfoButton);
        this.vehicleDescriptionButton = new GUIComponentButton(this.guiLeft + 147, this.guiTop + 159, 20, 20, 80, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPartBench.this.displayVehicleInfo = false;
            }
        };
        this.addComponent(this.vehicleDescriptionButton);
        this.repairCraftingButton = new GUIComponentButton(this.guiLeft + 127, this.guiTop + 159, 20, 20, 120, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPartBench.this.viewingRepair = true;
            }
        };
        this.addComponent(this.repairCraftingButton);
        this.normalCraftingButton = new GUIComponentButton(this.guiLeft + 127, this.guiTop + 159, 20, 20, 140, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPartBench.this.viewingRepair = false;
            }
        };
        this.addComponent(this.normalCraftingButton);
        this.confirmButton = new GUIComponentButton(this.guiLeft + 211, this.guiTop + 156, 20, 20, 20, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                InterfacePacket.sendToServer(new PacketPlayerCraftItem(GUIPartBench.this.player, GUIPartBench.this.currentItem, GUIPartBench.this.viewingRepair));
            }
        };
        this.addComponent(this.confirmButton);
    }

    @Override
    public void setStates() {
        super.setStates();
        if (this.normalMaterials == null) {
            this.updateNames();
        }
        this.prevPackButton.enabled = this.prevPack != null;
        this.nextPackButton.enabled = this.nextPack != null;
        this.prevPartButton.enabled = this.prevItem != null;
        this.nextPartButton.enabled = this.nextItem != null;
        this.prevColorButton.visible = this.currentItem instanceof AItemSubTyped;
        this.prevColorButton.enabled = this.prevSubItem != null;
        this.nextColorButton.visible = this.currentItem instanceof AItemSubTyped;
        this.nextColorButton.enabled = this.nextSubItem != null;
        this.vehicleInfoButton.visible = this.currentItem instanceof ItemVehicle && !this.displayVehicleInfo;
        this.vehicleDescriptionButton.visible = this.currentItem instanceof ItemVehicle && this.displayVehicleInfo;
        this.repairCraftingButton.visible = !this.viewingRepair && this.currentItem != null && this.repairMaterials != null && !this.repairMaterials.isEmpty();
        this.normalCraftingButton.visible = this.viewingRepair;
        this.partInfo.visible = !this.displayVehicleInfo;
        this.vehicleInfo.visible = this.displayVehicleInfo;
        if (this.normalMaterials != null && this.repairMaterials != null) {
            List<PackMaterialComponent> materials = this.viewingRepair ? this.repairMaterials : this.normalMaterials;
            int materialOffset = 1 + (materials.size() - 1) / this.craftingItemIcons.size();
            materialOffset = (int)(System.currentTimeMillis() % (long)(materialOffset * 5000) / 5000L);
            materialOffset *= this.craftingItemIcons.size();
            for (int i = 0; i < this.craftingItemIcons.size(); i = (int)((byte)(i + 1))) {
                int materialIndex = i + materialOffset;
                this.craftingItemIcons.get((int)i).stacks = materialIndex < materials.size() ? materials.get((int)materialIndex).possibleItems : null;
            }
        } else {
            for (int i = 0; i < this.craftingItemIcons.size(); i = (int)((byte)(i + 1))) {
                this.craftingItemIcons.get((int)i).stacks = null;
            }
        }
        this.confirmButton.enabled = this.currentItem != null && (this.player.isCreative() || (this.viewingRepair ? this.repairMaterials != null && this.player.getInventory().hasMaterials(this.currentItem, true, true, true) : this.normalMaterials != null && this.player.getInventory().hasMaterials(this.currentItem, true, true, false)));
        int wheelMovement = InterfaceInput.getTrackedMouseWheel();
        if (wheelMovement < 0 && this.nextPartButton.enabled) {
            this.nextPartButton.onClicked(false);
        } else if (wheelMovement > 0 && this.prevPartButton.enabled) {
            this.prevPartButton.onClicked(false);
        }
    }

    @Override
    public int getWidth() {
        return 327;
    }

    @Override
    public int getHeight() {
        return 196;
    }

    @Override
    protected String getTexture() {
        return "mts:textures/guis/crafting.png";
    }

    private void updateNames() {
        int i;
        ArrayList<String> packIDs = new ArrayList<String>(PackParserSystem.getAllPackIDs());
        int currentPackIndex = packIDs.indexOf(this.currentPack);
        this.nextPack = null;
        if (currentPackIndex < packIDs.size()) {
            block0: for (i = currentPackIndex + 1; i < packIDs.size() && this.nextPack == null; ++i) {
                for (AItemPack<?> packItem : PackParserSystem.getAllItemsForPack((String)packIDs.get(i), true)) {
                    if (!packItem.isBenchValid(this.definition)) continue;
                    this.nextPack = (String)packIDs.get(i);
                    continue block0;
                }
            }
        }
        this.prevPack = null;
        if (currentPackIndex > 0) {
            block2: for (i = currentPackIndex - 1; i >= 0 && this.prevPack == null; --i) {
                for (AItemPack<?> packItem : PackParserSystem.getAllItemsForPack((String)packIDs.get(i), true)) {
                    if (!packItem.isBenchValid(this.definition)) continue;
                    this.prevPack = (String)packIDs.get(i);
                    continue block2;
                }
            }
        }
        if (this.currentPack == null) {
            return;
        }
        List<AItemPack<?>> packItems = PackParserSystem.getAllItemsForPack(this.currentPack, true);
        int currentItemIndex = packItems.indexOf(this.currentItem);
        if (this.currentItem == null) {
            for (AItemPack aItemPack : packItems) {
                if (this.currentItem != null && (!(this.currentItem.definition instanceof AJSONMultiModelProvider) || this.nextSubItem != null) || !aItemPack.isBenchValid(this.definition)) continue;
                if (this.currentItem == null) {
                    this.currentItem = aItemPack;
                    currentItemIndex = packItems.indexOf(this.currentItem);
                    continue;
                }
                if (!(this.currentItem.definition instanceof AJSONMultiModelProvider) || this.nextSubItem != null || !((AJSONItem)aItemPack.definition).systemName.equals(((AJSONItem)this.currentItem.definition).systemName)) continue;
                this.nextSubItem = aItemPack;
            }
        }
        this.nextItem = null;
        this.nextSubItem = null;
        if (currentItemIndex < packItems.size()) {
            for (int i2 = currentItemIndex + 1; i2 < packItems.size() && this.nextItem == null; ++i2) {
                if (!packItems.get(i2).isBenchValid(this.definition)) continue;
                if (this.currentItem.definition instanceof AJSONMultiModelProvider && ((AJSONItem)packItems.get((int)i2).definition).systemName.equals(((AJSONItem)this.currentItem.definition).systemName)) {
                    if (this.nextSubItem != null) continue;
                    this.nextSubItem = packItems.get(i2);
                    continue;
                }
                this.nextItem = packItems.get(i2);
                break;
            }
        }
        this.prevItem = null;
        this.prevSubItem = null;
        if (currentItemIndex > 0) {
            for (int i3 = currentItemIndex - 1; i3 >= 0 && (this.prevItem == null || this.currentItem.definition instanceof AJSONMultiModelProvider); --i3) {
                if (!packItems.get(i3).isBenchValid(this.definition)) continue;
                if (this.currentItem.definition instanceof AJSONMultiModelProvider) {
                    if (((AJSONItem)packItems.get((int)i3).definition).systemName.equals(((AJSONItem)this.currentItem.definition).systemName)) {
                        if (this.prevSubItem != null) continue;
                        this.prevSubItem = packItems.get(i3);
                        continue;
                    }
                    if (this.prevItem == null) {
                        this.prevItem = packItems.get(i3);
                        continue;
                    }
                    if (!((AJSONItem)packItems.get((int)i3).definition).systemName.equals(((AJSONItem)this.prevItem.definition).systemName)) continue;
                    this.prevItem = packItems.get(i3);
                    continue;
                }
                this.prevItem = packItems.get(i3);
                break;
            }
        }
        this.packName.text = PackParserSystem.getPackConfiguration((String)this.currentPack).packName;
        this.partName.text = this.currentItem.getItemName();
        ArrayList<String> descriptiveLines = new ArrayList<String>();
        this.currentItem.addTooltipLines(descriptiveLines, new WrapperNBT());
        this.partInfo.text = "";
        for (String line : descriptiveLines) {
            this.partInfo.text = this.partInfo.text + line + "\n";
        }
        if (this.currentItem instanceof ItemVehicle) {
            this.vehicleInfo.text = this.getVehicleInfoText();
        }
        this.normalMaterials = PackMaterialComponent.parseFromJSON(this.currentItem, true, true, false, false);
        if (this.normalMaterials == null) {
            this.partInfo.text = PackMaterialComponent.lastErrorMessage;
        }
        this.repairMaterials = PackMaterialComponent.parseFromJSON(this.currentItem, true, true, false, true);
        if (this.repairMaterials == null) {
            this.partInfo.text = PackMaterialComponent.lastErrorMessage;
        }
        if (!(!(this.currentItem instanceof AItemSubTyped) || this.currentItem instanceof AItemPart && ((JSONPart)((AItemPart)this.currentItem).definition).generic.useVehicleTexture)) {
            this.modelRender.modelLocation = ((AJSONMultiModelProvider)((AItemSubTyped)this.currentItem).definition).getModelLocation(((AItemSubTyped)this.currentItem).subName);
            this.modelRender.textureLocation = ((AJSONMultiModelProvider)((AItemSubTyped)this.currentItem).definition).getTextureLocation(((AItemSubTyped)this.currentItem).subName);
            this.itemRender.stack = null;
            this.modelRender.spin = !(this.currentItem.definition instanceof JSONPoleComponent) || !((JSONPoleComponent)this.currentItem.definition).pole.type.equals((Object)ItemPoleComponent.PoleComponentType.SIGN);
        } else {
            this.itemRender.stack = this.currentItem.getNewStack(null);
            this.modelRender.modelLocation = null;
        }
        lastOpenedItem.put(this.definition, this.currentItem);
    }

    private String getVehicleInfoText() {
        JSONVehicle vehicleDefinition = (JSONVehicle)this.currentItem.definition;
        int controllers = 0;
        int passengers = 0;
        int cargo = 0;
        int mixed = 0;
        float minFuelConsumption = 99.0f;
        float maxFuelConsumption = 0.0f;
        float minWheelSize = 99.0f;
        float maxWheelSize = 0.0f;
        for (JSONPartDefinition part : vehicleDefinition.parts) {
            if (part.isController) {
                ++controllers;
                continue;
            }
            boolean canAcceptSeat = false;
            boolean canAcceptCargo = false;
            if (part.types.contains("seat")) {
                canAcceptSeat = true;
            }
            if (part.types.contains("crate") || part.types.contains("barrel")) {
                canAcceptCargo = true;
            }
            if (canAcceptSeat && !canAcceptCargo) {
                ++passengers;
            } else if (canAcceptCargo && !canAcceptSeat) {
                ++cargo;
            } else if (canAcceptCargo && canAcceptSeat) {
                ++mixed;
            }
            for (String partNameEntry : part.types) {
                if (!partNameEntry.startsWith("engine")) continue;
                minFuelConsumption = Math.min(part.minValue, minFuelConsumption);
                maxFuelConsumption = Math.max(part.maxValue, maxFuelConsumption);
                break;
            }
            if (!part.types.contains("wheel")) continue;
            minWheelSize = Math.min(part.minValue, minWheelSize);
            maxWheelSize = Math.max(part.maxValue, maxWheelSize);
        }
        String totalInformation = "";
        totalInformation = totalInformation + InterfaceCore.translate("gui.vehicle_bench.weight") + ": " + String.valueOf(vehicleDefinition.motorized.emptyMass) + "\n";
        totalInformation = totalInformation + InterfaceCore.translate("gui.vehicle_bench.fuel") + ": " + String.valueOf(vehicleDefinition.motorized.fuelCapacity) + "\n";
        totalInformation = totalInformation + InterfaceCore.translate("gui.vehicle_bench.controllers") + ": " + String.valueOf(controllers) + "\n";
        totalInformation = totalInformation + InterfaceCore.translate("gui.vehicle_bench.passengers") + ": " + String.valueOf(passengers) + "\n";
        totalInformation = totalInformation + InterfaceCore.translate("gui.vehicle_bench.cargo") + ": " + String.valueOf(cargo) + "\n";
        totalInformation = totalInformation + InterfaceCore.translate("gui.vehicle_bench.mixed") + ": " + String.valueOf(mixed) + "\n";
        if (minFuelConsumption != 99.0f) {
            totalInformation = totalInformation + InterfaceCore.translate("gui.vehicle_bench.engine") + ": " + String.valueOf(minFuelConsumption) + "-" + String.valueOf(maxFuelConsumption) + "\n";
        }
        if (minWheelSize != 99.0f) {
            totalInformation = totalInformation + InterfaceCore.translate("gui.vehicle_bench.wheel") + ": " + String.valueOf(minWheelSize) + "-" + String.valueOf(maxWheelSize) + "\n";
        }
        return totalInformation;
    }
}

