/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_Sign;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponent3DModel;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.guis.components.GUIComponentTextBox;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.packets.instances.PacketEntityTextChange;
import minecrafttransportsimulator.rendering.instances.RenderText;

public class GUITextEditor
extends AGUIBase {
    private GUIComponentButton confirmButton;
    private final List<GUIComponentTextBox> textInputBoxes = new ArrayList<GUIComponentTextBox>();
    private final List<String> textInputFieldNames = new ArrayList<String>();
    private final AEntityD_Definable<?> entity;
    private final List<GUIComponentLabel> signTextLabels = new ArrayList<GUIComponentLabel>();

    public GUITextEditor(AEntityD_Definable<?> entity) {
        this.entity = entity;
    }

    @Override
    public void setupComponents() {
        GUIComponentLabel label;
        ArrayList<String> textLines;
        ArrayList<JSONText> textObjects;
        int boxWidth;
        super.setupComponents();
        this.textInputBoxes.clear();
        if (this.entity instanceof TileEntityPole_Sign) {
            GUIComponent3DModel modelRender = new GUIComponent3DModel(this.guiLeft + 3 * this.getWidth() / 4, this.guiTop + 160, 64.0f, false, false, false);
            this.addComponent(modelRender);
            modelRender.modelLocation = ((AJSONMultiModelProvider)this.entity.definition).getModelLocation(this.entity.subName);
            modelRender.textureLocation = ((AJSONMultiModelProvider)this.entity.definition).getTextureLocation(this.entity.subName);
            boxWidth = 100;
            textObjects = new ArrayList();
            textLines = new ArrayList();
            textObjects.addAll(this.entity.text.keySet());
            textLines.addAll(this.entity.text.values());
            this.signTextLabels.clear();
            for (int i = 0; i < textObjects.size(); i = (int)((byte)(i + 1))) {
                JSONText textDef = (JSONText)textObjects.get(i);
                label = new GUIComponentLabel(modelRender.constructedX + (int)(textDef.pos.x * 64.0), modelRender.constructedY - (int)(textDef.pos.y * 64.0), textDef.color, (String)textLines.get(i), RenderText.TextAlignment.values()[textDef.renderPosition], textDef.scale * 64.0f / 16.0f, textDef.wrapWidth * 64 / 16, textDef.fontName, textDef.autoScale);
                this.addComponent(label);
                this.signTextLabels.add(label);
            }
        } else {
            boxWidth = 200;
            textObjects = new ArrayList<JSONText>();
            textLines = new ArrayList<String>();
            textObjects.addAll(this.entity.text.keySet());
            textLines.addAll(this.entity.text.values());
            if (this.entity instanceof AEntityF_Multipart) {
                for (APart part : ((AEntityF_Multipart)this.entity).parts) {
                    textObjects.addAll(part.text.keySet());
                    textLines.addAll(part.text.values());
                }
            }
        }
        this.textInputFieldNames.clear();
        int currentOffset = 0;
        for (JSONText textObject : textObjects) {
            if (textObject.variableName != null || this.textInputFieldNames.contains(textObject.fieldName)) continue;
            label = new GUIComponentLabel(this.guiLeft + 20, this.guiTop + 30 + currentOffset, ColorRGB.BLACK, textObject.fieldName);
            this.addComponent(label);
            int textRowsRequired = 1 + 5 * textObject.maxLength / boxWidth;
            GUIComponentTextBox box = new GUIComponentTextBox(this.guiLeft + 20, label.constructedY + 10, boxWidth, 12 * textRowsRequired, (String)textLines.get(textObjects.indexOf(textObject)), ColorRGB.WHITE, textObject.maxLength);
            this.addComponent(box);
            this.textInputBoxes.add(box);
            currentOffset += box.height + 12;
            this.textInputFieldNames.add(textObject.fieldName);
        }
        this.confirmButton = new GUIComponentButton(this.guiLeft + 150, this.guiTop + 15, 80, 20, InterfaceCore.translate("gui.trafficsignalcontroller.confirm")){

            @Override
            public void onClicked(boolean leftSide) {
                ArrayList<String> packetTextLines = new ArrayList<String>();
                for (JSONText textObject : textObjects) {
                    packetTextLines.add(((GUIComponentTextBox)GUITextEditor.this.textInputBoxes.get(GUITextEditor.this.textInputFieldNames.indexOf(textObject.fieldName))).getText());
                }
                InterfacePacket.sendToServer(new PacketEntityTextChange(GUITextEditor.this.entity, packetTextLines));
                GUITextEditor.this.close();
            }
        };
        this.addComponent(this.confirmButton);
    }

    @Override
    public void setStates() {
        super.setStates();
        this.confirmButton.enabled = true;
        for (int i = 0; i < this.signTextLabels.size(); ++i) {
            this.signTextLabels.get((int)i).text = this.textInputBoxes.get(i).getText();
        }
    }
}

