/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.components;

import java.util.List;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.jsondefs.JSONCraftingBench;
import minecrafttransportsimulator.jsondefs.JSONPack;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.systems.PackParserSystem;

public abstract class AItemPack<JSONDefinition extends AJSONItem>
extends AItemBase {
    public final JSONDefinition definition;
    private final String sourcePackID;

    public AItemPack(JSONDefinition definition, String sourcePackID) {
        this.definition = definition;
        this.sourcePackID = sourcePackID;
    }

    @Override
    public String getRegistrationName() {
        return ((AJSONItem)this.definition).packID + "." + ((AJSONItem)this.definition).systemName;
    }

    @Override
    public String getItemName() {
        return ((AJSONItem)this.definition).general.name != null ? ((AJSONItem)this.definition).general.name : ((AJSONItem)this.definition).systemName;
    }

    @Override
    public void addTooltipLines(List<String> tooltipLines, WrapperNBT data) {
        if (((AJSONItem)this.definition).general.description != null) {
            for (String tooltipLine : ((AJSONItem)this.definition).general.description.split("\n")) {
                tooltipLines.add(tooltipLine);
            }
        }
    }

    @Override
    public int getStackSize() {
        return ((AJSONItem)this.definition).general.stackSize != 0 ? ((AJSONItem)this.definition).general.stackSize : super.getStackSize();
    }

    @Override
    public String getCreativeTabID() {
        String owningPackID = ((AJSONItem)this.definition).packID;
        String generatingPackID = this.sourcePackID != null ? this.sourcePackID : ((AJSONItem)this.definition).packID;
        JSONPack owningConfiguration = PackParserSystem.getPackConfiguration(((AJSONItem)this.definition).packID);
        JSONPack generatingConfiguration = PackParserSystem.getPackConfiguration(generatingPackID);
        if (owningConfiguration.externalSkinsInOwnTab) {
            return generatingPackID;
        }
        if (generatingConfiguration.internalSkinsInOwnTab) {
            return generatingPackID;
        }
        return owningPackID;
    }

    public boolean isBenchValid(JSONCraftingBench craftingDefinition) {
        boolean hasMaterials;
        boolean bl = hasMaterials = !((AJSONItem)this.definition).general.materials.isEmpty();
        if (!hasMaterials && this instanceof AItemSubTyped) {
            AItemSubTyped subTypedItem = (AItemSubTyped)this;
            for (JSONSubDefinition subDefinition : ((AJSONMultiModelProvider)subTypedItem.definition).definitions) {
                if (!subDefinition.subName.equals(subTypedItem.subName)) continue;
                hasMaterials = !subDefinition.extraMaterials.isEmpty();
            }
        }
        if (hasMaterials) {
            if (craftingDefinition.items != null) {
                return craftingDefinition.items.contains(((AJSONItem)this.definition).packID + ":" + ((AJSONItem)this.definition).systemName);
            }
            if (craftingDefinition.itemTypes.contains(((AJSONItem)this.definition).classification.toString().toLowerCase())) {
                if (this.definition instanceof JSONPart && craftingDefinition.partTypes != null) {
                    for (String partType : craftingDefinition.partTypes) {
                        if (!((JSONPart)this.definition).generic.type.contains(partType)) continue;
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    public void populateDefaultData(WrapperNBT data) {
        data.setString("packID", ((AJSONItem)this.definition).packID);
        data.setString("systemName", ((AJSONItem)this.definition).systemName);
    }
}

