/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.components;

import java.util.List;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.mcinterface.WrapperNBT;

public abstract class AItemSubTyped<JSONDefinition extends AJSONMultiModelProvider>
extends AItemPack<JSONDefinition> {
    public final String subName;

    public AItemSubTyped(JSONDefinition definition, String subName, String sourcePackID) {
        super(definition, sourcePackID);
        this.subName = subName;
    }

    @Override
    public String getRegistrationName() {
        return super.getRegistrationName() + this.subName;
    }

    @Override
    public String getItemName() {
        for (JSONSubDefinition subDefinition : ((AJSONMultiModelProvider)this.definition).definitions) {
            if (!subDefinition.subName.equals(this.subName)) continue;
            return subDefinition.name != null ? subDefinition.name : super.getItemName();
        }
        return "";
    }

    @Override
    public void addTooltipLines(List<String> tooltipLines, WrapperNBT data) {
        super.addTooltipLines(tooltipLines, data);
        for (JSONSubDefinition subDefinition : ((AJSONMultiModelProvider)this.definition).definitions) {
            if (!subDefinition.subName.equals(this.subName) || subDefinition.description == null) continue;
            for (String tooltipLine : subDefinition.description.split("\n")) {
                tooltipLines.add(tooltipLine);
            }
        }
    }

    @Override
    public void populateDefaultData(WrapperNBT data) {
        super.populateDefaultData(data);
        data.setString("subName", this.subName);
    }

    public List<String> getExtraMaterials() {
        for (JSONSubDefinition subDefinition : ((AJSONMultiModelProvider)this.definition).definitions) {
            if (!subDefinition.subName.equals(this.subName)) continue;
            return subDefinition.extraMaterials;
        }
        return null;
    }
}

