/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.components;

import java.util.HashMap;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;

public interface IItemBlock {
    public static final Map<IItemBlock, ABlockBase> itemToBlockMap = new HashMap<IItemBlock, ABlockBase>();

    public Class<? extends ABlockBase> getBlockClass();

    default public ABlockBase getBlock() {
        if (!itemToBlockMap.containsKey(this)) {
            Class<? extends ABlockBase> blockClass = this.getBlockClass();
            ABlockBase existingBlock = null;
            for (ABlockBase block : itemToBlockMap.values()) {
                if (!blockClass.equals(block.getClass())) continue;
                existingBlock = block;
                break;
            }
            if (existingBlock != null) {
                itemToBlockMap.put(this, existingBlock);
            } else {
                try {
                    itemToBlockMap.put(this, this.getBlockClass().newInstance());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return itemToBlockMap.get(this);
    }

    default public boolean placeBlock(WrapperWorld world, WrapperPlayer player, Point3d position, ABlockBase.Axis axis) {
        return world.setBlock(this.getBlock(), position, player, axis);
    }
}

