/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityDecor;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.items.components.IItemFood;
import minecrafttransportsimulator.items.components.IItemVehicleInteractable;
import minecrafttransportsimulator.items.instances.ItemVehicle;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.jsondefs.JSONPotionEffect;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperEntity;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.instances.PacketEntityGUIRequest;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableSet;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableToggle;
import minecrafttransportsimulator.packets.instances.PacketGUIRequest;
import minecrafttransportsimulator.packets.instances.PacketPartEngine;
import minecrafttransportsimulator.packets.instances.PacketPartInteractable;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.systems.ConfigSystem;

public class ItemItem
extends AItemPack<JSONItem>
implements IItemVehicleInteractable,
IItemFood {
    public int pageNumber;
    private static PartEngine firstEngineClicked;
    private static PartInteractable firstPartClicked;

    public ItemItem(JSONItem definition) {
        super(definition, null);
    }

    @Override
    public boolean canBreakBlocks() {
        return !((JSONItem)this.definition).item.type.equals((Object)JSONItem.ItemComponentType.WRENCH);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public IItemVehicleInteractable.CallbackType doVehicleInteraction(EntityVehicleF_Physics vehicle, APart part, BoundingBox hitBox, WrapperPlayer player, AEntityE_Interactable.PlayerOwnerState ownerState, boolean rightClick) {
        switch (((JSONItem)this.definition).item.type) {
            case WRENCH: {
                if (vehicle.world.isClient()) return IItemVehicleInteractable.CallbackType.NONE;
                if (ownerState.equals((Object)AEntityE_Interactable.PlayerOwnerState.USER)) {
                    player.sendPacket(new PacketPlayerChatMessage(player, "interact.failure.vehicleowned"));
                    return IItemVehicleInteractable.CallbackType.NONE;
                }
                if (rightClick) {
                    if (((Boolean)ConfigSystem.configObject.clientControls.devMode.value).booleanValue() && vehicle.equals(player.getEntityRiding())) {
                        player.sendPacket(new PacketEntityGUIRequest(vehicle, player, PacketEntityGUIRequest.EntityGUIType.PACK_EXPORTER));
                        return IItemVehicleInteractable.CallbackType.NONE;
                    }
                    if (player.isSneaking()) {
                        player.sendPacket(new PacketEntityGUIRequest(vehicle, player, PacketEntityGUIRequest.EntityGUIType.TEXT_EDITOR));
                        return IItemVehicleInteractable.CallbackType.NONE;
                    }
                    player.sendPacket(new PacketEntityGUIRequest(vehicle, player, PacketEntityGUIRequest.EntityGUIType.INSTRUMENTS));
                    return IItemVehicleInteractable.CallbackType.NONE;
                }
                if (vehicle.world.isClient()) return IItemVehicleInteractable.CallbackType.NONE;
                if (part != null && !player.isSneaking() && !part.placementDefinition.isPermanent && part.isValid) {
                    if (part instanceof PartInteractable) {
                        PartInteractable interactable = (PartInteractable)part;
                        if (!((JSONPart)interactable.definition).interactable.canBeOpenedInHand && interactable.getMass() > (double)((JSONPart)interactable.definition).generic.mass) {
                            player.sendPacket(new PacketPlayerChatMessage(player, InterfaceCore.translate("interact.failure.cantremoveinventory")));
                            return IItemVehicleInteractable.CallbackType.NONE;
                        }
                    }
                    part.disconnectAllConnections();
                    vehicle.removePart(part, (Iterator)null);
                    AItemPart droppedItem = (AItemPart)part.getItem();
                    if (droppedItem == null) return IItemVehicleInteractable.CallbackType.NONE;
                    WrapperNBT partData = new WrapperNBT();
                    part.save(partData);
                    vehicle.world.spawnItem(droppedItem, partData, part.position);
                    return IItemVehicleInteractable.CallbackType.NONE;
                }
                if (!player.isSneaking()) return IItemVehicleInteractable.CallbackType.NONE;
                if (((Boolean)ConfigSystem.configObject.general.opPickupVehiclesOnly.value).booleanValue()) {
                    if (!ownerState.equals((Object)AEntityE_Interactable.PlayerOwnerState.ADMIN)) return IItemVehicleInteractable.CallbackType.NONE;
                }
                if (((Boolean)ConfigSystem.configObject.general.creativePickupVehiclesOnly.value).booleanValue()) {
                    if (!player.isCreative()) return IItemVehicleInteractable.CallbackType.NONE;
                }
                if (!vehicle.isValid) return IItemVehicleInteractable.CallbackType.NONE;
                vehicle.disconnectAllConnections();
                Iterator droppedItem = vehicle.parts.iterator();
                while (true) {
                    if (!droppedItem.hasNext()) {
                        ItemVehicle vehicleItem = (ItemVehicle)vehicle.getItem();
                        WrapperNBT vehicleData = new WrapperNBT();
                        vehicle.save(vehicleData);
                        vehicle.world.spawnItem(vehicleItem, vehicleData, vehicle.position);
                        vehicle.remove();
                        return IItemVehicleInteractable.CallbackType.NONE;
                    }
                    APart vehiclePart = (APart)droppedItem.next();
                    vehiclePart.disconnectAllConnections();
                }
            }
            case PAINT_GUN: {
                if (vehicle.world.isClient()) return IItemVehicleInteractable.CallbackType.NONE;
                if (!rightClick) return IItemVehicleInteractable.CallbackType.NONE;
                if (ownerState.equals((Object)AEntityE_Interactable.PlayerOwnerState.USER)) {
                    player.sendPacket(new PacketPlayerChatMessage(player, "interact.failure.vehicleowned"));
                    return IItemVehicleInteractable.CallbackType.NONE;
                }
                if (part != null) {
                    player.sendPacket(new PacketEntityGUIRequest(part, player, PacketEntityGUIRequest.EntityGUIType.PAINT_GUN));
                    return IItemVehicleInteractable.CallbackType.NONE;
                }
                player.sendPacket(new PacketEntityGUIRequest(vehicle, player, PacketEntityGUIRequest.EntityGUIType.PAINT_GUN));
                return IItemVehicleInteractable.CallbackType.NONE;
            }
            case KEY: {
                if (!vehicle.world.isClient() && rightClick) {
                    WrapperItemStack stack = player.getHeldStack();
                    WrapperNBT data = stack.getData();
                    UUID keyVehicleUUID = data.getUUID("vehicle");
                    if (keyVehicleUUID == null) {
                        if (vehicle.ownerUUID != null && ownerState.equals((Object)AEntityE_Interactable.PlayerOwnerState.USER)) {
                            player.sendPacket(new PacketPlayerChatMessage(player, "interact.key.failure.notowner"));
                            return IItemVehicleInteractable.CallbackType.NONE;
                        }
                        keyVehicleUUID = vehicle.uniqueUUID;
                        data.setUUID("vehicle", keyVehicleUUID);
                        stack.setData(data);
                    }
                    if (!keyVehicleUUID.equals(vehicle.uniqueUUID)) {
                        player.sendPacket(new PacketPlayerChatMessage(player, "interact.key.failure.wrongkey"));
                        return IItemVehicleInteractable.CallbackType.NONE;
                    }
                    if (part instanceof PartSeat) {
                        return IItemVehicleInteractable.CallbackType.SKIP;
                    }
                    if (vehicle.locked) {
                        vehicle.locked = false;
                        player.sendPacket(new PacketPlayerChatMessage(player, "interact.key.info.unlock"));
                        if (hitBox.definition == null) return IItemVehicleInteractable.CallbackType.ALL;
                        if (hitBox.definition.variableName == null) return IItemVehicleInteractable.CallbackType.ALL;
                        if (vehicle.isVariableActive(hitBox.definition.variableName)) return IItemVehicleInteractable.CallbackType.ALL;
                        if (vehicle.getVariable(hitBox.definition.variableName) != 0.0) return IItemVehicleInteractable.CallbackType.ALL;
                        return IItemVehicleInteractable.CallbackType.ALL_AND_MORE;
                    }
                    vehicle.locked = true;
                    player.sendPacket(new PacketPlayerChatMessage(player, "interact.key.info.lock"));
                    if (hitBox.definition == null) return IItemVehicleInteractable.CallbackType.ALL;
                    if (hitBox.definition.variableName == null) return IItemVehicleInteractable.CallbackType.ALL;
                    if (vehicle.isVariableActive(hitBox.definition.variableName)) return IItemVehicleInteractable.CallbackType.ALL_AND_MORE;
                    if (vehicle.getVariable(hitBox.definition.variableName) == 0.0) return IItemVehicleInteractable.CallbackType.ALL;
                    return IItemVehicleInteractable.CallbackType.ALL_AND_MORE;
                }
                vehicle.locked = !vehicle.locked;
                return IItemVehicleInteractable.CallbackType.NONE;
            }
            case TICKET: {
                if (vehicle.world.isClient()) return IItemVehicleInteractable.CallbackType.NONE;
                if (!rightClick) return IItemVehicleInteractable.CallbackType.NONE;
                if (!player.isSneaking()) {
                    vehicle.world.loadEntities(new BoundingBox(player.getPosition(), 8.0, 8.0, 8.0), vehicle);
                    return IItemVehicleInteractable.CallbackType.NONE;
                }
                Iterator iterator = vehicle.locationRiderMap.inverse().keySet().iterator();
                while (iterator.hasNext()) {
                    WrapperEntity entity = (WrapperEntity)iterator.next();
                    if (entity instanceof WrapperPlayer) continue;
                    vehicle.removeRider(entity, iterator);
                }
                return IItemVehicleInteractable.CallbackType.NONE;
            }
            case FUEL_HOSE: {
                if (vehicle.world.isClient()) return IItemVehicleInteractable.CallbackType.NONE;
                if (!rightClick) return IItemVehicleInteractable.CallbackType.NONE;
                if (firstPartClicked == null) {
                    if (!(part instanceof PartInteractable)) return IItemVehicleInteractable.CallbackType.NONE;
                    PartInteractable interactable = (PartInteractable)part;
                    if (interactable.tank == null) return IItemVehicleInteractable.CallbackType.NONE;
                    if (interactable.linkedPart == null && interactable.linkedVehicle == null) {
                        firstPartClicked = interactable;
                        player.sendPacket(new PacketPlayerChatMessage(player, "interact.fuelhose.firstlink"));
                        return IItemVehicleInteractable.CallbackType.NONE;
                    }
                    player.sendPacket(new PacketPlayerChatMessage(player, "interact.fuelhose.alreadylinked"));
                    return IItemVehicleInteractable.CallbackType.NONE;
                }
                if (part instanceof PartInteractable) {
                    PartInteractable interactable = (PartInteractable)part;
                    if (interactable.tank == null) return IItemVehicleInteractable.CallbackType.NONE;
                    if (interactable.equals(firstPartClicked)) return IItemVehicleInteractable.CallbackType.NONE;
                    if (interactable.linkedPart == null && interactable.linkedVehicle == null) {
                        if (!(part.position.distanceTo(ItemItem.firstPartClicked.position) < 15.0)) {
                            firstPartClicked = null;
                            player.sendPacket(new PacketPlayerChatMessage(player, "interact.fuelhose.toofar"));
                            return IItemVehicleInteractable.CallbackType.NONE;
                        }
                        if (!(interactable.tank.getFluid().isEmpty() || ItemItem.firstPartClicked.tank.getFluid().isEmpty() || interactable.tank.getFluid().equals(ItemItem.firstPartClicked.tank.getFluid()))) {
                            firstPartClicked = null;
                            player.sendPacket(new PacketPlayerChatMessage(player, "interact.fuelhose.differentfluids"));
                            return IItemVehicleInteractable.CallbackType.NONE;
                        }
                        ItemItem.firstPartClicked.linkedPart = interactable;
                        InterfacePacket.sendToAllClients(new PacketPartInteractable(firstPartClicked, player));
                        player.sendPacket(new PacketPlayerChatMessage(player, "interact.fuelhose.secondlink"));
                        firstPartClicked = null;
                        return IItemVehicleInteractable.CallbackType.NONE;
                    }
                    firstPartClicked = null;
                    player.sendPacket(new PacketPlayerChatMessage(player, "interact.fuelhose.alreadylinked"));
                    return IItemVehicleInteractable.CallbackType.NONE;
                }
                if (part != null) return IItemVehicleInteractable.CallbackType.NONE;
                if (!(vehicle.position.distanceTo(ItemItem.firstPartClicked.position) < 15.0)) {
                    firstPartClicked = null;
                    player.sendPacket(new PacketPlayerChatMessage(player, "interact.fuelhose.toofar"));
                    return IItemVehicleInteractable.CallbackType.NONE;
                }
                if (!(vehicle.fuelTank.getFluid().isEmpty() || ItemItem.firstPartClicked.tank.getFluid().isEmpty() || vehicle.fuelTank.getFluid().equals(ItemItem.firstPartClicked.tank.getFluid()))) {
                    firstPartClicked = null;
                    player.sendPacket(new PacketPlayerChatMessage(player, "interact.fuelhose.differentfluids"));
                    return IItemVehicleInteractable.CallbackType.NONE;
                }
                ItemItem.firstPartClicked.linkedVehicle = vehicle;
                InterfacePacket.sendToAllClients(new PacketPartInteractable(firstPartClicked, player));
                player.sendPacket(new PacketPlayerChatMessage(player, "interact.fuelhose.secondlink"));
                firstPartClicked = null;
                return IItemVehicleInteractable.CallbackType.NONE;
            }
            case JUMPER_CABLES: {
                if (vehicle.world.isClient()) return IItemVehicleInteractable.CallbackType.NONE;
                if (!rightClick) return IItemVehicleInteractable.CallbackType.NONE;
                if (!(part instanceof PartEngine)) return IItemVehicleInteractable.CallbackType.NONE;
                PartEngine engine = (PartEngine)part;
                if (engine.linkedEngine != null) {
                    player.sendPacket(new PacketPlayerChatMessage(player, "interact.jumpercable.alreadylinked"));
                    return IItemVehicleInteractable.CallbackType.NONE;
                }
                if (firstEngineClicked == null) {
                    firstEngineClicked = engine;
                    player.sendPacket(new PacketPlayerChatMessage(player, "interact.jumpercable.firstlink"));
                    return IItemVehicleInteractable.CallbackType.NONE;
                }
                if (firstEngineClicked.equals(engine)) return IItemVehicleInteractable.CallbackType.NONE;
                if (ItemItem.firstEngineClicked.entityOn.equals(engine.entityOn)) {
                    firstEngineClicked = null;
                    player.sendPacket(new PacketPlayerChatMessage(player, "interact.jumpercable.samevehicle"));
                    return IItemVehicleInteractable.CallbackType.NONE;
                }
                if (engine.position.distanceTo(ItemItem.firstEngineClicked.position) < 15.0) {
                    engine.linkedEngine = firstEngineClicked;
                    ItemItem.firstEngineClicked.linkedEngine = engine;
                    InterfacePacket.sendToAllClients(new PacketPartEngine(engine, firstEngineClicked));
                    InterfacePacket.sendToAllClients(new PacketPartEngine(firstEngineClicked, engine));
                    firstEngineClicked = null;
                    player.sendPacket(new PacketPlayerChatMessage(player, "interact.jumpercable.secondlink"));
                    return IItemVehicleInteractable.CallbackType.NONE;
                }
                firstEngineClicked = null;
                player.sendPacket(new PacketPlayerChatMessage(player, "interact.jumpercable.toofar"));
                return IItemVehicleInteractable.CallbackType.NONE;
            }
            case JUMPER_PACK: {
                if (!rightClick) return IItemVehicleInteractable.CallbackType.NONE;
                vehicle.electricPower = 12.0;
                if (vehicle.world.isClient()) return IItemVehicleInteractable.CallbackType.NONE;
                InterfacePacket.sendToPlayer(new PacketPlayerChatMessage(player, "interact.jumperpack.success"), player);
                if (player.isCreative()) return IItemVehicleInteractable.CallbackType.ALL;
                player.getInventory().removeFromSlot(player.getHotbarIndex(), 1);
                return IItemVehicleInteractable.CallbackType.ALL;
            }
        }
        return IItemVehicleInteractable.CallbackType.SKIP;
    }

    @Override
    public boolean onBlockClicked(WrapperWorld world, WrapperPlayer player, Point3d position, ABlockBase.Axis axis) {
        if (((JSONItem)this.definition).item.type.equals((Object)JSONItem.ItemComponentType.PAINT_GUN) && !world.isClient()) {
            Object tile = world.getTileEntity(position);
            if (tile instanceof TileEntityDecor) {
                player.sendPacket(new PacketEntityGUIRequest((AEntityB_Existing)tile, player, PacketEntityGUIRequest.EntityGUIType.PAINT_GUN));
                return true;
            }
            if (tile instanceof TileEntityPole) {
                TileEntityPole pole = (TileEntityPole)tile;
                axis = ABlockBase.Axis.getFromRotation(player.getYaw(), ((JSONPoleComponent)pole.definition).pole.allowsDiagonals).getOpposite();
                if (pole.components.containsKey((Object)axis)) {
                    player.sendPacket(new PacketEntityGUIRequest(pole.components.get((Object)axis), player, PacketEntityGUIRequest.EntityGUIType.PAINT_GUN));
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onUsed(WrapperWorld world, WrapperPlayer player) {
        if (((JSONItem)this.definition).item.type.equals((Object)JSONItem.ItemComponentType.BOOKLET)) {
            if (!world.isClient()) {
                player.sendPacket(new PacketGUIRequest(player, PacketGUIRequest.GUIType.BOOKELET));
            }
        } else if (((JSONItem)this.definition).item.type.equals((Object)JSONItem.ItemComponentType.Y2K_BUTTON) && !world.isClient() && player.isOP()) {
            for (EntityVehicleF_Physics vehicle : world.getEntitiesOfType(EntityVehicleF_Physics.class)) {
                vehicle.setVariable("throttle", 0.0);
                InterfacePacket.sendToAllClients(new PacketEntityVariableSet(vehicle, "throttle", 0.0));
                if (!vehicle.isVariableActive("p_brake")) {
                    vehicle.setVariable("p_brake", 1.0);
                    InterfacePacket.sendToAllClients(new PacketEntityVariableToggle(vehicle, "p_brake"));
                }
                for (PartEngine engine : vehicle.engines.values()) {
                    if (!engine.isVariableActive("engine_magneto")) continue;
                    engine.setVariable("engine_magneto", 0.0);
                    InterfacePacket.sendToAllClients(new PacketEntityVariableToggle(engine, "engine_magneto"));
                }
            }
        }
        return true;
    }

    @Override
    public int getTimeToEat() {
        return ((JSONItem)this.definition).item.type.equals((Object)JSONItem.ItemComponentType.FOOD) ? ((JSONItem)this.definition).food.timeToEat : 0;
    }

    @Override
    public boolean isDrink() {
        return ((JSONItem)this.definition).food.isDrink;
    }

    @Override
    public int getHungerAmount() {
        return ((JSONItem)this.definition).food.hungerAmount;
    }

    @Override
    public float getSaturationAmount() {
        return ((JSONItem)this.definition).food.saturationAmount;
    }

    @Override
    public List<JSONPotionEffect> getEffects() {
        return ((JSONItem)this.definition).food.effects;
    }
}

