/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.systems.ConfigSystem;

public class ItemPartEngine
extends AItemPart {
    public static final AItemPart.AItemPartCreator CREATOR = new AItemPart.AItemPartCreator(){

        @Override
        public boolean isCreatorValid(JSONPart definition) {
            return definition.generic.type.startsWith("engine");
        }

        @Override
        public ItemPartEngine createItem(JSONPart definition, String subName, String sourcePackID) {
            return new ItemPartEngine(definition, subName, sourcePackID);
        }
    };

    public ItemPartEngine(JSONPart definition, String subName, String sourcePackID) {
        super(definition, subName, sourcePackID);
    }

    @Override
    public boolean isPartValidForPackDef(JSONPartDefinition placementDefinition, String subNameToPlaceOn, boolean checkMinMax) {
        return super.isPartValidForPackDef(placementDefinition, subNameToPlaceOn, checkMinMax) && (!checkMinMax || placementDefinition.minValue <= ((JSONPart)this.definition).engine.fuelConsumption && placementDefinition.maxValue >= ((JSONPart)this.definition).engine.fuelConsumption);
    }

    @Override
    public PartEngine createPart(AEntityF_Multipart<?> entity, WrapperPlayer placingPlayer, JSONPartDefinition packVehicleDef, WrapperNBT partData, APart parentPart) {
        return new PartEngine(entity, placingPlayer, packVehicleDef, partData, parentPart);
    }

    @Override
    public void addTooltipLines(List<String> tooltipLines, WrapperNBT data) {
        super.addTooltipLines(tooltipLines, data);
        if (data.getBoolean("isCreative")) {
            tooltipLines.add(InterfaceCore.translate("info.item.engine.creative"));
        }
        tooltipLines.add(InterfaceCore.translate("info.item.engine.maxrpm") + ((JSONPart)this.definition).engine.maxRPM);
        tooltipLines.add(InterfaceCore.translate("info.item.engine.maxsaferpm") + ((JSONPart)this.definition).engine.maxSafeRPM);
        tooltipLines.add(InterfaceCore.translate("info.item.engine.fuelconsumption") + ((JSONPart)this.definition).engine.fuelConsumption);
        if (((JSONPart)this.definition).engine.jetPowerFactor > 0.0f) {
            tooltipLines.add(InterfaceCore.translate("info.item.engine.jetpowerfactor") + (int)(100.0f * ((JSONPart)this.definition).engine.jetPowerFactor) + "%");
            tooltipLines.add(InterfaceCore.translate("info.item.engine.bypassratio") + ((JSONPart)this.definition).engine.bypassRatio);
        }
        tooltipLines.add(InterfaceCore.translate("info.item.engine.fueltype") + ((JSONPart)this.definition).engine.fuelType);
        if (ConfigSystem.configObject.fuel.fuels.containsKey(((JSONPart)this.definition).engine.fuelType)) {
            String line = InterfaceCore.translate("info.item.engine.fluids");
            for (Map.Entry<String, Double> fuelEntry : ConfigSystem.configObject.fuel.fuels.get(((JSONPart)this.definition).engine.fuelType).entrySet()) {
                String fluidName = InterfaceCore.getFluidName(fuelEntry.getKey());
                if (fluidName.equals("INVALID")) continue;
                line = line + InterfaceCore.getFluidName(fuelEntry.getKey()) + "@" + fuelEntry.getValue() + ", ";
            }
            tooltipLines.add(line.substring(0, line.length() - 2));
        }
        tooltipLines.add(InterfaceCore.translate("info.item.engine.hours") + (double)Math.round(data.getDouble("hours") * 100.0) / 100.0);
        if (((JSONPart)this.definition).engine.gearRatios.size() > 3) {
            tooltipLines.add(((JSONPart)this.definition).engine.isAutomatic ? InterfaceCore.translate("info.item.engine.automatic") : InterfaceCore.translate("info.item.engine.manual"));
            tooltipLines.add(InterfaceCore.translate("info.item.engine.gearratios"));
            for (int i = 0; i < ((JSONPart)this.definition).engine.gearRatios.size(); i = (int)((byte)(i + 5))) {
                String gearRatios = "";
                for (int j = i; j < i + 5 && j < ((JSONPart)this.definition).engine.gearRatios.size(); j = (int)((byte)(j + 1))) {
                    gearRatios = gearRatios + String.valueOf(((JSONPart)this.definition).engine.gearRatios.get(j));
                    if (j >= ((JSONPart)this.definition).engine.gearRatios.size() - 1) continue;
                    gearRatios = gearRatios + ",  ";
                }
                tooltipLines.add(gearRatios);
            }
        } else {
            tooltipLines.add(InterfaceCore.translate("info.item.engine.gearratios") + ((JSONPart)this.definition).engine.gearRatios.get(((JSONPart)this.definition).engine.gearRatios.size() - 1));
        }
        if (data.getBoolean("oilLeak")) {
            tooltipLines.add(InterfaceCore.translate("info.item.engine.oilleak"));
        }
        if (data.getBoolean("fuelLeak")) {
            tooltipLines.add(InterfaceCore.translate("info.item.engine.fuelleak"));
        }
        if (data.getBoolean("brokenStarter")) {
            tooltipLines.add(InterfaceCore.translate("info.item.engine.brokenstarter"));
        }
    }

    @Override
    public void getDataBlocks(List<WrapperNBT> dataBlocks) {
        WrapperNBT data = new WrapperNBT();
        data.setBoolean("isCreative", true);
        dataBlocks.add(data);
    }
}

