/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import java.util.List;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityPlayerGun;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.items.components.IItemEntityProvider;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;

public class ItemPartGun
extends AItemPart
implements IItemEntityProvider<EntityPlayerGun> {
    public static final AItemPart.AItemPartCreator CREATOR = new AItemPart.AItemPartCreator(){

        @Override
        public boolean isCreatorValid(JSONPart definition) {
            return definition.generic.type.startsWith("gun");
        }

        @Override
        public ItemPartGun createItem(JSONPart definition, String subName, String sourcePackID) {
            return new ItemPartGun(definition, subName, sourcePackID);
        }
    };

    public ItemPartGun(JSONPart definition, String subName, String sourcePackID) {
        super(definition, subName, sourcePackID);
    }

    @Override
    public boolean isPartValidForPackDef(JSONPartDefinition placementDefinition, String subNameToPlaceOn, boolean checkMinMax) {
        return super.isPartValidForPackDef(placementDefinition, subNameToPlaceOn, checkMinMax) && (!checkMinMax || placementDefinition.minValue <= ((JSONPart)this.definition).gun.diameter && placementDefinition.maxValue >= ((JSONPart)this.definition).gun.diameter);
    }

    @Override
    public PartGun createPart(AEntityF_Multipart<?> entity, WrapperPlayer placingPlayer, JSONPartDefinition packVehicleDef, WrapperNBT partData, APart parentPart) {
        return new PartGun(entity, placingPlayer, packVehicleDef, partData, parentPart);
    }

    @Override
    public void addTooltipLines(List<String> tooltipLines, WrapperNBT data) {
        super.addTooltipLines(tooltipLines, data);
        tooltipLines.add(InterfaceCore.translate("info.item.gun.diameter") + ((JSONPart)this.definition).gun.diameter);
        tooltipLines.add(InterfaceCore.translate("info.item.gun.caseRange") + ((JSONPart)this.definition).gun.minCaseLength + "-" + ((JSONPart)this.definition).gun.maxCaseLength);
        tooltipLines.add(InterfaceCore.translate("info.item.gun.fireDelay") + ((JSONPart)this.definition).gun.fireDelay);
        tooltipLines.add(InterfaceCore.translate("info.item.gun.muzzleVelocity") + ((JSONPart)this.definition).gun.muzzleVelocity);
        tooltipLines.add(InterfaceCore.translate("info.item.gun.capacity") + ((JSONPart)this.definition).gun.capacity);
        if (((JSONPart)this.definition).gun.autoReload) {
            tooltipLines.add(InterfaceCore.translate("info.item.gun.autoReload"));
        }
        tooltipLines.add(InterfaceCore.translate("info.item.gun.yawRange") + ((JSONPart)this.definition).gun.minYaw + "-" + ((JSONPart)this.definition).gun.maxYaw);
        tooltipLines.add(InterfaceCore.translate("info.item.gun.pitchRange") + ((JSONPart)this.definition).gun.minPitch + "-" + ((JSONPart)this.definition).gun.maxPitch);
    }

    @Override
    public boolean canBreakBlocks() {
        return !((JSONPart)this.definition).gun.handHeld;
    }

    @Override
    public EntityPlayerGun createEntity(WrapperWorld world, WrapperPlayer placingPlayer, WrapperNBT data) {
        return new EntityPlayerGun(world, placingPlayer, data);
    }

    @Override
    public Class<EntityPlayerGun> getEntityClass() {
        return EntityPlayerGun.class;
    }
}

