/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import java.util.List;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityFluidTank;
import minecrafttransportsimulator.entities.instances.EntityFurnace;
import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.items.components.IItemVehicleInteractable;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.instances.PacketFurnaceFuelAdd;
import minecrafttransportsimulator.packets.instances.PacketItemInteractable;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.systems.ConfigSystem;

public class ItemPartInteractable
extends AItemPart
implements IItemVehicleInteractable {
    public static final AItemPart.AItemPartCreator CREATOR = new AItemPart.AItemPartCreator(){

        @Override
        public boolean isCreatorValid(JSONPart definition) {
            return definition.generic.type.startsWith("interactable");
        }

        @Override
        public ItemPartInteractable createItem(JSONPart definition, String subName, String sourcePackID) {
            return new ItemPartInteractable(definition, subName, sourcePackID);
        }
    };

    public ItemPartInteractable(JSONPart definition, String subName, String sourcePackID) {
        super(definition, subName, sourcePackID);
    }

    @Override
    public boolean isPartValidForPackDef(JSONPartDefinition placementDefinition, String subNameToPlaceOn, boolean checkMinMax) {
        return super.isPartValidForPackDef(placementDefinition, subNameToPlaceOn, checkMinMax) && (!checkMinMax || placementDefinition.minValue <= ((JSONPart)this.definition).interactable.inventoryUnits && placementDefinition.maxValue >= ((JSONPart)this.definition).interactable.inventoryUnits);
    }

    @Override
    public PartInteractable createPart(AEntityF_Multipart<?> entity, WrapperPlayer placingPlayer, JSONPartDefinition packVehicleDef, WrapperNBT partData, APart parentPart) {
        return new PartInteractable(entity, placingPlayer, packVehicleDef, partData, parentPart);
    }

    @Override
    public void addTooltipLines(List<String> tooltipLines, WrapperNBT data) {
        super.addTooltipLines(tooltipLines, data);
        switch (((JSONPart)this.definition).interactable.interactionType) {
            case CRATE: {
                tooltipLines.add(InterfaceCore.translate("info.item.interactable.capacity") + ((JSONPart)this.definition).interactable.inventoryUnits * 9.0f);
                break;
            }
            case BARREL: {
                tooltipLines.add(InterfaceCore.translate("info.item.interactable.capacity") + ((JSONPart)this.definition).interactable.inventoryUnits * 10000.0f + "mb");
                break;
            }
            case JERRYCAN: {
                tooltipLines.add(InterfaceCore.translate("info.item.jerrycan.fill"));
                tooltipLines.add(InterfaceCore.translate("info.item.jerrycan.drain"));
                String jerrycanFluid = data.getString("jerrycanFluid");
                if (jerrycanFluid.isEmpty()) {
                    tooltipLines.add(InterfaceCore.translate("info.item.jerrycan.empty"));
                    break;
                }
                tooltipLines.add(InterfaceCore.translate("info.item.jerrycan.contains") + InterfaceCore.getFluidName(jerrycanFluid));
                break;
            }
        }
    }

    @Override
    public IItemVehicleInteractable.CallbackType doVehicleInteraction(EntityVehicleF_Physics vehicle, APart part, BoundingBox hitBox, WrapperPlayer player, AEntityE_Interactable.PlayerOwnerState ownerState, boolean rightClick) {
        if (((JSONPart)this.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.JERRYCAN)) {
            if (!vehicle.world.isClient() && rightClick) {
                WrapperItemStack stack = player.getHeldStack();
                WrapperNBT data = stack.getData();
                String jerrrycanFluid = data.getString("jerrycanFluid");
                if (part instanceof PartInteractable) {
                    EntityFurnace furnace;
                    EntityFluidTank tank = ((PartInteractable)part).tank;
                    if (tank != null && jerrrycanFluid.isEmpty() && tank.getFluidLevel() >= 1000.0) {
                        data.setString("jerrycanFluid", tank.getFluid());
                        stack.setData(data);
                        tank.drain(tank.getFluid(), 1000.0, true);
                    }
                    if ((furnace = ((PartInteractable)part).furnace) != null && !jerrrycanFluid.isEmpty()) {
                        if (ConfigSystem.configObject.fuel.fuels.get("furnace").containsKey(jerrrycanFluid)) {
                            int addedFuel = (int)(ConfigSystem.configObject.fuel.fuels.get("furnace").get(jerrrycanFluid) * 1000.0 * 20.0 * (double)furnace.definition.furnaceEfficiency);
                            int priorFuel = furnace.ticksLeftOfFuel;
                            furnace.ticksLeftOfFuel = addedFuel;
                            InterfacePacket.sendToAllClients(new PacketFurnaceFuelAdd(furnace));
                            furnace.ticksLeftOfFuel += priorFuel;
                            furnace.ticksAddedOfFuel = furnace.ticksLeftOfFuel;
                            data.setString("jerrycanFluid", "");
                            stack.setData(data);
                            player.sendPacket(new PacketPlayerChatMessage(player, "interact.jerrycan.success"));
                        } else {
                            player.sendPacket(new PacketPlayerChatMessage(player, "interact.jerrycan.wrongtype"));
                        }
                    }
                } else if (!jerrrycanFluid.isEmpty()) {
                    if (vehicle.fuelTank.getFluid().isEmpty() || vehicle.fuelTank.getFluid().equals(jerrrycanFluid)) {
                        if (vehicle.fuelTank.getFluidLevel() + 1000.0 > (double)vehicle.fuelTank.getMaxLevel()) {
                            player.sendPacket(new PacketPlayerChatMessage(player, "interact.jerrycan.toofull"));
                        } else {
                            vehicle.fuelTank.fill(jerrrycanFluid, 1000.0, true);
                            data.setString("jerrycanFluid", "");
                            stack.setData(data);
                            player.sendPacket(new PacketPlayerChatMessage(player, "interact.jerrycan.success"));
                        }
                    } else {
                        player.sendPacket(new PacketPlayerChatMessage(player, "interact.jerrycan.wrongtype"));
                    }
                } else {
                    player.sendPacket(new PacketPlayerChatMessage(player, "interact.jerrycan.empty"));
                }
            }
            return IItemVehicleInteractable.CallbackType.NONE;
        }
        return IItemVehicleInteractable.CallbackType.SKIP;
    }

    @Override
    public boolean onUsed(WrapperWorld world, WrapperPlayer player) {
        if (((JSONPart)this.definition).interactable.canBeOpenedInHand && ((JSONPart)this.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.CRATE)) {
            if (!world.isClient()) {
                EntityInventoryContainer inventory = new EntityInventoryContainer(world, player.getHeldStack().getData().getDataOrNew("inventory"), (int)(((JSONPart)this.definition).interactable.inventoryUnits * 9.0f));
                world.addEntity(inventory);
                player.sendPacket(new PacketItemInteractable(player, inventory, ((JSONPart)this.definition).interactable.inventoryTexture));
            }
            return true;
        }
        return false;
    }
}

