/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import java.util.List;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.PartPropeller;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;

public class ItemPartPropeller
extends AItemPart {
    public static final AItemPart.AItemPartCreator CREATOR = new AItemPart.AItemPartCreator(){

        @Override
        public boolean isCreatorValid(JSONPart definition) {
            return definition.generic.type.startsWith("propeller");
        }

        @Override
        public ItemPartPropeller createItem(JSONPart definition, String subName, String sourcePackID) {
            return new ItemPartPropeller(definition, subName, sourcePackID);
        }
    };

    public ItemPartPropeller(JSONPart definition, String subName, String sourcePackID) {
        super(definition, subName, sourcePackID);
    }

    @Override
    public boolean isPartValidForPackDef(JSONPartDefinition placementDefinition, String subNameToPlaceOn, boolean checkMinMax) {
        return super.isPartValidForPackDef(placementDefinition, subNameToPlaceOn, checkMinMax) && (!checkMinMax || placementDefinition.minValue <= (float)((JSONPart)this.definition).propeller.diameter && placementDefinition.maxValue >= (float)((JSONPart)this.definition).propeller.diameter);
    }

    @Override
    public PartPropeller createPart(AEntityF_Multipart<?> entity, WrapperPlayer placingPlayer, JSONPartDefinition packVehicleDef, WrapperNBT partData, APart parentPart) {
        return new PartPropeller(entity, placingPlayer, packVehicleDef, partData, parentPart);
    }

    @Override
    public void addTooltipLines(List<String> tooltipLines, WrapperNBT data) {
        super.addTooltipLines(tooltipLines, data);
        tooltipLines.add(InterfaceCore.translate(((JSONPart)this.definition).propeller.isDynamicPitch ? "info.item.propeller.dynamicPitch" : "info.item.propeller.staticPitch"));
        tooltipLines.add(InterfaceCore.translate("info.item.propeller.pitch") + ((JSONPart)this.definition).propeller.pitch);
        tooltipLines.add(InterfaceCore.translate("info.item.propeller.diameter") + ((JSONPart)this.definition).propeller.diameter);
        tooltipLines.add(InterfaceCore.translate("info.item.propeller.maxrpm") + Math.round(20417.4 / (0.07979645340118074 * (double)((JSONPart)this.definition).propeller.diameter)));
    }
}

