/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.instances.BlockPole;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityPole_Component;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_Core;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_Sign;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_StreetLight;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_TrafficSignal;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.items.components.IItemBlock;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.systems.PackParserSystem;

public class ItemPoleComponent
extends AItemSubTyped<JSONPoleComponent>
implements IItemBlock {
    public ItemPoleComponent(JSONPoleComponent definition, String subName, String sourcePackID) {
        super(definition, subName, sourcePackID);
    }

    @Override
    public boolean onBlockClicked(WrapperWorld world, WrapperPlayer player, Point3d position, ABlockBase.Axis axis) {
        if (((JSONPoleComponent)this.definition).pole.type.equals((Object)PoleComponentType.CORE)) {
            return this.placeBlock(world, player, position, axis);
        }
        return false;
    }

    @Override
    public Class<? extends ABlockBase> getBlockClass() {
        return BlockPole.class;
    }

    public static enum PoleComponentType {
        CORE,
        TRAFFIC_SIGNAL,
        STREET_LIGHT,
        SIGN;


        public static ATileEntityPole_Component createComponent(TileEntityPole pole, WrapperPlayer placingPlayer, ABlockBase.Axis axis, WrapperNBT data) {
            ItemPoleComponent item = (ItemPoleComponent)PackParserSystem.getItem(data.getString("packID"), data.getString("systemName"), data.getString("subName"));
            switch (((JSONPoleComponent)item.definition).pole.type) {
                case CORE: {
                    return new TileEntityPole_Core(pole, placingPlayer, axis, data);
                }
                case TRAFFIC_SIGNAL: {
                    return new TileEntityPole_TrafficSignal(pole, placingPlayer, axis, data);
                }
                case STREET_LIGHT: {
                    return new TileEntityPole_StreetLight(pole, placingPlayer, axis, data);
                }
                case SIGN: {
                    return new TileEntityPole_Sign(pole, placingPlayer, axis, data);
                }
            }
            return null;
        }
    }
}

