/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.BezierCurve;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.instances.BlockCollision;
import minecrafttransportsimulator.blocks.instances.BlockRoad;
import minecrafttransportsimulator.blocks.tileentities.components.RoadClickData;
import minecrafttransportsimulator.blocks.tileentities.components.RoadLane;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityRoad;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.items.components.IItemBlock;
import minecrafttransportsimulator.jsondefs.JSONRoadComponent;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;

public class ItemRoadComponent
extends AItemSubTyped<JSONRoadComponent>
implements IItemBlock {
    private final Map<WrapperPlayer, Point3d> lastPositionClicked = new HashMap<WrapperPlayer, Point3d>();
    private final Map<WrapperPlayer, Double> lastRotationClicked = new HashMap<WrapperPlayer, Double>();
    private final Map<WrapperPlayer, RoadClickData> lastRoadClickedData = new HashMap<WrapperPlayer, RoadClickData>();

    public ItemRoadComponent(JSONRoadComponent definition, String subName, String sourcePackID) {
        super(definition, subName, sourcePackID);
    }

    @Override
    public void addTooltipLines(List<String> tooltipLines, WrapperNBT data) {
        if (((JSONRoadComponent)this.definition).road.type.equals((Object)TileEntityRoad.RoadComponent.CORE_STATIC) || ((JSONRoadComponent)this.definition).road.type.equals((Object)TileEntityRoad.RoadComponent.CORE_DYNAMIC)) {
            for (int i = 1; i <= 5; i = (int)((byte)(i + 1))) {
                tooltipLines.add(InterfaceCore.translate("info.item.roadcomponent.line" + String.valueOf(i)));
            }
        }
    }

    @Override
    public boolean onBlockClicked(WrapperWorld world, WrapperPlayer player, Point3d position, ABlockBase.Axis axis) {
        if (!world.isClient()) {
            Point3d blockPlacementPoint;
            TileEntityRoad clickedRoad;
            ABlockBase clickedBlock = world.getBlock(position);
            if (clickedBlock instanceof BlockRoad && !(clickedRoad = (TileEntityRoad)world.getTileEntity(position)).isActive()) {
                return false;
            }
            if (((JSONRoadComponent)this.definition).road.type.equals((Object)TileEntityRoad.RoadComponent.CORE_DYNAMIC)) {
                if (player.isSneaking() || !this.lastPositionClicked.containsKey(player)) {
                    this.lastRotationClicked.put(player, (double)Math.round(player.getYaw() / 15.0f) * 15.0);
                    if (clickedBlock instanceof BlockRoad) {
                        clickedRoad = (TileEntityRoad)world.getTileEntity(position);
                    } else if (clickedBlock instanceof BlockCollision) {
                        clickedRoad = ((BlockCollision)clickedBlock).getMasterRoad(world, position);
                    } else {
                        clickedRoad = null;
                        this.lastPositionClicked.put(player, position.copy().add(0.0, 1.0, 0.0));
                    }
                    if (clickedRoad != null) {
                        RoadClickData clickedRoadData = clickedRoad.getClickData(position.copy().subtract(clickedRoad.position), false);
                        JSONRoadComponent.JSONRoadGeneric roadDefinition = ((JSONRoadComponent)clickedRoadData.roadClicked.definition).road;
                        if ((roadDefinition.type.equals((Object)TileEntityRoad.RoadComponent.CORE_DYNAMIC) ? roadDefinition.laneOffsets.length : clickedRoadData.sectorClicked.lanes.size()) != ((JSONRoadComponent)this.definition).road.laneOffsets.length) {
                            player.sendPacket(new PacketPlayerChatMessage(player, "interact.roadcomponent.lanemismatchend"));
                            return true;
                        }
                        if (clickedRoadData.lanesOccupied) {
                            player.sendPacket(new PacketPlayerChatMessage(player, "interact.roadcomponent.alreadyconnected"));
                            return true;
                        }
                        this.lastPositionClicked.put(player, position);
                        this.lastRoadClickedData.put(player, clickedRoad.getClickData(position.copy().subtract(clickedRoad.position), false));
                    } else {
                        this.lastRoadClickedData.remove(player);
                    }
                    player.sendPacket(new PacketPlayerChatMessage(player, "interact.roadcomponent.set"));
                } else if (!player.isSneaking() && this.lastPositionClicked.containsKey(player)) {
                    if (position.distanceTo(this.lastPositionClicked.get(player)) < 32.0) {
                        double endRotation;
                        Point3d endPosition;
                        RoadClickData endingRoadData;
                        double startRotation;
                        Point3d startPosition;
                        RoadClickData startingRoadData;
                        TileEntityRoad startingRoad;
                        if (clickedBlock instanceof BlockRoad) {
                            startingRoad = (TileEntityRoad)world.getTileEntity(position);
                            startingRoadData = startingRoad.getClickData(position.copy().subtract(startingRoad.position), true);
                        } else if (clickedBlock instanceof BlockCollision) {
                            startingRoad = ((BlockCollision)clickedBlock).getMasterRoad(world, position);
                            startingRoadData = startingRoad.getClickData(position.copy().subtract(startingRoad.position), true);
                        } else {
                            startingRoadData = null;
                        }
                        if (startingRoadData != null) {
                            JSONRoadComponent.JSONRoadGeneric roadDefinition = ((JSONRoadComponent)startingRoadData.roadClicked.definition).road;
                            if ((roadDefinition.type.equals((Object)TileEntityRoad.RoadComponent.CORE_DYNAMIC) ? roadDefinition.laneOffsets.length : startingRoadData.sectorClicked.lanes.size()) != ((JSONRoadComponent)this.definition).road.laneOffsets.length) {
                                player.sendPacket(new PacketPlayerChatMessage(player, "interact.roadcomponent.lanemismatch"));
                                return true;
                            }
                            if (startingRoadData.lanesOccupied) {
                                player.sendPacket(new PacketPlayerChatMessage(player, "interact.roadcomponent.alreadyconnected"));
                                return true;
                            }
                            startPosition = startingRoadData.genPosition;
                            startRotation = startingRoadData.genRotation;
                            blockPlacementPoint = startPosition.copy();
                            boolean foundSpot = false;
                            for (int i = -1; i < 1 && !foundSpot; ++i) {
                                for (int j = -1; j < 1 && !foundSpot; ++j) {
                                    blockPlacementPoint.add(i, 0.0, j);
                                    if (world.isAir(blockPlacementPoint)) {
                                        foundSpot = true;
                                        continue;
                                    }
                                    blockPlacementPoint.add(-i, 0.0, -j);
                                }
                            }
                            if (!foundSpot) {
                                player.sendPacket(new PacketPlayerChatMessage(player, "interact.roadcomponent.blockedplacement"));
                                return true;
                            }
                        } else {
                            blockPlacementPoint = position.copy().add(0.0, 1.0, 0.0);
                            startRotation = Math.round(player.getYaw() / 15.0f) * 15;
                            startPosition = blockPlacementPoint.copy().add(new Point3d(-0.5, 0.0, -0.5).rotateFine(new Point3d(0.0, startRotation, 0.0)));
                        }
                        if ((endingRoadData = this.lastRoadClickedData.get(player)) != null) {
                            endPosition = endingRoadData.genPosition;
                            endRotation = endingRoadData.genRotation;
                        } else {
                            endPosition = this.lastPositionClicked.get(player).copy();
                            endRotation = this.lastRotationClicked.get(player);
                            endPosition.add(new Point3d(-0.5, 0.0, 0.5).rotateFine(new Point3d(0.0, endRotation + 180.0, 0.0)));
                        }
                        if (startPosition.equals(endPosition)) {
                            player.sendPacket(new PacketPlayerChatMessage(player, "interact.roadcomponent.sameblock"));
                            return true;
                        }
                        ABlockBase oldBlock = world.getBlock(blockPlacementPoint);
                        if (oldBlock instanceof BlockCollision) {
                            TileEntityRoad road = ((BlockCollision)oldBlock).getMasterRoad(world, position);
                            road.collisionBlockOffsets.remove(blockPlacementPoint.copy().subtract(road.position));
                        }
                        if (world.setBlock(this.getBlock(), blockPlacementPoint, player, axis)) {
                            TileEntityRoad newRoad = (TileEntityRoad)world.getTileEntity(blockPlacementPoint);
                            newRoad.dynamicCurve = new BezierCurve(startPosition.copy().subtract(blockPlacementPoint), endPosition.copy().subtract(blockPlacementPoint), (float)startRotation, (float)endRotation);
                            if (newRoad.spawnCollisionBlocks(player)) {
                                for (RoadLane lane : newRoad.lanes) {
                                    lane.generateConnections();
                                }
                                this.lastRoadClickedData.put(player, newRoad.getClickData(blockPlacementPoint, false));
                                this.lastPositionClicked.put(player, newRoad.position);
                                this.lastRotationClicked.put(player, startRotation + 180.0);
                            }
                        } else {
                            player.sendPacket(new PacketPlayerChatMessage(player, "interact.roadcomponent.blockedplacement"));
                        }
                    } else {
                        player.sendPacket(new PacketPlayerChatMessage(player, "interact.roadcomponent.toofar"));
                    }
                    return true;
                }
            } else if (((JSONRoadComponent)this.definition).road.type.equals((Object)TileEntityRoad.RoadComponent.CORE_STATIC)) {
                blockPlacementPoint = position.copy().add(0.0, 1.0, 0.0);
                if (world.setBlock(this.getBlock(), blockPlacementPoint, player, axis)) {
                    TileEntityRoad newRoad = (TileEntityRoad)world.getTileEntity(blockPlacementPoint);
                    if (newRoad.spawnCollisionBlocks(player)) {
                        for (RoadLane lane : newRoad.lanes) {
                            lane.generateConnections();
                        }
                        this.lastRoadClickedData.put(player, newRoad.getClickData(blockPlacementPoint, false));
                        this.lastPositionClicked.put(player, newRoad.position);
                        this.lastRotationClicked.put(player, (double)(Math.round(player.getYaw() / 15.0f) * 15) + 180.0);
                    }
                } else {
                    player.sendPacket(new PacketPlayerChatMessage(player, "interact.roadcomponent.blockedplacement"));
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<? extends ABlockBase> getBlockClass() {
        return BlockRoad.class;
    }
}

