/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.items.components.IItemEntityProvider;
import minecrafttransportsimulator.jsondefs.AJSONPartProvider;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.systems.ConfigSystem;

public class ItemVehicle
extends AItemSubTyped<JSONVehicle>
implements IItemEntityProvider<EntityVehicleF_Physics> {
    public ItemVehicle(JSONVehicle definition, String subName, String sourcePackID) {
        super(definition, subName, sourcePackID);
    }

    @Override
    public boolean onBlockClicked(WrapperWorld world, WrapperPlayer player, Point3d position, ABlockBase.Axis axis) {
        if (!world.isClient()) {
            WrapperItemStack heldStack = player.getHeldStack();
            WrapperNBT data = heldStack.getData();
            this.populateDefaultData(data);
            boolean wasSaved = !data.getString("uniqueUUID").isEmpty();
            EntityVehicleF_Physics vehicle = this.createEntity(world, player, data);
            if (!wasSaved) {
                for (JSONPartDefinition partDef : ((JSONVehicle)vehicle.definition).parts) {
                    vehicle.addDefaultPart(partDef, player, (AJSONPartProvider)vehicle.definition, true, false);
                }
                if (((JSONVehicle)vehicle.definition).motorized.defaultFuelQty > 0) {
                    for (APart part : vehicle.partsFromNBT) {
                        if (!(part instanceof PartEngine)) continue;
                        String mostPotentFluid = "";
                        for (String fluidName : ConfigSystem.configObject.fuel.fuels.get(((JSONPart)part.definition).engine.fuelType).keySet()) {
                            if (!mostPotentFluid.isEmpty() && !(ConfigSystem.configObject.fuel.fuels.get(((JSONPart)part.definition).engine.fuelType).get(mostPotentFluid) < ConfigSystem.configObject.fuel.fuels.get(((JSONPart)part.definition).engine.fuelType).get(fluidName))) continue;
                            mostPotentFluid = fluidName;
                        }
                        vehicle.fuelTank.manuallySet(mostPotentFluid, ((JSONVehicle)vehicle.definition).motorized.defaultFuelQty);
                        break;
                    }
                    if (vehicle.fuelTank.getFluid().isEmpty()) {
                        vehicle.remove();
                        throw new IllegalArgumentException("A defaultFuelQty was specified for: " + ((JSONVehicle)vehicle.definition).packID + ":" + ((JSONVehicle)vehicle.definition).systemName + ", but no engine was noted as a defaultPart, so we don't know what fuel to put in the vehicle.");
                    }
                }
            }
            vehicle.world.spawnEntity(vehicle);
            if (!player.isCreative()) {
                player.getInventory().removeFromSlot(player.getHotbarIndex(), 1);
            }
        }
        return true;
    }

    @Override
    public void populateDefaultData(WrapperNBT data) {
        super.populateDefaultData(data);
        data.setPoint3d("position", new Point3d());
        data.setPoint3d("motion", new Point3d());
        data.setPoint3d("angles", new Point3d());
        data.setPoint3d("rotation", new Point3d());
    }

    @Override
    public EntityVehicleF_Physics createEntity(WrapperWorld world, WrapperPlayer placingPlayer, WrapperNBT data) {
        return new EntityVehicleF_Physics(world, placingPlayer, data);
    }

    @Override
    public Class<EntityVehicleF_Physics> getEntityClass() {
        return EntityVehicleF_Physics.class;
    }
}

