/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.jsondefs;

import java.util.List;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.JSONRendering;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.packloading.JSONParser;
import minecrafttransportsimulator.packloading.PackResourceLoader;

public abstract class AJSONMultiModelProvider
extends AJSONItem {
    @JSONParser.JSONRequired
    @JSONParser.JSONDescription(value="A list of definitions for this content.  Each definition is simply a variant of a different texture on the same model, with potentially different names/descriptions/materials/etc.  If a component uses definitions, then you will need to specify at least one, even if the component only has one variant.  Also note that anything that has a definitions section is able to be added to dynamically via a skin.")
    public List<JSONSubDefinition> definitions;
    @JSONParser.JSONDescription(value="The rendering properties for this object.")
    public JSONRendering rendering;

    public String getModelLocation(String currentSubName) {
        for (JSONSubDefinition subDefinition : this.definitions) {
            if (!subDefinition.subName.equals(currentSubName)) continue;
            switch (this.rendering.modelType) {
                case OBJ: {
                    return PackResourceLoader.getPackResource(this, PackResourceLoader.ResourceType.OBJ_MODEL, subDefinition.modelName != null ? subDefinition.modelName : this.systemName);
                }
                case LITTLETILES: {
                    return PackResourceLoader.getPackResource(this, PackResourceLoader.ResourceType.LT_MODEL, subDefinition.modelName != null ? subDefinition.modelName : this.systemName);
                }
                case NONE: {
                    return null;
                }
            }
        }
        return null;
    }

    public String getTextureLocation(String currentSubName) {
        for (JSONSubDefinition subDefinition : this.definitions) {
            if (!subDefinition.subName.equals(currentSubName)) continue;
            switch (this.rendering.modelType) {
                case OBJ: {
                    return PackResourceLoader.getPackResource(this, PackResourceLoader.ResourceType.PNG, subDefinition.textureName != null ? subDefinition.textureName : this.systemName + currentSubName);
                }
                case LITTLETILES: {
                    return "GLOBAL";
                }
                case NONE: {
                    return null;
                }
            }
        }
        return null;
    }
}

