/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.jsondefs;

import java.util.List;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.jsondefs.JSONCraftingBench;
import minecrafttransportsimulator.packloading.JSONParser;

@JSONParser.JSONDescription(value="Sometimes, you just want to have something shiny to place in the world that can't be driven away by a pesky thief.  In this case, decor is the go-to choice.  Decors are essentially block-based OBJ models that can be placed down.  These come with full animation support, and can even have some additional functions built-in to justify the cost of crafting them.")
public class JSONDecor
extends AJSONMultiModelProvider {
    @JSONParser.JSONDescription(value="Decor-specific properties.")
    public JSONDecorGeneric decor;

    public static enum DecorComponentType {
        GENERIC,
        CHEST,
        BEACON,
        SIGNAL_CONTROLLER,
        FUEL_PUMP,
        ITEM_LOADER,
        ITEM_UNLOADER,
        FLUID_LOADER,
        FLUID_UNLOADER,
        RADIO;

    }

    public class JSONDecorGeneric {
        @JSONParser.JSONDescription(value="An optional type for this decor to give it functionality.")
        public DecorComponentType type;
        @JSONParser.JSONRequired
        @JSONParser.JSONDescription(value="How wide a decor is.  1 is a full block width.  Numbers over 1 will result in unpredictable operations, so don't use them.")
        public float width;
        @JSONParser.JSONRequired
        @JSONParser.JSONDescription(value="How high a decor is.  1 is a full block height.  Numbers over 1 will result in unpredictable operations, so don't use them.")
        public float height;
        @JSONParser.JSONRequired
        @JSONParser.JSONDescription(value="How deep a decor is.  1 is a full block depth.  Numbers over 1 will result in unpredictable operations, so don't use them.")
        public float depth;
        @JSONParser.JSONDescription(value="How much light this decor gives off.  A value from 0-1, with 1 being full possible light.")
        public float lightLevel;
        @JSONParser.JSONDescription(value="A optional crafting definition for this decor.  If this is included, the decor will open a GUI for crafting pack components when clicked.")
        public JSONCraftingBench crafting;
        @JSONParser.JSONDescription(value="An optional number of inventory units for this decor.  If set, it will make this decor act like a chest and hold items.  This is how many rows (of 9 slots) the inventory has.  Also used in item loaders/unloaders to configure their internal buffers.")
        public float inventoryUnits;
        @JSONParser.JSONDescription(value="The texture for the GUI if the decor has an inventory.  Only used if this decor has an inventory.  If not set, the default is used.")
        public String inventoryTexture;
        @JSONParser.JSONDescription(value="The fuel capacity of the decor. Units are in milli-buckets. Only use if this decor is a fuel pump/fluid loader. If not set, a value of 15000 is used.")
        public int fuelCapacity;
        @JSONParser.JSONDescription(value="The quantity of fuel to pump per tick. Units are in milli-buckets. Only use if this decor is a fuel pump/fluid loader. If not set, a value of 10 is used.")
        public int pumpRate;
        @Deprecated
        public List<String> itemTypes;
        @Deprecated
        public List<String> partTypes;
        @Deprecated
        public List<String> items;
    }
}

