/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.mcinterface;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.IItemEntityProvider;
import minecrafttransportsimulator.mcinterface.ABuilderEntityBase;
import minecrafttransportsimulator.mcinterface.InterfaceChunkloader;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.InterfaceEventsEntityRendering;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperAABBCollective;
import minecrafttransportsimulator.mcinterface.WrapperEntity;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.instances.PacketVehicleInteract;
import minecrafttransportsimulator.systems.PackParserSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class BuilderEntityExisting
extends ABuilderEntityBase {
    protected static final Map<String, IItemEntityProvider<?>> entityMap = new HashMap();
    protected AEntityB_Existing entity;
    private static Point3d lastExplosionPosition;
    private WrapperAABBCollective interactionBoxes;
    private WrapperAABBCollective collisionBoxes;

    public BuilderEntityExisting(World world) {
        super(world);
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (this.entity != null) {
            if (!this.entity.isValid) {
                this.func_70106_y();
            } else {
                this.entity.world.beginProfiling("MTSEntity_" + this.func_145782_y(), true);
                this.entity.world.beginProfiling("Main_Execution", true);
                this.entity.update();
                this.entity.world.beginProfiling("MovementOverhead", false);
                this.func_70107_b(this.entity.position.x, this.entity.position.y, this.entity.position.z);
                this.field_70177_z = (float)(-this.entity.angles.y);
                this.field_70125_A = (float)this.entity.angles.x;
                if (!this.field_70170_p.field_72995_K && this.field_70163_u < 0.0 && this.field_70170_p.func_189509_E(this.func_180425_c())) {
                    this.func_70106_y();
                    this.entity.world.endProfiling();
                    this.entity.world.endProfiling();
                    return;
                }
                if (this.entity instanceof AEntityE_Interactable) {
                    AEntityE_Interactable interactable = (AEntityE_Interactable)this.entity;
                    this.entity.world.beginProfiling("CollisionOverhead", false);
                    this.interactionBoxes = new WrapperAABBCollective(interactable.encompassingBox, interactable.getInteractionBoxes());
                    this.collisionBoxes = new WrapperAABBCollective(interactable.encompassingBox, interactable.getCollisionBoxes());
                    if (interactable.ticksExisted > 1L && interactable.ticksExisted % 20L == 0L) {
                        this.func_70105_a((float)Math.max(interactable.encompassingBox.widthRadius * 2.0, interactable.encompassingBox.depthRadius * 2.0), (float)interactable.encompassingBox.heightRadius * 2.0f);
                        if (World.MAX_ENTITY_RADIUS < interactable.encompassingBox.widthRadius || World.MAX_ENTITY_RADIUS < interactable.encompassingBox.heightRadius || World.MAX_ENTITY_RADIUS < interactable.encompassingBox.depthRadius) {
                            World.MAX_ENTITY_RADIUS = Math.max(Math.max(interactable.encompassingBox.widthRadius, interactable.encompassingBox.depthRadius), interactable.encompassingBox.heightRadius);
                        }
                    }
                    this.entity.world.beginProfiling("RiderOverhead", false);
                    if (!this.field_70170_p.field_72995_K) {
                        Iterator<WrapperEntity> riderIterator = interactable.locationRiderMap.inverse().keySet().iterator();
                        while (riderIterator.hasNext()) {
                            WrapperEntity rider = (WrapperEntity)riderIterator.next();
                            if (this.equals(rider.entity.func_184187_bx())) continue;
                            interactable.removeRider(rider, riderIterator);
                        }
                    }
                }
                this.entity.world.endProfiling();
                this.entity.world.endProfiling();
            }
        } else if (!this.loadedFromSavedNBT && this.loadFromSavedNBT) {
            WrapperWorld worldWrapper = WrapperWorld.getWrapperFor(this.field_70170_p);
            try {
                this.entity = entityMap.get(this.lastLoadedNBT.func_74779_i("entityid")).createEntity(worldWrapper, null, new WrapperNBT(this.lastLoadedNBT));
                this.entity.world.addEntity(this.entity);
                this.loadedFromSavedNBT = true;
                this.lastLoadedNBT = null;
            }
            catch (Exception e) {
                InterfaceCore.logError("Failed to load entity on builder from saved NBT.  Did a pack change?");
                InterfaceCore.logError(e.getMessage());
                this.func_70106_y();
            }
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        InterfaceChunkloader.removeEntityTicket(this);
        if (this.entity != null) {
            this.entity.remove();
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (!this.field_70128_L) {
            this.func_70106_y();
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && this.entity instanceof AEntityE_Interactable) {
            WrapperPlayer playerSource;
            AEntityE_Interactable interactable = (AEntityE_Interactable)this.entity;
            Entity attacker = source.func_76364_f();
            Entity trueSource = source.func_76346_g();
            WrapperPlayer wrapperPlayer = playerSource = trueSource instanceof EntityPlayer ? WrapperPlayer.getWrapperFor((EntityPlayer)trueSource) : null;
            if (lastExplosionPosition != null && source.func_94541_c()) {
                BoundingBox explosiveBounds = new BoundingBox(lastExplosionPosition, amount, amount, amount);
                for (BoundingBox box : this.interactionBoxes.boxes) {
                    if (!box.intersects(explosiveBounds)) continue;
                    interactable.attack(new Damage(source.field_76373_n, amount, box, null, playerSource).setExplosive());
                }
                lastExplosionPosition = null;
            } else if (attacker != null) {
                RayTraceResult hitRaytrace;
                Damage damage = null;
                Point3d attackerPosition = new Point3d(attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v);
                for (BoundingBox box : this.interactionBoxes.boxes) {
                    if (!box.isPointInside(attackerPosition)) continue;
                    damage = new Damage(source.field_76373_n, amount, box, null, playerSource);
                    break;
                }
                if (damage == null && (hitRaytrace = this.interactionBoxes.func_72327_a(attacker.func_174791_d(), attacker.func_174791_d().func_72441_c(attacker.field_70159_w, attacker.field_70181_x, attacker.field_70179_y))) != null) {
                    damage = new Damage(source.field_76373_n, amount, this.interactionBoxes.lastBoxRayTraced, null, playerSource);
                }
                if (damage != null) {
                    interactable.attack(damage);
                }
            }
        }
        return true;
    }

    public void func_184232_k(Entity passenger) {
        if (this.entity instanceof AEntityE_Interactable) {
            AEntityE_Interactable interactable = (AEntityE_Interactable)this.entity;
            Iterator<WrapperEntity> iterator = interactable.locationRiderMap.inverse().keySet().iterator();
            while (iterator.hasNext()) {
                WrapperEntity rider = (WrapperEntity)iterator.next();
                if (!rider.entity.equals((Object)passenger)) continue;
                interactable.updateRider(rider, iterator);
                return;
            }
            interactable.addRider(WrapperEntity.getWrapperFor(passenger), null);
        }
    }

    public boolean shouldRiderSit() {
        return this.entity != null ? InterfaceEventsEntityRendering.renderCurrentRiderSitting : super.shouldRiderSit();
    }

    public AxisAlignedBB func_174813_aQ() {
        return this.interactionBoxes != null ? this.interactionBoxes : super.func_174813_aQ();
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.collisionBoxes != null ? this.collisionBoxes : super.func_70046_E();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        if (this.entity instanceof AEntityF_Multipart) {
            for (APart part : ((AEntityF_Multipart)this.entity).parts) {
                for (BoundingBox box : part.interactionBoxes) {
                    Object partItem;
                    if (!box.isPointInside(new Point3d(target.field_72307_f.field_72450_a, target.field_72307_f.field_72448_b, target.field_72307_f.field_72449_c)) || (partItem = part.getItem()) == null) continue;
                    return ((AItemBase)part.getItem()).getNewStack((WrapperNBT)part.save((WrapperNBT)new WrapperNBT())).stack;
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_70067_L() {
        return this.collisionBoxes != null && !this.collisionBoxes.boxes.isEmpty();
    }

    public boolean canRiderInteract() {
        return true;
    }

    @Override
    public NBTTagCompound func_189511_e(NBTTagCompound tag) {
        super.func_189511_e(tag);
        if (this.entity != null) {
            this.entity.save(new WrapperNBT(tag));
            tag.func_74778_a("entityid", this.entity.getClass().getSimpleName());
        }
        return tag;
    }

    @SubscribeEvent
    public static void on(ExplosionEvent.Detonate event) {
        if (!event.getWorld().field_72995_K) {
            lastExplosionPosition = new Point3d(event.getExplosion().getPosition().field_72450_a, event.getExplosion().getPosition().field_72448_b, event.getExplosion().getPosition().field_72449_c);
        }
    }

    @SubscribeEvent
    public static void on(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof BuilderEntityExisting && ((BuilderEntityExisting)event.getTarget()).entity instanceof EntityVehicleF_Physics) {
            BuilderEntityExisting builder = (BuilderEntityExisting)event.getTarget();
            if (event.getEntityPlayer().field_70170_p.field_72995_K && event.getEntityPlayer().equals((Object)Minecraft.func_71410_x().field_71439_g) && event.getHand().equals((Object)EnumHand.MAIN_HAND) && builder.interactionBoxes != null) {
                BoundingBox boxClicked = builder.interactionBoxes.lastBoxRayTraced;
                if (boxClicked != null) {
                    InterfacePacket.sendToServer(new PacketVehicleInteract((EntityVehicleF_Physics)builder.entity, WrapperPlayer.getWrapperFor(event.getEntityPlayer()), boxClicked, true));
                } else {
                    InterfaceCore.logError("A entity was clicked (interacted) without doing RayTracing first, or AABBs in vehicle are corrupt!");
                }
                event.setCanceled(true);
                event.setCancellationResult(EnumActionResult.SUCCESS);
            }
        }
    }

    @SubscribeEvent
    public static void on(AttackEntityEvent event) {
        if (event.getTarget() instanceof BuilderEntityExisting && ((BuilderEntityExisting)event.getTarget()).entity instanceof EntityVehicleF_Physics) {
            BuilderEntityExisting builder = (BuilderEntityExisting)event.getTarget();
            if (event.getEntityPlayer().field_70170_p.field_72995_K && event.getEntityPlayer().equals((Object)Minecraft.func_71410_x().field_71439_g)) {
                BoundingBox boxClicked = builder.interactionBoxes.lastBoxRayTraced;
                if (boxClicked != null) {
                    InterfacePacket.sendToServer(new PacketVehicleInteract((EntityVehicleF_Physics)builder.entity, WrapperPlayer.getWrapperFor(event.getEntityPlayer()), boxClicked, false));
                } else {
                    InterfaceCore.logError("A entity was clicked (attacked) without doing RayTracing first, or AABBs in vehicle are corrupt!");
                }
                event.getEntityPlayer().func_184185_a(SoundEvents.field_187724_dU, 1.0f, 1.0f);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        for (AItemPack<?> packItem : PackParserSystem.getAllPackItems()) {
            if (!(packItem instanceof IItemEntityProvider)) continue;
            entityMap.put(((IItemEntityProvider)((Object)packItem)).getEntityClass().getSimpleName(), (IItemEntityProvider)((Object)packItem));
        }
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(BuilderEntityExisting.class).id(new ResourceLocation("mts", "mts_entity"), 0).name("mts_entity").tracker(512, 5, false).build());
    }
}

