/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.mcinterface;

import minecrafttransportsimulator.mcinterface.ABuilderEntityBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class BuilderEntityRenderForwarder
extends ABuilderEntityBase {
    protected EntityPlayer playerFollowing;
    protected int idleTickCounter;
    private long[] lastTickRendered = new long[]{0L, 0L, 0L};
    private float[] lastPartialTickRendered = new float[]{0.0f, 0.0f, 0.0f};
    private boolean doneRenderingShaders;
    private static int framesShadersDetected;
    private static boolean shadersDetected;

    public BuilderEntityRenderForwarder(World world) {
        super(world);
        this.func_70105_a(0.05f, 0.05f);
    }

    public BuilderEntityRenderForwarder(EntityPlayer playerFollowing) {
        this(playerFollowing.field_70170_p);
        this.playerFollowing = playerFollowing;
        this.func_70107_b(playerFollowing.field_70165_t, playerFollowing.field_70163_u, playerFollowing.field_70161_v);
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (this.playerFollowing != null && this.playerFollowing.field_70170_p == this.field_70170_p && !this.playerFollowing.field_70128_L) {
            double playerVelocity = Math.sqrt(this.playerFollowing.field_70159_w * this.playerFollowing.field_70159_w + this.playerFollowing.field_70181_x * this.playerFollowing.field_70181_x + this.playerFollowing.field_70179_y * this.playerFollowing.field_70179_y);
            Vec3d playerEyesVec = this.playerFollowing.func_70040_Z().func_186678_a(Math.max(1.0, playerVelocity / 2.0));
            this.func_70107_b(this.playerFollowing.field_70165_t + playerEyesVec.field_72450_a, this.playerFollowing.field_70163_u + (double)this.playerFollowing.eyeHeight + playerEyesVec.field_72448_b, this.playerFollowing.field_70161_v + playerEyesVec.field_72449_c);
        } else if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        } else if (!this.loadedFromSavedNBT && this.loadFromSavedNBT) {
            this.playerFollowing = this.field_70170_p.func_152378_a(this.lastLoadedNBT.func_186857_a("playerFollowing"));
            this.loadedFromSavedNBT = true;
            this.lastLoadedNBT = null;
        }
        this.idleTickCounter = 0;
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public boolean shouldRenderEntity(float partialTicks) {
        int renderPass = MinecraftForgeClient.getRenderPass();
        if (renderPass == -1) {
            renderPass = 2;
        }
        if (!shadersDetected) {
            if (renderPass != 2 && this.lastTickRendered[renderPass] > this.lastTickRendered[2] && this.lastTickRendered[2] > 0L) {
                if (++framesShadersDetected == 1000) {
                    shadersDetected = true;
                }
            } else {
                framesShadersDetected = 0;
            }
        }
        if (!shadersDetected || this.doneRenderingShaders) {
            this.lastTickRendered[renderPass] = this.field_70170_p.func_82737_E();
            this.lastPartialTickRendered[renderPass] = partialTicks;
        } else if (shadersDetected && !this.doneRenderingShaders && renderPass == 1) {
            this.doneRenderingShaders = true;
        }
        if (renderPass == 2) {
            if (shadersDetected) {
                this.doneRenderingShaders = false;
            }
            return this.lastTickRendered[0] != this.lastTickRendered[2] || this.lastPartialTickRendered[0] != this.lastPartialTickRendered[2];
        }
        return true;
    }

    @Override
    public NBTTagCompound func_189511_e(NBTTagCompound tag) {
        super.func_189511_e(tag);
        if (this.playerFollowing != null) {
            tag.func_186854_a("playerFollowing", this.playerFollowing.func_110124_au());
        }
        return tag;
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(BuilderEntityRenderForwarder.class).id(new ResourceLocation("mts", "mts_entity_renderer"), 1).name("mts_entity_renderer").tracker(512, 5, false).build());
    }
}

