/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.mcinterface;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.components.ABlockBaseTileEntity;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.PacketEntityCSHandshakeClient;
import minecrafttransportsimulator.mcinterface.PacketEntityCSHandshakeServer;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;

public class BuilderTileEntity<TileEntityType extends ATileEntityBase<?>>
extends TileEntity
implements ITickable {
    protected TileEntityType tileEntity;
    private boolean needDataFromServer = true;
    protected NBTTagCompound lastLoadedNBT;
    protected boolean loadFromSavedNBT;
    protected boolean loadedFromSavedNBT;
    protected final List<WrapperPlayer> playersRequestingData = new ArrayList<WrapperPlayer>();

    public void func_73660_a() {
        if (this.field_145850_b != null && this.field_174879_c != null) {
            if (this.tileEntity != null) {
                ((ATileEntityBase)this.tileEntity).update();
            } else if (!this.loadedFromSavedNBT) {
                if (this.lastLoadedNBT != null && !this.field_145850_b.field_72995_K) {
                    this.loadFromSavedNBT = true;
                }
                if (this.loadFromSavedNBT && this.field_145850_b.func_175667_e(this.field_174879_c)) {
                    try {
                        WrapperWorld worldWrapper = WrapperWorld.getWrapperFor(this.field_145850_b);
                        Point3d position = new Point3d(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
                        ABlockBaseTileEntity block = (ABlockBaseTileEntity)worldWrapper.getBlock(position);
                        this.tileEntity = block.createTileEntity(worldWrapper, position, null, new WrapperNBT(this.lastLoadedNBT));
                        ((ATileEntityBase)this.tileEntity).world.addEntity(this.tileEntity);
                        this.loadedFromSavedNBT = true;
                        this.lastLoadedNBT = null;
                    }
                    catch (Exception e) {
                        InterfaceCore.logError("Failed to load tile entity on builder from saved NBT.  Did a pack change?");
                        InterfaceCore.logError(e.getMessage());
                        this.field_145850_b.func_175698_g(this.field_174879_c);
                    }
                }
            }
            if (this.field_145850_b.field_72995_K) {
                if (this.needDataFromServer) {
                    InterfacePacket.sendToServer(new PacketEntityCSHandshakeClient(InterfaceClient.getClientPlayer(), this));
                    this.needDataFromServer = false;
                }
            } else if (!this.playersRequestingData.isEmpty()) {
                for (WrapperPlayer player : this.playersRequestingData) {
                    WrapperNBT data = new WrapperNBT();
                    this.func_189515_b(data.tag);
                    player.sendPacket(new PacketEntityCSHandshakeServer(this, data));
                }
                this.playersRequestingData.clear();
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.tileEntity != null) {
            ((AEntityB_Existing)this.tileEntity).remove();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.tileEntity != null && ((ATileEntityBase)this.tileEntity).isValid) {
            this.func_145843_s();
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.lastLoadedNBT = tag;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.tileEntity != null) {
            ((AEntityD_Definable)this.tileEntity).save(new WrapperNBT(tag));
        } else if (this.lastLoadedNBT != null) {
            tag = this.lastLoadedNBT;
        }
        return tag;
    }
}

